// @formatter:off
package com.ejie.aa21b.control;

import java.util.ArrayList;
import java.util.List;

import javax.servlet.http.HttpServletRequest;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.NoSuchMessageException;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;

import com.ejie.aa21b.model.Aa21b02s01;
import com.ejie.aa21b.model.Aa21b13s01;
import com.ejie.aa21b.model.Aa21b15s01;
import com.ejie.aa21b.model.Aa21b20s01;
import com.ejie.aa21b.model.NoraPais;
import com.ejie.aa21b.model.NoraProvincia;
import com.ejie.aa21b.seguridad.Aa21bPersonaSesion;
import com.ejie.aa21b.seguridad.Aa21bSeguridad;
import com.ejie.aa21b.service.Aa21b02s01Service;
import com.ejie.aa21b.service.Aa21b07s01Service;
import com.ejie.aa21b.service.Aa21b12s01Service;
import com.ejie.aa21b.service.Aa21b13s01Service;
import com.ejie.aa21b.service.Aa21b14s01Service;
import com.ejie.aa21b.service.Aa21b15s01Service;
import com.ejie.aa21b.service.Aa21b20s01Service;
import com.ejie.aa21b.service.NoraPaisService;
import com.ejie.aa21b.service.NoraProvinciaService;
import com.ejie.x38.control.bind.annotation.RequestJsonBody;
import com.ejie.x38.dto.JQGridRequestDto;
import com.ejie.x38.dto.JQGridResponseDto;
import com.ejie.x38.dto.JerarquiaDto;
import com.ejie.x38.dto.TableRowDto;

/**
 * Aa21b15s01Controller  
 * 
 *  
 */

@Controller
@RequestMapping(value = "/aa21b15s01")
public class Aa21b15s01Controller {

	private static final Logger logger = LoggerFactory
			.getLogger(Aa21b15s01Controller.class);

	@Autowired
	private Aa21b15s01Service aa21b15s01Service;

	@Autowired
	private Aa21b20s01Service aa21b20s01Service;

	@Autowired
	private Aa21b13s01Service aa21b13s01Service;

	@Autowired
	private Aa21b07s01Service aa21b07s01Service;

	@Autowired
	private Aa21b02s01Service aa21b02s01Service;

	@Autowired
	private Aa21b14s01Service aa21b14s01Service;

	@Autowired
	private Aa21b12s01Service aa21b12s01Service;

	@Autowired
	private NoraPaisService noraPaisService;

	@Autowired
	private NoraProvinciaService noraProvinciaService;

	/*
	 * OPERACIONES CRUD (Create, Read, Update, Delete)
	 */

	/**
	 * Operacion CRUD Read. Devuelve el bean correspondiente al identificador
	 * indicado.
	 * 
	 * @param cusu15
	 *            String
	 * @return Aa21b15s01 Objeto correspondiente al identificador indicado.
	 */
	@RequestMapping(value = "/{cusu15}", method = RequestMethod.GET)
	public @ResponseBody
	Aa21b15s01 get(@PathVariable String cusu15) {
		Aa21b15s01 aa21b15s01 = new Aa21b15s01();
		aa21b15s01.setCusu15(cusu15);
		aa21b15s01 = this.aa21b15s01Service.find(aa21b15s01);
		Aa21b15s01Controller.logger
				.info("[GET - findBy_PK] : Obtener Aa21b15s01 por PK");
		return aa21b15s01;
	}

	@RequestMapping(value = "find/{xlnets}", method = RequestMethod.GET)
	public @ResponseBody
	Aa21b15s01 find(@PathVariable String xlnets) {
		Aa21b15s01 aa21b15s01 = new Aa21b15s01();
		aa21b15s01.setUxlnet15(xlnets);
		aa21b15s01 = this.aa21b15s01Service.find(aa21b15s01);
		Aa21b15s01Controller.logger
				.info("[GET - findBy_PK] : Obtener Aa21b15s01 por PK");
		return aa21b15s01;
	}

	/**
	 * Devuelve una lista de beans correspondientes a los valores de filtrados
	 * indicados en el objeto pasado como parametro.
	 * 
	 * @param filterAa21b15s01
	 *            Aa21b15s01 Objeto que contiene los parametros de filtrado
	 *            utilizados en la busqueda.
	 * @return List<Aa21b15s01> Lista de objetos correspondientes a la busqueda
	 *         realizada.
	 */
	@RequestMapping(method = RequestMethod.GET)
	public @ResponseBody
	List<Aa21b15s01> getAll(@ModelAttribute Aa21b15s01 filterAa21b15s01) {
		Aa21b15s01Controller.logger
				.info("[GET - find_ALL] : Obtener Aa21b15s01 por filtro");
		return this.aa21b15s01Service.findAll(filterAa21b15s01, null);
	}

	/**
	 * Operacion CRUD Edit. Modificacion del bean indicado.
	 * 
	 * @param aa21b15s01
	 *            Aa21b15s01 Bean que contiene la informacion a modificar.
	 * @return Aa21b15s01 Bean resultante de la modificacion.
	 */
	@RequestMapping(method = RequestMethod.PUT)
	public @ResponseBody
	Aa21b15s01 edit(@RequestBody Aa21b15s01 aa21b15s01) throws Exception {
		/**
		 * Si se ha cambiado el servicio lo que hay que hacer es dar de baja el
		 * registro y dar de alta uno nuevo
		 */
		if (aa21b15s01.getCambioServ15() != null
				&& aa21b15s01.getCambioServ15().equals("S")) {
			this.aa21b15s01Service.removeForCambioServicio(aa21b15s01);
			Aa21b15s01 aa21b15s01Aux = this.aa21b15s01Service.add(aa21b15s01);
			Aa21b15s01Controller.logger
					.info("[PUT] : Aa21b15s01 creado correctamente");
			return aa21b15s01Aux;
		} else {
			Aa21b15s01 aa21b15s01Aux = this.aa21b15s01Service
					.update(aa21b15s01);
			Aa21b15s01Controller.logger
					.info("[PUT] : Aa21b15s01 actualizado correctamente");
			return aa21b15s01Aux;
		}
	}

	/**
	 * Operacion CRUD Create. Creacion de un nuevo registro a partir del bean
	 * indicado.
	 * 
	 * @param aa21b15s01
	 *            Aa21b15s01 Bean que contiene la informacion con la que se va a
	 *            crear el nuevo registro.
	 * @return Aa21b15s01 Bean resultante del proceso de creacion.
	 * @throws Exception
	 *             Exception
	 * @throws NoSuchMessageException
	 *             Exception
	 */
	@RequestMapping(method = RequestMethod.POST)
	public @ResponseBody
	Aa21b15s01 add(@RequestBody Aa21b15s01 aa21b15s01)
			throws NoSuchMessageException, Exception {
		Aa21b15s01 aa21b15s01Aux = this.aa21b15s01Service.add(aa21b15s01);
		Aa21b15s01Controller.logger
				.info("[POST] : Aa21b15s01 insertado correctamente");
		return aa21b15s01Aux;
	}

	/**
	 * Operacion CRUD Delete. Borrado del registro correspondiente al
	 * identificador especificado.
	 * 
	 * @param cusu15
	 *            String Identificador del objeto que se desea eliminar.
	 * @return Aa21b15s01 Bean eliminado.
	 * @throws Exception
	 *             Exception
	 */
	@RequestMapping(value = "/{cusu15}", method = RequestMethod.DELETE)
	@ResponseStatus(value = HttpStatus.OK)
	public @ResponseBody
	Aa21b15s01 remove(@PathVariable String cusu15) throws Exception {
		Aa21b15s01 aa21b15s01 = new Aa21b15s01();
		aa21b15s01.setCusu15(cusu15);
		this.aa21b15s01Service.remove(aa21b15s01);
		Aa21b15s01Controller.logger
				.info("[DELETE] : Aa21b15s01 borrado correctamente");
		return aa21b15s01;
	}

	/*
	 * METODOS COMPONENTE RUP_TABLE
	 */

	/**
	 * Metodo de presentacion del RUP_TABLE.
	 * 
	 * @param model
	 *            Model
	 * @return String
	 */
	@RequestMapping(value = "/maint", method = RequestMethod.GET)
	public String getFormEdit(Model model) {
		Aa21b15s01Controller.logger.info("[GET - View] : aa21b15s01");

		Aa21b02s01 filtroTipos = new Aa21b02s01();
		logger.info("Cargar tipos de expedientes en el modelo");
		model.addAttribute("tiposExpedientes",
				this.aa21b02s01Service.findAll(filtroTipos, null));

		// Estados de expediente
		logger.info("Cargar estados de expedientes en el modelo");
		model.addAttribute("estadosExpedientes",
				this.aa21b07s01Service.findAll(null, null));

		// ubicaciones
		logger.info("Cargar ubicaciones en el modelo");
		model.addAttribute("ubicaciones",
				this.aa21b14s01Service.findAll(null, null));

		// Departamentos
		logger.info("Cargar departamentos en el modelo");
		// Departamentos
		model.addAttribute("departamentos",
				this.aa21b12s01Service.findAll(null, null));
		logger.info("Cargar paises del nora en el modelo");
		List<NoraPais> paises = this.noraPaisService.findAll(null, null);
		model.addAttribute("paises", paises);
		logger.info("Cargar provincias del nora en el modelo");
		List<NoraProvincia> provincias = this.noraProvinciaService.findAll(
				null, null);
		model.addAttribute("provincias", provincias);

		Aa21bPersonaSesion ps = new Aa21bSeguridad().getUsuario();
		String usuario = ps.getPersonaXLNET().getCodigo();
		logger.info("Usuario XLNETS=" + usuario);
		Aa21b13s01 aa21b13s01 = new Aa21b13s01();
		aa21b13s01.setCServ13(ps.getServicio());
		model.addAttribute("servicio", ps.getServicio());

		return "aa21b15s01";
	}

	/**
	 * Operacion de filtrado del componente RUP_TABLE.
	 * 
	 * @param filterAa21b15s01
	 *            Aa21b15s01 Bean que contiene los parametros de filtrado a
	 *            emplear.
	 * @param jqGridRequestDto
	 *            Dto que contiene los parametros de configuracion propios del
	 *            RUP_TABLE a aplicar en el filtrado.
	 * @return JQGridResponseDto<Aa21b15s01> Dto que contiene el resultado del
	 *         filtrado realizado por el componente RUP_TABLE.
	 */
	@RequestMapping(value = "/filter", method = RequestMethod.POST)
	public @ResponseBody
	JQGridResponseDto<Aa21b15s01> filter(
			@RequestJsonBody(param = "filter") Aa21b15s01 filterAa21b15s01,
			@RequestJsonBody JQGridRequestDto jqGridRequestDto) {

		Aa21b15s01Controller.logger
				.info("[POST - filter] : Obtener Aa21b15s01s");

		List<Aa21b13s01> listaServicios = new ArrayList<Aa21b13s01>();
		String vacio = "";
		if (filterAa21b15s01.getCserv15() != null
				&& !filterAa21b15s01.getCserv15().equals(vacio)
				// NULL como string...
				&& !filterAa21b15s01.getCserv15().equals("null")
				&& !filterAa21b15s01.getCserv15().equals("sinServicio")) {

			String[] arrayServicios = filterAa21b15s01.getCserv15().split(",");

			Aa21b13s01 servicio = null;
			for (int x = 0; x < arrayServicios.length; x++) {
				servicio = new Aa21b13s01();// NOPMD

				servicio.setCServ13(arrayServicios[x]);

				listaServicios.add(servicio);
			}
		}

		return this.aa21b15s01Service.filter(filterAa21b15s01,
				jqGridRequestDto, listaServicios, false);
	}

	/**
	 * Operacion de filtrado del componente RUP_TABLE.
	 * 
	 * @param filterAa21b15s01
	 *            Aa21b15s01 Bean que contiene los parametros de filtrado a
	 *            emplear.
	 * @param jqGridRequestDto
	 *            Dto que contiene los parametros de configuracion propios del
	 *            RUP_TABLE a aplicar en el filtrado.
	 * @return JQGridResponseDto<Aa21b15s01> Dto que contiene el resultado del
	 *         filtrado realizado por el componente RUP_TABLE.
	 */
	@RequestMapping(value = "/filterSinServicio", method = RequestMethod.POST)
	public @ResponseBody
	JQGridResponseDto<Aa21b15s01> filterSinServicio(
			@RequestJsonBody(param = "filter") Aa21b15s01 filterAa21b15s01,
			@RequestJsonBody JQGridRequestDto jqGridRequestDto) {
		Aa21b15s01Controller.logger
				.info("[POST - filter] : Obtener Aa21b15s01s");
		return this.aa21b15s01Service.filterSinServicio(filterAa21b15s01,
				jqGridRequestDto, false);
	}

	/**
	 * Operacion de busqueda del componente RUP_TABLE.
	 * 
	 * @param filterAa21b15s01
	 *            Aa21b15s01 Bean que contiene los parametros de filtrado a
	 *            emplear.
	 * @param searchAa21b15s01
	 *            Aa21b15s01 Bean que contiene los parametros de busqueda a
	 *            emplear.
	 * @param jqGridRequestDto
	 *            Dto que contiene los parametros de configuracion propios del
	 *            RUP_TABLE a aplicar en la búsqueda.
	 * @return TableRowDto<Aa21b15s01> Dto que contiene el resultado de la
	 *         busqueda realizada por el componente RUP_TABLE.
	 */
	@RequestMapping(value = "/search", method = RequestMethod.POST)
	public @ResponseBody
	List<TableRowDto<Aa21b15s01>> search(
			@RequestJsonBody(param = "filter") Aa21b15s01 filterAa21b15s01,
			@RequestJsonBody(param = "search") Aa21b15s01 searchAa21b15s01,
			@RequestJsonBody JQGridRequestDto jqGridRequestDto) {
		Aa21b15s01Controller.logger
				.info("[POST - search] : Buscar Aa21b15s01s");
		return this.aa21b15s01Service.search(filterAa21b15s01,
				searchAa21b15s01, jqGridRequestDto, false);
	}

	/**
	 * Borrado multiple de registros
	 * 
	 * @param filterAa21b15s01
	 *            Aa21b15s01 Bean que contiene los parametros de filtrado a
	 *            emplear.
	 * @param jqGridRequestDto
	 *            Dto que contiene los parametros de configuracion propios del
	 *            RUP_TABLE a aplicar en la busqueda.
	 * @return List<String> Lista de los identificadores de los registros
	 *         eliminados.
	 */
	@RequestMapping(value = "/deleteAll", method = RequestMethod.POST)
	@ResponseStatus(value = HttpStatus.OK)
	public @ResponseBody
	List<String> removeMultiple(
			@RequestJsonBody(param = "filter") Aa21b15s01 filterAa21b15s01,
			@RequestJsonBody JQGridRequestDto jqGridRequestDto) {
		Aa21b15s01Controller.logger
				.info("[POST - search] : [POST - removeMultiple] : Eliminar multiples Aa21b15s01s");
		this.aa21b15s01Service.removeMultiple(filterAa21b15s01,
				jqGridRequestDto, false);
		Aa21b15s01Controller.logger.info("All entities correctly deleted!");
		return jqGridRequestDto.getMultiselection().getSelectedIds();
	}

	/*
	 * METODOS COMPONENTE RUP_TABLE - JERARQUIA
	 */

	/**
	 * Operacion de filtrado del componente RUP_TABLE para presentar los
	 * registros mediante visualizacion jerarquica.
	 * 
	 * @param filterAa21b15s01
	 *            Aa21b15s01 Bean que contiene los parametros de filtrado a
	 *            emplear.
	 * @param jqGridRequestDto
	 *            Dto que contiene los parametros de configuracion propios del
	 *            RUP_TABLE a aplicar en el filtrado.
	 * @return JQGridResponseDto<JerarquiaDto<Aa21b15s01>> Dto que contiene el
	 *         resultado del filtrado realizado por el componente RUP_TABLE.
	 */
	@RequestMapping(value = "/jerarquia/filter", method = RequestMethod.POST)
	public @ResponseBody
	JQGridResponseDto<JerarquiaDto<Aa21b15s01>> jerarquia(
			@RequestJsonBody(param = "filter") Aa21b15s01 filterAa21b15s01,
			@RequestJsonBody JQGridRequestDto jqGridRequestDto) {
		Aa21b15s01Controller.logger
				.info("[POST - jerarquia] : Obtener Aa21b15s01s jerarquia");
		return this.aa21b15s01Service.jerarquia(filterAa21b15s01,
				jqGridRequestDto, false);
	}

	/**
	 * Recupera los hijos de los registros desplegados en la visualizacion
	 * jerarquica.
	 * 
	 * @param filterAa21b15s01
	 *            Aa21b15s01 Bean que contiene los parametros de filtrado a
	 *            emplear.
	 * @param jqGridRequestDto
	 *            Dto que contiene los parametros de configuracion propios del
	 *            RUP_TABLE a aplicar en el filtrado.
	 * @return JQGridResponseDto<JerarquiaDto<Aa21b15s01>> Dto que contiene el
	 *         resultado del filtrado realizado por el componente RUP_TABLE.
	 */
	@RequestMapping(value = "/jerarquiaChildren", method = RequestMethod.POST)
	public @ResponseBody
	JQGridResponseDto<JerarquiaDto<Aa21b15s01>> jerarquiaChildren(
			@RequestJsonBody(param = "filter") Aa21b15s01 filterAa21b15s01,
			@RequestJsonBody JQGridRequestDto jqGridRequestDto) {
		Aa21b15s01Controller.logger
				.info("[POST - jerarquia] : Obtener Aa21b15s01s jerarquia - Hijos");
		return this.aa21b15s01Service.jerarquiaChildren(filterAa21b15s01,
				jqGridRequestDto);
	}

	/**
	 * Method 'getAutocompleteNombreUsu'.
	 * 
	 * @param q
	 *            String
	 * @param c
	 *            Boolean
	 * 
	 * @return List<Aa21b15s01>
	 */
	@RequestMapping(value = "/autocompleteNombreUsu", method = RequestMethod.GET)
	public @ResponseBody
	List<Aa21b15s01> getAutocompleteNombreUsu(
			@RequestParam(value = "q", required = true) String q,
			@RequestParam(value = "c", required = true) Boolean c) {
		Aa21b15s01 usuario = new Aa21b15s01();
		usuario.setDusu15(q);
		return this.aa21b15s01Service.findUsuario(usuario, c);
	}

	/**
	 * Method 'getAutocompleteDescripcionServicio'.
	 * 
	 * @param q
	 *            String
	 * @param c
	 *            Boolean
	 * 
	 * @return List<Aa21b13s01>
	 */
	@RequestMapping(value = "/autocompleteDserv15cas", method = RequestMethod.GET)
	public @ResponseBody
	List<Aa21b13s01> getAutocompleteDescripcionServicioCas(
			@RequestParam(value = "q", required = true) String q,
			@RequestParam(value = "c", required = true) Boolean c) {
		Aa21b13s01 servicio = new Aa21b13s01();
		servicio.setDServ13(q);
		return this.aa21b13s01Service.findServicio(servicio, c);
	}

	/**
	 * Method 'getAutocompleteDescripcionServicio'.
	 * 
	 * @param q
	 *            String
	 * @param c
	 *            Boolean
	 * 
	 * @return List<Aa21b13s01>
	 */
	@RequestMapping(value = "/autocompleteDserv15eusk", method = RequestMethod.GET)
	public @ResponseBody
	List<Aa21b13s01> getAutocompleteDescripcionServicioEusk(
			@RequestParam(value = "q", required = true) String q,
			@RequestParam(value = "c", required = true) Boolean c) {
		Aa21b13s01 servicio = new Aa21b13s01();
		servicio.setEServ13(q);
		return this.aa21b13s01Service.findServicio(servicio, c);
	}

	/**
	 * Method 'getComboServiciosUsuarios'.
	 * 
	 * @return List<Aa21b13s01>
	 */
	@RequestMapping(value = "/comboServiciosUsuarios", method = RequestMethod.GET)
	public @ResponseBody
	List<Aa21b13s01> getComboServiciosUsuarios() {
		return this.aa21b13s01Service.findAll(null, null);
	}

	/**
	 * Method 'getComboUsuarios'.
	 * 
	 * @return List<Aa21b15s01>
	 */
	@RequestMapping(value = "/comboUsuarios", method = RequestMethod.GET)
	public @ResponseBody
	List<Aa21b15s01> getComboUsuarios() {
		return this.aa21b15s01Service.findAll(null, null);
	}

	/**
	 * Method 'getComboUsuariosServicio'.
	 * 
	 * @return List<Aa21b15s01>
	 */
	@RequestMapping(value = "/tUsuCombo", method = RequestMethod.GET)
	public @ResponseBody
	List<Aa21b15s01> getComboUsuariosServicio(
			@RequestParam(value = "cserv20", required = true) String q) {
		List<Aa21b15s01> listaUsuarios = new ArrayList<Aa21b15s01>();
		String vacio = "";
		if (q != null && !q.equals(vacio)
		// NULL como string...
				&& !q.equals("null")) {
			String[] arrayTiposExp = q.split(",");
			Aa21b15s01 usuario = null;
			for (int x = 0; x < arrayTiposExp.length; x++) {
				usuario = new Aa21b15s01();// NOPMD
				usuario.setCserv15(arrayTiposExp[x]);
				listaUsuarios.add(usuario);
			}
		}
		return this.aa21b15s01Service.findAllComboUsuariosServicios(
				listaUsuarios, null);
	}

	/**
	 * @param aa21b15s01
	 *            Aa21b15s01
	 * @return Aa21b15s01
	 */
	@RequestMapping(value = "/cambioEstadoUsuario", method = RequestMethod.POST)
	public @ResponseBody
	Aa21b15s01 cargarExpediente(@RequestBody Aa21b15s01 aa21b15s01) {
		Aa21b15s01 aa21b15s01Aux = this.aa21b15s01Service.update(aa21b15s01);
		Aa21b15s01Controller.logger
				.info("[PUT] : Aa21b15s01 estado actualizado correctamente");
		return aa21b15s01Aux;
	}

	/**
	 * @param aa21b15s01
	 *            Aa21b15s01
	 * @return Aa21b15s01
	 */
	@RequestMapping(value = "/updateBloqueos", method = RequestMethod.POST)
	public @ResponseBody
	Aa21b15s01 updateBloqueos(@RequestBody Aa21b15s01 aa21b15s01) {
		/**
		 * Obtengo el usuario de XLNETS y a partir del código, busco en la tabla
		 * el servicio al que corresponde Solo cargaremos en el combo de
		 * responsables los de ese servicio
		 */
		Aa21bPersonaSesion ps = new Aa21bSeguridad().getUsuario();
		String usuario = ps.getPersonaXLNET().getCodigo();
		logger.info("Usuario XLNETS=" + usuario);

		Aa21b15s01 aa21b15s01busqUsuario = ps.getPersonaAplicacion();
		logger.info("Buscar el usuario en la tabla 15");

		if (aa21b15s01 == null) {
			aa21b15s01 = new Aa21b15s01();
		}
		aa21b15s01.setCserv15(aa21b15s01busqUsuario.getCserv15());
		aa21b15s01.setBloq15("0");

		Aa21b15s01 aa21b15s01Aux = this.aa21b15s01Service
				.updateBloqueos(aa21b15s01);
		Aa21b15s01Controller.logger
				.info("[PUT] : Aa21b15s01 bloqueos actualizado correctamente");
		return aa21b15s01Aux;
	}

	/**
	 * Method 'bloquear'.
	 * 
	 * @param cusu15
	 *            String
	 * @return boolean
	 */
	@RequestMapping(value = "bloquear/{cusu15}", method = RequestMethod.POST)
	public @ResponseBody
	boolean bloquear(@PathVariable String cusu15) {
		return this.aa21b15s01Service.bloquear(cusu15);
	}

	/**
	 * Method 'desbloquear'.
	 * 
	 * @param cusu15
	 *            String
	 * @return boolean
	 */
	@RequestMapping(value = "desbloquear/{cusu15}", method = RequestMethod.POST)
	public @ResponseBody
	boolean desbloquear(@PathVariable String cusu15) {
		return this.aa21b15s01Service.desbloquear(cusu15);
	}

	/**
	 * Crear excel usuarios
	 * 
	 * @param model
	 *            Model
	 * @param filterUsuarios
	 *            Aa21b15s01
	 * @param request
	 *            HttpServletRequest
	 * @return String
	 */
	@RequestMapping(value = "excelUsuarios", method = RequestMethod.POST)
	public String informeExcelUsuarios(Model model,
			@ModelAttribute Aa21b15s01 filterUsuarios,
			HttpServletRequest request) {
		Aa21b15s01Controller.logger.info("Creando informe Excel Usuarios");
		String view = "";

		// Parametros formulario filtrado usuarios
		if (request.getParameter("icusu15") != null
				&& !request.getParameter("icusu15").equals("")) {
			filterUsuarios.setCusu15(request.getParameter("icusu15"));
		}

		if (request.getParameter("idusu15") != null
				&& !request.getParameter("idusu15").equals("")) {
			filterUsuarios.setDusu15(request.getParameter("idusu15"));
		}

		if (request.getParameter("isitu15") != null
				&& !request.getParameter("isitu15").equals("")) {
			filterUsuarios.setSitu15(request.getParameter("isitu15"));
		}

		List<Aa21b13s01> listaServicios = new ArrayList<Aa21b13s01>();
		String vacio = "";
		if (request.getParameter("icserv15") != null
				&& !request.getParameter("icserv15").equals(vacio)
				// NULL como string...
				&& !request.getParameter("icserv15").equals("null")) {

			String[] arrayServicios = request.getParameter("icserv15").split(
					",");

			Aa21b13s01 servicio = null;
			for (int x = 0; x < arrayServicios.length; x++) {
				servicio = new Aa21b13s01();// NOPMD
				servicio.setCServ13(arrayServicios[x]);
				listaServicios.add(servicio);
			}
		}

		JQGridRequestDto jqGridRequestDto = new JQGridRequestDto();
		jqGridRequestDto.setSidx("cserv15");
		jqGridRequestDto.setSord("asc");

		List<Aa21b15s01> listaUsuarios = aa21b15s01Service.findAllLike(
				filterUsuarios, jqGridRequestDto, listaServicios, false);

		model.addAttribute("usuarios", listaUsuarios);

		view = "reporteExcelUsuarios";
		return view;
	}

	/**
	 * Method 'getExpedientesAsociados'.
	 * 
	 * @param cusu15
	 *            String
	 * @param jqGridRequestDto
	 *            JQGridRequestDto
	 * 
	 * @return List<Aa21b20s01>
	 */
	@RequestMapping(value = "/obtenerExpedientesUsuario/{cusu15}", method = RequestMethod.POST)
	public @ResponseBody
	JQGridResponseDto<Aa21b20s01> getExpedientesAsociados(
			@PathVariable String cusu15,
			@RequestJsonBody JQGridRequestDto jqGridRequestDto) {
		Aa21b20s01 filterAa21b20s01 = new Aa21b20s01();
		if (cusu15 == null || (cusu15 != null && cusu15.equals(""))) {
			JQGridRequestDto data = new JQGridRequestDto();
			data.setRows(new Long(0));
			data.setPage(new Long(0));
			return new JQGridResponseDto<Aa21b20s01>(data, new Long(0), null);
		} else {
			filterAa21b20s01.setCrespo20(new Long(cusu15));
			return this.aa21b20s01Service.filter(filterAa21b20s01,
					jqGridRequestDto, false);
		}
	}

	@RequestMapping(value = "/obtenerExpedientesUsuarioServ/{cusu15}", method = RequestMethod.POST)
	public @ResponseBody
	JQGridResponseDto<Aa21b20s01> getExpedientesAsociadosServ(
			@PathVariable String cusu15,
			@RequestJsonBody JQGridRequestDto jqGridRequestDto) {
		Aa21b20s01 filterAa21b20s01 = new Aa21b20s01();
		if (cusu15 == null || (cusu15 != null && cusu15.equals(""))) {
			JQGridRequestDto data = new JQGridRequestDto();
			data.setRows(new Long(0));
			data.setPage(new Long(0));
			return new JQGridResponseDto<Aa21b20s01>(data, new Long(0), null);
		} else {

			// 20170109 - INI - INIGO
			String strServicioLogueado = new Aa21bSeguridad().getUsuario()
					.getServicio();
			if (strServicioLogueado != null && !"".equals(strServicioLogueado)) {
				filterAa21b20s01.setServicioLogueado(strServicioLogueado);
			}
			// 20170109 - FIN - INIGO

			filterAa21b20s01.setCrespo20(new Long(cusu15));
			return this.aa21b20s01Service.filter(filterAa21b20s01,
					jqGridRequestDto, false);
		}
	}

	/**
	 * Method 'getComboServiciosResponsables'.
	 * 
	 * @return List<Aa21b13s01>
	 */
	@RequestMapping(value = "/comboServiciosResponsables", method = RequestMethod.GET)
	public @ResponseBody
	List<Aa21b13s01> getComboServiciosResponsables() {
		return this.aa21b13s01Service.findAll(null, null);
	}

	/**
	 * Operacion CRUD Create. Creacion de un nuevo registro a partir del bean
	 * indicado.
	 * 
	 * @param aa21b15s01
	 *            Aa21b15s01 Bean que contiene la informacion con la que se va a
	 *            crear el nuevo registro.
	 * @return Aa21b15s01 Bean resultante del proceso de creacion.
	 * @throws Exception
	 *             Exception
	 * @throws NoSuchMessageException
	 *             Exception
	 */
	@RequestMapping(value = "/addList", method = RequestMethod.POST)
	public @ResponseBody
	Aa21b15s01 addList(@RequestBody Aa21b15s01[] list)
			throws NoSuchMessageException, Exception {
		for (Aa21b15s01 dato : list)
			this.aa21b15s01Service.add(dato);
		Aa21b15s01Controller.logger
				.info("[POST] : Aa21b15s01 insertado correctamente");
		return null;
	}

	/**
	 * Operacion de filtrado del componente RUP_TABLE.
	 * 
	 * @param filterAa21b15s01
	 *            Aa21b15s01 Bean que contiene los parametros de filtrado a
	 *            emplear.
	 * @param jqGridRequestDto
	 *            Dto que contiene los parametros de configuracion propios del
	 *            RUP_TABLE a aplicar en el filtrado.
	 * @return JQGridResponseDto<Aa21b15s01> Dto que contiene el resultado del
	 *         filtrado realizado por el componente RUP_TABLE.
	 */

	@RequestMapping(value = "/filterResponsablesServicio/filter", method = RequestMethod.POST)
	public @ResponseBody
	JQGridResponseDto<Aa21b15s01> filterResponsablesServicio(
			@RequestJsonBody(param = "filter") Aa21b15s01 filterAa21b15s01,
			@RequestJsonBody JQGridRequestDto jqGridRequestDto) {
		Aa21b15s01Controller.logger
				.info("[POST - filter] : Obtener filterResponsablesServicio");
		if (filterAa21b15s01 == null || filterAa21b15s01.getCserv15() == null) {
			filterAa21b15s01.setCserv15("---");

		} else {
			// Si ha seleccionado 92
			if ("92".equals(filterAa21b15s01.getCserv15())) {
				// HAy que buscar responsables del servicio antiguo 92 ()
				filterAa21b15s01.setCserv15(null);
				filterAa21b15s01.setCservOld15("92");
			}
		}
		JQGridResponseDto<Aa21b15s01> listaResponsables = this.aa21b15s01Service
				.filterResponsablesServicio(filterAa21b15s01, jqGridRequestDto,
						false);

		return listaResponsables;
	}
}