package com.ejie.aa21b.control;

import java.util.ArrayList;
import java.util.List;
import java.util.Properties;

import javax.servlet.http.HttpServletRequest;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;

import com.ejie.aa21b.model.Aa21b01s01;
import com.ejie.aa21b.model.Aa21b02s01;
import com.ejie.aa21b.model.Aa21b13s01;
import com.ejie.aa21b.model.Aa21b15s01;
import com.ejie.aa21b.seguridad.Aa21bPersonaSesion;
import com.ejie.aa21b.seguridad.Aa21bSeguridad;
import com.ejie.aa21b.service.Aa21b01s01Service;
import com.ejie.aa21b.service.Aa21b02s01Service;
import com.ejie.aa21b.service.Aa21b13s01Service;
import com.ejie.aa21b.service.Aa21b15s01Service;
import com.ejie.x38.control.bind.annotation.RequestJsonBody;
import com.ejie.x38.dto.JQGridRequestDto;
import com.ejie.x38.dto.JQGridResponseDto;
import com.ejie.x38.dto.JerarquiaDto;
import com.ejie.x38.dto.TableRowDto;

/**
 * Aa21b13s01Controller  
 * 
 *  
 */

@Controller
@RequestMapping(value = "/aa21b13s01")
public class Aa21b13s01Controller {

	private static final Logger logger = LoggerFactory
			.getLogger(Aa21b13s01Controller.class);

	@Autowired
	private Aa21b13s01Service aa21b13s01Service;

	@Autowired
	private Aa21b02s01Service aa21b02s01Service;

	@Autowired
	private Aa21b01s01Service aa21b01s01Service;

	@Autowired
	private Aa21b15s01Service aa21b15s01Service;

	@Autowired
	private Properties appConfiguration;

	/*
	 * OPERACIONES CRUD (Create, Read, Update, Delete)
	 */

	/**
	 * Operacion CRUD Read. Devuelve el bean correspondiente al identificador
	 * indicado.
	 * 
	 * @param cserv13
	 *            String
	 * @return Aa21b13s01 Objeto correspondiente al identificador indicado.
	 */
	@RequestMapping(value = "/{cserv13}", method = RequestMethod.GET)
	public @ResponseBody
	Aa21b13s01 get(@PathVariable String cserv13) {
		Aa21b13s01 aa21b13s01 = new Aa21b13s01();
		aa21b13s01.setCServ13(cserv13);
		aa21b13s01 = this.aa21b13s01Service.find(aa21b13s01);
		Aa21b13s01Controller.logger
				.info("[GET - findBy_PK] : Obtener Aa21b13s01 por PK");
		return aa21b13s01;
	}

	/**
	 * Devuelve una lista de beans correspondientes a los valores de filtrados
	 * indicados en el objeto pasado como parametro.
	 * 
	 * @param filterAa21b13s01
	 *            Aa21b13s01 Objeto que contiene los parametros de filtrado
	 *            utilizados en la busqueda.
	 * @return List<Aa21b13s01> Lista de objetos correspondientes a la busqueda
	 *         realizada.
	 */
	@RequestMapping(method = RequestMethod.GET)
	public @ResponseBody
	List<Aa21b13s01> getAll(@ModelAttribute Aa21b13s01 filterAa21b13s01) {
		Aa21b13s01Controller.logger
				.info("[GET - find_ALL] : Obtener Aa21b13s01 por filtro");
		return this.aa21b13s01Service.findAll(filterAa21b13s01, null);
	}

	/**
	 * Operacion CRUD Edit. Modificacion del bean indicado.
	 * 
	 * @param aa21b13s01
	 *            Aa21b13s01 Bean que contiene la informacion a modificar.
	 * @return Aa21b13s01 Bean resultante de la modificacion.
	 */
	@RequestMapping(method = RequestMethod.PUT)
	public @ResponseBody
	Aa21b13s01 edit(@RequestBody Aa21b13s01 aa21b13s01) {
		Aa21b13s01 aa21b13s01Aux = this.aa21b13s01Service.update(aa21b13s01);
		Aa21b13s01Controller.logger
				.info("[PUT] : Aa21b13s01 actualizado correctamente");
		return aa21b13s01Aux;
	}

	/**
	 * Operacion CRUD Create. Creacion de un nuevo registro a partir del bean
	 * indicado.
	 * 
	 * @param aa21b13s01
	 *            Aa21b13s01 Bean que contiene la informacion con la que se va a
	 *            crear el nuevo registro.
	 * @return Aa21b13s01 Bean resultante del proceso de creacion.
	 */
	@RequestMapping(method = RequestMethod.POST)
	public @ResponseBody
	Aa21b13s01 add(@RequestBody Aa21b13s01 aa21b13s01) {
		Aa21b13s01 aa21b13s01Aux = this.aa21b13s01Service.add(aa21b13s01);
		Aa21b13s01Controller.logger
				.info("[POST] : Aa21b13s01 insertado correctamente");
		return aa21b13s01Aux;
	}

	/**
	 * Operacion CRUD Delete. Borrado del registro correspondiente al
	 * identificador especificado.
	 * 
	 * @param cserv13
	 *            String Identificador del objeto que se desea eliminar.
	 * @return Aa21b13s01 Bean eliminado.
	 * @throws Exception
	 *             Exception
	 */
	@RequestMapping(value = "/{cserv13}", method = RequestMethod.DELETE)
	@ResponseStatus(value = HttpStatus.OK)
	public @ResponseBody
	Aa21b13s01 remove(@PathVariable String cserv13) throws Exception {
		Aa21b13s01 aa21b13s01 = new Aa21b13s01();
		aa21b13s01.setCServ13(cserv13);

		Aa21b02s01 aa21b02s01Aux = new Aa21b02s01();
		aa21b02s01Aux.setCserv02(aa21b13s01.getCServ13());

		this.aa21b02s01Service.compruebaBloqueosServicio(aa21b02s01Aux);

		Aa21b01s01 aa21b01s01Aux = new Aa21b01s01();
		aa21b01s01Aux.setCserv01(aa21b13s01.getCServ13());
		this.aa21b01s01Service.compruebaBloqueosServicio(aa21b01s01Aux);

		this.aa21b13s01Service.remove(aa21b13s01);

		this.aa21b02s01Service.removeTiposServicio(aa21b02s01Aux);

		this.aa21b01s01Service.removeFasesServicio(aa21b01s01Aux);

		Aa21b13s01Controller.logger
				.info("[DELETE] : Aa21b13s01 borrado correctamente");
		return aa21b13s01;
	}

	/*
	 * METODOS COMPONENTE RUP_TABLE
	 */

	/**
	 * Metodo de presentacion del RUP_TABLE.
	 * 
	 * @param model
	 *            Model
	 * @return String
	 */
	@RequestMapping(value = "/maint", method = RequestMethod.GET)
	public String getFormEdit(Model model) {
		Aa21b13s01Controller.logger.info("[GET - View] : aa21b13s01");
		return "aa21b13s01";
	}

	/**
	 * Method 'getCreateFormAñadir'.
	 * 
	 * @param model
	 *            Model
	 * @param request
	 *            HttpServletRequest
	 * 
	 * @return String
	 */
	@RequestMapping(value = "/altaservicio", method = RequestMethod.GET)
	public String getCreateFormAlta(Model model, HttpServletRequest request) {

		model.addAttribute("defaultLanguage", this.appConfiguration
				.get("aa21bOrgDocumentalWar.default.language"));
		model.addAttribute("defaultLayout", this.appConfiguration
				.get("aa21bOrgDocumentalWar.default.layout"));

		model.addAttribute("tipoDetalleServicio", "A");

		return "detalleServicio";
	}

	/**
	 * Method 'getCreateFormAñadir'.
	 * 
	 * @param model
	 *            Model
	 * @param request
	 *            HttpServletRequest
	 * 
	 * @return String
	 */
	@RequestMapping(value = "/modificarservicio", method = RequestMethod.GET)
	public String getCreateFormModificarServicio(@RequestParam String cserv13,
			Model model, HttpServletRequest request) {

		model.addAttribute("defaultLanguage", this.appConfiguration
				.get("aa21bOrgDocumentalWar.default.language"));
		model.addAttribute("defaultLayout", this.appConfiguration
				.get("aa21bOrgDocumentalWar.default.layout"));

		model.addAttribute("tipoDetalleServicio", "M");
		model.addAttribute("cserv", cserv13);

		return "detalleServicio";
	}

	/**
	 * Method 'getCreateFormConsultarServicio'.
	 * 
	 * @param model
	 *            Model
	 * @param request
	 *            HttpServletRequest
	 * 
	 * @return String
	 */
	@RequestMapping(value = "/consultarservicio", method = RequestMethod.GET)
	public String getCreateFormConsultarServicio(Model model,
			HttpServletRequest request) {

		model.addAttribute("defaultLanguage", this.appConfiguration
				.get("aa21bOrgDocumentalWar.default.language"));
		model.addAttribute("defaultLayout", this.appConfiguration
				.get("aa21bOrgDocumentalWar.default.layout"));

		model.addAttribute("tipoDetalleServicio", "C");
		model.addAttribute("cserv", request.getParameter("cserv13"));

		return "detalleServicio";
	}

	/**
	 * Method 'getCreateFormModificar'.
	 * 
	 * @param model
	 *            Model
	 * @param request
	 *            HttpServletRequest
	 * 
	 * @return ModelAndView
	 */
	/*
	 * @RequestMapping(value = "/modificarservicio", method =
	 * RequestMethod.POST) public String getCreateFormModificar(Model model,
	 * HttpServletRequest request) {
	 * 
	 * model.addAttribute("defaultLanguage", this.appConfiguration
	 * .get("aa21bOrgDocumentalWar.default.language"));
	 * model.addAttribute("defaultLayout", this.appConfiguration
	 * .get("aa21bOrgDocumentalWar.default.layout"));
	 * 
	 * if (request.getParameter("cserv13") != null) {
	 * model.addAttribute("cserv13", request.getParameter("cserv13")); }
	 * model.addAttribute("tipoDetalleServicio", "M");
	 * 
	 * return "detalleServicio"; }
	 */

	/**
	 * Operacion de filtrado del componente RUP_TABLE.
	 * 
	 * @param filterAa21b13s01
	 *            Aa21b13s01 Bean que contiene los parametros de filtrado a
	 *            emplear.
	 * @param jqGridRequestDto
	 *            Dto que contiene los parametros de configuracion propios del
	 *            RUP_TABLE a aplicar en el filtrado.
	 * @return JQGridResponseDto<Aa21b13s01> Dto que contiene el resultado del
	 *         filtrado realizado por el componente RUP_TABLE.
	 */
	@RequestMapping(value = "/filter", method = RequestMethod.POST)
	public @ResponseBody
	JQGridResponseDto<Aa21b13s01> filter(
			@RequestJsonBody(param = "filter") Aa21b13s01 filterAa21b13s01,
			@RequestJsonBody JQGridRequestDto jqGridRequestDto) {
		Aa21b13s01Controller.logger
				.info("[POST - filter] : Obtener Aa21b13s01s");

		List<Aa21b13s01> listaServicios = new ArrayList<Aa21b13s01>();
		String vacio = "";
		if (filterAa21b13s01.getCServ13() != null
				&& !filterAa21b13s01.getCServ13().equals(vacio)
				// NULL como string...
				&& !filterAa21b13s01.getCServ13().equals("null")) {

			String[] arrayServicios = filterAa21b13s01.getCServ13().split(",");

			Aa21b13s01 servicio = null;
			for (int x = 0; x < arrayServicios.length; x++) {
				servicio = new Aa21b13s01();// NOPMD

				servicio.setCServ13(arrayServicios[x]);

				listaServicios.add(servicio);
			}

		}

		return this.aa21b13s01Service.filter(filterAa21b13s01,
				jqGridRequestDto, listaServicios, false);
	}

	/**
	 * Operacion de busqueda del componente RUP_TABLE.
	 * 
	 * @param filterAa21b13s01
	 *            Aa21b13s01 Bean que contiene los parametros de filtrado a
	 *            emplear.
	 * @param searchAa21b13s01
	 *            Aa21b13s01 Bean que contiene los parametros de busqueda a
	 *            emplear.
	 * @param jqGridRequestDto
	 *            Dto que contiene los parametros de configuracion propios del
	 *            RUP_TABLE a aplicar en la búsqueda.
	 * @return TableRowDto<Aa21b13s01> Dto que contiene el resultado de la
	 *         busqueda realizada por el componente RUP_TABLE.
	 */
	@RequestMapping(value = "/search", method = RequestMethod.POST)
	public @ResponseBody
	List<TableRowDto<Aa21b13s01>> search(
			@RequestJsonBody(param = "filter") Aa21b13s01 filterAa21b13s01,
			@RequestJsonBody(param = "search") Aa21b13s01 searchAa21b13s01,
			@RequestJsonBody JQGridRequestDto jqGridRequestDto) {
		Aa21b13s01Controller.logger
				.info("[POST - search] : Buscar Aa21b13s01s");
		return this.aa21b13s01Service.search(filterAa21b13s01,
				searchAa21b13s01, jqGridRequestDto, false);
	}

	/**
	 * Borrado multiple de registros
	 * 
	 * @param filterAa21b13s01
	 *            Aa21b13s01 Bean que contiene los parametros de filtrado a
	 *            emplear.
	 * @param jqGridRequestDto
	 *            Dto que contiene los parametros de configuracion propios del
	 *            RUP_TABLE a aplicar en la busqueda.
	 * @return List<String> Lista de los identificadores de los registros
	 *         eliminados.
	 * 
	 */
	@RequestMapping(value = "/deleteAll", method = RequestMethod.POST)
	@ResponseStatus(value = HttpStatus.OK)
	public @ResponseBody
	List<String> removeMultiple(
			@RequestJsonBody(param = "filter") Aa21b13s01 filterAa21b13s01,
			@RequestJsonBody JQGridRequestDto jqGridRequestDto) {
		Aa21b13s01Controller.logger
				.info("[POST - search] : [POST - removeMultiple] : Eliminar multiples Aa21b13s01s");
		this.aa21b13s01Service.removeMultiple(filterAa21b13s01,
				jqGridRequestDto, false);
		Aa21b13s01Controller.logger.info("All entities correctly deleted!");

		return jqGridRequestDto.getMultiselection().getSelectedIds();
	}

	/*
	 * METODOS COMPONENTE RUP_TABLE - JERARQUIA
	 */

	/**
	 * Operacion de filtrado del componente RUP_TABLE para presentar los
	 * registros mediante visualizacion jerarquica.
	 * 
	 * @param filterAa21b13s01
	 *            Aa21b13s01 Bean que contiene los parametros de filtrado a
	 *            emplear.
	 * @param jqGridRequestDto
	 *            Dto que contiene los parametros de configuracion propios del
	 *            RUP_TABLE a aplicar en el filtrado.
	 * @return JQGridResponseDto<JerarquiaDto<Aa21b13s01>> Dto que contiene el
	 *         resultado del filtrado realizado por el componente RUP_TABLE.
	 */
	@RequestMapping(value = "/jerarquia/filter", method = RequestMethod.POST)
	public @ResponseBody
	JQGridResponseDto<JerarquiaDto<Aa21b13s01>> jerarquia(
			@RequestJsonBody(param = "filter") Aa21b13s01 filterAa21b13s01,
			@RequestJsonBody JQGridRequestDto jqGridRequestDto) {
		Aa21b13s01Controller.logger
				.info("[POST - jerarquia] : Obtener Aa21b13s01s jerarquia");
		return this.aa21b13s01Service.jerarquia(filterAa21b13s01,
				jqGridRequestDto, false);
	}

	/**
	 * Recupera los hijos de los registros desplegados en la visualizacion
	 * jerarquica.
	 * 
	 * @param filterAa21b13s01
	 *            Aa21b13s01 Bean que contiene los parametros de filtrado a
	 *            emplear.
	 * @param jqGridRequestDto
	 *            Dto que contiene los parametros de configuracion propios del
	 *            RUP_TABLE a aplicar en el filtrado.
	 * @return JQGridResponseDto<JerarquiaDto<Aa21b13s01>> Dto que contiene el
	 *         resultado del filtrado realizado por el componente RUP_TABLE.
	 */
	@RequestMapping(value = "/jerarquiaChildren", method = RequestMethod.POST)
	public @ResponseBody
	JQGridResponseDto<JerarquiaDto<Aa21b13s01>> jerarquiaChildren(
			@RequestJsonBody(param = "filter") Aa21b13s01 filterAa21b13s01,
			@RequestJsonBody JQGridRequestDto jqGridRequestDto) {
		Aa21b13s01Controller.logger
				.info("[POST - jerarquia] : Obtener Aa21b13s01s jerarquia - Hijos");
		return this.aa21b13s01Service.jerarquiaChildren(filterAa21b13s01,
				jqGridRequestDto);
	}

	/**
	 * Method 'getAutocompleteServicioCas'.
	 * 
	 * @param q
	 *            String
	 * @param c
	 *            Boolean
	 * 
	 * @return List<Aa21b13s01>
	 */
	@RequestMapping(value = "/autocompleteDenoServCas", method = RequestMethod.GET)
	public @ResponseBody
	List<Aa21b13s01> getAutocompleteServicioCas(
			@RequestParam(value = "q", required = true) String q,
			@RequestParam(value = "c", required = true) Boolean c) {

		Aa21b13s01 servicio = new Aa21b13s01();

		servicio.setDServ13(q);

		return this.aa21b13s01Service.findServicio(servicio, c);

	}

	/**
	 * Method 'getAutocompleteServicioEusk'.
	 * 
	 * @param q
	 *            String
	 * @param c
	 *            Boolean
	 * 
	 * @return List<Aa21b13s01>
	 */
	@RequestMapping(value = "/autocompleteDenoServEusk", method = RequestMethod.GET)
	public @ResponseBody
	List<Aa21b13s01> getAutocompleteServicioEusk(
			@RequestParam(value = "q", required = true) String q,
			@RequestParam(value = "c", required = true) Boolean c) {

		Aa21b13s01 servicio = new Aa21b13s01();

		servicio.setEServ13(q);

		return this.aa21b13s01Service.findServicio(servicio, c);

	}

	/**
	 * 
	 * @param aa21b13s01
	 *            Aa21b13s01
	 * @return Aa21b13s01
	 * @throws Exception
	 *             Exception
	 */
	@RequestMapping(value = "/cambioEstadoServicio", method = RequestMethod.POST)
	public @ResponseBody
	Aa21b13s01 cambioEstadoServicio(@RequestBody Aa21b13s01 aa21b13s01)
			throws Exception {

		Aa21b02s01 aa21b02s01Aux = new Aa21b02s01();
		aa21b02s01Aux.setCserv02(aa21b13s01.getCServ13());
		aa21b02s01Aux.setSitu02(aa21b13s01.getSitu13());

		this.aa21b02s01Service.compruebaBloqueosServicio(aa21b02s01Aux);

		Aa21b01s01 aa21b01s01Aux = new Aa21b01s01();
		aa21b01s01Aux.setCserv01(aa21b13s01.getCServ13());
		aa21b01s01Aux.setSitu01(aa21b13s01.getSitu13());

		this.aa21b01s01Service.compruebaBloqueosServicio(aa21b01s01Aux);

		//
		Aa21b13s01 aa21b13s01Aux = this.aa21b13s01Service.update(aa21b13s01);
		this.aa21b02s01Service.updateEstadosServicio(aa21b02s01Aux);
		this.aa21b01s01Service.updateEstadosServicio(aa21b01s01Aux);

		Aa21b13s01Controller.logger
				.info("[PUT] : aa21b13s01 estado actualizado correctamente");
		return aa21b13s01Aux;
	}

	/**
	 * 
	 * @param aa21b13s01
	 *            Aa21b13s01
	 * @return aa21b13s01
	 */
	@RequestMapping(value = "/updateBloqueos", method = RequestMethod.POST)
	public @ResponseBody
	Aa21b13s01 updateBloqueos(@RequestBody Aa21b13s01 aa21b13s01) {

		/**
		 * Obtengo el usuario de XLNETS y a partir del código, busco en la tabla
		 * el servicio al que corresponde Solo cargaremos en el combo de
		 * responsables los de ese servicio
		 */
		Aa21bPersonaSesion ps = new Aa21bSeguridad().getUsuario();
		String usuario = ps.getPersonaXLNET().getCodigo();
		logger.info("Usuario XLNETS=" + usuario);

		Aa21b15s01 aa21b15s01busqUsuario = ps.getPersonaAplicacion();
		logger.info("Buscar el usuario en la tabla 15");

		if (aa21b13s01 != null) {
			aa21b13s01.setCServ13(aa21b15s01busqUsuario.getCserv15());
		} else {
			aa21b13s01 = new Aa21b13s01();
			aa21b13s01.setCServ13(aa21b15s01busqUsuario.getCserv15());
		}
		aa21b13s01.setBloq13("0");

		Aa21b13s01 aa21b13s01Aux = this.aa21b13s01Service
				.updateBloqueos(aa21b13s01);
		Aa21b13s01Controller.logger
				.info("[PUT] : aa21b13s01 estado actualizado correctamente");
		return aa21b13s01Aux;
	}

	/**
	 * Method 'bloquear'.
	 * 
	 * @param cserv13
	 *            String
	 * @return boolean
	 */
	@RequestMapping(value = "bloquear/{cserv13}", method = RequestMethod.POST)
	public @ResponseBody
	boolean bloquear(@PathVariable String cserv13) {

		return this.aa21b13s01Service.bloquear(cserv13);
	}

	/**
	 * Method 'desbloquear'.
	 * 
	 * @param cserv13
	 *            String
	 * @return boolean
	 */
	@RequestMapping(value = "desbloquear/{cserv13}", method = RequestMethod.POST)
	public @ResponseBody
	boolean desbloquear(@PathVariable String cserv13) {

		return this.aa21b13s01Service.desbloquear(cserv13);
	}

	/**
	 * Operacion de filtrado del componente RUP_TABLE.
	 * 
	 * @param filterAa21b13s01
	 *            Aa21b13s01 Bean que contiene los parametros de filtrado a
	 *            emplear.
	 * @param jqGridRequestDto
	 *            Dto que contiene los parametros de configuracion propios del
	 *            RUP_TABLE a aplicar en el filtrado.
	 * @return JQGridResponseDto<Aa21b13s01> Dto que contiene el resultado del
	 *         filtrado realizado por el componente RUP_TABLE.
	 */
	@RequestMapping(value = "/findUsuario/filter", method = RequestMethod.POST)
	public @ResponseBody
	Object findUsuario(HttpServletRequest request) {
		Aa21b13s01Controller.logger
				.info("[POST - filter] : Obtener UsuariosAsigTemp");

		JQGridRequestDto data = new JQGridRequestDto();

		data.setRows(new Long(0));
		data.setPage(new Long(0));

		return new JQGridResponseDto<Aa21b15s01>(data, new Long(0), null);
	}

	/**
	 * Method 'crearServicio'.
	 * 
	 * @param servicio
	 *            Aa21b13s01
	 * @param listaUsuAsig
	 *            ArrayList<String>
	 * @return String
	 */
	@RequestMapping(value = "/crearServicio", method = RequestMethod.POST)
	public @ResponseBody
	Aa21b13s01 crearServicio(@RequestBody Aa21b13s01 servicio,
			@RequestParam ArrayList<String> listaUsuAsig) {

		Aa21b13s01 aa21b13s01 = this.aa21b13s01Service.add(servicio);
		Aa21b13s01Controller.logger
				.info("[POST] : Aa21b13s01 insertado correctamente");

		if (listaUsuAsig != null) {
			Aa21b13s01Controller.logger
					.info("[POST] : Aa21b13s01 actualizar usuarios asignados ");

			this.aa21b15s01Service.updateAsignados(listaUsuAsig, servicio);
		}

		return aa21b13s01;
	}

	/**
	 * Method 'actualizarServicio'.
	 * 
	 * @param servicio
	 *            Aa21b13s01
	 * @param listaUsuAsig
	 *            ArrayList<String>
	 * @param listaDesagregar
	 *            ArrayList<String>
	 * @return String
	 */
	@RequestMapping(value = "/actualizarServicio", method = RequestMethod.POST)
	public @ResponseBody
	Aa21b13s01 actualizarServicio(@RequestBody Aa21b13s01 servicio,
			@RequestParam ArrayList<String> listaUsuAsig,
			@RequestParam ArrayList<String> listaDesagregar) {

		Aa21b13s01 aa21b13s01Aux = this.aa21b13s01Service.update(servicio);
		Aa21b13s01Controller.logger
				.info("[POST] : Aa21b13s01 actualizado correctamente");

		if (listaUsuAsig != null) {
			Aa21b13s01Controller.logger
					.info("[POST] : Aa21b13s01 actualizar usuarios asignados ");

			this.aa21b15s01Service.updateAsignados(listaUsuAsig, servicio);
		}

		if (listaDesagregar != null) {
			Aa21b13s01Controller.logger
					.info("[POST] : Aa21b13s01 desagregar usuarios seleccionados");

			this.aa21b15s01Service.removeAsignados(listaDesagregar);

		}

		return aa21b13s01Aux;
	}

	/**
	 * Method 'getDenoServicio'.
	 * 
	 * @param cServ13
	 *            String
	 * 
	 * @return Aa21b13s01
	 */
	@RequestMapping(value = "/obtenerDenoServ", method = RequestMethod.GET)
	public @ResponseBody
	Aa21b13s01 getDenoServicio(
			@RequestParam(value = "cServ", required = false) String cServ13) {

		Aa21b13s01 servicio = new Aa21b13s01();

		servicio.setCServ13(cServ13);

		return this.aa21b13s01Service.find(servicio);
	}

	/**
	 * Method 'getComboServicios'.
	 * 
	 * @return List<Aa21b13s01>
	 */
	@RequestMapping(value = "/comboServicios", method = RequestMethod.GET)
	public @ResponseBody
	List<Aa21b13s01> getComboServicios() {
		return this.aa21b13s01Service.findAll(null, null);
	}

}
