// @formatter:off
package com.ejie.aa21b.control;

import java.util.List;

import javax.servlet.http.HttpServletRequest;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;

import com.ejie.aa21b.model.Aa21b02s01;
import com.ejie.aa21b.model.Aa21b05s01;
import com.ejie.aa21b.model.Aa21b20s01;
import com.ejie.aa21b.model.NoraPais;
import com.ejie.aa21b.model.NoraProvincia;
import com.ejie.aa21b.seguridad.Aa21bSeguridad;
import com.ejie.aa21b.service.Aa21b02s01Service;
import com.ejie.aa21b.service.Aa21b05s01Service;
import com.ejie.aa21b.service.Aa21b07s01Service;
import com.ejie.aa21b.service.Aa21b12s01Service;
import com.ejie.aa21b.service.Aa21b14s01Service;
import com.ejie.aa21b.service.Aa21b20s01Service;
import com.ejie.aa21b.service.NoraPaisService;
import com.ejie.aa21b.service.NoraProvinciaService;
import com.ejie.x38.control.bind.annotation.RequestJsonBody;
import com.ejie.x38.dto.JQGridRequestDto;
import com.ejie.x38.dto.JQGridResponseDto;
import com.ejie.x38.dto.JerarquiaDto;
import com.ejie.x38.dto.TableRowDto;

/**
 * Aa21b05s01Controller  
 * 
 *  
 */

@Controller
@RequestMapping(value = "/aa21b05s01")
public class Aa21b05s01Controller {

	private static final Logger logger = LoggerFactory.getLogger(Aa21b05s01Controller.class);

	@Autowired
	private Aa21b05s01Service aa21b05s01Service;

	@Autowired
	private Aa21b20s01Service aa21b20s01Service;

	@Autowired
	private Aa21b07s01Service aa21b07s01Service;

	@Autowired
	private Aa21b02s01Service aa21b02s01Service;

	@Autowired
	private Aa21b14s01Service aa21b14s01Service;

	@Autowired
	private Aa21b12s01Service aa21b12s01Service;

	@Autowired
	private NoraPaisService noraPaisService;

	@Autowired
	private NoraProvinciaService noraProvinciaService;

	/*
	 * OPERACIONES CRUD (Create, Read, Update, Delete)
	 */

	/**
	 * Operacion CRUD Read. Devuelve el bean correspondiente al identificador indicado.
	 * 
	 * @param cdocu05 Integer
	 * @return Aa21b05s01 Objeto correspondiente al identificador indicado.
	 */
	@RequestMapping(value = "/{cdocu05}", method = RequestMethod.GET)
	public @ResponseBody Aa21b05s01 get(@PathVariable Integer cdocu05) {
		Aa21b05s01 aa21b05s01 = new Aa21b05s01();
		aa21b05s01.setCdocu05(cdocu05);
		aa21b05s01 = this.aa21b05s01Service.find(aa21b05s01);
		Aa21b05s01Controller.logger.info("[GET - findBy_PK] : Obtener Aa21b05s01 por PK");
		return aa21b05s01;
	}

	/**
	 * Devuelve una lista de beans correspondientes a los valores de filtrados indicados en el objeto pasado como parametro.
	 * 
	 * @param filterAa21b05s01 Aa21b05s01 Objeto que contiene los parametros de filtrado utilizados en la busqueda.
	 * @return List<Aa21b05s01> Lista de objetos correspondientes a la busqueda realizada.
	 */
	@RequestMapping(method = RequestMethod.GET)
	public @ResponseBody List<Aa21b05s01> getAll(@ModelAttribute Aa21b05s01 filterAa21b05s01) {
		Aa21b05s01Controller.logger.info("[GET - find_ALL] : Obtener Aa21b05s01 por filtro");
		return this.aa21b05s01Service.findAll(filterAa21b05s01, null);
	}

	/**
	 * Operacion CRUD Edit. Modificacion del bean indicado.
	 * 
	 * @param aa21b05s01 Aa21b05s01 Bean que contiene la informacion a modificar.
	 * @return Aa21b05s01 Bean resultante de la modificacion.
	 */
	@RequestMapping(method = RequestMethod.PUT)
	public @ResponseBody Aa21b05s01 edit(@RequestBody Aa21b05s01 aa21b05s01) {
		Aa21b05s01 aa21b05s01Aux = this.aa21b05s01Service.update(aa21b05s01);
		Aa21b05s01Controller.logger.info("[PUT] : Aa21b05s01 actualizado correctamente");
		return aa21b05s01Aux;
	}

	/**
	 * Operacion CRUD Create. Creacion de un nuevo registro a partir del bean indicado.
	 * 
	 * @param aa21b05s01 Aa21b05s01 Bean que contiene la informacion con la que se va a crear el nuevo registro.
	 * @return Aa21b05s01 Bean resultante del proceso de creacion.
	 */
	@RequestMapping(method = RequestMethod.POST)
	public @ResponseBody Aa21b05s01 add(@RequestBody Aa21b05s01 aa21b05s01) {
		Aa21b05s01 aa21b05s01Aux = this.aa21b05s01Service.add(aa21b05s01);
		Aa21b05s01Controller.logger.info("[POST] : Aa21b05s01 insertado correctamente");
		return aa21b05s01Aux;
	}

	/**
	 * Operacion CRUD Delete. Borrado del registro correspondiente al identificador especificado.
	 * 
	 * @param cdocu05 Integer Identificador del objeto que se desea eliminar.
	 * @return Aa21b05s01 Bean eliminado.
	 * @throws Exception
	 */
	@RequestMapping(value = "/{cdocu05}", method = RequestMethod.DELETE)
	@ResponseStatus(value = HttpStatus.OK)
	public @ResponseBody Aa21b05s01 remove(@PathVariable Integer cdocu05) throws Exception {
		Aa21b05s01 aa21b05s01 = new Aa21b05s01();
		aa21b05s01.setCdocu05(cdocu05);
		this.aa21b05s01Service.remove(aa21b05s01);
		Aa21b05s01Controller.logger.info("[DELETE] : Aa21b05s01 borrado correctamente");
		return aa21b05s01;
	}

	/*
	 * METODOS COMPONENTE RUP_TABLE
	 */

	/**
	 * Metodo de presentacion del RUP_TABLE.
	 * 
	 * @param model Model
	 * @return String
	 */
	@RequestMapping(value = "/maint", method = RequestMethod.GET)
	public String getFormEdit(Model model) {
		Aa21b05s01Controller.logger.info("[GET - View] : aa21b05s01");
		Aa21b02s01 filtroTipos = new Aa21b02s01();
		logger.info("Cargar tipos de expedientes en el modelo");
		model.addAttribute("tiposExpedientes", this.aa21b02s01Service.findAll(filtroTipos, null));

		// Estados de expediente
		logger.info("Cargar estados de expedientes en el modelo");
		model.addAttribute("estadosExpedientes", this.aa21b07s01Service.findAll(null, null));

		// ubicaciones
		logger.info("Cargar ubicaciones en el modelo");
		model.addAttribute("ubicaciones", this.aa21b14s01Service.findAll(null, null));

		// Departamentos
		logger.info("Cargar departamentos en el modelo");
		// Departamentos
		model.addAttribute("departamentos", this.aa21b12s01Service.findAll(null, null));
		logger.info("Cargar paises del nora en el modelo");
		List<NoraPais> paises = this.noraPaisService.findAll(null, null);
		model.addAttribute("paises", paises);
		logger.info("Cargar provincias del nora en el modelo");
		List<NoraProvincia> provincias = this.noraProvinciaService.findAll(null, null);
		model.addAttribute("provincias", provincias);
		return "aa21b05s01";
	}

	/**
	 * Operacion de filtrado del componente RUP_TABLE.
	 * 
	 * @param filterAa21b05s01 Aa21b05s01 Bean que contiene los parametros de filtrado a emplear.
	 * @param jqGridRequestDto Dto que contiene los parametros de configuracion propios del RUP_TABLE a aplicar en el filtrado.
	 * @return JQGridResponseDto<Aa21b05s01> Dto que contiene el resultado del filtrado realizado por el componente RUP_TABLE.
	 */
	@RequestMapping(value = "/filter", method = RequestMethod.POST)
	public @ResponseBody JQGridResponseDto<Aa21b05s01> filter(@RequestJsonBody(param = "filter") Aa21b05s01 filterAa21b05s01,
															  @RequestJsonBody JQGridRequestDto jqGridRequestDto) {
		Aa21b05s01Controller.logger.info("[POST - filter] : Obtener Aa21b05s01s");
		return this.aa21b05s01Service.filter(filterAa21b05s01, jqGridRequestDto, false);
	}

	/**
	 * Operacion de busqueda del componente RUP_TABLE.
	 * 
	 * @param filterAa21b05s01 Aa21b05s01 Bean que contiene los parametros de filtrado a emplear.
	 * @param searchAa21b05s01 Aa21b05s01 Bean que contiene los parametros de busqueda a emplear.
	 * @param jqGridRequestDto Dto que contiene los parametros de configuracion propios del RUP_TABLE a aplicar en la búsqueda.
	 * @return TableRowDto<Aa21b05s01> Dto que contiene el resultado de la busqueda realizada por el componente RUP_TABLE.
	 */
	@RequestMapping(value = "/search", method = RequestMethod.POST)
	public @ResponseBody List<TableRowDto<Aa21b05s01>> search(@RequestJsonBody(param = "filter") Aa21b05s01 filterAa21b05s01,
															  @RequestJsonBody(param = "search") Aa21b05s01 searchAa21b05s01,
			@RequestJsonBody JQGridRequestDto jqGridRequestDto) {
		Aa21b05s01Controller.logger.info("[POST - search] : Buscar Aa21b05s01s");
		return this.aa21b05s01Service.search(filterAa21b05s01, searchAa21b05s01, jqGridRequestDto, false);
	}

	/**
	 * Borrado multiple de registros
	 * 
	 * @param filterAa21b05s01 Aa21b05s01 Bean que contiene los parametros de filtrado a emplear.
	 * @param jqGridRequestDto Dto que contiene los parametros de configuracion propios del RUP_TABLE a aplicar en la busqueda.
	 * @return List<String> Lista de los identificadores de los registros eliminados.
	 */
	@RequestMapping(value = "/deleteAll", method = RequestMethod.POST)
	@ResponseStatus(value = HttpStatus.OK)
	public @ResponseBody List<String> removeMultiple(@RequestJsonBody(param = "filter") Aa21b05s01 filterAa21b05s01,
													 @RequestJsonBody JQGridRequestDto jqGridRequestDto) {
		Aa21b05s01Controller.logger.info("[POST - search] : [POST - removeMultiple] : Eliminar multiples Aa21b05s01s");
		this.aa21b05s01Service.removeMultiple(filterAa21b05s01, jqGridRequestDto, false);
		Aa21b05s01Controller.logger.info("All entities correctly deleted!");
		return jqGridRequestDto.getMultiselection().getSelectedIds();
	}

	/*
	 * METODOS COMPONENTE RUP_TABLE - JERARQUIA
	 */

	/**
	 * Operacion de filtrado del componente RUP_TABLE para presentar los registros mediante visualizacion jerarquica.
	 * 
	 * @param filterAa21b05s01 Aa21b05s01 Bean que contiene los parametros de filtrado a emplear.
	 * @param jqGridRequestDto Dto que contiene los parametros de configuracion propios del RUP_TABLE a aplicar en el filtrado.
	 * @return JQGridResponseDto<JerarquiaDto<Aa21b05s01>> Dto que contiene el resultado del filtrado realizado por el componente RUP_TABLE.
	 */
	@RequestMapping(value = "/jerarquia/filter", method = RequestMethod.POST)
	public @ResponseBody JQGridResponseDto<JerarquiaDto<Aa21b05s01>> jerarquia(@RequestJsonBody(param = "filter") Aa21b05s01 filterAa21b05s01,
																			   @RequestJsonBody JQGridRequestDto jqGridRequestDto) {
		Aa21b05s01Controller.logger.info("[POST - jerarquia] : Obtener Aa21b05s01s jerarquia");
		return this.aa21b05s01Service.jerarquia(filterAa21b05s01, jqGridRequestDto, false);
	}

	/**
	 * Recupera los hijos de los registros desplegados en la visualizacion jerarquica.
	 * 
	 * @param filterAa21b05s01 Aa21b05s01 Bean que contiene los parametros de filtrado a emplear.
	 * @param jqGridRequestDto Dto que contiene los parametros de configuracion propios del RUP_TABLE a aplicar en el filtrado.
	 * @return JQGridResponseDto<JerarquiaDto<Aa21b05s01>> Dto que contiene el resultado del filtrado realizado por el componente RUP_TABLE.
	 */
	@RequestMapping(value = "/jerarquiaChildren", method = RequestMethod.POST)
	public @ResponseBody JQGridResponseDto<JerarquiaDto<Aa21b05s01>> jerarquiaChildren(@RequestJsonBody(param = "filter") Aa21b05s01 filterAa21b05s01,
																					   @RequestJsonBody JQGridRequestDto jqGridRequestDto) {
		Aa21b05s01Controller.logger.info("[POST - jerarquia] : Obtener Aa21b05s01s jerarquia - Hijos");
		return this.aa21b05s01Service.jerarquiaChildren(filterAa21b05s01, jqGridRequestDto);
	}

	/**
	 * Method 'getAutocompleteCodigoExpediente'.
	 * 
	 * @param q String
	 * @param c Boolean
	 * 
	 * @return List<Aa21b05s01>
	 */
	@RequestMapping(value = "/autocompleteDenoTipoDocCas", method = RequestMethod.GET)
	public @ResponseBody List<Aa21b05s01> getAutocompleteDenoTipoDocCas(@RequestParam(value = "q", required = true) String q,
																		@RequestParam(value = "c", required = true) Boolean c) {
		Aa21b05s01 tipoDocumento = new Aa21b05s01();
		tipoDocumento.setDdocu05(q);
		return this.aa21b05s01Service.findTipoDocumento(tipoDocumento, c);
	}

	/**
	 * Method 'getAutocompleteCodigoExpediente'.
	 * 
	 * @param q String
	 * @param c Boolean
	 * 
	 * @return List<Aa21b05s01>
	 */
	@RequestMapping(value = "/autocompleteDenoTipoDocEusk", method = RequestMethod.GET)
	public @ResponseBody List<Aa21b05s01> getAutocompleteDenoTipoDocEusk(@RequestParam(value = "q", required = true) String q,
																		 @RequestParam(value = "c", required = true) Boolean c) {
		Aa21b05s01 tipoDocumento = new Aa21b05s01();
		tipoDocumento.setEdocu05(q);
		return this.aa21b05s01Service.findTipoDocumento(tipoDocumento, c);
	}

	/**
	 * 
	 * @param aa21b05s01 Aa21b05s01
	 * @return aa21b05s01
	 */
	@RequestMapping(value = "/cambioEstadoTipoDocumento", method = RequestMethod.POST)
	public @ResponseBody Aa21b05s01 cambioEstadoTipoDoc(@RequestBody Aa21b05s01 aa21b05s01) {
		Aa21b05s01 aa21b05s01Aux = this.aa21b05s01Service.update(aa21b05s01);
		Aa21b05s01Controller.logger.info("[PUT] : aa21b05s01 estado actualizado correctamente");
		return aa21b05s01Aux;
	}

	/**
	 * @param aa21b05s01 Aa21b05s01
	 * @return aa21b05s01
	 */
	@RequestMapping(value = "/updateBloqueos", method = RequestMethod.POST)
	public @ResponseBody Aa21b05s01 updateBloqueos(@RequestBody Aa21b05s01 aa21b05s01) {
		Aa21b05s01 aa21b05s01Aux = this.aa21b05s01Service.updateBloqueos(aa21b05s01);
		Aa21b05s01Controller.logger.info("[PUT] : aa21b05s01 bloqueo actualizado correctamente");
		return aa21b05s01Aux;
	}

	/**
	 * Method 'bloquear'.
	 * 
	 * @param cdocu05 String
	 * @return boolean
	 */
	@RequestMapping(value = "bloquear/{cdocu05}", method = RequestMethod.POST)
	public @ResponseBody boolean bloquear(@PathVariable String cdocu05) {
		return this.aa21b05s01Service.bloquear(cdocu05);
	}

	/**
	 * Method 'desbloquear'.
	 * 
	 * @param cdocu05 String
	 * @return boolean
	 */
	@RequestMapping(value = "desbloquear/{cdocu05}", method = RequestMethod.POST)
	public @ResponseBody boolean desbloquear(@PathVariable String cdocu05) {
		return this.aa21b05s01Service.desbloquear(cdocu05);
	}

	/**
	 * Crear excel tipos documentos
	 * 
	 * @param model Model
	 * @param filterTiposDocumentos Aa21b05s01
	 * @param request HttpServletRequest
	 * @return String
	 */
	@RequestMapping(value = "excelTiposDocumentos", method = RequestMethod.POST)
	public String informeExcelDepartamentos(Model model, @ModelAttribute Aa21b05s01 filterTiposDocumentos, HttpServletRequest request) {
		Aa21b05s01Controller.logger.info("Creando informe Excel Tipos documentos");
		String view = "";

		// Parametros formulario filtrado tipos documentos
		if (request.getParameter("icdocu05") != null && !request.getParameter("icdocu05").equals("")) {
			filterTiposDocumentos.setCdocu05(new Integer(request.getParameter("icdocu05")));
		}

		if (request.getParameter("iddocu05") != null && !request.getParameter("iddocu05").equals("")) {
			filterTiposDocumentos.setDdocu05(request.getParameter("iddocu05"));
		}

		if (request.getParameter("iedocu05") != null && !request.getParameter("iedocu05").equals("")) {
			filterTiposDocumentos.setEdocu05(request.getParameter("iedocu05"));
		}

		if (request.getParameter("isitu05") != null && !request.getParameter("isitu05").equals("")) {
			filterTiposDocumentos.setSitu05(request.getParameter("isitu05"));
		}

		JQGridRequestDto jqGridRequestDto = new JQGridRequestDto();
		jqGridRequestDto.setSidx("cdocu05");
		jqGridRequestDto.setSord("asc");
		model.addAttribute("tiposDocumentos", aa21b05s01Service.findAllLike(filterTiposDocumentos, jqGridRequestDto, false));

		view = "reporteExcelTiposDocumentos";
		return view;
	}

	/**
	 * Method 'getComboTiposDocumentos'.
	 * 
	 * @return List<Aa21b05s01>
	 */
	@RequestMapping(value = "/comboTiposDocumentos", method = RequestMethod.GET)
	public @ResponseBody List<Aa21b05s01> getComboTiposDocumentos() {
		return this.aa21b05s01Service.findAll(null, null);
	}

	/**
	 * Method 'getExpedientesAsociados'.
	 * 
	 * @param cdocu05 String
	 * @param jqGridRequestDto JQGridRequestDto
	 * 
	 * @return List<Aa21b20s01>
	 */
	@RequestMapping(value = "/obtenerExpedientesTipoDoc/{cdocu05}", method = RequestMethod.POST)
	public @ResponseBody JQGridResponseDto<Aa21b20s01> getExpedientesAsociados(@PathVariable String cdocu05, @RequestJsonBody JQGridRequestDto jqGridRequestDto) {
		Aa21b20s01 filterAa21b20s01 = new Aa21b20s01();
		if (cdocu05 != null && !cdocu05.equals("")) {
			filterAa21b20s01.setCdocu(cdocu05);
			return this.aa21b20s01Service.filter(filterAa21b20s01, jqGridRequestDto, false);
		} else {
			JQGridRequestDto data = new JQGridRequestDto();
			data.setRows(new Long(0));
			data.setPage(new Long(0));
			return new JQGridResponseDto<Aa21b20s01>(data, new Long(0), null);
		}
	}
	
	@RequestMapping(value = "/obtenerExpedientesTipoDocServ/{cdocu05}", method = RequestMethod.POST)
	public @ResponseBody JQGridResponseDto<Aa21b20s01> getExpedientesAsociadosServ(@PathVariable String cdocu05, @RequestJsonBody JQGridRequestDto jqGridRequestDto) {
		Aa21b20s01 filterAa21b20s01 = new Aa21b20s01();
		if (cdocu05 != null && !cdocu05.equals("")) {

			//20170109 - INI - INIGO
			String strServicioLogueado = new Aa21bSeguridad().getUsuario().getServicio();
			if (strServicioLogueado != null && !"".equals(strServicioLogueado)) {
				filterAa21b20s01.setServicioLogueado(strServicioLogueado);
			}
			//20170109 - FIN - INIGO

			filterAa21b20s01.setCdocu(cdocu05);
			return this.aa21b20s01Service.filter(filterAa21b20s01, jqGridRequestDto, false);
		} else {
			JQGridRequestDto data = new JQGridRequestDto();
			data.setRows(new Long(0));
			data.setPage(new Long(0));
			return new JQGridResponseDto<Aa21b20s01>(data, new Long(0), null);
		}
	}
}