// @formatter:off
package com.ejie.aa21b.control;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;

import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.propertyeditors.CustomDateEditor;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.ServletRequestDataBinder;
import org.springframework.web.bind.annotation.InitBinder;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.multipart.support.ByteArrayMultipartFileEditor;

import com.ejie.aa21b.model.Aa21b01s01;
import com.ejie.aa21b.model.Aa21b02s01;
import com.ejie.aa21b.model.Aa21b13s01;
import com.ejie.aa21b.model.Aa21b15s01;
import com.ejie.aa21b.model.Aa21b20s01;
import com.ejie.aa21b.seguridad.Aa21bPersonaSesion;
import com.ejie.aa21b.seguridad.Aa21bSeguridad;
import com.ejie.aa21b.service.Aa21b01s01Service;
import com.ejie.aa21b.service.Aa21b02s01Service;
import com.ejie.aa21b.service.Aa21b20s01Service;

import com.ejie.x38.control.bind.annotation.RequestJsonBody;
import com.ejie.x38.dto.JQGridRequestDto;
import com.ejie.x38.dto.JQGridResponseDto;
import com.ejie.x38.dto.JerarquiaDto;
import com.ejie.x38.dto.TableRowDto;
import com.ejie.x38.util.DateTimeManager;

/**
 * Aa21b02s01Controller  
 * 
 *  
 */

@Controller
@RequestMapping(value = "/aa21b02s01")
public class Aa21b02s01Controller {

	private static final Logger logger = LoggerFactory.getLogger(Aa21b02s01Controller.class);

	@Autowired
	private Aa21b02s01Service aa21b02s01Service;

	@Autowired
	private Aa21b01s01Service aa21b01s01Service;

	@Autowired
	private Aa21b20s01Service aa21b20s01Service;

	/*
	 * OPERACIONES CRUD (Create, Read, Update, Delete)
	 */
	@InitBinder
	protected void initBinder(HttpServletRequest request, ServletRequestDataBinder binder) throws ServletException {
		binder.registerCustomEditor(byte[].class, new ByteArrayMultipartFileEditor());
		binder.registerCustomEditor(Date.class, new CustomDateEditor(DateTimeManager.getDateTimeFormat(LocaleContextHolder.getLocale()), true));
	}

	/**
	 * Operacion CRUD Read. Devuelve el bean correspondiente al identificador indicado.
	 * 
	 * @param idTipo String
	 * 
	 * @return Aa21b02s01 Objeto correspondiente al identificador indicado.
	 */
	@RequestMapping(value = "/{idTipo}", method = RequestMethod.GET)
	public @ResponseBody Aa21b02s01 get(@PathVariable String idTipo) {
		Aa21b02s01 aa21b02s01 = new Aa21b02s01();
		if (idTipo != null && !idTipo.equals("")) {
			aa21b02s01.setCserv02(idTipo.substring(0, idTipo.indexOf("-")));
			aa21b02s01.setCtipoe02(idTipo.substring(idTipo.indexOf("-") + 1));
		}
		aa21b02s01 = this.aa21b02s01Service.find(aa21b02s01);
		Aa21b02s01Controller.logger.info("[GET - findBy_PK] : Obtener Aa21b02s01 por PK");
		return aa21b02s01;
	}

	/**
	 * Devuelve una lista de beans correspondientes a los valores de filtrados indicados en el objeto pasado como parametro.
	 * 
	 * @param filterAa21b02s01 Aa21b02s01 Objeto que contiene los parametros de filtrado utilizados en la busqueda.
	 * @return List<Aa21b02s01> Lista de objetos correspondientes a la busqueda realizada.
	 */
	@RequestMapping(method = RequestMethod.GET)
	public @ResponseBody List<Aa21b02s01> getAll(@ModelAttribute Aa21b02s01 filterAa21b02s01) {
		Aa21b02s01Controller.logger.info("[GET - find_ALL] : Obtener Aa21b02s01 por filtro");
		return this.aa21b02s01Service.findAll(filterAa21b02s01, null);
	}

	/**
	 * Operacion CRUD Edit. Modificacion del bean indicado.
	 * 
	 * @param aa21b02s01 Aa21b02s01 Bean que contiene la informacion a modificar.
	 * @return Aa21b02s01 Bean resultante de la modificacion.
	 */
	@RequestMapping(method = RequestMethod.PUT)
	public @ResponseBody Aa21b02s01 edit(@RequestBody Aa21b02s01 aa21b02s01) {
		Aa21b02s01 aa21b02s01Aux = this.aa21b02s01Service.update(aa21b02s01);
		Aa21b02s01Controller.logger.info("[PUT] : Aa21b02s01 actualizado correctamente");
		return aa21b02s01Aux;
	}

	/**
	 * Operacion CRUD Create. Creacion de un nuevo registro a partir del bean indicado.
	 * 
	 * @param aa21b02s01 Aa21b02s01 Bean que contiene la informacion con la que se va a crear el nuevo registro.
	 * @return Aa21b02s01 Bean resultante del proceso de creacion.
	 */
	@RequestMapping(method = RequestMethod.POST)
	public @ResponseBody Aa21b02s01 add(@RequestBody Aa21b02s01 aa21b02s01) {
		Aa21b02s01 aa21b02s01Aux = this.aa21b02s01Service.add(aa21b02s01);
		Aa21b02s01Controller.logger.info("[POST] : Aa21b02s01 insertado correctamente");
		return aa21b02s01Aux;
	}

	/**
	 * Operacion CRUD Delete. Borrado del registro correspondiente al identificador especificado.
	 * 
	 * @param idTipo String
	 * @return Aa21b02s01 Bean eliminado.
	 * @throws Exception Exception
	 */
	@RequestMapping(value = "/{idTipo}", method = RequestMethod.DELETE)
	@ResponseStatus(value = HttpStatus.OK)
	public @ResponseBody Aa21b02s01 remove(@PathVariable String idTipo) throws Exception {
		Aa21b02s01 aa21b02s01 = new Aa21b02s01();
		if (idTipo != null && !idTipo.equals("")) {
			aa21b02s01.setCserv02(idTipo.substring(0, idTipo.indexOf("-")));
			aa21b02s01.setCtipoe02(idTipo.substring(idTipo.indexOf("-") + 1));
		}

		this.aa21b02s01Service.remove(aa21b02s01);
		// Borrar fases de tipos
		this.aa21b01s01Service.removeFasesTipoServicio(aa21b02s01);
		Aa21b02s01Controller.logger.info("[DELETE] : Aa21b02s01 borrado correctamente");
		return aa21b02s01;
	}

	/*
	 * METODOS COMPONENTE RUP_TABLE
	 */

	/**
	 * Metodo de presentacion del RUP_TABLE.
	 * 
	 * @param model Model
	 * @return String
	 */
	@RequestMapping(value = "/maint", method = RequestMethod.GET)
	public String getFormEdit(Model model) {
		Aa21b02s01Controller.logger.info("[GET - View] : aa21b02s01");
		return "aa21b02s01";
	}

	/**
	 * Operacion de filtrado del componente RUP_TABLE.
	 * 
	 * @param filterAa21b02s01 Aa21b02s01 Bean que contiene los parametros de filtrado a emplear.
	 * @param jqGridRequestDto Dto que contiene los parametros de configuracion propios del RUP_TABLE a aplicar en el filtrado.
	 * @return JQGridResponseDto<Aa21b02s01> Dto que contiene el resultado del filtrado realizado por el componente RUP_TABLE.
	 */
	@RequestMapping(value = "/filter", method = RequestMethod.POST)
	public @ResponseBody JQGridResponseDto<Aa21b02s01> filter(@RequestJsonBody(param = "filter") Aa21b02s01 filterAa21b02s01,
															  @RequestJsonBody JQGridRequestDto jqGridRequestDto) {
		Aa21b02s01Controller.logger.info("[POST - filter] : Obtener Aa21b02s01s");
		List<Aa21b13s01> listaServicios = new ArrayList<Aa21b13s01>();
		String vacio = "";
		if (filterAa21b02s01.getCserv02() != null
				&& !filterAa21b02s01.getCserv02().equals(vacio)
				// NULL como string...
				&& !filterAa21b02s01.getCserv02().equals("null")) {
			String[] arrayServicios = filterAa21b02s01.getCserv02().split(",");
			Aa21b13s01 servicio = null;
			for (int x = 0; x < arrayServicios.length; x++) {
				servicio = new Aa21b13s01();// NOPMD
				servicio.setCServ13(arrayServicios[x]);
				listaServicios.add(servicio);
			}
		}

		return this.aa21b02s01Service.filter(filterAa21b02s01, jqGridRequestDto, listaServicios, false);
	}

	/**
	 * Operacion de busqueda del componente RUP_TABLE.
	 * 
	 * @param filterAa21b02s01 Aa21b02s01 Bean que contiene los parametros de filtrado a emplear.
	 * @param searchAa21b02s01 Aa21b02s01 Bean que contiene los parametros de busqueda a emplear.
	 * @param jqGridRequestDto Dto que contiene los parametros de configuracion propios del RUP_TABLE a aplicar en la búsqueda.
	 * @return TableRowDto<Aa21b02s01> Dto que contiene el resultado de la busqueda realizada por el componente RUP_TABLE.
	 */
	@RequestMapping(value = "/search", method = RequestMethod.POST)
	public @ResponseBody List<TableRowDto<Aa21b02s01>> search(@RequestJsonBody(param = "filter") Aa21b02s01 filterAa21b02s01,
															  @RequestJsonBody(param = "search") Aa21b02s01 searchAa21b02s01,
													  		  @RequestJsonBody JQGridRequestDto jqGridRequestDto) {
		Aa21b02s01Controller.logger.info("[POST - search] : Buscar Aa21b02s01s");
		return this.aa21b02s01Service.search(filterAa21b02s01, searchAa21b02s01, jqGridRequestDto, false);
	}

	/**
	 * Borrado multiple de registros
	 * 
	 * @param filterAa21b02s01 Aa21b02s01 Bean que contiene los parametros de filtrado a emplear.
	 * @param jqGridRequestDto Dto que contiene los parametros de configuracion propios del RUP_TABLE a aplicar en la busqueda.
	 * @return List<String> Lista de los identificadores de los registros eliminados.
	 */
	@RequestMapping(value = "/deleteAll", method = RequestMethod.POST)
	@ResponseStatus(value = HttpStatus.OK)
	public @ResponseBody List<String> removeMultiple(@RequestJsonBody(param = "filter") Aa21b02s01 filterAa21b02s01,
													 @RequestJsonBody JQGridRequestDto jqGridRequestDto) {
		Aa21b02s01Controller.logger.info("[POST - search] : [POST - removeMultiple] : Eliminar multiples Aa21b02s01s");
		this.aa21b02s01Service.removeMultiple(filterAa21b02s01, jqGridRequestDto, false);
		Aa21b02s01Controller.logger.info("All entities correctly deleted!");
		return jqGridRequestDto.getMultiselection().getSelectedIds();
	}

	/*
	 * METODOS COMPONENTE RUP_TABLE - JERARQUIA
	 */

	/**
	 * Operacion de filtrado del componente RUP_TABLE para presentar los
	 * registros mediante visualizacion jerarquica.
	 * 
	 * @param filterAa21b02s01 Aa21b02s01 Bean que contiene los parametros de filtrado a emplear.
	 * @param jqGridRequestDto Dto que contiene los parametros de configuracion propios del RUP_TABLE a aplicar en el filtrado.
	 * @return JQGridResponseDto<JerarquiaDto<Aa21b02s01>> Dto que contiene el resultado del filtrado realizado por el componente RUP_TABLE.
	 */
	@RequestMapping(value = "/jerarquia/filter", method = RequestMethod.POST)
	public @ResponseBody JQGridResponseDto<JerarquiaDto<Aa21b02s01>> jerarquia(@RequestJsonBody(param = "filter") Aa21b02s01 filterAa21b02s01,
																			   @RequestJsonBody JQGridRequestDto jqGridRequestDto) {
		Aa21b02s01Controller.logger.info("[POST - jerarquia] : Obtener Aa21b02s01s jerarquia");
		return this.aa21b02s01Service.jerarquia(filterAa21b02s01, jqGridRequestDto, false);
	}

	/**
	 * Recupera los hijos de los registros desplegados en la visualizacion jerarquica.
	 * 
	 * @param filterAa21b02s01 Aa21b02s01 Bean que contiene los parametros de filtrado a emplear.
	 * @param jqGridRequestDto Dto que contiene los parametros de configuracion propios del RUP_TABLE a aplicar en el filtrado.
	 * @return JQGridResponseDto<JerarquiaDto<Aa21b02s01>> Dto que contiene el resultado del filtrado realizado por el componente RUP_TABLE.
	 */
	@RequestMapping(value = "/jerarquiaChildren", method = RequestMethod.POST)
	public @ResponseBody JQGridResponseDto<JerarquiaDto<Aa21b02s01>> jerarquiaChildren(@RequestJsonBody(param = "filter") Aa21b02s01 filterAa21b02s01,
																					   @RequestJsonBody JQGridRequestDto jqGridRequestDto) {
		Aa21b02s01Controller.logger.info("[POST - jerarquia] : Obtener Aa21b02s01s jerarquia - Hijos");
		return this.aa21b02s01Service.jerarquiaChildren(filterAa21b02s01, jqGridRequestDto);
	}

	/**
	 * Method 'getAutocompleteTipoExpedienteCas'.
	 * 
	 * @param q String
	 * @param c Boolean
	 * 
	 * @return List<Aa21b02s01>
	 */
	@RequestMapping(value = "/autocompleteDenoTipoEcas", method = RequestMethod.GET)
	public @ResponseBody List<Aa21b02s01> getAutocompleteTipoExpedienteCas(@RequestParam(value = "q", required = true) String q,
																		   @RequestParam(value = "c", required = true) Boolean c,
																		   @RequestParam(value = "cserv02", required = false) String cserv02) {
		Aa21b02s01 tipoExpediente = new Aa21b02s01();
		tipoExpediente.setDtipoe02(q);
		if (cserv02 != null && cserv02.equals("")) {
			tipoExpediente.setCserv02(null);
		} else {
			tipoExpediente.setCserv02(cserv02);
		}
		return this.aa21b02s01Service.findTipoExpediente(tipoExpediente, c);
	}

	/**
	 * Method 'getAutocompleteTipoExpedienteEusk'.
	 * 
	 * @param q String
	 * @param c Boolean
	 * 
	 * @return List<Aa21b02s01>
	 */
	@RequestMapping(value = "/autocompleteDenoTipoEeusk", method = RequestMethod.GET)
	public @ResponseBody List<Aa21b02s01> getAutocompleteTipoExpedienteEusk(@RequestParam(value = "q", required = true) String q,
																			@RequestParam(value = "c", required = true) Boolean c) {
		Aa21b02s01 tipoExpediente = new Aa21b02s01();
		tipoExpediente.setEtipoe02(q);
		return this.aa21b02s01Service.findTipoExpediente(tipoExpediente, c);
	}

	/**
	 * @param aa21b02s01 Aa21b02s01
	 * @return aa21b02s01
	 * @throws Exception Exception
	 */
	@RequestMapping(value = "/cambioEstadoTipoExpediente", method = RequestMethod.POST)
	public @ResponseBody Aa21b02s01 cargarExpediente(@RequestBody Aa21b02s01 aa21b02s01) throws Exception {
		Aa21b01s01 aa21b01s01Aux = new Aa21b01s01();
		aa21b01s01Aux.setCserv01(aa21b02s01.getCserv02());
		aa21b01s01Aux.setSitu01(aa21b02s01.getSitu02());
		this.aa21b01s01Service.compruebaBloqueosServicio(aa21b01s01Aux);
		Aa21b02s01 aa21b02s01Aux = this.aa21b02s01Service.update(aa21b02s01);
		this.aa21b01s01Service.updateEstadosServicio(aa21b01s01Aux);
		Aa21b02s01Controller.logger.info("[PUT] : aa21b02s01 estado actualizado correctamente");
		return aa21b02s01Aux;
	}

	/**
	 * @param aa21b02s01 Aa21b02s01
	 * @return aa21b02s01
	 */
	@RequestMapping(value = "/updateBloqueos", method = RequestMethod.POST)
	public @ResponseBody Aa21b02s01 updateBloqueos(@RequestBody Aa21b02s01 aa21b02s01) {
		/**
		 * Obtengo el usuario de XLNETS y a partir del código, busco en la tabla
		 * el servicio al que corresponde Solo cargaremos en el combo de responsables los de ese servicio
		 */
		Aa21bPersonaSesion ps = new Aa21bSeguridad().getUsuario();
		String usuario = ps.getPersonaXLNET().getCodigo();
		logger.info("Usuario XLNETS=" + usuario);
		Aa21b15s01 aa21b15s01busqUsuario = ps.getPersonaAplicacion();
		logger.info("Buscar el usuario en la tabla 15");
		if (aa21b02s01 != null) {
			aa21b02s01.setCserv02(aa21b15s01busqUsuario.getCserv15());
		} else {
			aa21b02s01 = new Aa21b02s01();
			aa21b02s01.setCserv02(aa21b15s01busqUsuario.getCserv15());
		}
		Aa21b02s01 aa21b02s01Aux = this.aa21b02s01Service.updateBloqueos(aa21b02s01);
		Aa21b02s01Controller.logger.info("[PUT] : aa21b02s01 estado actualizado correctamente");
		return aa21b02s01Aux;
	}

	/**
	 * Method 'bloquear'.
	 * 
	 * @param ctipoe02 String
	 * @return boolean
	 */
	@RequestMapping(value = "bloquear/{ctipoe02}", method = RequestMethod.POST)
	public @ResponseBody boolean bloquear(@PathVariable String ctipoe02) {
		return this.aa21b02s01Service.bloquear(ctipoe02);
	}

	/**
	 * Method 'desbloquear'.
	 * 
	 * @param ctipoe02 String
	 * @return boolean
	 */
	@RequestMapping(value = "desbloquear/{ctipoe02}", method = RequestMethod.POST)
	public @ResponseBody boolean desbloquear(@PathVariable String ctipoe02) {
		return this.aa21b02s01Service.desbloquear(ctipoe02);
	}

	/**
	 * Method 'getComboTiposExpedienteServicio'.
	 * 
	 * @param q String
	 * 
	 * @return List<Aa21b02s01>
	 */
	@RequestMapping(value = "/comboTiposExpedientes", method = RequestMethod.GET)
	public @ResponseBody List<Aa21b02s01> getComboTiposExpedienteServicio() {
		return this.aa21b02s01Service.findAll(null, null);
	}

	/**
	 * Method 'getComboTiposExpedienteServicio'.
	 * 
	 * @param q String
	 * 
	 * @return List<Aa21b02s01>
	 */
	@RequestMapping(value = "/comboTiposExpedienteServicio", method = RequestMethod.GET)
	public @ResponseBody List<Aa21b02s01> getComboTiposExpedienteServicio(@RequestParam(value = "cserv01", required = true) String q) {
		List<Aa21b02s01> listaTiposExpedientes = new ArrayList<Aa21b02s01>();
		String vacio = "";
		if (q != null && !q.equals(vacio)
		// NULL como string...
				&& !q.equals("null")) {
			String[] arrayTiposExp = q.split(",");
			Aa21b02s01 tipoExp = null;
			for (int x = 0; x < arrayTiposExp.length; x++) {
				tipoExp = new Aa21b02s01();// NOPMD
				tipoExp.setCserv02(arrayTiposExp[x]);
				listaTiposExpedientes.add(tipoExp);
			}
		}
		return this.aa21b02s01Service.findAllComboTiposExpServicio(listaTiposExpedientes, null);
	}

	/**
	 * Method 'getComboTiposExpedienteServicio'.
	 * 
	 * @param q String
	 * 
	 * @return List<Aa21b02s01>
	 */
	@RequestMapping(value = "/comboTiposExpedienteServicio2", method = RequestMethod.GET)
	public @ResponseBody List<Aa21b02s01> getComboTiposExpedienteServicio2(@RequestParam(value = "cserv02", required = true) String q,
																		   @RequestParam(value = "situ02", required = true) String situ) {
		Aa21b02s01 filtro = new Aa21b02s01();
		filtro.setSitu02(situ);
		filtro.setCserv02(q);
		return this.aa21b02s01Service.findAll(filtro, null);
	}

	/**
	 * Method 'getDenoTipo'.
	 * 
	 * @param cTipoe02 String
	 * 
	 * @return Aa21b13s01
	 */
	@RequestMapping(value = "/obtenerDenoTipo", method = RequestMethod.GET)
	public @ResponseBody Aa21b02s01 getDenoTipo(@RequestParam(value = "cTipoe", required = false) String cTipoe02,
												@RequestParam(value = "cServ", required = false) String cServ02) {
		Aa21b02s01 tipoExp = new Aa21b02s01();
		tipoExp.setCtipoe02(cTipoe02);
		tipoExp.setCserv02(cServ02);
		return this.aa21b02s01Service.find(tipoExp);
	}

	/**
	 * Method 'getExpedientesAsociados'.
	 * 
	 * @param ctipoe02 String
	 * @param jqGridRequestDto JQGridRequestDto
	 * 
	 * @return List<Aa21b20s01>
	 */
	@RequestMapping(value = "/obtenerExpedientesTipo/{ctipoe02}", method = RequestMethod.POST)
	public @ResponseBody JQGridResponseDto<Aa21b20s01> getExpedientesAsociados(@PathVariable String ctipoe02, @RequestJsonBody JQGridRequestDto jqGridRequestDto) {
		Aa21b20s01 filterAa21b20s01 = new Aa21b20s01();
		if (ctipoe02 != null && !ctipoe02.equals("")) {
			filterAa21b20s01.setCexpe20(ctipoe02);
			return this.aa21b20s01Service.filter(filterAa21b20s01, jqGridRequestDto, false);
		} else {
			JQGridRequestDto data = new JQGridRequestDto();
			data.setRows(new Long(0));
			data.setPage(new Long(0));
			return new JQGridResponseDto<Aa21b20s01>(data, new Long(0), null);
		}
	}

	@RequestMapping(value = "/obtenerExpedientesTipoServ/{ctipoe02}", method = RequestMethod.POST)
	public @ResponseBody JQGridResponseDto<Aa21b20s01> getExpedientesAsociadosServ(@PathVariable String ctipoe02, @RequestJsonBody JQGridRequestDto jqGridRequestDto) {
		Aa21b20s01 filterAa21b20s01 = new Aa21b20s01();
		if (ctipoe02 != null && !ctipoe02.equals("")) {

			//20170109 - INI - INIGO
			String strServicioLogueado = new Aa21bSeguridad().getUsuario().getServicio();
			if (strServicioLogueado != null && !"".equals(strServicioLogueado)) {
				filterAa21b20s01.setServicioLogueado(strServicioLogueado);
			}
			//20170109 - FIN - INIGO

			filterAa21b20s01.setCexpe20(ctipoe02);
			return this.aa21b20s01Service.filter(filterAa21b20s01, jqGridRequestDto, false);
		} else {
			JQGridRequestDto data = new JQGridRequestDto();
			data.setRows(new Long(0));
			data.setPage(new Long(0));
			return new JQGridResponseDto<Aa21b20s01>(data, new Long(0), null);
		}
	}
}