// @formatter:off
package com.ejie.aa21b.control;

import java.io.BufferedOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.multipart.MultipartFile;

import com.ejie.aa21b.model.Aa21b01s01;
import com.ejie.aa21b.model.Aa21b02s01;
import com.ejie.aa21b.model.Aa21b13s01;
import com.ejie.aa21b.model.Aa21b15s01;
import com.ejie.aa21b.model.Aa21b20s01;
import com.ejie.aa21b.seguridad.Aa21bPersonaSesion;
import com.ejie.aa21b.seguridad.Aa21bSeguridad;
import com.ejie.aa21b.service.Aa21b01s01Service;
import com.ejie.aa21b.service.Aa21b20s01Service;
import com.ejie.aa21b.service.Aa21bAccesoPIDService;
import com.ejie.aa21b.util.MimeTypes;
import com.ejie.x38.control.bind.annotation.RequestJsonBody;
import com.ejie.x38.dto.JQGridRequestDto;
import com.ejie.x38.dto.JQGridResponseDto;
import com.ejie.x38.dto.JerarquiaDto;
import com.ejie.x38.dto.TableRowDto;

/**
 * Aa21b01s01Controller  
 * 
 *  
 */

@Controller
@RequestMapping(value = "/aa21b01s01")
public class Aa21b01s01Controller {

	private static final Logger logger = LoggerFactory.getLogger(Aa21b01s01Controller.class);

	@Autowired
	private Aa21b01s01Service aa21b01s01Service;

	@Autowired
	private Aa21b20s01Service aa21b20s01Service;

	@Autowired
	private Aa21bAccesoPIDService pidService;

	/*
	 * OPERACIONES CRUD (Create, Read, Update, Delete)
	 */

	/**
	 * Operacion CRUD Read. Devuelve el bean correspondiente al identificador indicado.
	 * 
	 * @param idFase String
	 * @return Aa21b01s01 Objeto correspondiente al identificador indicado.
	 */
	@RequestMapping(value = "/{idFase}", method = RequestMethod.GET)
	public @ResponseBody Aa21b01s01 get(@PathVariable String idFase) {
		// Recorro el String id que trae el valor de los campos de la clave primaria separados por el carácter "-"
		List<String> listaCamposClave = new ArrayList<String>();
		if (idFase != null && !idFase.trim().equals("")) {
			int longitud = idFase.length();
			for (int i = 0; i <= longitud; i++) {
				if (idFase.indexOf("-") != -1) {
					listaCamposClave.add(idFase.substring(0, idFase.indexOf("-")));
				} else {
					listaCamposClave.add(idFase);
				}
				idFase = idFase.substring(idFase.indexOf("-") + 1);
			}
		}
		Aa21b01s01 aa21b01s01 = new Aa21b01s01();
		if (listaCamposClave != null && listaCamposClave.size() > 0) {
			aa21b01s01.setCserv01(listaCamposClave.get(0));
			aa21b01s01.setCtipoe01(listaCamposClave.get(1));
			aa21b01s01.setCfase01(new Long(listaCamposClave.get(2)));
		}
		aa21b01s01 = this.aa21b01s01Service.find(aa21b01s01);
		Aa21b01s01Controller.logger.info("[GET - findBy_PK] : Obtener Aa21b01s01 por PK");
		return aa21b01s01;
	}

	/**
	 * Devuelve una lista de beans correspondientes a los valores de filtrados indicados en el objeto pasado como parametro.
	 * 
	 * @param filterAa21b01s01 Aa21b01s01 Objeto que contiene los parametros de filtrado utilizados en la busqueda.
	 * @return List<Aa21b01s01> Lista de objetos correspondientes a la busqueda realizada.
	 */
	@RequestMapping(method = RequestMethod.GET)
	public @ResponseBody List<Aa21b01s01> getAll(@ModelAttribute Aa21b01s01 filterAa21b01s01) {
		Aa21b01s01Controller.logger.info("[GET - find_ALL] : Obtener Aa21b01s01 por filtro");
		return this.aa21b01s01Service.findAll(filterAa21b01s01, null);
	}

	/**
	 * Operacion CRUD Edit. Modificacion del bean indicado.
	 * 
	 * @param aa21b01s01 Aa21b01s01 Bean que contiene la informacion a modificar.
	 * @return Aa21b01s01 Bean resultante de la modificacion.
	 */
	@RequestMapping(method = RequestMethod.PUT)
	public @ResponseBody Aa21b01s01 edit(@RequestBody Aa21b01s01 aa21b01s01) {
		Aa21b01s01 aa21b01s01Aux = this.aa21b01s01Service.update(aa21b01s01);
		Aa21b01s01Controller.logger.info("[PUT] : Aa21b01s01 actualizado correctamente");
		return aa21b01s01Aux;
	}

	/**
	 * Operacion CRUD Create. Creacion de un nuevo registro a partir del bean indicado.
	 * 
	 * @param aa21b01s01 Aa21b01s01 Bean que contiene la informacion con la que se va a crear el nuevo registro.
	 * @return Aa21b01s01 Bean resultante del proceso de creacion.
	 */
	@RequestMapping(method = RequestMethod.POST)
	public @ResponseBody Aa21b01s01 add(@RequestBody Aa21b01s01 aa21b01s01) {
		Aa21b01s01 aa21b01s01Aux = this.aa21b01s01Service.add(aa21b01s01);
		Aa21b01s01Controller.logger.info("[POST] : Aa21b01s01 insertado correctamente");
		return aa21b01s01Aux;
	}

	/**
	 * Operacion CRUD Delete. Borrado del registro correspondiente al identificador especificado.
	 * 
	 * @param idFase String
	 * @return Aa21b01s01 Bean eliminado.
	 * @throws Exception Exception
	 */
	@RequestMapping(value = "/{idFase}", method = RequestMethod.DELETE)
	@ResponseStatus(value = HttpStatus.OK)
	public @ResponseBody Aa21b01s01 remove(@PathVariable String idFase) throws Exception {
		// Recorro el String id que trae el valor de los campos de la clave primaria separados por el carácter "-"
		List<String> listaCamposClave = new ArrayList<String>();
		if (idFase != null && !idFase.trim().equals("")) {
			int longitud = idFase.length();
			for (int i = 0; i <= longitud; i++) {
				if (idFase.indexOf("-") != -1) {
					listaCamposClave.add(idFase.substring(0, idFase.indexOf("-")));
				} else {
					listaCamposClave.add(idFase);
				}
				idFase = idFase.substring(idFase.indexOf("-") + 1);
			}
		}
		Aa21b01s01 aa21b01s01 = new Aa21b01s01();
		if (listaCamposClave != null && listaCamposClave.size() > 0) {
			aa21b01s01.setCserv01(listaCamposClave.get(0));
			aa21b01s01.setCtipoe01(listaCamposClave.get(1));
			aa21b01s01.setCfase01(new Long(listaCamposClave.get(2)));
		}

		this.aa21b01s01Service.remove(aa21b01s01);
		Aa21b01s01Controller.logger.info("[DELETE] : Aa21b01s01 borrado correctamente");
		return aa21b01s01;
	}

	/*
	 * METODOS COMPONENTE RUP_TABLE
	 */

	/**
	 * Metodo de presentacion del RUP_TABLE.
	 * 
	 * @param model Model
	 * @return String
	 */
	@RequestMapping(value = "/maint", method = RequestMethod.GET)
	public String getFormEdit(Model model) {
		Aa21b01s01Controller.logger.info("[GET - View] : aa21b01s01");
		return "aa21b01s01";
	}

	/**
	 * Operacion de filtrado del componente RUP_TABLE.
	 * 
	 * @param filterAa21b01s01 Aa21b01s01 Bean que contiene los parametros de filtrado a emplear.
	 * @param jqGridRequestDto Dto que contiene los parametros de configuracion propios del RUP_TABLE a aplicar en el filtrado.
	 * @return JQGridResponseDto<Aa21b01s01> Dto que contiene el resultado del filtrado realizado por el componente RUP_TABLE.
	 */
	@RequestMapping(value = "/filter", method = RequestMethod.POST)
	public @ResponseBody JQGridResponseDto<Aa21b01s01> filter(@RequestJsonBody(param = "filter") Aa21b01s01 filterAa21b01s01,
															  @RequestJsonBody JQGridRequestDto jqGridRequestDto) {
		Aa21b01s01Controller.logger.info("[POST - filter] : Obtener Aa21b01s01s");
		List<Aa21b13s01> listaServicios = new ArrayList<Aa21b13s01>();
		String vacio = "";
		if (filterAa21b01s01.getCserv01() != null
				&& !filterAa21b01s01.getCserv01().equals(vacio)
				// NULL como string...
				&& !filterAa21b01s01.getCserv01().equals("null")) {
			String[] arrayServicios = filterAa21b01s01.getCserv01().toString().split(",");
			Aa21b13s01 servicio = null;
			for (int x = 0; x < arrayServicios.length; x++) {
				servicio = new Aa21b13s01();// NOPMD
				servicio.setCServ13(arrayServicios[x]);
				listaServicios.add(servicio);
			}
		}
		List<Aa21b02s01> listaTiposExpedientes = new ArrayList<Aa21b02s01>();
		vacio = "";
		if (filterAa21b01s01.getCtipoe01() != null
				&& !filterAa21b01s01.getCtipoe01().equals(vacio)
				// NULL como string...
				&& !filterAa21b01s01.getCtipoe01().equals("null")) {
			String[] arrayTiposExpedientes = filterAa21b01s01.getCtipoe01().split(",");
			Aa21b02s01 tipoExp = null;
			for (int x = 0; x < arrayTiposExpedientes.length; x++) {
				tipoExp = new Aa21b02s01();// NOPMD
				tipoExp.setCtipoe02(arrayTiposExpedientes[x]);
				listaTiposExpedientes.add(tipoExp);
			}
		}
		jqGridRequestDto.setSidx("ctipoe01 asc, cfase01 asc");
		jqGridRequestDto.setSord(" ");
		return this.aa21b01s01Service.filter(filterAa21b01s01, jqGridRequestDto, listaServicios, listaTiposExpedientes, false);
	}

	/**
	 * Operacion de busqueda del componente RUP_TABLE.
	 * 
	 * @param filterAa21b01s01 Aa21b01s01 Bean que contiene los parametros de filtrado a emplear.
	 * @param searchAa21b01s01 Aa21b01s01 Bean que contiene los parametros de busqueda a emplear.
	 * @param jqGridRequestDto Dto que contiene los parametros de configuracion propios del RUP_TABLE a aplicar en la búsqueda.
	 * @return TableRowDto<Aa21b01s01> Dto que contiene el resultado de la busqueda realizada por el componente RUP_TABLE.
	 */
	@RequestMapping(value = "/search", method = RequestMethod.POST)
	public @ResponseBody List<TableRowDto<Aa21b01s01>> search(@RequestJsonBody(param = "filter") Aa21b01s01 filterAa21b01s01,
															  @RequestJsonBody(param = "search") Aa21b01s01 searchAa21b01s01,
													  		  @RequestJsonBody JQGridRequestDto jqGridRequestDto) {
		Aa21b01s01Controller.logger.info("[POST - search] : Buscar Aa21b01s01s");
		return this.aa21b01s01Service.search(filterAa21b01s01, searchAa21b01s01, jqGridRequestDto, false);
	}

	/**
	 * Borrado multiple de registros
	 * 
	 * @param filterAa21b01s01 Aa21b01s01 Bean que contiene los parametros de filtrado a emplear.
	 * @param jqGridRequestDto Dto que contiene los parametros de configuracion propios del RUP_TABLE a aplicar en la busqueda.
	 * @return List<String> Lista de los identificadores de los registros eliminados.
	 */
	@RequestMapping(value = "/deleteAll", method = RequestMethod.POST)
	@ResponseStatus(value = HttpStatus.OK) 
	public @ResponseBody List<String> removeMultiple(@RequestJsonBody(param = "filter") Aa21b01s01 filterAa21b01s01, @RequestJsonBody JQGridRequestDto jqGridRequestDto) {
		Aa21b01s01Controller.logger.info("[POST - search] : [POST - removeMultiple] : Eliminar multiples Aa21b01s01s");
		this.aa21b01s01Service.removeMultiple(filterAa21b01s01, jqGridRequestDto, false);
		Aa21b01s01Controller.logger.info("All entities correctly deleted!");
		return jqGridRequestDto.getMultiselection().getSelectedIds();
	}

	/*
	 * METODOS COMPONENTE RUP_TABLE - JERARQUIA
	 */

	/**
	 * Operacion de filtrado del componente RUP_TABLE para presentar los registros mediante visualizacion jerarquica.
	 * 
	 * @param filterAa21b01s01 Aa21b01s01 Bean que contiene los parametros de filtrado a emplear.
	 * @param jqGridRequestDto Dto que contiene los parametros de configuracion propios del RUP_TABLE a aplicar en el filtrado.
	 * @return JQGridResponseDto<JerarquiaDto<Aa21b01s01>> Dto que contiene el resultado del filtrado realizado por el componente RUP_TABLE.
	 */
	@RequestMapping(value = "/jerarquia/filter", method = RequestMethod.POST)
	public @ResponseBody JQGridResponseDto<JerarquiaDto<Aa21b01s01>> jerarquia(@RequestJsonBody(param = "filter") Aa21b01s01 filterAa21b01s01,
																			   @RequestJsonBody JQGridRequestDto jqGridRequestDto) {
		Aa21b01s01Controller.logger.info("[POST - jerarquia] : Obtener Aa21b01s01s jerarquia");
		return this.aa21b01s01Service.jerarquia(filterAa21b01s01, jqGridRequestDto, false);
	}

	/**
	 * Recupera los hijos de los registros desplegados en la visualizacion jerarquica.
	 * 
	 * @param filterAa21b01s01 Aa21b01s01 Bean que contiene los parametros de filtrado a emplear.
	 * @param jqGridRequestDto Dto que contiene los parametros de configuracion propios del RUP_TABLE a aplicar en el filtrado.
	 * @return JQGridResponseDto<JerarquiaDto<Aa21b01s01>> Dto que contiene el resultado del filtrado realizado por el componente RUP_TABLE.
	 */
	@RequestMapping(value = "/jerarquiaChildren", method = RequestMethod.POST)
	public @ResponseBody JQGridResponseDto<JerarquiaDto<Aa21b01s01>> jerarquiaChildren(@RequestJsonBody(param = "filter") Aa21b01s01 filterAa21b01s01,
																					   @RequestJsonBody JQGridRequestDto jqGridRequestDto) {
		Aa21b01s01Controller.logger.info("[POST - jerarquia] : Obtener Aa21b01s01s jerarquia - Hijos");
		return this.aa21b01s01Service.jerarquiaChildren(filterAa21b01s01, jqGridRequestDto);
	}

	/**
	 * @param aa21b01s01 Aa21b01s01
	 * @return aa21b01s01
	 */
	@RequestMapping(value = "/updateBloqueos", method = RequestMethod.POST)
	public @ResponseBody Aa21b01s01 updateBloqueos(@RequestBody Aa21b01s01 aa21b01s01) {
		/**
		 * Obtengo el usuario de XLNETS y a partir del código, busco en la tabla
		 * el servicio al que corresponde Solo cargaremos en el combo de responsables los de ese servicio
		 */
		Aa21bPersonaSesion ps = new Aa21bSeguridad().getUsuario();
		String usuario = ps.getPersonaXLNET().getCodigo();
		logger.info("Usuario XLNETS=" + usuario);
		Aa21b15s01 aa21b15s01busqUsuario = ps.getPersonaAplicacion();
		logger.info("Buscar el usuario en la tabla 15");
		if (aa21b01s01 != null) {
			aa21b01s01.setCserv01(aa21b15s01busqUsuario.getCserv15());
		} else {
			aa21b01s01 = new Aa21b01s01();
			aa21b01s01.setCserv01(aa21b15s01busqUsuario.getCserv15());
		}
		Aa21b01s01 aa21b01s01Aux = this.aa21b01s01Service.updateBloqueos(aa21b01s01);
		Aa21b01s01Controller.logger.info("[PUT] : aa21b01s01 estado actualizado correctamente");
		return aa21b01s01Aux;
	}

	/**
	 * Method 'bloquear'.
	 * 
	 * @param idFase String
	 * @return boolean
	 */
	@RequestMapping(value = "bloquear/{idFase}", method = RequestMethod.POST)
	public @ResponseBody boolean bloquear(@PathVariable String idFase) {
		return this.aa21b01s01Service.bloquear(idFase);
	}

	/**
	 * Method 'desbloquear'.
	 * 
	 * @param idFase String
	 * @return boolean
	 */
	@RequestMapping(value = "desbloquear/{idFase}", method = RequestMethod.POST)
	public @ResponseBody boolean desbloquear(@PathVariable String idFase) {
		return this.aa21b01s01Service.desbloquear(idFase);
	}

	/**
	 * @param aa21b01s01 Aa21b01s01
	 * @return aa21b01s01
	 */
	@RequestMapping(value = "/cambioEstadoFasesExpediente", method = RequestMethod.POST)
	public @ResponseBody Aa21b01s01 cargarExpediente(@RequestBody Aa21b01s01 aa21b01s01) {
		Aa21b01s01 aa21b01s01Aux = this.aa21b01s01Service.update(aa21b01s01);
		Aa21b01s01Controller.logger.info("[PUT] : aa21b02s01 estado actualizado correctamente");
		return aa21b01s01Aux;
	}

	/**
	 * Method 'getAutocompleteServicioCas'.
	 * 
	 * @param q String
	 * @param c Boolean
	 * 
	 * @return List<Aa21b01s01>
	 */
	@RequestMapping(value = "/autocompleteDenoFaseCas", method = RequestMethod.GET)
	public @ResponseBody List<Aa21b01s01> getAutocompleteFaseCas(@RequestParam(value = "q", required = true) String q,
																 @RequestParam(value = "c", required = true) Boolean c) {
		Aa21b01s01 faseExp = new Aa21b01s01();
		faseExp.setDfase01(q);
		return this.aa21b01s01Service.findFase(faseExp, c);
	}

	/**
	 * Method 'getAutocompleteServicioEusk'.
	 * 
	 * @param q String
	 * @param c Boolean
	 * 
	 * @return List<Aa21b01s01>
	 */
	@RequestMapping(value = "/autocompleteDenoFaseEusk", method = RequestMethod.GET)
	public @ResponseBody List<Aa21b01s01> getAutocompleteFaseEusk(@RequestParam(value = "q", required = true) String q,
																  @RequestParam(value = "c", required = true) Boolean c) {
		Aa21b01s01 servicio = new Aa21b01s01();
		servicio.setEfase01(q);
		return this.aa21b01s01Service.findFase(servicio, c);
	}

	/**
	 * Method 'getComboFasesExpediente'.
	 * 
	 * @param cserv String
	 * @param cexpe String
	 * 
	 * @return List<Aa21b02s01>
	 */
	@RequestMapping(value = "/comboFasesExpediente", method = RequestMethod.GET)
	public @ResponseBody
	List<Aa21b01s01> getComboFasesExpediente(@RequestParam(value = "cserv", required = false) String cserv,
											 @RequestParam(value = "cexpe", required = false) String cexpe,
											 @RequestParam(value = "fases", required = false) ArrayList<String> fasesExp) {
		Aa21b01s01 fase = new Aa21b01s01();
		fase.setCserv01(cserv);
		fase.setCtipoe01(cexpe);
		return this.aa21b01s01Service.findAll(fase, null);
	}

	/**
	 * @param request HttpServletRequest
	 * @param cserv01 String
	 * @param ctipoe01 String
	 * @param cfase01 Long
	 * @param dfase01 String
	 * @param efase01 String
	 * @param situ01 String
	 * @param ndocu01 Long
	 * @param tdocu01 String
	 * @param docu01 MultipartFile
	 * @return Aa21b01s01
	 * @throws Exception Exception
	 */
	@RequestMapping(value = "/crearFaseExpediente", method = RequestMethod.POST)
	public @ResponseBody Aa21b01s01 crearFaseExpediente(HttpServletRequest request,
														@RequestParam(value = "cserv01", required = false) String cserv01,
														@RequestParam(value = "ctipoe01", required = false) String ctipoe01,
														@RequestParam(value = "cfase01", required = false) Long cfase01,
														@RequestParam(value = "dfase01", required = false) String dfase01,
														@RequestParam(value = "efase01", required = false) String efase01,
														@RequestParam(value = "situ01", required = false) String situ01,
														@RequestParam(value = "ndocu01", required = false) String codPid01,
														@RequestParam(value = "tdocu01", required = false) String tdocu01,
														@RequestParam(value = "docu01", required = false) MultipartFile docu01) throws Exception {
		Aa21b01s01 aa21b01s01 = new Aa21b01s01();
		aa21b01s01.setCserv01(cserv01);
		aa21b01s01.setCtipoe01(ctipoe01);
		aa21b01s01.setCfase01(cfase01);
		aa21b01s01.setDfase01(dfase01);
		aa21b01s01.setEfase01(efase01);
		aa21b01s01.setSitu01(situ01);
		aa21b01s01.setCodPid01(codPid01);
		Aa21b01s01 aa21b01s01aux = new Aa21b01s01();
		if (docu01 != null && docu01.getSize() > 0) {
			aa21b01s01.setTdocu01(docu01.getContentType());
			// aa21b01s01.setDocu01(docu01.getBytes());
			aa21b01s01.setDocumentoPID(docu01.getBytes());
			String fileName = new String(docu01.getOriginalFilename().getBytes("iso-8859-1"), "UTF-8");
			int indicepunto = fileName.lastIndexOf(".");
			String extension = fileName.substring(indicepunto + 1, fileName.length());
			aa21b01s01.setExtdocu01(extension);
			aa21b01s01aux = this.aa21b01s01Service.addDocumentoFase(aa21b01s01);
		} else {
			aa21b01s01aux = aa21b01s01;
		}
		aa21b01s01aux = this.aa21b01s01Service.add(aa21b01s01aux);
		Aa21b01s01Controller.logger.info("[PUT] : Aa21b01s01 insertado fichero correctamente");
		return aa21b01s01aux;
	}

	/**
	 * @param request HttpServletRequest
	 * @param cserv01 String
	 * @param ctipoe01 String
	 * @param cfase01 Long
	 * @param dfase01 String
	 * @param efase01 String
	 * @param situ01 String
	 * @param ndocu01 Long
	 * @param tdocu01 String
	 * @param docu01 MultipartFile
	 * @return Aa21b01s01
	 * @throws Exception Exception
	 */
	@RequestMapping(value = "/guardarFaseExpediente", method = RequestMethod.POST)
	public @ResponseBody Aa21b01s01 guardarFaseExpediente(HttpServletRequest request,
														  @RequestParam(value = "cserv01", required = false) String cserv01,
														  @RequestParam(value = "ctipoe01", required = false) String ctipoe01,
														  @RequestParam(value = "cfase01", required = false) Long cfase01,
														  @RequestParam(value = "dfase01", required = false) String dfase01,
														  @RequestParam(value = "efase01", required = false) String efase01,
														  @RequestParam(value = "situ01", required = false) String situ01,
														  @RequestParam(value = "codPid01", required = false) String codPid01,
														  @RequestParam(value = "tdocu01", required = false) String tdocu01,
														  @RequestParam(value = "docu01", required = false) MultipartFile docu01) throws Exception {
		this.logger.info("guardarFaseExpediente");
		Aa21b01s01 aa21b01s01 = new Aa21b01s01();
		aa21b01s01.setCserv01(cserv01);
		aa21b01s01.setCtipoe01(ctipoe01);
		aa21b01s01.setCfase01(cfase01);
		aa21b01s01.setDfase01(dfase01);
		aa21b01s01.setEfase01(efase01);
		aa21b01s01.setSitu01(situ01);
		if (docu01 != null && docu01.getSize() > 0) {
			logger.info("tiene documento. Tamaño=" + docu01.getSize());
			aa21b01s01.setCodPid01(codPid01);
			aa21b01s01.setTdocu01(docu01.getContentType());
			aa21b01s01.setDocumentoPID(docu01.getBytes());
			String fileName = new String(docu01.getOriginalFilename().getBytes("iso-8859-1"), "UTF-8");
			int indicepunto = fileName.lastIndexOf(".");
			String extension = fileName.substring(indicepunto + 1, fileName.length());
			aa21b01s01.setExtdocu01(extension);
			logger.info("Añadir fichero");
			aa21b01s01 = this.aa21b01s01Service.addDocumentoFase(aa21b01s01);
			// Actualizo el número y tipo de documento de documento en la tabla 01
		}
		Aa21b01s01 aa21b01s01aux = this.aa21b01s01Service.update(aa21b01s01);
		Aa21b01s01Controller.logger.info("[PUT] : Aa21b01s01 insertado fichero correctamente");
		return aa21b01s01aux;
	}

	/**
	 * @param idFase String
	 * @param request HttpServletRequest
	 * @param response HttpServletResponse
	 * @return Aa21b01s01
	 * @throws IOException Exception
	 */
	@RequestMapping(value = "/getDocumentoFase", method = RequestMethod.GET)
	public @ResponseBody Object getDocumentoFase(@RequestParam(value = "idFaseExp", required = false) String idFase, HttpServletRequest request, HttpServletResponse response) throws IOException {
		// Recorro el String id que trae el valor de los campos de la clave primaria separados por el carácter "-"
		List<String> listaCamposClave = new ArrayList<String>();
		if (idFase != null && !idFase.trim().equals("")) {
			int longitud = idFase.length();
			for (int i = 0; i <= longitud; i++) {
				if (idFase.indexOf("-") != -1) {
					listaCamposClave.add(idFase.substring(0, idFase.indexOf("-")));
				} else {
					listaCamposClave.add(idFase);
				}
				idFase = idFase.substring(idFase.indexOf("-") + 1);
			}
		}
		Aa21b01s01 aa21b01s01 = new Aa21b01s01();
		if (listaCamposClave != null && listaCamposClave.size() > 0) {
			aa21b01s01.setCserv01(listaCamposClave.get(0));
			aa21b01s01.setCtipoe01(listaCamposClave.get(1));
			aa21b01s01.setCfase01(new Long(listaCamposClave.get(2)));
		}
		aa21b01s01 = this.aa21b01s01Service.findDocumentoFase(aa21b01s01);
		Aa21b01s01Controller.logger.info("[GET - findBy_PK] : Obtener Aa21b01s01 por PK");
		byte[] fileByteArray = aa21b01s01.getDocumentoPID();
		if (aa21b01s01.getExtdocu01() == null)// Si no tiene extension, intentar adibinarlo lyenedo las cabeceras
			aa21b01s01.setExtdocu01(MimeTypes.getContentType(fileByteArray));
		ServletOutputStream sos = null;
		BufferedOutputStream bos = null;
		StringBuffer fileName = new StringBuffer("Documento");
		if (fileByteArray != null) {
			response.setContentType(aa21b01s01.getTdocu01());
			fileName.append(".");
			fileName.append(aa21b01s01.getExtdocu01());
			response.setContentLength(fileByteArray.length);
			response.setHeader("Pragma", "no-cache");
			response.setHeader("Expires", "-1");
			response.setHeader("Cache-Control", "no-store, no-cache, must-revalidate");
			response.setHeader("Content-Disposition", "attachment;filename=\"" + fileName + "\"");
			sos = response.getOutputStream();
			bos = new BufferedOutputStream(sos);// NOPMD
			bos.write(fileByteArray);
			bos.flush();
			bos.close();
		}
		return aa21b01s01;
	}

	/**
	 * @param idFase String
	 * @param request HttpServletRequest
	 * @param response HttpServletResponse
	 * @return Aa21b01s01
	 * @throws IOException Exception
	 */
	@RequestMapping(value = "/getDocumentoFaseEdit", method = RequestMethod.GET)
	public @ResponseBody List<String> getDocumentoFaseEdit(@RequestParam(value = "idFaseExp", required = false) String idFase,
														   HttpServletRequest request, HttpServletResponse response) throws IOException {
		// Recorro el String id que trae el valor de los campos de la clave primaria separados por el carácter "-"
		List<String> listaCamposClave = new ArrayList<String>();
		if (idFase != null && !idFase.trim().equals("")) {
			int longitud = idFase.length();
			for (int i = 0; i <= longitud; i++) {
				if (idFase.indexOf("-") != -1) {
					listaCamposClave.add(idFase.substring(0, idFase.indexOf("-")));
				} else {
					listaCamposClave.add(idFase);
				}
				idFase = idFase.substring(idFase.indexOf("-") + 1);
			}
		}
		Aa21b01s01 aa21b01s01 = new Aa21b01s01();
		if (listaCamposClave != null && listaCamposClave.size() > 0) {
			aa21b01s01.setCserv01(listaCamposClave.get(0));
			aa21b01s01.setCtipoe01(listaCamposClave.get(1));
			aa21b01s01.setCfase01(new Long(listaCamposClave.get(2)));
		}
		aa21b01s01 = this.aa21b01s01Service.find(aa21b01s01);
		Aa21b01s01Controller.logger.info("[GET - findBy_PK] : Obtener Aa21b01s01 por PK");
		return this.pidService.edicionOnline(aa21b01s01.getCodPid01());
	}

	/**
	 * Method 'getExpedientesAsociados'.
	 * 
	 * @param idFase String
	 * @param jqGridRequestDto JQGridRequestDto
	 * 
	 * @return List<Aa21b20s01>
	 */
	@RequestMapping(value = "/obtenerExpedientesFase/{idFase}", method = RequestMethod.POST)
	public @ResponseBody JQGridResponseDto<Aa21b20s01> getExpedientesAsociados(@PathVariable String idFase,	@RequestJsonBody JQGridRequestDto jqGridRequestDto) {
		// Recorro el String id que trae el valor de los campos de la clave primaria separados por el carácter "-"
		List<String> listaCamposClave = new ArrayList<String>();
		if (idFase != null && !idFase.trim().equals("")) {
			int longitud = idFase.length();
			for (int i = 0; i <= longitud; i++) {
				if (idFase.indexOf("-") != -1) {
					listaCamposClave.add(idFase.substring(0, idFase.indexOf("-")));
				} else {
					listaCamposClave.add(idFase);
				}
				idFase = idFase.substring(idFase.indexOf("-") + 1);
			}
			Aa21b20s01 filterAa21b20s01 = new Aa21b20s01();
			if (listaCamposClave != null && listaCamposClave.size() > 0) {
				filterAa21b20s01.setCserv20(listaCamposClave.get(0));
				filterAa21b20s01.setCexpe20(listaCamposClave.get(1));
				filterAa21b20s01.setCfase(listaCamposClave.get(2));
			}
			return this.aa21b20s01Service.filterConFase(filterAa21b20s01, jqGridRequestDto, false);
		} else {
			JQGridRequestDto data = new JQGridRequestDto();
			data.setRows(new Long(0));
			data.setPage(new Long(0));
			return new JQGridResponseDto<Aa21b20s01>(data, new Long(0), null);
		}
	}
	
	@RequestMapping(value = "/obtenerExpedientesFaseServ/{idFase}", method = RequestMethod.POST)
	public @ResponseBody JQGridResponseDto<Aa21b20s01> getExpedientesAsociadosServ(@PathVariable String idFase, @RequestJsonBody JQGridRequestDto jqGridRequestDto) {
		// Recorro el String id que trae el valor de los campos de la clave primaria separados por el carácter "-"
		List<String> listaCamposClave = new ArrayList<String>();
		if (idFase != null && !idFase.trim().equals("")) {
			int longitud = idFase.length();
			for (int i = 0; i <= longitud; i++) {
				if (idFase.indexOf("-") != -1) {
					listaCamposClave.add(idFase.substring(0, idFase.indexOf("-")));
				} else {
					listaCamposClave.add(idFase);
				}
				idFase = idFase.substring(idFase.indexOf("-") + 1);
			}
			Aa21b20s01 filterAa21b20s01 = new Aa21b20s01();
			if (listaCamposClave != null && listaCamposClave.size() > 0) {

				//20170109 - INI - INIGO
				String strServicioLogueado = new Aa21bSeguridad().getUsuario().getServicio();
				if (strServicioLogueado != null && !"".equals(strServicioLogueado)) {
					filterAa21b20s01.setServicioLogueado(strServicioLogueado);
				}
				//20170109 - FIN - INIGO

				filterAa21b20s01.setCserv20(listaCamposClave.get(0));
				filterAa21b20s01.setCexpe20(listaCamposClave.get(1));
				filterAa21b20s01.setCfase(listaCamposClave.get(2));
			}
			return this.aa21b20s01Service.filterConFase(filterAa21b20s01, jqGridRequestDto, false);
		} else {
			JQGridRequestDto data = new JQGridRequestDto();
			data.setRows(new Long(0));
			data.setPage(new Long(0));
			return new JQGridResponseDto<Aa21b20s01>(data, new Long(0), null);
		}
	}

	/**
	 * Method 'getFasesTipoExp'.
	 * 
	 * @param fase Aa21b01s01
	 * 
	 * @return List<Aa21b01s01>
	 */
	@RequestMapping(value = "/obtenerFasesPorTipoExp", method = RequestMethod.POST)
	public @ResponseBody List<Aa21b01s01> getExpedientesAsociados(@RequestBody Aa21b01s01 fase) {
		return this.aa21b01s01Service.findAll(fase, null);
	}
}