package com.ejie.w43df.pid.utilities;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;

import sun.misc.BASE64Decoder;
import sun.misc.BASE64Encoder;

public final class W43dfBase64 {
	public W43dfBase64 getInstance() {
		return new W43dfBase64();
	}

	public static byte[] encodeStringToBytes(String pDecodedString)
			throws Exception {
		byte[] encodedBytes = null;
		BASE64Encoder encoder;
		try {
			encoder = new BASE64Encoder();
			encodedBytes = encoder.encode(pDecodedString.getBytes()).getBytes();
		} catch (Exception e) {
			throw new Exception("Error enconding String to bytes: "
					+ e.toString(), e);
		}
		return encodedBytes;
	}

	public static String encodeBytesToString(byte[] pDecodedBytes)
			throws Exception {
		String encodedString = null;
		BASE64Encoder encoder;
		try {
			encoder = new BASE64Encoder();
			encodedString = encoder.encode(pDecodedBytes);
		} catch (Exception e) {
			throw new Exception("Error encoding bytes to String: "
					+ e.toString(), e);
		}
		return encodedString;
	}

	public static String encodeObjectToString(Object pObject) throws Exception {
		String encodedString = null;
		BASE64Encoder encoder;
		ByteArrayOutputStream baos = null;
		ObjectOutputStream oos = null;
		try {
			baos = new ByteArrayOutputStream();
			oos = new ObjectOutputStream(baos);
			oos.writeObject(pObject);
			encoder = new BASE64Encoder();
			encodedString = encoder.encode(baos.toByteArray());
		} catch (Exception e) {
			throw new Exception("Error encoding Object to String: "
					+ e.toString(), e);
		} finally {
			if (baos != null)
				try {
					baos.close();
				} catch (Throwable thre) {
				}
			if (oos != null)
				try {
					oos.close();
				} catch (Throwable thre) {
				}
		}
		return encodedString;
	}

	public static byte[] decodeStringToBytes(String pEncodedString)
			throws Exception {
		byte[] decodedbytes = null;
		BASE64Decoder decoder;
		try {
			decoder = new BASE64Decoder();
			decodedbytes = decoder.decodeBuffer(pEncodedString);
		} catch (Exception exc) {
			throw new Exception("Error decoding String to bytes: "
					+ exc.toString(), exc);
		}
		return decodedbytes;
	}

	public static String decodeBytesToString(byte[] pEncodedBytes)
			throws Exception {
		String decodedString = null;
		BASE64Decoder decoder;
		try {
			decoder = new BASE64Decoder();
			decodedString = new String(decoder.decodeBuffer(new String(
					pEncodedBytes)));
		} catch (Exception exc) {
			throw new Exception("Error decoding bytes to String: "
					+ exc.toString(), exc);
		}
		return decodedString;

	}

	public static Object decodeStringToObject(String pEncodedString)
			throws Exception {
		Object object = null;
		BASE64Decoder decoder;
		ObjectInputStream ois = null;
		ByteArrayInputStream bios = null;
		try {
			decoder = new BASE64Decoder();
			bios = new ByteArrayInputStream(
					decoder.decodeBuffer(pEncodedString));
			ois = new ObjectInputStream(bios);
			object = ois.readObject();
		} catch (Exception exc) {
			throw new Exception("Error decoding String to Object: "
					+ exc.toString(), exc);
		} finally {
			if (bios != null)
				try {
					bios.close();
				} catch (Throwable thre) {
				}
			if (ois != null)
				try {
					ois.close();
				} catch (Throwable thre) {
				}
		}
		return object;
	}
}
