package com.ejie.aa21b.ws.handler;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.StringWriter;
import java.net.MalformedURLException;

import javax.xml.XMLConstants;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.OutputKeys;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.TransformerFactoryConfigurationError;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import javax.xml.ws.LogicalMessage;
import javax.xml.ws.WebServiceException;
import javax.xml.ws.handler.LogicalHandler;
import javax.xml.ws.handler.LogicalMessageContext;
import javax.xml.ws.handler.MessageContext;

import org.w3c.dom.Document;
import org.xml.sax.SAXException;

public class ValidationHandler implements LogicalHandler<LogicalMessageContext> {
	private String schemaUrl = "OrgDocumentalWebServiceImplService_schema1.xsd";
	private final static String RejectionResponseBody = "<ns2:MessageControllerResponse xmlns:ns2=\"http://some.namespace.com/\"><return>SOMEDATA</return></ns2:MessageControllerResponse>";

	@Override
	public boolean handleMessage(LogicalMessageContext context) {
		Boolean isOutBound = (Boolean) context
				.get(MessageContext.MESSAGE_OUTBOUND_PROPERTY);

		if (isOutBound) {
			return true;
		}

		LogicalMessage lm = context.getMessage();
		Source payload = lm.getPayload();
		StreamResult res = new StreamResult(new StringWriter());
		String message = "";

		try {
			Transformer trans;
			trans = TransformerFactory.newInstance().newTransformer();
			trans.setOutputProperty(OutputKeys.ENCODING, "ISO-8859-1");
			if (payload == null) { // Para el caso del que sea una llamada que
									// no recibe parametros
				return true;
			}
			trans.transform(payload, res);
			message = res.getWriter().toString();
			// Validate
			validate(message, schemaUrl);
		} catch (TransformerConfigurationException e) {
			// When Source payload Transformer object could not be obtained.
			throw new WebServiceException(e);

		} catch (TransformerFactoryConfigurationError e) {
			// When Source payload Transformer object could not be obtained.
			throw new WebServiceException(e);
		} catch (TransformerException e) {
			// When Source payload could not be transformed to String.
			throw new WebServiceException(e);
		} catch (MalformedURLException e) {
			// When URL to schema is invalid.
			throw new WebServiceException(e);
		} catch (ParserConfigurationException e) {
			// When parser needed for validation could not be obtained.
			throw new WebServiceException(e);
		} catch (IOException e) {
			// When something is wrong with IO.
			throw new WebServiceException(e);
		} catch (SAXException e) {
			// When XSD-schema validation fails.
			throw new WebServiceException(e);
		}

		return true;
	}

	private void validate(String xml, String schemaUrl)
			throws ParserConfigurationException, IOException,
			MalformedURLException, SAXException {

		DocumentBuilder parser = null;
		Document document = null;
		DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
		dbf.setNamespaceAware(true);
		parser = dbf.newDocumentBuilder();

		byte bytes[] = xml.getBytes();
		document = parser.parse(new ByteArrayInputStream(bytes));
		SchemaFactory factory = SchemaFactory
				.newInstance(XMLConstants.W3C_XML_SCHEMA_NS_URI);

		Schema schema = null;
		File f = new File("/datos/aa21b/file/" + schemaUrl);
		schema = factory.newSchema(f);
		javax.xml.validation.Validator validator = schema.newValidator();
		validator.validate(new DOMSource(document));
	}

	@Override
	public boolean handleFault(LogicalMessageContext context) {
		processMessage(context);
		return true;
	}

	@Override
	public void close(MessageContext context) {
		;
	}

	private void processMessage(LogicalMessageContext context) {
		Boolean outboundProperty = (Boolean) context
				.get(MessageContext.MESSAGE_OUTBOUND_PROPERTY);

		if (outboundProperty) {
			LogicalMessage msg = context.getMessage();
			msg.setPayload(new StreamSource(new ByteArrayInputStream(
					RejectionResponseBody.getBytes())));
		}
	}
}
