package com.ejie.aa21b.util;

import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;

import org.apache.log4j.Logger;

public class Aa21bParametros {

	private static final Logger logger = Logger
			.getLogger(Aa21bParametros.class);

	/**
	 * Method 'getParametros'
	 * 
	 * @return Properties
	 * @throws IOException
	 *             Exception
	 */
	public Properties getParametros() throws IOException {
		Properties par = null;

		par = new Properties();
		InputStream in = getClass().getResourceAsStream(
				Aa21bPaginas.AA21B_PROPERTIES_DEFAULT);
		par.load(in);
		in.close();

		return (par);
	}

	/**
	 * Method 'getParametros'
	 * 
	 * @param path
	 *            String
	 * @return Properties
	 * @throws IOException
	 *             Exception
	 */
	public Properties getParametros(String path) throws IOException {
		Properties par = null;

		par = new Properties();
		InputStream in = getClass().getResourceAsStream(path);
		par.load(in);
		in.close();
		return (par);
	}

	/**
	 * Method 'get' Obtiene la característica astrClave de la configuración.
	 * 
	 * @param astrClave
	 *            característica que queremos obtener.
	 * @return String valor que tiene la característica buscada.
	 */
	public static String get(String astrClave) {
		String lstrValor = "";

		Aa21bParametros utiles = new Aa21bParametros();
		Properties p1;
		try {
			p1 = utiles.getParametros(Aa21bPaginas.AA21B_PROPERTIES_DEFAULT);
			lstrValor = p1.getProperty(astrClave);
		} catch (IOException e) {
			// TODO Auto-generated catch block
			logger.error("get - IOException  " + e.getMessage());
			e.printStackTrace();
		}

		return lstrValor;
	}

	/**
	 * Method 'getImpreso' Obtiene la caracter�stica astrClave del fichero de
	 * propiedades Impresos.
	 * 
	 * @param astrClave
	 *            caracter�stica que queremos obtener.
	 * @return String valor que tiene la caracter�stica buscada.
	 */
	public static String getImpreso(String astrClave) {
		String lstrValor = "";

		Aa21bParametros utiles = new Aa21bParametros();
		Properties p1;
		try {
			p1 = utiles.getParametros(Aa21bPaginas.AA21B_PROPERTIES_IMPRESOS);
			lstrValor = p1.getProperty(astrClave);
		} catch (IOException e) {
			// TODO Auto-generated catch block
			logger.error("getImpreso - IOException  " + e.getMessage());
			e.printStackTrace();
		}
		return lstrValor;
	}

}
