/**
 * 
 */
package com.ejie.aa21b.service.ws;

import java.util.List;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.ejie.aa21b.dao.ws.ExpedientesWsDao;
import com.ejie.aa21b.model.ws.ErrorWs;
import com.ejie.aa21b.model.ws.ExpActualizaWs;
import com.ejie.aa21b.model.ws.ExpResumenWs;
import com.ejie.aa21b.model.ws.ExpedientesWs;
import com.ejie.aa21b.model.ws.WhereWs;

/**
 *  
 * 
 */

@Service(value = "expedientesWsService")
public class ExpedientesWsServiceImpl implements ExpedientesWsService {

	private static final Logger logger = LoggerFactory
			.getLogger(ExpedientesWsServiceImpl.class);

	@Autowired
	private ExpedientesWsDao expedientesWsDao;

	public ExpedientesWs obtenerExpedientesActualiza() {
		ExpedientesWsServiceImpl.logger
				.info("ExpedientesWsServiceImpl - Entra en obtenerExpedientesActualiza");
		ErrorWs error;
		ExpedientesWs expedienteWs = new ExpedientesWs();
		List<ExpActualizaWs> listaExpedientesActualiza = this.expedientesWsDao
				.actualizaExpedientes();
		if (listaExpedientesActualiza != null
				&& listaExpedientesActualiza.size() > 0) {// Hay
			// expedientes
			expedienteWs.setListaExpActualiza(listaExpedientesActualiza);
		} else {
			error = new ErrorWs();
			error.setCodigoError(ErrorWs.ERROR_NOHAYDATOS);
			error.setDescripcionCastellano(ErrorWs.ERROR_NOHAYDATOS_CAST);
			error.setDescripcionEuskera(ErrorWs.ERROR_NOHAYDATOS_EUSK);
			expedienteWs.setError(error);
		}

		return (expedienteWs);
	}

	/**
	 * Finds a list of rows in the Aa21b20s01 table.
	 * 
	 * @param whereEntrada
	 *            WhereWs
	 * @return List<ExpedientesWs>
	 */
	public ExpedientesWs obtenerExpedientesBusca(WhereWs whereEntrada) {
		ExpedientesWsServiceImpl.logger
				.info("ExpedientesWsServiceImpl - Entra en obtenerExpedientesBusca");
		ErrorWs error;
		ExpedientesWs expedienteWs = new ExpedientesWs();

		try {
			if (whereEntrada != null
					&& (whereEntrada.getExpe() != null && !""
							.equals(whereEntrada.getExpe()))
					|| (whereEntrada.getObjeto() != null && !""
							.equals(whereEntrada.getObjeto()))) {
				// Hay al menos uno de los parámetros de entrada.
				List<ExpResumenWs> listaExpedientesBusca = this.expedientesWsDao
						.buscaExpedientes(whereEntrada);
				if (listaExpedientesBusca != null
						&& listaExpedientesBusca.size() > 0) {// Hay
																// expedientes
					expedienteWs.setListaExpResumen(listaExpedientesBusca);
				} else {
					error = new ErrorWs();
					error.setCodigoError(ErrorWs.ERROR_NOHAYDATOS);
					error.setDescripcionCastellano(ErrorWs.ERROR_NOHAYDATOS_CAST);
					error.setDescripcionEuskera(ErrorWs.ERROR_NOHAYDATOS_EUSK);
					expedienteWs.setError(error);
				}
			} else {
				// No hay ningún parámetro de entrada
				error = new ErrorWs();
				error.setCodigoError(ErrorWs.ERROR_FALTAEXPEDIENTEENTRADA);
				error.setDescripcionCastellano(ErrorWs.ERROR_FALTAEXPEDIENTEENTRADA_CAST);
				error.setDescripcionEuskera(ErrorWs.ERROR_FALTAEXPEDIENTEENTRADA_EUSK);
				expedienteWs.setError(error);
			}

		} catch (Exception e) {
			// Error general
			error = new ErrorWs();
			error.setCodigoError(ErrorWs.ERROR_GENERAL);
			error.setDescripcionCastellano(ErrorWs.ERROR_GENERAL_CAST);
			error.setDescripcionEuskera(ErrorWs.ERROR_GENERAL_EUSK);
			expedienteWs.setError(error);
		}

		return (expedienteWs);
	}
}
