package com.ejie.aa21b.service;

import java.net.MalformedURLException;
import java.util.ArrayList;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.aa21b.dao.ProcesoPidDao;
import com.ejie.aa21b.model.Aa21b23s01;

@Service(value = "Aa21b23s01ServiceImpl")
public class ProcesoPidServiceImpl implements ProcesoPidService {
	@Autowired
	private ProcesoPidDao aa21b23s01Dao;
	@Autowired
	private Aa21bAccesoPIDService pidService;

	@Override
	public ArrayList<Aa21b23s01> obtenerLista() {
		// TODO Auto-generated method stub
		return aa21b23s01Dao.obtenerLista();
	}

	@Override
	@Transactional(rollbackFor = Throwable.class)
	public Aa21b23s01 obtenerDocumento(int id) {
		Aa21b23s01 res = new Aa21b23s01();
		// TODO Auto-generated method stub

		try {
			res = aa21b23s01Dao.obtenerDocumento(id);
			String cod = pidService.saveNew(res.getDoc(), "entrada",
					res.getExtension());
			res = new Aa21b23s01();
			res.setId(id);
			res.setCodPid(cod);

		} catch (MalformedURLException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
			res = new Aa21b23s01();
			res.setId(id);
		}
		return res;

	}

	@Override
	@Transactional(rollbackFor = Throwable.class)
	public Aa21b23s01 guardarCodPid(Aa21b23s01 entrada) {
		// TODO Auto-generated method stub
		return aa21b23s01Dao.guardarCodPid(entrada);
	}

	@Override
	public Aa21b23s01 eliminarDocumento(int id) {
		// TODO Auto-generated method stub
		Aa21b23s01 res = new Aa21b23s01();

		try {
			res = aa21b23s01Dao.obtenerDocumento(id);
			// Lo borramos del PIF
			this.pidService.delete(res.getCodPid());

		} catch (Exception e) {
			e.printStackTrace();
		}
		return res;
	}

}
