package com.ejie.aa21b.service;

import java.util.ArrayList;
import java.util.List;

import com.ejie.aa21b.model.NoraProvincia;
import com.ejie.x38.dto.JQGridRequestDto;
import com.ejie.x38.dto.Pagination;

/**
 * * NoraProvinciaService  
 * 
 *  
 */

public interface NoraProvinciaService {

	/**
	 * Inserts a single row in the NoraProvincia table.
	 * 
	 * @param provincia
	 *            NoraProvincia
	 * @return NoraProvincia
	 */
	NoraProvincia add(NoraProvincia provincia);

	/**
	 * Updates a single row in the NoraProvincia table.
	 * 
	 * @param provincia
	 *            NoraProvincia
	 * @return NoraProvincia
	 */
	NoraProvincia update(NoraProvincia provincia);

	/**
	 * Finds a single row in the NoraProvincia table.
	 * 
	 * @param provincia
	 *            NoraProvincia
	 * @return NoraProvincia
	 */
	NoraProvincia find(NoraProvincia provincia);

	/**
	 * Finds a List of rows in the NoraProvincia table.
	 * 
	 * @param provincia
	 *            NoraProvincia
	 * @param jqGridRequestDto
	 *            JQGridRequestDto
	 * @return List
	 */
	List<NoraProvincia> findAll(NoraProvincia provincia,
			JQGridRequestDto jqGridRequestDto);

	/**
	 * Counts rows in the NoraProvincia table.
	 * 
	 * @param provincia
	 *            NoraProvincia
	 * @return Long
	 */
	Long findAllCount(NoraProvincia provincia);

	/**
	 * Finds rows in the NoraProvincia table using like.
	 * 
	 * @param provincia
	 *            NoraProvincia
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	List<NoraProvincia> findAllLike(NoraProvincia provincia,
			Pagination pagination, Boolean startsWith);

	/**
	 * Deletes a single row in the NoraProvincia table.
	 * 
	 * @param provincia
	 *            NoraProvincia
	 * @return
	 */
	void remove(NoraProvincia provincia);

	/**
	 * Deletes multiple rows in the NoraProvincia table.
	 * 
	 * @param t17ProvinciaList
	 *            ArrayList
	 * @return
	 */
	void removeMultiple(ArrayList<NoraProvincia> t17ProvinciaList);

}
