package com.ejie.aa21b.service;

import java.util.List;

import com.ejie.aa21b.model.NoraPais;
import com.ejie.x38.dto.JQGridRequestDto;
import com.ejie.x38.dto.Pagination;

/**
 * * NoraPaisService  
 * 
 *  
 */

public interface NoraPaisService {

	/**
	 * Finds a single row in the NoraPais table.
	 * 
	 * @param pais
	 *            NoraPais
	 * @return NoraPais
	 */
	NoraPais find(NoraPais pais);

	/**
	 * Finds a List of rows in the NoraPais table.
	 * 
	 * @param pais
	 *            NoraPais
	 * @param jqGridRequestDto
	 *            JQGridRequestDto
	 * @return List
	 */
	List<NoraPais> findAll(NoraPais pais, JQGridRequestDto jqGridRequestDto);

	/**
	 * Counts rows in the NoraPais table.
	 * 
	 * @param pais
	 *            NoraPais
	 * @return Long
	 */
	Long findAllCount(NoraPais pais);

	/**
	 * Finds rows in the NoraPais table using like.
	 * 
	 * @param pais
	 *            NoraPais
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	List<NoraPais> findAllLike(NoraPais pais, Pagination pagination,
			Boolean startsWith);

}
