package com.ejie.aa21b.service;

import java.util.ArrayList;
import java.util.List;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.aa21b.dao.NoraMunicipioDao;
import com.ejie.aa21b.model.NoraMunicipio;
import com.ejie.x38.dto.Pagination;

/**
 * * NoraMunicipioServiceImpl  
 * 
 *  
 */

@Service(value = "noraMunicipioService")
public class NoraMunicipioServiceImpl implements NoraMunicipioService {

	private static final Logger logger = LoggerFactory
			.getLogger(NoraMunicipioServiceImpl.class);
	@Autowired
	private NoraMunicipioDao t17MunicipioDao;

	/**
	 * Inserts a single row in the NoraMunicipio table.
	 * 
	 * @param municipio
	 *            NoraMunicipio
	 * @return NoraMunicipio
	 */
	@Transactional(rollbackFor = Throwable.class)
	public NoraMunicipio add(NoraMunicipio municipio) {
		return this.t17MunicipioDao.add(municipio);
	}

	/**
	 * Updates a single row in the NoraMunicipio table.
	 * 
	 * @param municipio
	 *            NoraMunicipio
	 * @return NoraMunicipio
	 */
	@Transactional(rollbackFor = Throwable.class)
	public NoraMunicipio update(NoraMunicipio municipio) {
		return this.t17MunicipioDao.update(municipio);
	}

	/**
	 * Finds a single row in the NoraMunicipio table.
	 * 
	 * @param municipio
	 *            NoraMunicipio
	 * @return NoraMunicipio
	 */
	public NoraMunicipio find(NoraMunicipio municipio) {
		return (NoraMunicipio) this.t17MunicipioDao.find(municipio);
	}

	/**
	 * Finds a List of rows in the NoraMunicipio table.
	 * 
	 * @param municipio
	 *            NoraMunicipio
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	public List<NoraMunicipio> findAll(NoraMunicipio municipio,
			Pagination pagination) {
		return (List<NoraMunicipio>) this.t17MunicipioDao.findAll(municipio,
				pagination);
	}

	/**
	 * Counts rows in the NoraMunicipio table.
	 * 
	 * @param municipio
	 *            NoraMunicipio
	 * @return Long
	 */
	public Long findAllCount(NoraMunicipio municipio) {
		return this.t17MunicipioDao.findAllCount(municipio);
	}

	/**
	 * Finds rows in the NoraMunicipio table using like.
	 * 
	 * @param municipio
	 *            NoraMunicipio
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	public List<NoraMunicipio> findAllLike(NoraMunicipio municipio,
			Pagination pagination, Boolean startsWith) {
		return (List<NoraMunicipio>) this.t17MunicipioDao.findAllLike(
				municipio, pagination, startsWith);
	}

	/**
	 * Deletes a single row in the NoraMunicipio table.
	 * 
	 * @param municipio
	 *            NoraMunicipio
	 * @return
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void remove(NoraMunicipio municipio) {
		this.t17MunicipioDao.remove(municipio);
	}

	/**
	 * Deletes multiple rows in the NoraMunicipio table.
	 * 
	 * @param t17MunicipioList
	 *            ArrayList
	 * @return
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void removeMultiple(ArrayList<NoraMunicipio> t17MunicipioList) {
		for (NoraMunicipio t17MunicipioAux : t17MunicipioList) {
			this.t17MunicipioDao.remove(t17MunicipioAux);
		}
	}

	/**
	 * Getter method for NoraMunicipioDao
	 * 
	 * @return NoraMunicipioDao
	 */
	public NoraMunicipioDao getNoraMunicipioDao() {
		return this.t17MunicipioDao;
	}

	/**
	 * Setter method for NoraMunicipioDao.
	 * 
	 * @param t17MunicipioDao
	 *            NoraMunicipioDao
	 * @return
	 */
	public void setNoraMunicipioDao(NoraMunicipioDao t17MunicipioDao) {
		logger.info("Setting Dependency " + t17MunicipioDao);
		this.t17MunicipioDao = t17MunicipioDao;
	}
}
