package com.ejie.aa21b.service;

import java.util.List;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.ejie.aa21b.dao.NoraAutonomiaDao;
import com.ejie.aa21b.model.NoraAutonomia;
import com.ejie.x38.dto.Pagination;

/**
 * * NoraAutonomiaServiceImpl  
 * 
 *  
 */

@Service(value = "noraAutonomiaService")
public class NoraAutonomiaServiceImpl implements NoraAutonomiaService {

	private static final Logger logger = LoggerFactory
			.getLogger(NoraAutonomiaServiceImpl.class);
	@Autowired
	private NoraAutonomiaDao noraAutonomiaDao;

	/**
	 * Finds a single row in the NoraAutonomia table.
	 * 
	 * @param autonomia
	 *            NoraAutonomia
	 * @return NoraAutonomia
	 */
	public NoraAutonomia find(NoraAutonomia autonomia) {
		return (NoraAutonomia) this.noraAutonomiaDao.find(autonomia);
	}

	/**
	 * Finds a List of rows in the NoraAutonomia table.
	 * 
	 * @param autonomia
	 *            NoraAutonomia
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	public List<NoraAutonomia> findAll(NoraAutonomia autonomia,
			Pagination pagination) {
		return (List<NoraAutonomia>) this.noraAutonomiaDao.findAll(autonomia,
				pagination);
	}

	/**
	 * Counts rows in the NoraAutonomia table.
	 * 
	 * @param autonomia
	 *            NoraAutonomia
	 * @return Long
	 */
	public Long findAllCount(NoraAutonomia autonomia) {
		return this.noraAutonomiaDao.findAllCount(autonomia);
	}

	/**
	 * Finds rows in the NoraAutonomia table using like.
	 * 
	 * @param autonomia
	 *            NoraAutonomia
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	public List<NoraAutonomia> findAllLike(NoraAutonomia autonomia,
			Pagination pagination, Boolean startsWith) {
		return (List<NoraAutonomia>) this.noraAutonomiaDao.findAllLike(
				autonomia, pagination, startsWith);
	}

	/**
	 * Getter method for NoraAutonomiaDao
	 * 
	 * @return NoraAutonomiaDao
	 */
	public NoraAutonomiaDao getT17ProvinciaDao() {
		return this.noraAutonomiaDao;
	}

	/**
	 * Setter method for NoraAutonomiaDao.
	 * 
	 * @param noraAutonomiaDao
	 *            NoraAutonomiaDao
	 * @return
	 */
	public void setT17ProvinciaDao(NoraAutonomiaDao noraAutonomiaDao) {
		logger.info("Setting Dependency " + noraAutonomiaDao);
		this.noraAutonomiaDao = noraAutonomiaDao;
	}
}
