package com.ejie.aa21b.service;

import java.util.List;

import com.ejie.aa21b.model.NoraAutonomia;
import com.ejie.x38.dto.Pagination;

/**
 * * NoraAutonomiaService  
 * 
 *  
 */

public interface NoraAutonomiaService {

	/**
	 * Finds a single row in the NoraAutonomia table.
	 * 
	 * @param autonomia
	 *            NoraAutonomia
	 * @return NoraAutonomia
	 */
	NoraAutonomia find(NoraAutonomia autonomia);

	/**
	 * Finds a List of rows in the NoraAutonomia table.
	 * 
	 * @param autonomia
	 *            NoraAutonomia
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	List<NoraAutonomia> findAll(NoraAutonomia autonomia, Pagination pagination);

	/**
	 * Counts rows in the NoraAutonomia table.
	 * 
	 * @param autonomia
	 *            NoraAutonomia
	 * @return Long
	 */
	Long findAllCount(NoraAutonomia autonomia);

	/**
	 * Finds rows in the NoraAutonomia table using like.
	 * 
	 * @param autonomia
	 *            NoraAutonomia
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	List<NoraAutonomia> findAllLike(NoraAutonomia autonomia,
			Pagination pagination, Boolean startsWith);

}
