package com.ejie.aa21b.service;

import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.ejie.aa21b.dao.Aa21bDesbloqueosTablasDao;
import com.ejie.aa21b.model.Aa21b97s01;
import com.ejie.aa21b.model.Aa21b98s01;
import com.ejie.x38.dto.JQGridRequestDto;
import com.ejie.x38.dto.JQGridResponseDto;
import com.ejie.x38.dto.TableRowDto;

/**
 * Aa21bDesbloqueosTablasServiceImpl  
 * 12:26:50.
 * 
 *  
 */

@Service(value = "aa21bDesbloqueosTablasService")
public class Aa21bDesbloqueosTablasServiceImpl implements
		Aa21bDesbloqueosTablasService {

	@Autowired
	private Aa21bDesbloqueosTablasDao aa21bDesbloqueosTablasDao;

	/**
	 * Finds a list of rows in the Aa21b12s01 table.
	 * 
	 * @param aa21b97s01
	 *            Aa21b97s01
	 * @param jqGridRequestDto
	 *            JQGridRequestDto
	 * @return List<Aa21b97s01>
	 */
	public List<Aa21b97s01> findAll(Aa21b97s01 aa21b97s01,
			JQGridRequestDto jqGridRequestDto) {
		return (List<Aa21b97s01>) this.aa21bDesbloqueosTablasDao.findAll(
				aa21b97s01, jqGridRequestDto);
	}

	/**
	 * Filter method in the Aa21b12s01 table.
	 * 
	 * @param filterAa21b97s01
	 *            Aa21b97s01
	 * @param jqGridRequestDto
	 *            JQGridRequestDto
	 * @param startsWith
	 *            Boolean
	 * @return JQGridResponseDto<Aa21b97s01>
	 */
	public JQGridResponseDto<Aa21b97s01> filter(Aa21b97s01 filterAa21b97s01,
			JQGridRequestDto jqGridRequestDto, Boolean startsWith) {
		List<Aa21b97s01> listaAa21b97s01 = this.aa21bDesbloqueosTablasDao
				.findAll(filterAa21b97s01, jqGridRequestDto);
		Long recordNum = this.aa21bDesbloqueosTablasDao
				.findAllCount(filterAa21b97s01 != null ? filterAa21b97s01
						: new Aa21b97s01());
		if (jqGridRequestDto.getMultiselection().getSelectedIds() != null) {
			List<TableRowDto<Aa21b97s01>> reorderSelection = this.aa21bDesbloqueosTablasDao
					.reorderSelection(filterAa21b97s01, jqGridRequestDto);
			return new JQGridResponseDto<Aa21b97s01>(jqGridRequestDto,
					recordNum, listaAa21b97s01, reorderSelection);
		}
		return new JQGridResponseDto<Aa21b97s01>(jqGridRequestDto, recordNum,
				listaAa21b97s01);
	}

	/**
	 * Finds a single row in the Aa21b12s01 table.
	 * 
	 * @param aa21b97s01
	 *            Aa21b97s01
	 * @return Aa21b97s01
	 */
	public Aa21b97s01 find(Aa21b97s01 aa21b97s01) {
		return (Aa21b97s01) this.aa21bDesbloqueosTablasDao.find(aa21b97s01);
	}

	@Override
	public List<Aa21b97s01> findTabla(Aa21b97s01 aa21b97s01, Boolean c) {

		return this.aa21bDesbloqueosTablasDao.findTabla(aa21b97s01, c);
	}

	/**
	 * Finds a single row in the Aa21b12s01 table.
	 * 
	 * @param aa21b98s01
	 *            Aa21b98s01
	 * @return Aa21b98s01
	 */
	public List<Aa21b98s01> findDetalle(Aa21b98s01 aa21b98s01) {
		return (List<Aa21b98s01>) this.aa21bDesbloqueosTablasDao
				.findDetalle(aa21b98s01);
	}

}