/**
 * 
 */
package com.ejie.aa21b.service;

import java.net.MalformedURLException;
import java.util.List;

import com.ejie.w43df.pid.client.W43DfFormat;
import com.ejie.w43df.pid.client.W43DfPIDInterface;

/**
 * Servicio que encapsula las llamadas al webservice de PID
 * 
 *  
 * 
 */
public interface Aa21bAccesoPIDService {

	/**
	 * Guarda un nuevo elemento
	 * 
	 * @param data
	 * @param documentId
	 * @return
	 */
	public String saveNew(byte[] data, String documentName, String extension)
			throws MalformedURLException;

	/**
	 * Carga el documento con ID desde el PID
	 * 
	 * @param documentoId
	 * @return
	 */
	public byte[] load(String documentoId) throws MalformedURLException;

	public List<W43DfFormat> recuperarFormatosCMS(
			W43DfPIDInterface documentsManager) throws MalformedURLException;

	public void modify(byte[] data, String documentId, String format)
			throws MalformedURLException;

	public void delete(String documentId) throws MalformedURLException;

	public String copy(String documentId) throws MalformedURLException;

	public List<String> edicionOnline(String documentoId)
			throws MalformedURLException;

	/**
	 * Descarga el documento del PIF del usuario y lo guarda en el PID
	 * 
	 * @param path
	 * @return
	 */
	public String subirFicheroEditado(String path);

	/**
	 * Descarga el documento del PIF del usuario y lo guarda en el PID en el
	 * documentId
	 * 
	 * @param path
	 * @return
	 */
	public void actualizarFicheroEditado(String path, String documentId);
}
