package com.ejie.aa21b.service;
import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.aa21b.dao.Aa21b29s01Dao;
import com.ejie.aa21b.model.Aa21b29s01;
import com.ejie.x38.dto.JQGridRequestDto;
import com.ejie.x38.dto.JQGridResponseDto;
import com.ejie.x38.dto.JerarquiaDto;
import com.ejie.x38.dto.TableRowDto;

/**
 * Aa21b29s01ServiceImpl  
 *  
 */

@Service(value = "aa21b29s01Service")
public class Aa21b29s01ServiceImpl implements Aa21b29s01Service {

	@Autowired
	private Aa21b29s01Dao aa21b29s01Dao;

	/**
	 * Inserts a single row in the Aa21b29s01 table.
	 *
	 * @param aa21b29s01 Aa21b29s01
	 * @return Aa21b29s01
	 */
	@Transactional(rollbackFor = Throwable.class)
	public Aa21b29s01 add(Aa21b29s01 aa21b29s01) {
		return this.aa21b29s01Dao.add(aa21b29s01);
	}

	/**
	 * Updates a single row in the Aa21b29s01 table.
	 *
	 * @param aa21b29s01 Aa21b29s01
	 * @return Aa21b29s01
	 */
	@Transactional(rollbackFor = Throwable.class)
	public Aa21b29s01 update(Aa21b29s01 aa21b29s01) {
		return this.aa21b29s01Dao.update(aa21b29s01);
	 }

	/**
	 * Finds a single row in the Aa21b29s01 table.
	 *
	 * @param aa21b29s01 Aa21b29s01
	 * @return Aa21b29s01
	 */
	public Aa21b29s01 find(Aa21b29s01 aa21b29s01) {
		return (Aa21b29s01) this.aa21b29s01Dao.find(aa21b29s01);
	}
	
	/**
	 * Deletes a single row in the Aa21b29s01 table.
	 *
	 * @param aa21b29s01 Aa21b29s01
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void remove(Aa21b29s01 aa21b29s01) {
		this.aa21b29s01Dao.remove(aa21b29s01);
	}

	/**
	 * Finds a list of rows in the Aa21b29s01 table.
	 *
	 * @param aa21b29s01 Aa21b29s01
	 * @param jqGridRequestDto JQGridRequestDto
	 * @return List<Aa21b29s01>
	 */
	public List<Aa21b29s01> findAll(Aa21b29s01 aa21b29s01, JQGridRequestDto jqGridRequestDto){
		return (List<Aa21b29s01>) this.aa21b29s01Dao.findAll(aa21b29s01, jqGridRequestDto);
	}
    
	/**
	 * Finds rows in the Aa21b29s01 table using like.
	 *
	 * @param aa21b29s01 Aa21b29s01
	 * @param jqGridRequestDto JQGridRequestDto
     * @param startsWith Boolean	 
	 * @return List<Aa21b29s01>
	 */
	public List<Aa21b29s01> findAllLike(Aa21b29s01 aa21b29s01, JQGridRequestDto jqGridRequestDto, Boolean startsWith){
		return (List<Aa21b29s01>) this.aa21b29s01Dao.findAllLike(aa21b29s01, jqGridRequestDto, startsWith);
	}

	/*
	 * OPERACIONES RUP_TABLE
	 */
	 
	/**
	 * Removes rows from the Aa21b29s01 table.
	 *
	 * @param filterAa21b29s01 Aa21b29s01
	 * @param jqGridRequestDto JQGridRequestDto
	 * @param startsWith Boolean
	 */	
	public void removeMultiple(Aa21b29s01 filterAa21b29s01, JQGridRequestDto jqGridRequestDto,  Boolean startsWith){
		this.aa21b29s01Dao.removeMultiple(filterAa21b29s01, jqGridRequestDto, startsWith);
	}
        
	/**
	 * Filter method in the Aa21b29s01 table.
	 *
	 * @param filterAa21b29s01 Aa21b29s01
	 * @param jqGridRequestDto JQGridRequestDto
	 * @param startsWith Boolean
	 * @return JQGridResponseDto<Aa21b29s01>
	 */	
	public JQGridResponseDto< Aa21b29s01> filter(Aa21b29s01 filterAa21b29s01, JQGridRequestDto jqGridRequestDto,  Boolean startsWith){
		List<Aa21b29s01> listaAa21b29s01 =  this.aa21b29s01Dao.findAllLike(filterAa21b29s01, jqGridRequestDto, false);
		Long recordNum =  this.aa21b29s01Dao.findAllLikeCount(filterAa21b29s01 != null ? filterAa21b29s01: new Aa21b29s01 (),false);
		if (jqGridRequestDto.getMultiselection().getSelectedIds()!=null){
			List< TableRowDto< Aa21b29s01>> reorderSelection = this.aa21b29s01Dao.reorderSelection(filterAa21b29s01, jqGridRequestDto, startsWith);
			return new JQGridResponseDto<Aa21b29s01>(jqGridRequestDto, recordNum, listaAa21b29s01, reorderSelection);
		}
		return new JQGridResponseDto<Aa21b29s01>(jqGridRequestDto, recordNum, listaAa21b29s01);   
	}
    
    /**
	 * Searches rows in the Aa21b29s01 table.
	 *
	 * @param filterAa21b29s01 Aa21b29s01
	 * @param searchAa21b29s01 Aa21b29s01
	 * @param jqGridRequestDto JQGridRequestDto
	 * @param startsWith Boolean
	 * @return List<TableRowDto<Aa21b29s01>>
	 */	
    public List< TableRowDto< Aa21b29s01>> search(Aa21b29s01 filterAa21b29s01, Aa21b29s01 searchAa21b29s01, JQGridRequestDto jqGridRequestDto, Boolean startsWith){
		return this.aa21b29s01Dao.search(filterAa21b29s01, searchAa21b29s01, jqGridRequestDto, startsWith);
	}
    
    /**
	 * Reorder the selection made in Aa21b29s01 table.
	 *
	 * @param filterAa21b29s01 Aa21b29s01
	 * @param jqGridRequestDto JQGridRequestDto
	 * @param startsWith Boolean
	 * @return Object
	 */	
    public Object reorderSelection(Aa21b29s01 filterAa21b29s01, JQGridRequestDto jqGridRequestDto, Boolean startsWith){
		return this.aa21b29s01Dao.reorderSelection(filterAa21b29s01, jqGridRequestDto, startsWith);
	}
    
    /*
	 * OPERACIONES RUP_TABLE JERARQUIA
	 */
	 
	/**
	 * Finder method in the hierarchical the Aa21b29s01 table.
	 *
	 * @param filterAa21b29s01 Aa21b29s01
	 * @param jqGridRequestDto JQGridRequestDto
	 * @param startsWith Boolean
	 * @return JQGridResponseDto<JerarquiaDto<Aa21b29s01>>
	 */	
	public JQGridResponseDto<JerarquiaDto<Aa21b29s01>> jerarquia(Aa21b29s01 filterAa21b29s01, JQGridRequestDto jqGridRequestDto, Boolean startsWith){
		List<JerarquiaDto<Aa21b29s01>> listaAa21b29s01 =  this.aa21b29s01Dao.findAllLikeJerarquia(filterAa21b29s01, jqGridRequestDto);
		Long recordNum = this.aa21b29s01Dao.findAllLikeCountJerarquia(filterAa21b29s01, jqGridRequestDto);
		return new JQGridResponseDto<JerarquiaDto<Aa21b29s01>>(jqGridRequestDto, recordNum, listaAa21b29s01);
	}
	
	/**
	 * Finder method for siblings rows in the hierarchical the Aa21b29s01 table.
	 *
	 * @param filterAa21b29s01 Aa21b29s01
	 * @param jqGridRequestDto JQGridRequestDto
	 * @return JQGridResponseDto<JerarquiaDto<Aa21b29s01>>
	 */	
	public JQGridResponseDto<JerarquiaDto<Aa21b29s01>> jerarquiaChildren(Aa21b29s01 filterAa21b29s01, JQGridRequestDto jqGridRequestDto){
		JQGridResponseDto<JerarquiaDto<Aa21b29s01>> jqGridResponseDto = new JQGridResponseDto<JerarquiaDto<Aa21b29s01>>();
		jqGridResponseDto.addAdditionalParam(JQGridResponseDto.CHILDREN, this.aa21b29s01Dao.findAllChild(filterAa21b29s01, jqGridRequestDto));
		return jqGridResponseDto;
	}
	
	
}

