package com.ejie.aa21b.service;

import java.net.MalformedURLException;
import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.aa21b.dao.Aa21b21s01Dao;
import com.ejie.aa21b.dao.ComunDao;
import com.ejie.aa21b.model.Aa21b02s01;
import com.ejie.aa21b.model.Aa21b13s01;
import com.ejie.aa21b.model.Aa21b21s01;
import com.ejie.x38.dto.JQGridRequestDto;
import com.ejie.x38.dto.JQGridResponseDto;
import com.ejie.x38.dto.JerarquiaDto;
import com.ejie.x38.dto.TableRowDto;

/**
 * Aa21b21s01ServiceImpl  
 * 
 *  
 */

@Service(value = "aa21b21s01Service")
public class Aa21b21s01ServiceImpl implements Aa21b21s01Service {

	@Autowired
	private Aa21b21s01Dao aa21b21s01Dao;

	@Autowired
	private ComunDao comunDao;
	@Autowired
	private Aa21bAccesoPIDService pidService;

	/**
	 * Inserts a single row in the Aa21b21s01 table.
	 * 
	 * @param aa21b21s01
	 *            Aa21b21s01
	 * @return Aa21b21s01
	 */
	@Transactional(rollbackFor = Throwable.class)
	public Aa21b21s01 add(Aa21b21s01 aa21b21s01) {
		return this.aa21b21s01Dao.add(aa21b21s01);
	}

	/**
	 * Updates a single row in the Aa21b21s01 table.
	 * 
	 * @param aa21b21s01
	 *            Aa21b21s01
	 * @return Aa21b21s01
	 */
	@Transactional(rollbackFor = Throwable.class)
	public Aa21b21s01 update(Aa21b21s01 aa21b21s01) {
		return this.aa21b21s01Dao.update(aa21b21s01);
	}

	/**
	 * Finds a single row in the Aa21b21s01 table.
	 * 
	 * @param aa21b21s01
	 *            Aa21b21s01
	 * @return Aa21b21s01
	 */
	public Aa21b21s01 find(Aa21b21s01 aa21b21s01) {
		return (Aa21b21s01) this.aa21b21s01Dao.find(aa21b21s01);
	}

	/**
	 * Deletes a single row in the Aa21b21s01 table.
	 * 
	 * @param aa21b21s01
	 *            Aa21b21s01
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void remove(Aa21b21s01 aa21b21s01) {
		this.aa21b21s01Dao.remove(aa21b21s01);
	}

	/**
	 * Finds a list of rows in the Aa21b21s01 table.
	 * 
	 * @param aa21b21s01
	 *            Aa21b21s01
	 * @param jqGridRequestDto
	 *            JQGridRequestDto
	 * @return List<Aa21b21s01>
	 */
	public List<Aa21b21s01> findAll(Aa21b21s01 aa21b21s01,
			JQGridRequestDto jqGridRequestDto) {
		return (List<Aa21b21s01>) this.aa21b21s01Dao.findAll(aa21b21s01,
				jqGridRequestDto);
	}

	/**
	 * Finds rows in the Aa21b21s01 table using like.
	 * 
	 * @param aa21b21s01
	 *            Aa21b21s01
	 * @param jqGridRequestDto
	 *            JQGridRequestDto
	 * @param startsWith
	 *            Boolean
	 * @return List<Aa21b21s01>
	 */
	public List<Aa21b21s01> findAllLike(Aa21b21s01 aa21b21s01,
			JQGridRequestDto jqGridRequestDto, Boolean startsWith) {
		return (List<Aa21b21s01>) this.aa21b21s01Dao.findAllLike(aa21b21s01,
				jqGridRequestDto, null, null, startsWith);
	}

	/*
	 * OPERACIONES RUP_TABLE
	 */

	/**
	 * Removes rows from the Aa21b21s01 table.
	 * 
	 * @param filterAa21b21s01
	 *            Aa21b21s01
	 * @param jqGridRequestDto
	 *            JQGridRequestDto
	 * @param startsWith
	 *            Boolean
	 */
	public void removeMultiple(Aa21b21s01 filterAa21b21s01,
			JQGridRequestDto jqGridRequestDto, Boolean startsWith) {
		this.aa21b21s01Dao.removeMultiple(filterAa21b21s01, jqGridRequestDto,
				startsWith);
	}

	/**
	 * Filter method in the Aa21b21s01 table.
	 * 
	 * @param filterAa21b21s01
	 *            Aa21b21s01
	 * @param jqGridRequestDto
	 *            JQGridRequestDto
	 * @param startsWith
	 *            Boolean
	 * @return JQGridResponseDto<Aa21b21s01>
	 */
	public JQGridResponseDto<Aa21b21s01> filter(Aa21b21s01 filterAa21b21s01,
			JQGridRequestDto jqGridRequestDto, List<Aa21b13s01> listaServicios,
			List<Aa21b02s01> listaTiposExpedientes, Boolean startsWith) {

		List<Aa21b21s01> listaAa21b21s01 = this.aa21b21s01Dao.findAllLike(
				filterAa21b21s01, jqGridRequestDto, listaServicios,
				listaTiposExpedientes, false);

		Long recordNum = this.aa21b21s01Dao.findAllLikeCount(
				filterAa21b21s01 != null ? filterAa21b21s01 : new Aa21b21s01(),
				listaServicios, listaTiposExpedientes, false);

		if (jqGridRequestDto.getMultiselection().getSelectedIds() != null) {
			List<TableRowDto<Aa21b21s01>> reorderSelection = this.aa21b21s01Dao
					.reorderSelection(filterAa21b21s01, jqGridRequestDto,
							startsWith);
			return new JQGridResponseDto<Aa21b21s01>(jqGridRequestDto,
					recordNum, listaAa21b21s01, reorderSelection);
		}
		return new JQGridResponseDto<Aa21b21s01>(jqGridRequestDto, recordNum,
				listaAa21b21s01);
	}

	/**
	 * Searches rows in the Aa21b21s01 table.
	 * 
	 * @param filterAa21b21s01
	 *            Aa21b21s01
	 * @param searchAa21b21s01
	 *            Aa21b21s01
	 * @param jqGridRequestDto
	 *            JQGridRequestDto
	 * @param startsWith
	 *            Boolean
	 * @return List<TableRowDto<Aa21b21s01>>
	 */
	public List<TableRowDto<Aa21b21s01>> search(Aa21b21s01 filterAa21b21s01,
			Aa21b21s01 searchAa21b21s01, JQGridRequestDto jqGridRequestDto,
			Boolean startsWith) {
		return this.aa21b21s01Dao.search(filterAa21b21s01, searchAa21b21s01,
				jqGridRequestDto, startsWith);
	}

	/**
	 * Reorder the selection made in Aa21b21s01 table.
	 * 
	 * @param filterAa21b21s01
	 *            Aa21b21s01
	 * @param jqGridRequestDto
	 *            JQGridRequestDto
	 * @param startsWith
	 *            Boolean
	 * @return Object
	 */
	public Object reorderSelection(Aa21b21s01 filterAa21b21s01,
			JQGridRequestDto jqGridRequestDto, Boolean startsWith) {
		return this.aa21b21s01Dao.reorderSelection(filterAa21b21s01,
				jqGridRequestDto, startsWith);
	}

	/*
	 * OPERACIONES RUP_TABLE JERARQUIA
	 */

	/**
	 * Finder method in the hierarchical the Aa21b21s01 table.
	 * 
	 * @param filterAa21b21s01
	 *            Aa21b21s01
	 * @param jqGridRequestDto
	 *            JQGridRequestDto
	 * @param startsWith
	 *            Boolean
	 * @return JQGridResponseDto<JerarquiaDto<Aa21b21s01>>
	 */
	public JQGridResponseDto<JerarquiaDto<Aa21b21s01>> jerarquia(
			Aa21b21s01 filterAa21b21s01, JQGridRequestDto jqGridRequestDto,
			Boolean startsWith) {
		List<JerarquiaDto<Aa21b21s01>> listaAa21b21s01 = this.aa21b21s01Dao
				.findAllLikeJerarquia(filterAa21b21s01, jqGridRequestDto);
		Long recordNum = this.aa21b21s01Dao.findAllLikeCountJerarquia(
				filterAa21b21s01, jqGridRequestDto);
		return new JQGridResponseDto<JerarquiaDto<Aa21b21s01>>(
				jqGridRequestDto, recordNum, listaAa21b21s01);
	}

	/**
	 * Finder method for siblings rows in the hierarchical the Aa21b21s01 table.
	 * 
	 * @param filterAa21b21s01
	 *            Aa21b21s01
	 * @param jqGridRequestDto
	 *            JQGridRequestDto
	 * @return JQGridResponseDto<JerarquiaDto<Aa21b21s01>>
	 */
	public JQGridResponseDto<JerarquiaDto<Aa21b21s01>> jerarquiaChildren(
			Aa21b21s01 filterAa21b21s01, JQGridRequestDto jqGridRequestDto) {
		JQGridResponseDto<JerarquiaDto<Aa21b21s01>> jqGridResponseDto = new JQGridResponseDto<JerarquiaDto<Aa21b21s01>>();
		jqGridResponseDto.addAdditionalParam(JQGridResponseDto.CHILDREN,
				this.aa21b21s01Dao.findAllChild(filterAa21b21s01,
						jqGridRequestDto));
		return jqGridResponseDto;
	}

	/**
	 * @param id
	 *            String return
	 * @return boolean
	 */
	public boolean bloquear(String id) {

		return this.comunDao
				.bloquear(
						"cserv21||'-'||cexpe21||'-'||aexpe21||'-'||nexpe21||'-'||cfase21",
						id.toString());
	}

	/**
	 * @param id
	 *            String
	 * @return boolean
	 */
	public boolean desbloquear(String id) {

		return this.comunDao
				.desbloquear(
						"cserv21||'-'||cexpe21||'-'||aexpe21||'-'||nexpe21||'-'||cfase21",
						id.toString());
	}

	@Override
	public Aa21b21s01 findDocFaseExpediente(Aa21b21s01 aa21b21s01) {
		// TODO Auto-generated method stub
		Aa21b21s01 temp = this.aa21b21s01Dao.findDocFaseExpediente(aa21b21s01);
		try {
			temp.setDocumentoPID(pidService.load(temp.getDocu21()));
		} catch (MalformedURLException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
		return temp;
	}

	@Override
	public void updateDocumentoFaseExpediente(Aa21b21s01 aa21b21s01) {
		// TODO Auto-generated method stub
		this.aa21b21s01Dao.updateDocumentoFaseExpediente(aa21b21s01);
		try {
			pidService.modify(aa21b21s01.getDocumentoPID(),
					aa21b21s01.getCodPid21(), aa21b21s01.getExtdocu21());
		} catch (MalformedURLException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
	}

	@Override
	public void removeDocumento(Aa21b21s01 aa21b21s01) {
		// TODO Auto-generated method stub
		this.aa21b21s01Dao.removeDocumento(aa21b21s01);
	}

}
