package com.ejie.aa21b.service;

import java.util.Calendar;
import java.util.List;

import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.aa21b.dao.Aa21b20s01Dao;
import com.ejie.aa21b.dao.Aa21b22s01Dao;
import com.ejie.aa21b.dao.Aa21b25s01Dao;
import com.ejie.aa21b.dao.Aa21b29s01Dao;
import com.ejie.aa21b.dao.ComunDao;
import com.ejie.aa21b.model.Aa21b02s01;
import com.ejie.aa21b.model.Aa21b07s01;
import com.ejie.aa21b.model.Aa21b13s01;
import com.ejie.aa21b.model.Aa21b14s01;
import com.ejie.aa21b.model.Aa21b15s01;
import com.ejie.aa21b.model.Aa21b20s01;
import com.ejie.aa21b.model.Aa21b20s01Consultas;
import com.ejie.x38.dto.JQGridRequestDto;
import com.ejie.x38.dto.JQGridResponseDto;
import com.ejie.x38.dto.JerarquiaDto;
import com.ejie.x38.dto.TableRowDto;

/**
 * Aa21b20s01ServiceImpl  
 * 
 *  
 */

@Service(value = "aa21b20s01Service")
public class Aa21b20s01ServiceImpl implements Aa21b20s01Service {
	private static final Logger logger = LoggerFactory
			.getLogger(Aa21b20s01ServiceImpl.class);
	@Autowired
	private Aa21b20s01Dao aa21b20s01Dao;
	@Autowired
	private Aa21b22s01Dao asociadosDao;
	@Autowired
	private Aa21b25s01Dao documentosDao;
	@Autowired
	private Aa21b29s01Dao historicosDao;
	@Autowired
	private ComunDao comunDao;

	/**
	 * Inserts a single row in the Aa21b20s01 table.
	 * 
	 * @param aa21b20s01
	 *            Aa21b20s01
	 * @return Aa21b20s01
	 */
	@Transactional(rollbackFor = Throwable.class)
	public Aa21b20s01 add(Aa21b20s01 aa21b20s01) {
		return this.aa21b20s01Dao.add(aa21b20s01);
	}

	/**
	 * Updates a single row in the Aa21b20s01 table.
	 * 
	 * @param aa21b20s01
	 *            Aa21b20s01
	 * @return Aa21b20s01
	 */
	@Transactional(rollbackFor = Throwable.class)
	public Aa21b20s01 update(Aa21b20s01 aa21b20s01) {
		return this.aa21b20s01Dao.update(aa21b20s01);
	}

	/**
	 * Finds a single row in the Aa21b20s01 table.
	 * 
	 * @param aa21b20s01
	 *            Aa21b20s01
	 * @return Aa21b20s01
	 */
	public Aa21b20s01 find(Aa21b20s01 aa21b20s01) {
		return (Aa21b20s01) this.aa21b20s01Dao.find(aa21b20s01);
	}

	/**
	 * Deletes a single row in the Aa21b20s01 table.
	 * 
	 * @param aa21b20s01
	 *            Aa21b20s01
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void remove(Aa21b20s01 aa21b20s01) {
		this.aa21b20s01Dao.remove(aa21b20s01);
	}

	/**
	 * Finds a list of rows in the Aa21b20s01 table.
	 * 
	 * @param aa21b20s01
	 *            Aa21b20s01
	 * @param jqGridRequestDto
	 *            JQGridRequestDto
	 * @return List<Aa21b20s01>
	 */
	public List<Aa21b20s01> findAll(Aa21b20s01 aa21b20s01,
			JQGridRequestDto jqGridRequestDto) {
		return (List<Aa21b20s01>) this.aa21b20s01Dao.findAll(aa21b20s01,
				jqGridRequestDto);
	}

	/**
	 * Finds rows in the Aa21b20s01 table using like.
	 * 
	 * @param aa21b20s01
	 *            Aa21b20s01
	 * @param jqGridRequestDto
	 *            JQGridRequestDto
	 * @param startsWith
	 *            Boolean
	 * @return List<Aa21b20s01>
	 */
	public List<Aa21b20s01> findAllLike(Aa21b20s01 aa21b20s01,
			JQGridRequestDto jqGridRequestDto, Boolean startsWith) {
		return (List<Aa21b20s01>) this.aa21b20s01Dao.findAllLike(aa21b20s01,
				jqGridRequestDto, startsWith);
	}

	/*
	 * OPERACIONES RUP_TABLE
	 */

	/**
	 * Removes rows from the Aa21b20s01 table.
	 * 
	 * @param filterAa21b20s01
	 *            Aa21b20s01
	 * @param jqGridRequestDto
	 *            JQGridRequestDto
	 * @param startsWith
	 *            Boolean
	 */
	public void removeMultiple(Aa21b20s01 filterAa21b20s01,
			JQGridRequestDto jqGridRequestDto, Boolean startsWith) {
		this.aa21b20s01Dao.removeMultiple(filterAa21b20s01, jqGridRequestDto,
				startsWith);
	}

	/**
	 * Filter method in the Aa21b20s01 table.
	 * 
	 * @param filterAa21b20s01
	 *            Aa21b20s01
	 * @param jqGridRequestDto
	 *            JQGridRequestDto
	 * @param startsWith
	 *            Boolean
	 * @return JQGridResponseDto<Aa21b20s01>
	 */
	public JQGridResponseDto<Aa21b20s01> filter(Aa21b20s01 filterAa21b20s01,
			JQGridRequestDto jqGridRequestDto, Boolean startsWith) {
		List<Aa21b20s01> listaAa21b20s01 = this.aa21b20s01Dao.findAllLike(
				filterAa21b20s01, jqGridRequestDto, false);
		Long recordNum = this.aa21b20s01Dao.findAllLikeCount(
				filterAa21b20s01 != null ? filterAa21b20s01 : new Aa21b20s01(),
				false);
		if (jqGridRequestDto.getMultiselection().getSelectedIds() != null) {
			List<TableRowDto<Aa21b20s01>> reorderSelection = this.aa21b20s01Dao
					.reorderSelection(filterAa21b20s01, jqGridRequestDto,
							startsWith);
			return new JQGridResponseDto<Aa21b20s01>(jqGridRequestDto,
					recordNum, listaAa21b20s01, reorderSelection);
		}
		return new JQGridResponseDto<Aa21b20s01>(jqGridRequestDto, recordNum,
				listaAa21b20s01);
	}

	/**
	 * Filter method in the Aa21b20s01 table.
	 * 
	 * @param filterAa21b20s01
	 *            Aa21b20s01
	 * @param jqGridRequestDto
	 *            JQGridRequestDto
	 * @param startsWith
	 *            Boolean
	 * @return JQGridResponseDto<Aa21b20s01>
	 */
	public JQGridResponseDto<Aa21b20s01> filterConFase(
			Aa21b20s01 filterAa21b20s01, JQGridRequestDto jqGridRequestDto,
			Boolean startsWith) {
		List<Aa21b20s01> listaAa21b20s01 = this.aa21b20s01Dao
				.findAllLikeConFase(filterAa21b20s01, jqGridRequestDto, false);
		Long recordNum = this.aa21b20s01Dao.findAllLikeCountConFase(
				filterAa21b20s01 != null ? filterAa21b20s01 : new Aa21b20s01(),
				false);
		if (jqGridRequestDto.getMultiselection().getSelectedIds() != null) {
			List<TableRowDto<Aa21b20s01>> reorderSelection = this.aa21b20s01Dao
					.reorderSelectionConFase(filterAa21b20s01,
							jqGridRequestDto, startsWith);
			return new JQGridResponseDto<Aa21b20s01>(jqGridRequestDto,
					recordNum, listaAa21b20s01, reorderSelection);
		}
		return new JQGridResponseDto<Aa21b20s01>(jqGridRequestDto, recordNum,
				listaAa21b20s01);
	}

	/**
	 * Searches rows in the Aa21b20s01 table.
	 * 
	 * @param filterAa21b20s01
	 *            Aa21b20s01
	 * @param searchAa21b20s01
	 *            Aa21b20s01
	 * @param jqGridRequestDto
	 *            JQGridRequestDto
	 * @param startsWith
	 *            Boolean
	 * @return List<TableRowDto<Aa21b20s01>>
	 */
	public List<TableRowDto<Aa21b20s01>> search(Aa21b20s01 filterAa21b20s01,
			Aa21b20s01 searchAa21b20s01, JQGridRequestDto jqGridRequestDto,
			Boolean startsWith) {
		return this.aa21b20s01Dao.search(filterAa21b20s01, searchAa21b20s01,
				jqGridRequestDto, startsWith);
	}

	/**
	 * Reorder the selection made in Aa21b20s01 table.
	 * 
	 * @param filterAa21b20s01
	 *            Aa21b20s01
	 * @param jqGridRequestDto
	 *            JQGridRequestDto
	 * @param startsWith
	 *            Boolean
	 * @return Object
	 */
	public Object reorderSelection(Aa21b20s01 filterAa21b20s01,
			JQGridRequestDto jqGridRequestDto, Boolean startsWith) {
		return this.aa21b20s01Dao.reorderSelection(filterAa21b20s01,
				jqGridRequestDto, startsWith);
	}

	/*
	 * OPERACIONES RUP_TABLE JERARQUIA
	 */

	/**
	 * Finder method in the hierarchical the Aa21b20s01 table.
	 * 
	 * @param filterAa21b20s01
	 *            Aa21b20s01
	 * @param jqGridRequestDto
	 *            JQGridRequestDto
	 * @param startsWith
	 *            Boolean
	 * @return JQGridResponseDto<JerarquiaDto<Aa21b20s01>>
	 */
	public JQGridResponseDto<JerarquiaDto<Aa21b20s01>> jerarquia(
			Aa21b20s01 filterAa21b20s01, JQGridRequestDto jqGridRequestDto,
			Boolean startsWith) {
		List<JerarquiaDto<Aa21b20s01>> listaAa21b20s01 = this.aa21b20s01Dao
				.findAllLikeJerarquia(filterAa21b20s01, jqGridRequestDto);
		Long recordNum = this.aa21b20s01Dao.findAllLikeCountJerarquia(
				filterAa21b20s01, jqGridRequestDto);
		return new JQGridResponseDto<JerarquiaDto<Aa21b20s01>>(
				jqGridRequestDto, recordNum, listaAa21b20s01);
	}

	/**
	 * Finder method for siblings rows in the hierarchical the Aa21b20s01 table.
	 * 
	 * @param filterAa21b20s01
	 *            Aa21b20s01
	 * @param jqGridRequestDto
	 *            JQGridRequestDto
	 * @return JQGridResponseDto<JerarquiaDto<Aa21b20s01>>
	 */
	public JQGridResponseDto<JerarquiaDto<Aa21b20s01>> jerarquiaChildren(
			Aa21b20s01 filterAa21b20s01, JQGridRequestDto jqGridRequestDto) {
		JQGridResponseDto<JerarquiaDto<Aa21b20s01>> jqGridResponseDto = new JQGridResponseDto<JerarquiaDto<Aa21b20s01>>();
		jqGridResponseDto.addAdditionalParam(JQGridResponseDto.CHILDREN,
				this.aa21b20s01Dao.findAllChild(filterAa21b20s01,
						jqGridRequestDto));
		return jqGridResponseDto;
	}

	/**
	 * @param idExpe
	 *            String return
	 * @return boolean
	 */
	public boolean bloquear(String idExpe) {

		return this.comunDao.bloquear(
				"cserv20||'-'||cexpe20||'-'||aexpe20||'-'||nexpe20",
				idExpe.toString());
	}

	/**
	 * @param idExpe
	 *            String
	 * @return boolean
	 */
	public boolean desbloquear(String idExpe) {

		return this.comunDao.desbloquear(
				"cserv20||'-'||cexpe20||'-'||aexpe20||'-'||nexpe20",
				idExpe.toString());
	}

	/**
	 * Updates a single row in the Aa21b12s01 table.
	 * 
	 * @param aa21b20s01
	 *            Aa21b20s01
	 * @return Aa21b20s01
	 */
	@Transactional(rollbackFor = Throwable.class)
	public Aa21b20s01 updateBloqueos(Aa21b20s01 aa21b20s01) {
		return this.aa21b20s01Dao.updateBloqueos(aa21b20s01);
	}

	@Override
	public List<Aa21b20s01> findExpAsociados(String experel) {
		// TODO Auto-generated method stub
		return this.aa21b20s01Dao.findExpAsociados(experel);
	}

	@Override
	public List<Aa21b20s01Consultas> findAllLikeConsultas(
			Aa21b20s01Consultas filterAa21b20s01,
			JQGridRequestDto jqGridRequestDto, List<Aa21b13s01> listaServicios,
			List<Aa21b02s01> listaTiposExpedientes,
			List<Aa21b15s01> listaResponsables, List<Aa21b14s01> listaArchivos,
			List<Aa21b07s01> listaEstados, Boolean startsWith) {
		// TODO Auto-generated method stub
		return this.aa21b20s01Dao.findAllLikeConsultas(filterAa21b20s01,
				jqGridRequestDto, listaServicios, listaTiposExpedientes,
				listaResponsables, listaArchivos, listaEstados, startsWith);
	}

	@Override
	public Aa21b20s01 findPorReferencia(Aa21b20s01 expAsociado) {
		// TODO Auto-generated method stub
		return this.aa21b20s01Dao.findPorReferencia(expAsociado);
	}

	@Override
	public JQGridResponseDto<Aa21b20s01> filterConsultas(
			Aa21b20s01 filterAa21b20s01, List<Aa21b13s01> listaServicios,
			List<Aa21b02s01> listaTiposExpedientes,
			List<Aa21b15s01> listaResponsables, List<Aa21b14s01> listaArchivos,
			List<Aa21b07s01> listaEstados, JQGridRequestDto jqGridRequestDto,
			boolean startsWith) {
		// TODO Auto-generated method stub
		List<Aa21b20s01> listaAa21b20s01 = this.aa21b20s01Dao
				.findAllLikeMultiples(filterAa21b20s01, jqGridRequestDto,
						listaServicios, listaTiposExpedientes,
						listaResponsables, listaArchivos, listaEstados, false);
		Long recordNum = this.aa21b20s01Dao.findAllLikeCountMultiples(
				filterAa21b20s01 != null ? filterAa21b20s01 : new Aa21b20s01(),
				listaServicios, listaTiposExpedientes, listaResponsables,
				listaArchivos, listaEstados, false);
		if (jqGridRequestDto.getMultiselection().getSelectedIds() != null) {
			List<TableRowDto<Aa21b20s01>> reorderSelectionMultiples = this.aa21b20s01Dao
					.reorderSelectionMultiples(filterAa21b20s01,
							jqGridRequestDto, listaServicios,
							listaTiposExpedientes, listaResponsables,
							listaArchivos, listaEstados, startsWith);
			return new JQGridResponseDto<Aa21b20s01>(jqGridRequestDto,
					recordNum, listaAa21b20s01, reorderSelectionMultiples);
		}
		return new JQGridResponseDto<Aa21b20s01>(jqGridRequestDto, recordNum,
				listaAa21b20s01);
	}

	@Transactional(rollbackFor = Throwable.class)
	public int updateTipoExpediente(Aa21b20s01 expediente, String nuevoCexpe) {
		Aa21b20s01ServiceImpl.logger.info("Actualizar tipo de expediente");
		Aa21b20s01 nuevoExpe = new Aa21b20s01();
		nuevoExpe.setCexpe20(nuevoCexpe);
		Long nuevoAexpe = null;
		Calendar c1 = Calendar.getInstance();
		nuevoAexpe = (long) c1.get(Calendar.YEAR);
		nuevoExpe.setAexpe20(nuevoAexpe);
		Integer nuevoNexpe = aa21b20s01Dao
				.obtenerCorrelativoExpediente(nuevoExpe);
		// Actualizamos la tabla de expedientes
		aa21b20s01Dao.update(expediente, nuevoCexpe, nuevoAexpe, nuevoNexpe);

		documentosDao.update(expediente, nuevoCexpe, nuevoAexpe, nuevoNexpe);

		historicosDao.update(expediente, nuevoCexpe, nuevoAexpe, nuevoNexpe);
		String mierdaCodigo = nuevoCexpe + "/"
				+ StringUtils.leftPad(nuevoNexpe + "", 6, '0') + "/"
				+ nuevoAexpe;
		asociadosDao.update(expediente.getReferenciaGrupo(), mierdaCodigo);
		return 0;
	}

	@Override
	public String obtenerCorrelativoUbica() {
		// TODO Auto-generated method stub
		String correlativo = "";
		correlativo = aa21b20s01Dao.obtenerCorrelativoUbica();

		return correlativo;
	}

	@Override
	public Aa21b20s01 updateModificacionEspecial(Aa21b20s01 expediente) {
		// TODO Auto-generated method stub
		return this.aa21b20s01Dao.updateModificacionEspecial(expediente);
	}

	/**
	 * Finds a single row in the Aa21b20s01 table.
	 * 
	 * @param aa21b20s01
	 *            Aa21b20s01
	 * @return Aa21b20s01
	 */
	public Aa21b20s01 findConGrupoTipoExp(Aa21b20s01 aa21b20s01) {
		return (Aa21b20s01) this.aa21b20s01Dao.findConGrupoTipoExp(aa21b20s01);
	}

}