package com.ejie.aa21b.service;

import java.util.ArrayList;
import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.NoSuchMessageException;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.context.support.ReloadableResourceBundleMessageSource;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.aa21b.dao.Aa21b15s01Dao;
import com.ejie.aa21b.dao.ComunDao;
import com.ejie.aa21b.model.Aa21b13s01;
import com.ejie.aa21b.model.Aa21b15s01;
import com.ejie.x38.dto.JQGridRequestDto;
import com.ejie.x38.dto.JQGridResponseDto;
import com.ejie.x38.dto.JerarquiaDto;
import com.ejie.x38.dto.TableRowDto;

/**
 * Aa21b15s01ServiceImpl  
 * 
 *  
 */

@Service(value = "aa21b15s01Service")
public class Aa21b15s01ServiceImpl implements Aa21b15s01Service {

	@Autowired
	private ReloadableResourceBundleMessageSource appMessageSource;

	@Autowired
	private Aa21b15s01Dao aa21b15s01Dao;

	@Autowired
	private ComunDao comunDao;

	/**
	 * Inserts a single row in the Aa21b15s01 table.
	 * 
	 * @param aa21b15s01
	 *            Aa21b15s01
	 * @return Aa21b15s01
	 * @throws Exception
	 *             Exception
	 * @throws NoSuchMessageException
	 *             Exception
	 */
	@Transactional(rollbackFor = Throwable.class)
	public Aa21b15s01 add(Aa21b15s01 aa21b15s01) throws NoSuchMessageException,
			Exception {

		String mensaje = "etErrorGuardarUsuario";
		try {
			// Comprobamos que no exista el usuario
			if (this.aa21b15s01Dao.existeUsuario(aa21b15s01)) {
				mensaje = "etErrorGuardarUsuarioExiste";
				throw new Exception();
			} else {
				// Lo añadimos
				return this.aa21b15s01Dao.add(aa21b15s01);
			}
		} catch (Exception e) {
			throw new Exception(this.appMessageSource.getMessage(mensaje, null,
					LocaleContextHolder.getLocale()));
		}

	}

	/**
	 * Updates a single row in the Aa21b15s01 table.
	 * 
	 * @param aa21b15s01
	 *            Aa21b15s01
	 * @return Aa21b15s01
	 */
	@Transactional(rollbackFor = Throwable.class)
	public Aa21b15s01 update(Aa21b15s01 aa21b15s01) {
		return this.aa21b15s01Dao.update(aa21b15s01);
	}

	/**
	 * Finds a single row in the Aa21b15s01 table.
	 * 
	 * @param aa21b15s01
	 *            Aa21b15s01
	 * @return Aa21b15s01
	 */
	public Aa21b15s01 find(Aa21b15s01 aa21b15s01) {
		return (Aa21b15s01) this.aa21b15s01Dao.find(aa21b15s01);
	}

	/**
	 * Finds a single row in the Aa21b15s01 table.
	 * 
	 * @param aa21b15s01
	 *            Aa21b15s01
	 * @return Aa21b15s01
	 */
	public Aa21b15s01 findXLNET(Aa21b15s01 aa21b15s01) {
		return (Aa21b15s01) this.aa21b15s01Dao.findXLNET(aa21b15s01);
	}

	/**
	 * Deletes a single row in the Aa21b15s01 table.
	 * 
	 * @param aa21b15s01
	 *            Aa21b15s01
	 * @throws Exception
	 *             Exception
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void remove(Aa21b15s01 aa21b15s01) throws Exception {

		String mensaje = "etErrorBorrarUsuario";
		try {
			// Comprobamos que no exista ningún Expediente para este
			// usuario
			if (this.aa21b15s01Dao.existeUsuarioExp(aa21b15s01.getCusu15())) {
				mensaje = "etExisteExpedienteUsuario";
				throw new Exception();
			} else {
				// Lo borramos
				this.aa21b15s01Dao.remove(aa21b15s01);
			}
		} catch (Exception e) {
			throw new Exception(this.appMessageSource.getMessage(mensaje, null,
					LocaleContextHolder.getLocale()));
		}
	}

	/**
	 * Deletes a single row in the Aa21b15s01 table.
	 * 
	 * @param aa21b15s01
	 *            Aa21b15s01
	 * @throws Exception
	 *             Exception
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void removeForCambioServicio(Aa21b15s01 aa21b15s01) throws Exception {

		String mensaje = "etErrorBorrarUsuario";
		try {
			// Comprobamos que no exista ningún Expediente para este
			// usuario
			if (this.aa21b15s01Dao.existeUsuarioExp(aa21b15s01.getCusu15())) {
				mensaje = "etExisteExpedienteUsuarioCambioServ";
				throw new Exception();
			} else {
				// Lo borramos
				this.aa21b15s01Dao.remove(aa21b15s01);
			}
		} catch (Exception e) {
			throw new Exception(this.appMessageSource.getMessage(mensaje, null,
					LocaleContextHolder.getLocale()));
		}
	}

	/**
	 * Finds a list of rows in the Aa21b15s01 table.
	 * 
	 * @param aa21b15s01
	 *            Aa21b15s01
	 * @param jqGridRequestDto
	 *            JQGridRequestDto
	 * @return List<Aa21b15s01>
	 */
	public List<Aa21b15s01> findAll(Aa21b15s01 aa21b15s01,
			JQGridRequestDto jqGridRequestDto) {
		return (List<Aa21b15s01>) this.aa21b15s01Dao.findAll(aa21b15s01,
				jqGridRequestDto);
	}

	/**
	 * Finds rows in the Aa21b15s01 table using like.
	 * 
	 * @param aa21b15s01
	 *            Aa21b15s01
	 * @param jqGridRequestDto
	 *            JQGridRequestDto
	 * @param listaServicios
	 *            List<Aa21b13s01> listaServicios,
	 * @param startsWith
	 *            Boolean
	 * @return List<Aa21b15s01>
	 */
	public List<Aa21b15s01> findAllLike(Aa21b15s01 aa21b15s01,
			JQGridRequestDto jqGridRequestDto, List<Aa21b13s01> listaServicios,
			Boolean startsWith) {
		return (List<Aa21b15s01>) this.aa21b15s01Dao.findAllLike(aa21b15s01,
				jqGridRequestDto, listaServicios, startsWith);
	}

	/*
	 * OPERACIONES RUP_TABLE
	 */

	/**
	 * Removes rows from the Aa21b15s01 table.
	 * 
	 * @param filterAa21b15s01
	 *            Aa21b15s01
	 * @param jqGridRequestDto
	 *            JQGridRequestDto
	 * @param startsWith
	 *            Boolean
	 */
	public void removeMultiple(Aa21b15s01 filterAa21b15s01,
			JQGridRequestDto jqGridRequestDto, Boolean startsWith) {
		this.aa21b15s01Dao.removeMultiple(filterAa21b15s01, jqGridRequestDto,
				startsWith);
	}

	/**
	 * Filter method in the Aa21b15s01 table.
	 * 
	 * @param filterAa21b15s01
	 *            Aa21b15s01
	 * @param jqGridRequestDto
	 *            JQGridRequestDto
	 * @param listaServicios
	 *            List<Aa21b13s01> listaServicios,
	 * @param startsWith
	 *            Boolean
	 * @return JQGridResponseDto<Aa21b15s01>
	 */
	public JQGridResponseDto<Aa21b15s01> filter(Aa21b15s01 filterAa21b15s01,
			JQGridRequestDto jqGridRequestDto, List<Aa21b13s01> listaServicios,
			Boolean startsWith) {
		List<Aa21b15s01> listaAa21b15s01 = this.aa21b15s01Dao.findAllLike(
				filterAa21b15s01, jqGridRequestDto, listaServicios, false);
		Long recordNum = this.aa21b15s01Dao.findAllLikeCount(
				filterAa21b15s01 != null ? filterAa21b15s01 : new Aa21b15s01(),
				listaServicios, false);
		if (jqGridRequestDto.getMultiselection().getSelectedIds() != null) {
			List<TableRowDto<Aa21b15s01>> reorderSelection = this.aa21b15s01Dao
					.reorderSelection(filterAa21b15s01, jqGridRequestDto,
							startsWith);
			return new JQGridResponseDto<Aa21b15s01>(jqGridRequestDto,
					recordNum, listaAa21b15s01, reorderSelection);
		}
		return new JQGridResponseDto<Aa21b15s01>(jqGridRequestDto, recordNum,
				listaAa21b15s01);
	}

	/**
	 * Searches rows in the Aa21b15s01 table.
	 * 
	 * @param filterAa21b15s01
	 *            Aa21b15s01
	 * @param searchAa21b15s01
	 *            Aa21b15s01
	 * @param jqGridRequestDto
	 *            JQGridRequestDto
	 * @param startsWith
	 *            Boolean
	 * @return List<TableRowDto<Aa21b15s01>>
	 */
	public List<TableRowDto<Aa21b15s01>> search(Aa21b15s01 filterAa21b15s01,
			Aa21b15s01 searchAa21b15s01, JQGridRequestDto jqGridRequestDto,
			Boolean startsWith) {
		return this.aa21b15s01Dao.search(filterAa21b15s01, searchAa21b15s01,
				jqGridRequestDto, startsWith);
	}

	/**
	 * Reorder the selection made in Aa21b15s01 table.
	 * 
	 * @param filterAa21b15s01
	 *            Aa21b15s01
	 * @param jqGridRequestDto
	 *            JQGridRequestDto
	 * @param startsWith
	 *            Boolean
	 * @return Object
	 */
	public Object reorderSelection(Aa21b15s01 filterAa21b15s01,
			JQGridRequestDto jqGridRequestDto, Boolean startsWith) {
		return this.aa21b15s01Dao.reorderSelection(filterAa21b15s01,
				jqGridRequestDto, startsWith);
	}

	/*
	 * OPERACIONES RUP_TABLE JERARQUIA
	 */

	/**
	 * Finder method in the hierarchical the Aa21b15s01 table.
	 * 
	 * @param filterAa21b15s01
	 *            Aa21b15s01
	 * @param jqGridRequestDto
	 *            JQGridRequestDto
	 * @param startsWith
	 *            Boolean
	 * @return JQGridResponseDto<JerarquiaDto<Aa21b15s01>>
	 */
	public JQGridResponseDto<JerarquiaDto<Aa21b15s01>> jerarquia(
			Aa21b15s01 filterAa21b15s01, JQGridRequestDto jqGridRequestDto,
			Boolean startsWith) {
		List<JerarquiaDto<Aa21b15s01>> listaAa21b15s01 = this.aa21b15s01Dao
				.findAllLikeJerarquia(filterAa21b15s01, jqGridRequestDto);
		Long recordNum = this.aa21b15s01Dao.findAllLikeCountJerarquia(
				filterAa21b15s01, jqGridRequestDto);
		return new JQGridResponseDto<JerarquiaDto<Aa21b15s01>>(
				jqGridRequestDto, recordNum, listaAa21b15s01);
	}

	/**
	 * Finder method for siblings rows in the hierarchical the Aa21b15s01 table.
	 * 
	 * @param filterAa21b15s01
	 *            Aa21b15s01
	 * @param jqGridRequestDto
	 *            JQGridRequestDto
	 * @return JQGridResponseDto<JerarquiaDto<Aa21b15s01>>
	 */
	public JQGridResponseDto<JerarquiaDto<Aa21b15s01>> jerarquiaChildren(
			Aa21b15s01 filterAa21b15s01, JQGridRequestDto jqGridRequestDto) {
		JQGridResponseDto<JerarquiaDto<Aa21b15s01>> jqGridResponseDto = new JQGridResponseDto<JerarquiaDto<Aa21b15s01>>();
		jqGridResponseDto.addAdditionalParam(JQGridResponseDto.CHILDREN,
				this.aa21b15s01Dao.findAllChild(filterAa21b15s01,
						jqGridRequestDto));
		return jqGridResponseDto;
	}

	@Override
	public List<Aa21b15s01> findUsuario(Aa21b15s01 usuario, Boolean c) {
		// TODO Auto-generated method stub
		return this.aa21b15s01Dao.findUsu(usuario, c);
	}

	/**
	 * @param cusu15
	 *            String return
	 * @return boolean
	 */
	public boolean bloquear(String cusu15) {

		return this.comunDao.bloquear("cusu15", cusu15.toString());
	}

	/**
	 * @param cusu15
	 *            String
	 * @return boolean
	 */
	public boolean desbloquear(String cusu15) {

		return this.comunDao.desbloquear("cusu15", cusu15.toString());
	}

	@Override
	public Aa21b15s01 updateBloqueos(Aa21b15s01 aa21b15s01) {
		// TODO Auto-generated method stub
		return this.aa21b15s01Dao.updateBloqueos(aa21b15s01);
	}

	@Override
	public JQGridResponseDto<Aa21b15s01> filterSinServicio(
			Aa21b15s01 filterAa21b15s01, JQGridRequestDto jqGridRequestDto,
			boolean startsWith) {
		// TODO Auto-generated method stub
		List<Aa21b15s01> listaAa21b15s01 = this.aa21b15s01Dao
				.findAllLikeSinServicio(filterAa21b15s01, jqGridRequestDto,
						false);
		Long recordNum = this.aa21b15s01Dao.findAllLikeCountSinServicio(
				filterAa21b15s01 != null ? filterAa21b15s01 : new Aa21b15s01(),
				false);
		if (jqGridRequestDto.getMultiselection().getSelectedIds() != null) {
			List<TableRowDto<Aa21b15s01>> reorderSelection = this.aa21b15s01Dao
					.reorderSelection(filterAa21b15s01, jqGridRequestDto,
							startsWith);
			return new JQGridResponseDto<Aa21b15s01>(jqGridRequestDto,
					recordNum, listaAa21b15s01, reorderSelection);
		}
		return new JQGridResponseDto<Aa21b15s01>(jqGridRequestDto, recordNum,
				listaAa21b15s01);
	}

	@Override
	public JQGridResponseDto<Aa21b15s01> filterResponsablesServicio(
			Aa21b15s01 filterAa21b15s01, JQGridRequestDto jqGridRequestDto,
			boolean startsWith) {
		// TODO Auto-generated method stub
		List<Aa21b15s01> listaAa21b15s01 = this.aa21b15s01Dao
				.findAllLikeRespServicio(filterAa21b15s01, jqGridRequestDto,
						false);
		Long recordNum = this.aa21b15s01Dao.findAllLikeCountRespServicio(
				filterAa21b15s01 != null ? filterAa21b15s01 : new Aa21b15s01(),
				false);
		if (jqGridRequestDto.getMultiselection().getSelectedIds() != null) {
			List<TableRowDto<Aa21b15s01>> reorderSelection = this.aa21b15s01Dao
					.reorderSelection(filterAa21b15s01, jqGridRequestDto,
							startsWith);
			return new JQGridResponseDto<Aa21b15s01>(jqGridRequestDto,
					recordNum, listaAa21b15s01, reorderSelection);
		}
		return new JQGridResponseDto<Aa21b15s01>(jqGridRequestDto, recordNum,
				listaAa21b15s01);
	}

	@Transactional(rollbackFor = Throwable.class)
	public void updateAsignados(ArrayList<String> listaUsuAsig,
			Aa21b13s01 servicio) {
		// TODO Auto-generated method stub
		this.aa21b15s01Dao.updateAsignados(listaUsuAsig, servicio);
	}

	@Transactional(rollbackFor = Throwable.class)
	public void removeAsignados(ArrayList<String> listaDesagregar) {
		// TODO Auto-generated method stub
		this.aa21b15s01Dao.removeAsignados(listaDesagregar);
	}

	@Override
	public List<Aa21b15s01> findAllComboUsuariosServicios(
			List<Aa21b15s01> listaUsuarios, JQGridRequestDto jqGridRequestDto) {
		// TODO Auto-generated method stub
		return this.aa21b15s01Dao.findAllComboUsuariosServicios(listaUsuarios,
				jqGridRequestDto);
	}
}
