package com.ejie.aa21b.service;

import java.util.ArrayList;
import java.util.List;

import org.springframework.context.NoSuchMessageException;

import com.ejie.aa21b.model.Aa21b13s01;
import com.ejie.aa21b.model.Aa21b15s01;
import com.ejie.x38.dto.JQGridRequestDto;
import com.ejie.x38.dto.JQGridResponseDto;
import com.ejie.x38.dto.JerarquiaDto;
import com.ejie.x38.dto.TableRowDto;

/**
 * Aa21b15s01Service  
 * 
 *  
 */

public interface Aa21b15s01Service {

	/**
	 * Inserts a single row in the Aa21b15s01 table.
	 * 
	 * @param aa21b15s01
	 *            Aa21b15s01
	 * @return Aa21b15s01
	 */
	Aa21b15s01 add(Aa21b15s01 aa21b15s01) throws NoSuchMessageException,
			Exception;

	/**
	 * Updates a single row in the Aa21b15s01 table.
	 * 
	 * @param aa21b15s01
	 *            Aa21b15s01
	 * @return Aa21b15s01
	 */
	Aa21b15s01 update(Aa21b15s01 aa21b15s01);

	/**
	 * Finds a single row in the Aa21b15s01 table.
	 * 
	 * @param aa21b15s01
	 *            Aa21b15s01
	 * @return Aa21b15s01
	 */
	Aa21b15s01 find(Aa21b15s01 aa21b15s01);

	/**
	 * Finds a single row in the Aa21b15s01 table.
	 * 
	 * @param aa21b15s01
	 *            Aa21b15s01
	 * @return Aa21b15s01
	 */
	Aa21b15s01 findXLNET(Aa21b15s01 aa21b15s01);

	/**
	 * Deletes a single row in the Aa21b15s01 table.
	 * 
	 * @param aa21b15s01
	 *            Aa21b15s01
	 * @throws Exception
	 * @throws NoSuchMessageException
	 */
	void remove(Aa21b15s01 aa21b15s01) throws NoSuchMessageException, Exception;

	/**
	 * Finds a list of rows in the Aa21b15s01 table.
	 * 
	 * @param aa21b15s01
	 *            Aa21b15s01
	 * @param jqGridRequestDto
	 *            JQGridRequestDto
	 * @return List<Aa21b15s01>
	 */
	List<Aa21b15s01> findAll(Aa21b15s01 aa21b15s01,
			JQGridRequestDto jqGridRequestDto);

	/**
	 * Finds rows in the Aa21b15s01 table using like.
	 * 
	 * @param aa21b15s01
	 *            Aa21b15s01
	 * @param jqGridRequestDto
	 *            JQGridRequestDto
	 * @param listaServicios
	 *            List<Aa21b13s01> listaServicios,
	 * @param startsWith
	 *            Boolean
	 * @return List<Aa21b15s01>
	 */
	List<Aa21b15s01> findAllLike(Aa21b15s01 aa21b15s01,
			JQGridRequestDto jqGridRequestDto, List<Aa21b13s01> listaServicios,
			Boolean startsWith);

	/*
	 * OPERACIONES RUP_TABLE
	 */

	/**
	 * Removes rows from the Aa21b15s01 table.
	 * 
	 * @param filterAa21b15s01
	 *            Aa21b15s01
	 * @param jqGridRequestDto
	 *            JQGridRequestDto
	 * @param startsWith
	 *            Boolean
	 */
	void removeMultiple(Aa21b15s01 filterAa21b15s01,
			JQGridRequestDto jqGridRequestDto, Boolean startsWith);

	/**
	 * Filter method in the Aa21b15s01 table.
	 * 
	 * @param filterAa21b15s01
	 *            Aa21b15s01
	 * @param jqGridRequestDto
	 *            JQGridRequestDto
	 * @param listaServicios
	 *            List<Aa21b13s01>
	 * @param startsWith
	 *            Boolean
	 * @return JQGridResponseDto<Aa21b15s01>
	 */
	JQGridResponseDto<Aa21b15s01> filter(Aa21b15s01 filterAa21b15s01,
			JQGridRequestDto jqGridRequestDto, List<Aa21b13s01> listaServicios,
			Boolean startsWith);

	/**
	 * Searches rows in the Aa21b15s01 table.
	 * 
	 * @param filterAa21b15s01
	 *            Aa21b15s01
	 * @param searchAa21b15s01
	 *            Aa21b15s01
	 * @param jqGridRequestDto
	 *            JQGridRequestDto
	 * @param startsWith
	 *            Boolean
	 * @return List<TableRowDto<Aa21b15s01>>
	 */
	List<TableRowDto<Aa21b15s01>> search(Aa21b15s01 filterAa21b15s01,
			Aa21b15s01 searchAa21b15s01, JQGridRequestDto jqGridRequestDto,
			Boolean startsWith);

	/**
	 * Reorder the selection made in Aa21b15s01 table.
	 * 
	 * @param filterAa21b15s01
	 *            Aa21b15s01
	 * @param jqGridRequestDto
	 *            JQGridRequestDto
	 * @param startsWith
	 *            Boolean
	 * @return Object
	 */
	Object reorderSelection(Aa21b15s01 filterAa21b15s01,
			JQGridRequestDto jqGridRequestDto, Boolean startsWith);

	/*
	 * OPERACIONES RUP_TABLE JERARQUIA
	 */

	/**
	 * Finder method in the hierarchical the Aa21b15s01 table.
	 * 
	 * @param filterAa21b15s01
	 *            Aa21b15s01
	 * @param jqGridRequestDto
	 *            JQGridRequestDto
	 * @param startsWith
	 *            Boolean
	 * @return JQGridResponseDto<JerarquiaDto<Aa21b15s01>>
	 */
	JQGridResponseDto<JerarquiaDto<Aa21b15s01>> jerarquia(
			Aa21b15s01 filterAa21b15s01, JQGridRequestDto jqGridRequestDto,
			Boolean startsWith);

	/**
	 * Finder method for siblings rows in the hierarchical the Aa21b15s01 table.
	 * 
	 * @param filterAa21b15s01
	 *            Aa21b15s01
	 * @param jqGridRequestDto
	 *            JQGridRequestDto
	 * @return JQGridResponseDto<JerarquiaDto<Aa21b15s01>>
	 */
	JQGridResponseDto<JerarquiaDto<Aa21b15s01>> jerarquiaChildren(
			Aa21b15s01 filterAa21b15s01, JQGridRequestDto jqGridRequestDto);

	/**
	 * 
	 * @param cusu15
	 *            String
	 * @return boolean
	 */
	boolean bloquear(String cusu15);

	/**
	 * 
	 * @param cusu15
	 *            String
	 * @return boolean
	 * 
	 */
	boolean desbloquear(String cusu15);

	/**
	 * 
	 * @param usuario
	 *            Aa21b15s01
	 * @param c
	 *            boolean
	 * @return List<Aa21b15s01>
	 * 
	 */
	List<Aa21b15s01> findUsuario(Aa21b15s01 usuario, Boolean c);

	Aa21b15s01 updateBloqueos(Aa21b15s01 aa21b15s01);

	JQGridResponseDto<Aa21b15s01> filterSinServicio(
			Aa21b15s01 filterAa21b15s01, JQGridRequestDto jqGridRequestDto,
			boolean b);

	void updateAsignados(ArrayList<String> listaUsuAsig, Aa21b13s01 servicio);

	void removeAsignados(ArrayList<String> listaDesagregar);

	List<Aa21b15s01> findAllComboUsuariosServicios(
			List<Aa21b15s01> listaUsuarios, JQGridRequestDto jqGridRequestDto);

	void removeForCambioServicio(Aa21b15s01 aa21b15s01)
			throws NoSuchMessageException, Exception;

	JQGridResponseDto<Aa21b15s01> filterResponsablesServicio(
			Aa21b15s01 filterAa21b15s01, JQGridRequestDto jqGridRequestDto,
			boolean b);

}
