package com.ejie.aa21b.service;

import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.context.support.ReloadableResourceBundleMessageSource;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.aa21b.dao.Aa21b13s01Dao;
import com.ejie.aa21b.dao.ComunDao;
import com.ejie.aa21b.model.Aa21b12s01;
import com.ejie.aa21b.model.Aa21b13s01;
import com.ejie.x38.dto.JQGridRequestDto;
import com.ejie.x38.dto.JQGridResponseDto;
import com.ejie.x38.dto.JerarquiaDto;
import com.ejie.x38.dto.TableRowDto;

/**
 * Aa21b13s01ServiceImpl  
 * 
 *  
 */

@Service(value = "aa21b13s01Service")
public class Aa21b13s01ServiceImpl implements Aa21b13s01Service {

	@Autowired
	private ReloadableResourceBundleMessageSource appMessageSource;

	@Autowired
	private Aa21b13s01Dao aa21b13s01Dao;

	@Autowired
	private ComunDao comunDao;

	/**
	 * Inserts a single row in the Aa21b13s01 table.
	 * 
	 * @param aa21b13s01
	 *            Aa21b13s01
	 * @return Aa21b13s01
	 */
	@Transactional(rollbackFor = Throwable.class)
	public Aa21b13s01 add(Aa21b13s01 aa21b13s01) {
		return this.aa21b13s01Dao.add(aa21b13s01);
	}

	/**
	 * Updates a single row in the Aa21b13s01 table.
	 * 
	 * @param aa21b13s01
	 *            Aa21b13s01
	 * @return Aa21b13s01
	 */
	@Transactional(rollbackFor = Throwable.class)
	public Aa21b13s01 update(Aa21b13s01 aa21b13s01) {
		return this.aa21b13s01Dao.update(aa21b13s01);
	}

	/**
	 * Finds a single row in the Aa21b13s01 table.
	 * 
	 * @param aa21b13s01
	 *            Aa21b13s01
	 * @return Aa21b13s01
	 */
	public Aa21b13s01 find(Aa21b13s01 aa21b13s01) {
		return (Aa21b13s01) this.aa21b13s01Dao.find(aa21b13s01);
	}

	/**
	 * Deletes a single row in the Aa21b13s01 table.
	 * 
	 * @param aa21b13s01
	 *            Aa21b13s01
	 * @throws Exception
	 *             Exception
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void remove(Aa21b13s01 aa21b13s01) throws Exception {
		String mensaje = "etErrorBorrarServicio";
		try {
			// Comprobamos que no exista ningún Expediente para este
			// departamento
			if (this.aa21b13s01Dao.existeServicioExp(aa21b13s01.getCServ13())) {
				mensaje = "etExisteExpedienteServicio";
				throw new Exception();
			} else if (this.aa21b13s01Dao.existeServicioUsuarios(aa21b13s01
					.getCServ13())) {
				mensaje = "etExisteUsuarioServicio";
				throw new Exception();
			} else {
				// Lo borramos
				this.aa21b13s01Dao.remove(aa21b13s01);

			}
		} catch (Exception e) {
			throw new Exception(this.appMessageSource.getMessage(mensaje, null,
					LocaleContextHolder.getLocale()));
		}
	}

	/**
	 * Finds a list of rows in the Aa21b13s01 table.
	 * 
	 * @param aa21b13s01
	 *            Aa21b13s01
	 * @param jqGridRequestDto
	 *            JQGridRequestDto
	 * @return List<Aa21b13s01>
	 */
	public List<Aa21b13s01> findAll(Aa21b13s01 aa21b13s01,
			JQGridRequestDto jqGridRequestDto) {
		return (List<Aa21b13s01>) this.aa21b13s01Dao.findAll(aa21b13s01,
				jqGridRequestDto);
	}

	/**
	 * Finds rows in the Aa21b13s01 table using like.
	 * 
	 * @param aa21b13s01
	 *            Aa21b13s01
	 * @param jqGridRequestDto
	 *            JQGridRequestDto
	 * @param startsWith
	 *            Boolean
	 * @return List<Aa21b13s01>
	 */
	public List<Aa21b13s01> findAllLike(Aa21b13s01 aa21b13s01,
			JQGridRequestDto jqGridRequestDto, Boolean startsWith) {
		return (List<Aa21b13s01>) this.aa21b13s01Dao.findAllLike(aa21b13s01,
				jqGridRequestDto, null, startsWith);
	}

	/*
	 * OPERACIONES RUP_TABLE
	 */

	/**
	 * Removes rows from the Aa21b13s01 table.
	 * 
	 * @param filterAa21b13s01
	 *            Aa21b13s01
	 * @param jqGridRequestDto
	 *            JQGridRequestDto
	 * @param startsWith
	 *            Boolean
	 */
	public void removeMultiple(Aa21b13s01 filterAa21b13s01,
			JQGridRequestDto jqGridRequestDto, Boolean startsWith) {
		this.aa21b13s01Dao.removeMultiple(filterAa21b13s01, jqGridRequestDto,
				startsWith);
	}

	/**
	 * Filter method in the Aa21b13s01 table.
	 * 
	 * @param filterAa21b13s01
	 *            Aa21b13s01
	 * @param jqGridRequestDto
	 *            JQGridRequestDto
	 * @param listaServicios
	 *            List<Aa21b13s01>
	 * @param startsWith
	 *            Boolean
	 * @return JQGridResponseDto<Aa21b13s01>
	 */
	public JQGridResponseDto<Aa21b13s01> filter(Aa21b13s01 filterAa21b13s01,
			JQGridRequestDto jqGridRequestDto, List<Aa21b13s01> listaServicios,
			Boolean startsWith) {
		List<Aa21b13s01> listaAa21b13s01 = this.aa21b13s01Dao.findAllLike(
				filterAa21b13s01, jqGridRequestDto, listaServicios, false);

		Long recordNum = this.aa21b13s01Dao.findAllLikeCount(
				filterAa21b13s01 != null ? filterAa21b13s01 : new Aa21b13s01(),
				listaServicios, false);
		if (jqGridRequestDto.getMultiselection().getSelectedIds() != null) {
			List<TableRowDto<Aa21b13s01>> reorderSelection = this.aa21b13s01Dao
					.reorderSelection(filterAa21b13s01, jqGridRequestDto,
							startsWith);
			return new JQGridResponseDto<Aa21b13s01>(jqGridRequestDto,
					recordNum, listaAa21b13s01, reorderSelection);
		}
		return new JQGridResponseDto<Aa21b13s01>(jqGridRequestDto, recordNum,
				listaAa21b13s01);
	}

	/**
	 * Searches rows in the Aa21b13s01 table.
	 * 
	 * @param filterAa21b13s01
	 *            Aa21b13s01
	 * @param searchAa21b13s01
	 *            Aa21b13s01
	 * @param jqGridRequestDto
	 *            JQGridRequestDto
	 * @param startsWith
	 *            Boolean
	 * @return List<TableRowDto<Aa21b13s01>>
	 */
	public List<TableRowDto<Aa21b13s01>> search(Aa21b13s01 filterAa21b13s01,
			Aa21b13s01 searchAa21b13s01, JQGridRequestDto jqGridRequestDto,
			Boolean startsWith) {
		return this.aa21b13s01Dao.search(filterAa21b13s01, searchAa21b13s01,
				jqGridRequestDto, startsWith);
	}

	/**
	 * Reorder the selection made in Aa21b13s01 table.
	 * 
	 * @param filterAa21b13s01
	 *            Aa21b13s01
	 * @param jqGridRequestDto
	 *            JQGridRequestDto
	 * @param startsWith
	 *            Boolean
	 * @return Object
	 */
	public Object reorderSelection(Aa21b13s01 filterAa21b13s01,
			JQGridRequestDto jqGridRequestDto, Boolean startsWith) {
		return this.aa21b13s01Dao.reorderSelection(filterAa21b13s01,
				jqGridRequestDto, startsWith);
	}

	/*
	 * OPERACIONES RUP_TABLE JERARQUIA
	 */

	/**
	 * Finder method in the hierarchical the Aa21b13s01 table.
	 * 
	 * @param filterAa21b13s01
	 *            Aa21b13s01
	 * @param jqGridRequestDto
	 *            JQGridRequestDto
	 * @param startsWith
	 *            Boolean
	 * @return JQGridResponseDto<JerarquiaDto<Aa21b13s01>>
	 */
	public JQGridResponseDto<JerarquiaDto<Aa21b13s01>> jerarquia(
			Aa21b13s01 filterAa21b13s01, JQGridRequestDto jqGridRequestDto,
			Boolean startsWith) {
		List<JerarquiaDto<Aa21b13s01>> listaAa21b13s01 = this.aa21b13s01Dao
				.findAllLikeJerarquia(filterAa21b13s01, jqGridRequestDto);
		Long recordNum = this.aa21b13s01Dao.findAllLikeCountJerarquia(
				filterAa21b13s01, jqGridRequestDto);
		return new JQGridResponseDto<JerarquiaDto<Aa21b13s01>>(
				jqGridRequestDto, recordNum, listaAa21b13s01);
	}

	/**
	 * Finder method for siblings rows in the hierarchical the Aa21b13s01 table.
	 * 
	 * @param filterAa21b13s01
	 *            Aa21b13s01
	 * @param jqGridRequestDto
	 *            JQGridRequestDto
	 * @return JQGridResponseDto<JerarquiaDto<Aa21b13s01>>
	 */
	public JQGridResponseDto<JerarquiaDto<Aa21b13s01>> jerarquiaChildren(
			Aa21b13s01 filterAa21b13s01, JQGridRequestDto jqGridRequestDto) {
		JQGridResponseDto<JerarquiaDto<Aa21b13s01>> jqGridResponseDto = new JQGridResponseDto<JerarquiaDto<Aa21b13s01>>();
		jqGridResponseDto.addAdditionalParam(JQGridResponseDto.CHILDREN,
				this.aa21b13s01Dao.findAllChild(filterAa21b13s01,
						jqGridRequestDto));
		return jqGridResponseDto;
	}

	/**
	 * findServicio
	 * 
	 * @param servicio
	 *            Aa21b13s01
	 * @param c
	 *            Boolean return List<Aa21b13s01>
	 */
	@Override
	public List<Aa21b13s01> findServicio(Aa21b13s01 servicio, Boolean c) {

		return this.aa21b13s01Dao.findServicio(servicio, c);
	}

	@Override
	public JQGridResponseDto<JerarquiaDto<Aa21b12s01>> jerarquiaChildren(
			Aa21b12s01 filterAa21b12s01, JQGridRequestDto jqGridRequestDto) {
		// TODO Auto-generated method stub
		return null;
	}

	@Override
	public boolean bloquear(String cserv13) {
		// TODO Auto-generated method stub
		return this.comunDao.bloquear("cserv13", cserv13.toString());
	}

	@Override
	public boolean desbloquear(String cserv13) {
		// TODO Auto-generated method stub
		return this.comunDao.desbloquear("cserv13", cserv13.toString());
	}

	@Override
	public Aa21b13s01 updateBloqueos(Aa21b13s01 aa21b13s01) {
		// TODO Auto-generated method stub
		return this.aa21b13s01Dao.updateBloqueos(aa21b13s01);
	}

}
