package com.ejie.aa21b.service;

import java.util.List;

import com.ejie.aa21b.model.Aa21b12s01;
import com.ejie.aa21b.model.Aa21b13s01;
import com.ejie.x38.dto.JQGridRequestDto;
import com.ejie.x38.dto.JQGridResponseDto;
import com.ejie.x38.dto.JerarquiaDto;
import com.ejie.x38.dto.TableRowDto;

/**
 * Aa21b13s01Service  
 * 
 *  
 */

public interface Aa21b13s01Service {

	/**
	 * Inserts a single row in the Aa21b13s01 table.
	 * 
	 * @param aa21b13s01
	 *            Aa21b13s01
	 * @return Aa21b13s01
	 */
	Aa21b13s01 add(Aa21b13s01 aa21b13s01);

	/**
	 * Updates a single row in the Aa21b13s01 table.
	 * 
	 * @param aa21b13s01
	 *            Aa21b13s01
	 * @return Aa21b13s01
	 */
	Aa21b13s01 update(Aa21b13s01 aa21b13s01);

	/**
	 * Finds a single row in the Aa21b13s01 table.
	 * 
	 * @param aa21b13s01
	 *            Aa21b13s01
	 * @return Aa21b13s01
	 */
	Aa21b13s01 find(Aa21b13s01 aa21b13s01);

	/**
	 * Deletes a single row in the Aa21b13s01 table.
	 * 
	 * @param aa21b13s01
	 *            Aa21b13s01
	 * @throws Exception
	 *             Exception
	 */
	void remove(Aa21b13s01 aa21b13s01) throws Exception;

	/**
	 * Finds a list of rows in the Aa21b13s01 table.
	 * 
	 * @param aa21b13s01
	 *            Aa21b13s01
	 * @param jqGridRequestDto
	 *            JQGridRequestDto
	 * @return List<Aa21b13s01>
	 */
	List<Aa21b13s01> findAll(Aa21b13s01 aa21b13s01,
			JQGridRequestDto jqGridRequestDto);

	/**
	 * Finds rows in the Aa21b13s01 table using like.
	 * 
	 * @param aa21b13s01
	 *            Aa21b13s01
	 * @param jqGridRequestDto
	 *            JQGridRequestDto
	 * @param startsWith
	 *            Boolean
	 * @return List<Aa21b13s01>
	 */
	List<Aa21b13s01> findAllLike(Aa21b13s01 aa21b13s01,
			JQGridRequestDto jqGridRequestDto, Boolean startsWith);

	/*
	 * OPERACIONES RUP_TABLE
	 */

	/**
	 * Removes rows from the Aa21b13s01 table.
	 * 
	 * @param filterAa21b13s01
	 *            Aa21b13s01
	 * @param jqGridRequestDto
	 *            JQGridRequestDto
	 * @param startsWith
	 *            Boolean
	 */
	void removeMultiple(Aa21b13s01 filterAa21b13s01,
			JQGridRequestDto jqGridRequestDto, Boolean startsWith);

	/**
	 * Filter method in the Aa21b13s01 table.
	 * 
	 * @param filterAa21b13s01
	 *            Aa21b13s01
	 * @param jqGridRequestDto
	 *            JQGridRequestDto
	 * @param listaServicios
	 *            List<Aa21b13s01>
	 * @param startsWith
	 *            Boolean
	 * @return JQGridResponseDto<Aa21b13s01>
	 */
	JQGridResponseDto<Aa21b13s01> filter(Aa21b13s01 filterAa21b13s01,
			JQGridRequestDto jqGridRequestDto, List<Aa21b13s01> listaServicios,
			Boolean startsWith);

	/**
	 * Searches rows in the Aa21b13s01 table.
	 * 
	 * @param filterAa21b13s01
	 *            Aa21b13s01
	 * @param searchAa21b13s01
	 *            Aa21b13s01
	 * @param jqGridRequestDto
	 *            JQGridRequestDto
	 * @param startsWith
	 *            Boolean
	 * @return List<TableRowDto<Aa21b13s01>>
	 */
	List<TableRowDto<Aa21b13s01>> search(Aa21b13s01 filterAa21b13s01,
			Aa21b13s01 searchAa21b13s01, JQGridRequestDto jqGridRequestDto,
			Boolean startsWith);

	/**
	 * Reorder the selection made in Aa21b13s01 table.
	 * 
	 * @param filterAa21b13s01
	 *            Aa21b13s01
	 * @param jqGridRequestDto
	 *            JQGridRequestDto
	 * @param startsWith
	 *            Boolean
	 * @return Object
	 */
	Object reorderSelection(Aa21b13s01 filterAa21b13s01,
			JQGridRequestDto jqGridRequestDto, Boolean startsWith);

	/*
	 * OPERACIONES RUP_TABLE JERARQUIA
	 */

	/**
	 * Finder method in the hierarchical the Aa21b13s01 table.
	 * 
	 * @param filterAa21b13s01
	 *            Aa21b13s01
	 * @param jqGridRequestDto
	 *            JQGridRequestDto
	 * @param startsWith
	 *            Boolean
	 * @return JQGridResponseDto<JerarquiaDto<Aa21b13s01>>
	 */
	JQGridResponseDto<JerarquiaDto<Aa21b13s01>> jerarquia(
			Aa21b13s01 filterAa21b13s01, JQGridRequestDto jqGridRequestDto,
			Boolean startsWith);

	/**
	 * Finder method for siblings rows in the hierarchical the Aa21b13s01 table.
	 * 
	 * @param filterAa21b13s01
	 *            Aa21b13s01
	 * @param jqGridRequestDto
	 *            JQGridRequestDto
	 * @return JQGridResponseDto<JerarquiaDto<Aa21b13s01>>
	 */
	JQGridResponseDto<JerarquiaDto<Aa21b13s01>> jerarquiaChildren(
			Aa21b13s01 filterAa21b13s01, JQGridRequestDto jqGridRequestDto);

	/**
	 * findServicio
	 * 
	 * @param servicio
	 *            Aa21b13S01
	 * @param c
	 *            Boolean
	 * @return List<Aa21b13s01>
	 */
	List<Aa21b13s01> findServicio(Aa21b13s01 servicio, Boolean c);

	/**
	 * Finder method for siblings rows in the hierarchical the Aa21b12s01 table.
	 * 
	 * @param filterAa21b12s01
	 *            Aa21b12s01
	 * @param jqGridRequestDto
	 *            JQGridRequestDto
	 * @return JQGridResponseDto<JerarquiaDto<Aa21b12s01>>
	 */
	JQGridResponseDto<JerarquiaDto<Aa21b12s01>> jerarquiaChildren(
			Aa21b12s01 filterAa21b12s01, JQGridRequestDto jqGridRequestDto);

	/**
	 * 
	 * @param cserv13
	 *            String
	 * @return boolean
	 */
	boolean bloquear(String cserv13);

	/**
	 * 
	 * @param cserv13
	 *            String
	 * @return boolean
	 */
	boolean desbloquear(String cserv13);

	/**
	 * Updates a bloqueos in the Aa21b12s01 table.
	 * 
	 * @param aa21b13s01
	 *            Aa21b13s01
	 * @return Aa21b13s01
	 */
	Aa21b13s01 updateBloqueos(Aa21b13s01 aa21b13s01);

}
