package com.ejie.aa21b.service;

import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.context.support.ReloadableResourceBundleMessageSource;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.aa21b.dao.Aa21b12s01Dao;
import com.ejie.aa21b.dao.ComunDao;
import com.ejie.aa21b.model.Aa21b12s01;
import com.ejie.x38.dto.JQGridRequestDto;
import com.ejie.x38.dto.JQGridResponseDto;
import com.ejie.x38.dto.JerarquiaDto;
import com.ejie.x38.dto.TableRowDto;

/**
 * Aa21b12s01ServiceImpl  
 * 
 *  
 */

@Service(value = "aa21b12s01Service")
public class Aa21b12s01ServiceImpl implements Aa21b12s01Service {

	@Autowired
	private ReloadableResourceBundleMessageSource appMessageSource;

	@Autowired
	private Aa21b12s01Dao aa21b12s01Dao;

	@Autowired
	private ComunDao comunDao;

	/**
	 * Inserts a single row in the Aa21b12s01 table.
	 * 
	 * @param aa21b12s01
	 *            Aa21b12s01
	 * @return Aa21b12s01
	 */
	@Transactional(rollbackFor = Throwable.class)
	public Aa21b12s01 add(Aa21b12s01 aa21b12s01) {
		return this.aa21b12s01Dao.add(aa21b12s01);
	}

	/**
	 * Updates a single row in the Aa21b12s01 table.
	 * 
	 * @param aa21b12s01
	 *            Aa21b12s01
	 * @return Aa21b12s01
	 */
	@Transactional(rollbackFor = Throwable.class)
	public Aa21b12s01 update(Aa21b12s01 aa21b12s01) {
		return this.aa21b12s01Dao.update(aa21b12s01);
	}

	/**
	 * Finds a single row in the Aa21b12s01 table.
	 * 
	 * @param aa21b12s01
	 *            Aa21b12s01
	 * @return Aa21b12s01
	 */
	public Aa21b12s01 find(Aa21b12s01 aa21b12s01) {
		return (Aa21b12s01) this.aa21b12s01Dao.find(aa21b12s01);
	}

	/**
	 * Deletes a single row in the Aa00j07s01 table.
	 * 
	 * @param aa21b12s01
	 *            Aa21b12s01
	 * @throws Exception
	 *             Exception
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void remove(Aa21b12s01 aa21b12s01) throws Exception {
		String mensaje = "etErrorBorrarDepartamento";
		try {
			// Comprobamos que no exista ningún Expediente para este
			// departamento
			if (this.aa21b12s01Dao.existeDepartamentoExp(aa21b12s01
					.getCDepar12())) {
				mensaje = "etExisteExpedienteDepartamento";
				throw new Exception();
			} else {
				// Lo borramos
				this.aa21b12s01Dao.remove(aa21b12s01);
			}
		} catch (Exception e) {
			throw new Exception(this.appMessageSource.getMessage(mensaje, null,
					LocaleContextHolder.getLocale()));
		}
	}

	/**
	 * Finds a list of rows in the Aa21b12s01 table.
	 * 
	 * @param aa21b12s01
	 *            Aa21b12s01
	 * @param jqGridRequestDto
	 *            JQGridRequestDto
	 * @return List<Aa21b12s01>
	 */
	public List<Aa21b12s01> findAll(Aa21b12s01 aa21b12s01,
			JQGridRequestDto jqGridRequestDto) {
		return (List<Aa21b12s01>) this.aa21b12s01Dao.findAll(aa21b12s01,
				jqGridRequestDto);
	}

	/**
	 * Finds rows in the Aa21b12s01 table using like.
	 * 
	 * @param aa21b12s01
	 *            Aa21b12s01
	 * @param jqGridRequestDto
	 *            JQGridRequestDto
	 * @param startsWith
	 *            Boolean
	 * @return List<Aa21b12s01>
	 */
	public List<Aa21b12s01> findAllLike(Aa21b12s01 aa21b12s01,
			JQGridRequestDto jqGridRequestDto, Boolean startsWith) {
		return (List<Aa21b12s01>) this.aa21b12s01Dao.findAllLike(aa21b12s01,
				jqGridRequestDto, startsWith);
	}

	/*
	 * OPERACIONES RUP_TABLE
	 */

	/**
	 * Removes rows from the Aa21b12s01 table.
	 * 
	 * @param filterAa21b12s01
	 *            Aa21b12s01
	 * @param jqGridRequestDto
	 *            JQGridRequestDto
	 * @param startsWith
	 *            Boolean
	 */
	public void removeMultiple(Aa21b12s01 filterAa21b12s01,
			JQGridRequestDto jqGridRequestDto, Boolean startsWith) {
		this.aa21b12s01Dao.removeMultiple(filterAa21b12s01, jqGridRequestDto,
				startsWith);
	}

	/**
	 * Filter method in the Aa21b12s01 table.
	 * 
	 * @param filterAa21b12s01
	 *            Aa21b12s01
	 * @param jqGridRequestDto
	 *            JQGridRequestDto
	 * @param startsWith
	 *            Boolean
	 * @return JQGridResponseDto<Aa21b12s01>
	 */
	public JQGridResponseDto<Aa21b12s01> filter(Aa21b12s01 filterAa21b12s01,
			JQGridRequestDto jqGridRequestDto, Boolean startsWith) {
		List<Aa21b12s01> listaAa21b12s01 = this.aa21b12s01Dao.findAllLike(
				filterAa21b12s01, jqGridRequestDto, false);
		Long recordNum = this.aa21b12s01Dao.findAllLikeCount(
				filterAa21b12s01 != null ? filterAa21b12s01 : new Aa21b12s01(),
				false);
		if (jqGridRequestDto.getMultiselection().getSelectedIds() != null) {
			List<TableRowDto<Aa21b12s01>> reorderSelection = this.aa21b12s01Dao
					.reorderSelection(filterAa21b12s01, jqGridRequestDto,
							startsWith);
			return new JQGridResponseDto<Aa21b12s01>(jqGridRequestDto,
					recordNum, listaAa21b12s01, reorderSelection);
		}
		return new JQGridResponseDto<Aa21b12s01>(jqGridRequestDto, recordNum,
				listaAa21b12s01);
	}

	/**
	 * Searches rows in the Aa21b12s01 table.
	 * 
	 * @param filterAa21b12s01
	 *            Aa21b12s01
	 * @param searchAa21b12s01
	 *            Aa21b12s01
	 * @param jqGridRequestDto
	 *            JQGridRequestDto
	 * @param startsWith
	 *            Boolean
	 * @return List<TableRowDto<Aa21b12s01>>
	 */
	public List<TableRowDto<Aa21b12s01>> search(Aa21b12s01 filterAa21b12s01,
			Aa21b12s01 searchAa21b12s01, JQGridRequestDto jqGridRequestDto,
			Boolean startsWith) {
		return this.aa21b12s01Dao.search(filterAa21b12s01, searchAa21b12s01,
				jqGridRequestDto, startsWith);
	}

	/**
	 * Reorder the selection made in Aa21b12s01 table.
	 * 
	 * @param filterAa21b12s01
	 *            Aa21b12s01
	 * @param jqGridRequestDto
	 *            JQGridRequestDto
	 * @param startsWith
	 *            Boolean
	 * @return Object
	 */
	public Object reorderSelection(Aa21b12s01 filterAa21b12s01,
			JQGridRequestDto jqGridRequestDto, Boolean startsWith) {
		return this.aa21b12s01Dao.reorderSelection(filterAa21b12s01,
				jqGridRequestDto, startsWith);
	}

	/*
	 * OPERACIONES RUP_TABLE JERARQUIA
	 */

	/**
	 * Finder method in the hierarchical the Aa21b12s01 table.
	 * 
	 * @param filterAa21b12s01
	 *            Aa21b12s01
	 * @param jqGridRequestDto
	 *            JQGridRequestDto
	 * @param startsWith
	 *            Boolean
	 * @return JQGridResponseDto<JerarquiaDto<Aa21b12s01>>
	 */
	public JQGridResponseDto<JerarquiaDto<Aa21b12s01>> jerarquia(
			Aa21b12s01 filterAa21b12s01, JQGridRequestDto jqGridRequestDto,
			Boolean startsWith) {
		List<JerarquiaDto<Aa21b12s01>> listaAa21b12s01 = this.aa21b12s01Dao
				.findAllLikeJerarquia(filterAa21b12s01, jqGridRequestDto);
		Long recordNum = this.aa21b12s01Dao.findAllLikeCountJerarquia(
				filterAa21b12s01, jqGridRequestDto);
		return new JQGridResponseDto<JerarquiaDto<Aa21b12s01>>(
				jqGridRequestDto, recordNum, listaAa21b12s01);
	}

	/**
	 * Finder method for siblings rows in the hierarchical the Aa21b12s01 table.
	 * 
	 * @param filterAa21b12s01
	 *            Aa21b12s01
	 * @param jqGridRequestDto
	 *            JQGridRequestDto
	 * @return JQGridResponseDto<JerarquiaDto<Aa21b12s01>>
	 */
	public JQGridResponseDto<JerarquiaDto<Aa21b12s01>> jerarquiaChildren(
			Aa21b12s01 filterAa21b12s01, JQGridRequestDto jqGridRequestDto) {
		JQGridResponseDto<JerarquiaDto<Aa21b12s01>> jqGridResponseDto = new JQGridResponseDto<JerarquiaDto<Aa21b12s01>>();
		jqGridResponseDto.addAdditionalParam(JQGridResponseDto.CHILDREN,
				this.aa21b12s01Dao.findAllChild(filterAa21b12s01,
						jqGridRequestDto));
		return jqGridResponseDto;
	}

	@Override
	public List<Aa21b12s01> findDepartamento(Aa21b12s01 departamento, Boolean c) {
		// TODO Auto-generated method stub
		return this.aa21b12s01Dao.findDepartamento(departamento, c);
	}

	/**
	 * @param cdepar12
	 *            String return
	 * @return boolean
	 */
	public boolean bloquear(String cdepar12) {

		return this.comunDao.bloquear("cdepar12", cdepar12.toString());
	}

	/**
	 * @param cdepar12
	 *            String
	 * @return boolean
	 */
	public boolean desbloquear(String cdepar12) {

		return this.comunDao.desbloquear("cdepar12", cdepar12.toString());
	}

	/**
	 * Updates a single row in the Aa21b12s01 table.
	 * 
	 * @param aa21b12s01
	 *            Aa21b12s01
	 * @return Aa21b12s01
	 */
	@Transactional(rollbackFor = Throwable.class)
	public Aa21b12s01 updateBloqueos(Aa21b12s01 aa21b12s01) {
		return this.aa21b12s01Dao.updateBloqueos(aa21b12s01);
	}

}
