package com.ejie.aa21b.service;

import java.util.List;

import com.ejie.aa21b.model.Aa21b12s01;
import com.ejie.x38.dto.JQGridRequestDto;
import com.ejie.x38.dto.JQGridResponseDto;
import com.ejie.x38.dto.JerarquiaDto;
import com.ejie.x38.dto.TableRowDto;

/**
 * Aa21b12s01Service  
 * 
 *  
 */

public interface Aa21b12s01Service {

	/**
	 * Inserts a single row in the Aa21b12s01 table.
	 * 
	 * @param aa21b12s01
	 *            Aa21b12s01
	 * @return Aa21b12s01
	 */
	Aa21b12s01 add(Aa21b12s01 aa21b12s01);

	/**
	 * Updates a single row in the Aa21b12s01 table.
	 * 
	 * @param aa21b12s01
	 *            Aa21b12s01
	 * @return Aa21b12s01
	 */
	Aa21b12s01 update(Aa21b12s01 aa21b12s01);

	/**
	 * Finds a single row in the Aa21b12s01 table.
	 * 
	 * @param aa21b12s01
	 *            Aa21b12s01
	 * @return Aa21b12s01
	 */
	Aa21b12s01 find(Aa21b12s01 aa21b12s01);

	/**
	 * Deletes a single row in the Aa21b12s01 table.
	 * 
	 * @param aa21b12s01
	 *            Aa21b12s01
	 * @throws Exception
	 *             Exception
	 */
	void remove(Aa21b12s01 aa21b12s01) throws Exception;

	/**
	 * Finds a list of rows in the Aa21b12s01 table.
	 * 
	 * @param aa21b12s01
	 *            Aa21b12s01
	 * @param jqGridRequestDto
	 *            JQGridRequestDto
	 * @return List<Aa21b12s01>
	 */
	List<Aa21b12s01> findAll(Aa21b12s01 aa21b12s01,
			JQGridRequestDto jqGridRequestDto);

	/**
	 * Finds rows in the Aa21b12s01 table using like.
	 * 
	 * @param aa21b12s01
	 *            Aa21b12s01
	 * @param jqGridRequestDto
	 *            JQGridRequestDto
	 * @param startsWith
	 *            Boolean
	 * @return List<Aa21b12s01>
	 */
	List<Aa21b12s01> findAllLike(Aa21b12s01 aa21b12s01,
			JQGridRequestDto jqGridRequestDto, Boolean startsWith);

	/*
	 * OPERACIONES RUP_TABLE
	 */

	/**
	 * Removes rows from the Aa21b12s01 table.
	 * 
	 * @param filterAa21b12s01
	 *            Aa21b12s01
	 * @param jqGridRequestDto
	 *            JQGridRequestDto
	 * @param startsWith
	 *            Boolean
	 */
	void removeMultiple(Aa21b12s01 filterAa21b12s01,
			JQGridRequestDto jqGridRequestDto, Boolean startsWith);

	/**
	 * Filter method in the Aa21b12s01 table.
	 * 
	 * @param filterAa21b12s01
	 *            Aa21b12s01
	 * @param jqGridRequestDto
	 *            JQGridRequestDto
	 * @param startsWith
	 *            Boolean
	 * @return JQGridResponseDto<Aa21b12s01>
	 */
	JQGridResponseDto<Aa21b12s01> filter(Aa21b12s01 filterAa21b12s01,
			JQGridRequestDto jqGridRequestDto, Boolean startsWith);

	/**
	 * Searches rows in the Aa21b12s01 table.
	 * 
	 * @param filterAa21b12s01
	 *            Aa21b12s01
	 * @param searchAa21b12s01
	 *            Aa21b12s01
	 * @param jqGridRequestDto
	 *            JQGridRequestDto
	 * @param startsWith
	 *            Boolean
	 * @return List<TableRowDto<Aa21b12s01>>
	 */
	List<TableRowDto<Aa21b12s01>> search(Aa21b12s01 filterAa21b12s01,
			Aa21b12s01 searchAa21b12s01, JQGridRequestDto jqGridRequestDto,
			Boolean startsWith);

	/**
	 * Reorder the selection made in Aa21b12s01 table.
	 * 
	 * @param filterAa21b12s01
	 *            Aa21b12s01
	 * @param jqGridRequestDto
	 *            JQGridRequestDto
	 * @param startsWith
	 *            Boolean
	 * @return Object
	 */
	Object reorderSelection(Aa21b12s01 filterAa21b12s01,
			JQGridRequestDto jqGridRequestDto, Boolean startsWith);

	/*
	 * OPERACIONES RUP_TABLE JERARQUIA
	 */

	/**
	 * Finder method in the hierarchical the Aa21b12s01 table.
	 * 
	 * @param filterAa21b12s01
	 *            Aa21b12s01
	 * @param jqGridRequestDto
	 *            JQGridRequestDto
	 * @param startsWith
	 *            Boolean
	 * @return JQGridResponseDto<JerarquiaDto<Aa21b12s01>>
	 */
	JQGridResponseDto<JerarquiaDto<Aa21b12s01>> jerarquia(
			Aa21b12s01 filterAa21b12s01, JQGridRequestDto jqGridRequestDto,
			Boolean startsWith);

	/**
	 * Finder method for siblings rows in the hierarchical the Aa21b12s01 table.
	 * 
	 * @param filterAa21b12s01
	 *            Aa21b12s01
	 * @param jqGridRequestDto
	 *            JQGridRequestDto
	 * @return JQGridResponseDto<JerarquiaDto<Aa21b12s01>>
	 */
	JQGridResponseDto<JerarquiaDto<Aa21b12s01>> jerarquiaChildren(
			Aa21b12s01 filterAa21b12s01, JQGridRequestDto jqGridRequestDto);

	/**
	 * 
	 * @param departamento
	 *            Aa21b12s01
	 * @param c
	 *            Boolean
	 * @return List<Aa21b12s01>
	 */
	List<Aa21b12s01> findDepartamento(Aa21b12s01 departamento, Boolean c);

	/**
	 * 
	 * @param cdepar12
	 *            String
	 * @return boolean
	 */
	boolean bloquear(String cdepar12);

	/**
	 * 
	 * @param cdepar12
	 *            String
	 * @return boolean
	 */
	boolean desbloquear(String cdepar12);

	/**
	 * Updates a bloqueos in the Aa21b12s01 table.
	 * 
	 * @param aa21b12s01
	 *            Aa21b12s01
	 * @return Aa21b12s01
	 */
	Aa21b12s01 updateBloqueos(Aa21b12s01 aa21b12s01);

}
