package com.ejie.aa21b.service;

import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.context.support.ReloadableResourceBundleMessageSource;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.aa21b.dao.Aa21b05s01Dao;
import com.ejie.aa21b.dao.ComunDao;
import com.ejie.aa21b.model.Aa21b05s01;
import com.ejie.x38.dto.JQGridRequestDto;
import com.ejie.x38.dto.JQGridResponseDto;
import com.ejie.x38.dto.JerarquiaDto;
import com.ejie.x38.dto.TableRowDto;

/**
 * Aa21b05s01ServiceImpl  
 * 
 *  
 */

@Service(value = "aa21b05s01Service")
public class Aa21b05s01ServiceImpl implements Aa21b05s01Service {

	@Autowired
	private ReloadableResourceBundleMessageSource appMessageSource;

	@Autowired
	private Aa21b05s01Dao aa21b05s01Dao;

	@Autowired
	private ComunDao comunDao;

	/**
	 * Inserts a single row in the Aa21b05s01 table.
	 * 
	 * @param aa21b05s01
	 *            Aa21b05s01
	 * @return Aa21b05s01
	 */
	@Transactional(rollbackFor = Throwable.class)
	public Aa21b05s01 add(Aa21b05s01 aa21b05s01) {
		return this.aa21b05s01Dao.add(aa21b05s01);
	}

	/**
	 * Updates a single row in the Aa21b05s01 table.
	 * 
	 * @param aa21b05s01
	 *            Aa21b05s01
	 * @return Aa21b05s01
	 */
	@Transactional(rollbackFor = Throwable.class)
	public Aa21b05s01 update(Aa21b05s01 aa21b05s01) {
		return this.aa21b05s01Dao.update(aa21b05s01);
	}

	/**
	 * Finds a single row in the Aa21b05s01 table.
	 * 
	 * @param aa21b05s01
	 *            Aa21b05s01
	 * @return Aa21b05s01
	 */
	public Aa21b05s01 find(Aa21b05s01 aa21b05s01) {
		return (Aa21b05s01) this.aa21b05s01Dao.find(aa21b05s01);
	}

	/**
	 * Deletes a single row in the Aa21b05s01 table.
	 * 
	 * @param aa21b05s01
	 *            Aa21b05s01
	 * @throws Exception
	 *             Exception
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void remove(Aa21b05s01 aa21b05s01) throws Exception {
		String mensaje = "etErrorBorrarTipoDoc";
		try {
			// Comprobamos que no exista ningún Expediente para este
			// departamento
			if (this.aa21b05s01Dao.existeTipoDocExp(aa21b05s01.getCdocu05())) {
				mensaje = "etExisteExpedienteTipoDoc";
				throw new Exception();
			} else {
				// Lo borramos
				this.aa21b05s01Dao.remove(aa21b05s01);
			}
		} catch (Exception e) {
			throw new Exception(this.appMessageSource.getMessage(mensaje, null,
					LocaleContextHolder.getLocale()));
		}
	}

	/**
	 * Finds a list of rows in the Aa21b05s01 table.
	 * 
	 * @param aa21b05s01
	 *            Aa21b05s01
	 * @param jqGridRequestDto
	 *            JQGridRequestDto
	 * @return List<Aa21b05s01>
	 */
	public List<Aa21b05s01> findAll(Aa21b05s01 aa21b05s01,
			JQGridRequestDto jqGridRequestDto) {
		return (List<Aa21b05s01>) this.aa21b05s01Dao.findAll(aa21b05s01,
				jqGridRequestDto);
	}

	/**
	 * Finds rows in the Aa21b05s01 table using like.
	 * 
	 * @param aa21b05s01
	 *            Aa21b05s01
	 * @param jqGridRequestDto
	 *            JQGridRequestDto
	 * @param startsWith
	 *            Boolean
	 * @return List<Aa21b05s01>
	 */
	public List<Aa21b05s01> findAllLike(Aa21b05s01 aa21b05s01,
			JQGridRequestDto jqGridRequestDto, Boolean startsWith) {
		return (List<Aa21b05s01>) this.aa21b05s01Dao.findAllLike(aa21b05s01,
				jqGridRequestDto, startsWith);
	}

	/*
	 * OPERACIONES RUP_TABLE
	 */

	/**
	 * Removes rows from the Aa21b05s01 table.
	 * 
	 * @param filterAa21b05s01
	 *            Aa21b05s01
	 * @param jqGridRequestDto
	 *            JQGridRequestDto
	 * @param startsWith
	 *            Boolean
	 */
	public void removeMultiple(Aa21b05s01 filterAa21b05s01,
			JQGridRequestDto jqGridRequestDto, Boolean startsWith) {
		this.aa21b05s01Dao.removeMultiple(filterAa21b05s01, jqGridRequestDto,
				startsWith);
	}

	/**
	 * Filter method in the Aa21b05s01 table.
	 * 
	 * @param filterAa21b05s01
	 *            Aa21b05s01
	 * @param jqGridRequestDto
	 *            JQGridRequestDto
	 * @param startsWith
	 *            Boolean
	 * @return JQGridResponseDto<Aa21b05s01>
	 */
	public JQGridResponseDto<Aa21b05s01> filter(Aa21b05s01 filterAa21b05s01,
			JQGridRequestDto jqGridRequestDto, Boolean startsWith) {
		List<Aa21b05s01> listaAa21b05s01 = this.aa21b05s01Dao.findAllLike(
				filterAa21b05s01, jqGridRequestDto, false);
		Long recordNum = this.aa21b05s01Dao.findAllLikeCount(
				filterAa21b05s01 != null ? filterAa21b05s01 : new Aa21b05s01(),
				false);
		if (jqGridRequestDto.getMultiselection().getSelectedIds() != null) {
			List<TableRowDto<Aa21b05s01>> reorderSelection = this.aa21b05s01Dao
					.reorderSelection(filterAa21b05s01, jqGridRequestDto,
							startsWith);
			return new JQGridResponseDto<Aa21b05s01>(jqGridRequestDto,
					recordNum, listaAa21b05s01, reorderSelection);
		}
		return new JQGridResponseDto<Aa21b05s01>(jqGridRequestDto, recordNum,
				listaAa21b05s01);
	}

	/**
	 * Searches rows in the Aa21b05s01 table.
	 * 
	 * @param filterAa21b05s01
	 *            Aa21b05s01
	 * @param searchAa21b05s01
	 *            Aa21b05s01
	 * @param jqGridRequestDto
	 *            JQGridRequestDto
	 * @param startsWith
	 *            Boolean
	 * @return List<TableRowDto<Aa21b05s01>>
	 */
	public List<TableRowDto<Aa21b05s01>> search(Aa21b05s01 filterAa21b05s01,
			Aa21b05s01 searchAa21b05s01, JQGridRequestDto jqGridRequestDto,
			Boolean startsWith) {
		return this.aa21b05s01Dao.search(filterAa21b05s01, searchAa21b05s01,
				jqGridRequestDto, startsWith);
	}

	/**
	 * Reorder the selection made in Aa21b05s01 table.
	 * 
	 * @param filterAa21b05s01
	 *            Aa21b05s01
	 * @param jqGridRequestDto
	 *            JQGridRequestDto
	 * @param startsWith
	 *            Boolean
	 * @return Object
	 */
	public Object reorderSelection(Aa21b05s01 filterAa21b05s01,
			JQGridRequestDto jqGridRequestDto, Boolean startsWith) {
		return this.aa21b05s01Dao.reorderSelection(filterAa21b05s01,
				jqGridRequestDto, startsWith);
	}

	/*
	 * OPERACIONES RUP_TABLE JERARQUIA
	 */

	/**
	 * Finder method in the hierarchical the Aa21b05s01 table.
	 * 
	 * @param filterAa21b05s01
	 *            Aa21b05s01
	 * @param jqGridRequestDto
	 *            JQGridRequestDto
	 * @param startsWith
	 *            Boolean
	 * @return JQGridResponseDto<JerarquiaDto<Aa21b05s01>>
	 */
	public JQGridResponseDto<JerarquiaDto<Aa21b05s01>> jerarquia(
			Aa21b05s01 filterAa21b05s01, JQGridRequestDto jqGridRequestDto,
			Boolean startsWith) {
		List<JerarquiaDto<Aa21b05s01>> listaAa21b05s01 = this.aa21b05s01Dao
				.findAllLikeJerarquia(filterAa21b05s01, jqGridRequestDto);
		Long recordNum = this.aa21b05s01Dao.findAllLikeCountJerarquia(
				filterAa21b05s01, jqGridRequestDto);
		return new JQGridResponseDto<JerarquiaDto<Aa21b05s01>>(
				jqGridRequestDto, recordNum, listaAa21b05s01);
	}

	/**
	 * Finder method for siblings rows in the hierarchical the Aa21b05s01 table.
	 * 
	 * @param filterAa21b05s01
	 *            Aa21b05s01
	 * @param jqGridRequestDto
	 *            JQGridRequestDto
	 * @return JQGridResponseDto<JerarquiaDto<Aa21b05s01>>
	 */
	public JQGridResponseDto<JerarquiaDto<Aa21b05s01>> jerarquiaChildren(
			Aa21b05s01 filterAa21b05s01, JQGridRequestDto jqGridRequestDto) {
		JQGridResponseDto<JerarquiaDto<Aa21b05s01>> jqGridResponseDto = new JQGridResponseDto<JerarquiaDto<Aa21b05s01>>();
		jqGridResponseDto.addAdditionalParam(JQGridResponseDto.CHILDREN,
				this.aa21b05s01Dao.findAllChild(filterAa21b05s01,
						jqGridRequestDto));
		return jqGridResponseDto;
	}

	@Override
	public List<Aa21b05s01> findTipoDocumento(Aa21b05s01 tipoDocumento,
			Boolean c) {
		// TODO Auto-generated method stub
		return this.aa21b05s01Dao.findTipoDocumento(tipoDocumento, c);
	}

	/**
	 * @param cdocu05
	 *            String return
	 * @return boolean
	 */
	public boolean bloquear(String cdocu05) {

		return this.comunDao.bloquear("cdocu05", cdocu05.toString());
	}

	/**
	 * @param cdocu05
	 *            String
	 * @return boolean
	 */
	public boolean desbloquear(String cdocu05) {

		return this.comunDao.desbloquear("cdocu05", cdocu05.toString());
	}

	/**
	 * @param aa21b05s01
	 *            Aa21b05s01
	 * 
	 * @return Aa21b05s01
	 */
	@Override
	public Aa21b05s01 updateBloqueos(Aa21b05s01 aa21b05s01) {
		// TODO Auto-generated method stub
		return this.aa21b05s01Dao.updateBloqueos(aa21b05s01);
	}

}
