package com.ejie.aa21b.service;

import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.context.support.ReloadableResourceBundleMessageSource;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.aa21b.dao.Aa21b02s01Dao;
import com.ejie.aa21b.dao.ComunDao;
import com.ejie.aa21b.model.Aa21b02s01;
import com.ejie.aa21b.model.Aa21b13s01;
import com.ejie.x38.dto.JQGridRequestDto;
import com.ejie.x38.dto.JQGridResponseDto;
import com.ejie.x38.dto.JerarquiaDto;
import com.ejie.x38.dto.TableRowDto;

/**
 * Aa21b02s01ServiceImpl  
 * 
 *  
 */

@Service(value = "aa21b02s01Service")
public class Aa21b02s01ServiceImpl implements Aa21b02s01Service {

	@Autowired
	private ReloadableResourceBundleMessageSource appMessageSource;

	@Autowired
	private Aa21b02s01Dao aa21b02s01Dao;

	@Autowired
	private ComunDao comunDao;

	/**
	 * Inserts a single row in the Aa21b02s01 table.
	 * 
	 * @param aa21b02s01
	 *            Aa21b02s01
	 * @return Aa21b02s01
	 */
	@Transactional(rollbackFor = Throwable.class)
	public Aa21b02s01 add(Aa21b02s01 aa21b02s01) {
		return this.aa21b02s01Dao.add(aa21b02s01);
	}

	/**
	 * Updates a single row in the Aa21b02s01 table.
	 * 
	 * @param aa21b02s01
	 *            Aa21b02s01
	 * @return Aa21b02s01
	 */
	@Transactional(rollbackFor = Throwable.class)
	public Aa21b02s01 update(Aa21b02s01 aa21b02s01) {
		return this.aa21b02s01Dao.update(aa21b02s01);
	}

	/**
	 * Finds a single row in the Aa21b02s01 table.
	 * 
	 * @param aa21b02s01
	 *            Aa21b02s01
	 * @return Aa21b02s01
	 */
	public Aa21b02s01 find(Aa21b02s01 aa21b02s01) {
		return (Aa21b02s01) this.aa21b02s01Dao.find(aa21b02s01);
	}

	/**
	 * Deletes a single row in the Aa21b02s01 table.
	 * 
	 * @param aa21b02s01
	 *            Aa21b02s01
	 * @throws Exception
	 *             Exception
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void remove(Aa21b02s01 aa21b02s01) throws Exception {
		String mensaje = "etErrorBorrarTipoExpediente";
		try {
			// Comprobamos que no exista ningún Expediente para este
			// departamento
			if (this.aa21b02s01Dao.existeTipoExpExp(aa21b02s01.getCtipoe02(),
					Integer.parseInt(aa21b02s01.getCserv02()))) {
				mensaje = "etExisteExpedienteTipoExpediente";
				throw new Exception();
			} else {
				// Lo borramos
				this.aa21b02s01Dao.remove(aa21b02s01);
			}
		} catch (Exception e) {
			throw new Exception(this.appMessageSource.getMessage(mensaje, null,
					LocaleContextHolder.getLocale()));
		}
	}

	/**
	 * Finds a list of rows in the Aa21b02s01 table.
	 * 
	 * @param aa21b02s01
	 *            Aa21b02s01
	 * @param jqGridRequestDto
	 *            JQGridRequestDto
	 * @return List<Aa21b02s01>
	 */
	public List<Aa21b02s01> findAll(Aa21b02s01 aa21b02s01,
			JQGridRequestDto jqGridRequestDto) {
		return (List<Aa21b02s01>) this.aa21b02s01Dao.findAll(aa21b02s01,
				jqGridRequestDto);
	}

	/**
	 * Finds rows in the Aa21b02s01 table using like.
	 * 
	 * @param aa21b02s01
	 *            Aa21b02s01
	 * @param jqGridRequestDto
	 *            JQGridRequestDto
	 * @param startsWith
	 *            Boolean
	 * @return List<Aa21b02s01>
	 */
	public List<Aa21b02s01> findAllLike(Aa21b02s01 aa21b02s01,
			JQGridRequestDto jqGridRequestDto, Boolean startsWith) {
		return (List<Aa21b02s01>) this.aa21b02s01Dao.findAllLike(aa21b02s01,
				jqGridRequestDto, null, startsWith);
	}

	/*
	 * OPERACIONES RUP_TABLE
	 */

	/**
	 * Removes rows from the Aa21b02s01 table.
	 * 
	 * @param filterAa21b02s01
	 *            Aa21b02s01
	 * @param jqGridRequestDto
	 *            JQGridRequestDto
	 * @param startsWith
	 *            Boolean
	 */
	public void removeMultiple(Aa21b02s01 filterAa21b02s01,
			JQGridRequestDto jqGridRequestDto, Boolean startsWith) {
		this.aa21b02s01Dao.removeMultiple(filterAa21b02s01, jqGridRequestDto,
				startsWith);
	}

	/**
	 * Filter method in the Aa21b02s01 table.
	 * 
	 * @param filterAa21b02s01
	 *            Aa21b02s01
	 * @param jqGridRequestDto
	 *            JQGridRequestDto
	 * @param listaServicios
	 *            List<Aa21b13s01>
	 * @param startsWith
	 *            Boolean
	 * @return JQGridResponseDto<Aa21b02s01>
	 */
	public JQGridResponseDto<Aa21b02s01> filter(Aa21b02s01 filterAa21b02s01,
			JQGridRequestDto jqGridRequestDto, List<Aa21b13s01> listaServicios,
			Boolean startsWith) {
		List<Aa21b02s01> listaAa21b02s01 = this.aa21b02s01Dao.findAllLike(
				filterAa21b02s01, jqGridRequestDto, listaServicios, false);
		Long recordNum = this.aa21b02s01Dao.findAllLikeCount(
				filterAa21b02s01 != null ? filterAa21b02s01 : new Aa21b02s01(),
				listaServicios, false);
		if (jqGridRequestDto.getMultiselection().getSelectedIds() != null) {
			List<TableRowDto<Aa21b02s01>> reorderSelection = this.aa21b02s01Dao
					.reorderSelection(filterAa21b02s01, jqGridRequestDto,
							startsWith);
			return new JQGridResponseDto<Aa21b02s01>(jqGridRequestDto,
					recordNum, listaAa21b02s01, reorderSelection);
		}
		return new JQGridResponseDto<Aa21b02s01>(jqGridRequestDto, recordNum,
				listaAa21b02s01);
	}

	/**
	 * Searches rows in the Aa21b02s01 table.
	 * 
	 * @param filterAa21b02s01
	 *            Aa21b02s01
	 * @param searchAa21b02s01
	 *            Aa21b02s01
	 * @param jqGridRequestDto
	 *            JQGridRequestDto
	 * @param startsWith
	 *            Boolean
	 * @return List<TableRowDto<Aa21b02s01>>
	 */
	public List<TableRowDto<Aa21b02s01>> search(Aa21b02s01 filterAa21b02s01,
			Aa21b02s01 searchAa21b02s01, JQGridRequestDto jqGridRequestDto,
			Boolean startsWith) {
		return this.aa21b02s01Dao.search(filterAa21b02s01, searchAa21b02s01,
				jqGridRequestDto, startsWith);
	}

	/**
	 * Reorder the selection made in Aa21b02s01 table.
	 * 
	 * @param filterAa21b02s01
	 *            Aa21b02s01
	 * @param jqGridRequestDto
	 *            JQGridRequestDto
	 * @param startsWith
	 *            Boolean
	 * @return Object
	 */
	public Object reorderSelection(Aa21b02s01 filterAa21b02s01,
			JQGridRequestDto jqGridRequestDto, Boolean startsWith) {
		return this.aa21b02s01Dao.reorderSelection(filterAa21b02s01,
				jqGridRequestDto, startsWith);
	}

	/*
	 * OPERACIONES RUP_TABLE JERARQUIA
	 */

	/**
	 * Finder method in the hierarchical the Aa21b02s01 table.
	 * 
	 * @param filterAa21b02s01
	 *            Aa21b02s01
	 * @param jqGridRequestDto
	 *            JQGridRequestDto
	 * @param startsWith
	 *            Boolean
	 * @return JQGridResponseDto<JerarquiaDto<Aa21b02s01>>
	 */
	public JQGridResponseDto<JerarquiaDto<Aa21b02s01>> jerarquia(
			Aa21b02s01 filterAa21b02s01, JQGridRequestDto jqGridRequestDto,
			Boolean startsWith) {
		List<JerarquiaDto<Aa21b02s01>> listaAa21b02s01 = this.aa21b02s01Dao
				.findAllLikeJerarquia(filterAa21b02s01, jqGridRequestDto);
		Long recordNum = this.aa21b02s01Dao.findAllLikeCountJerarquia(
				filterAa21b02s01, jqGridRequestDto);
		return new JQGridResponseDto<JerarquiaDto<Aa21b02s01>>(
				jqGridRequestDto, recordNum, listaAa21b02s01);
	}

	/**
	 * Finder method for siblings rows in the hierarchical the Aa21b02s01 table.
	 * 
	 * @param filterAa21b02s01
	 *            Aa21b02s01
	 * @param jqGridRequestDto
	 *            JQGridRequestDto
	 * @return JQGridResponseDto<JerarquiaDto<Aa21b02s01>>
	 */
	public JQGridResponseDto<JerarquiaDto<Aa21b02s01>> jerarquiaChildren(
			Aa21b02s01 filterAa21b02s01, JQGridRequestDto jqGridRequestDto) {
		JQGridResponseDto<JerarquiaDto<Aa21b02s01>> jqGridResponseDto = new JQGridResponseDto<JerarquiaDto<Aa21b02s01>>();
		jqGridResponseDto.addAdditionalParam(JQGridResponseDto.CHILDREN,
				this.aa21b02s01Dao.findAllChild(filterAa21b02s01,
						jqGridRequestDto));
		return jqGridResponseDto;
	}

	@Override
	public List<Aa21b02s01> findTipoExpediente(Aa21b02s01 tipoExpediente,
			Boolean c) {
		// TODO Auto-generated method stub
		return this.aa21b02s01Dao.findTipoExpediente(tipoExpediente, c);
	}

	/**
	 * @param ctipoe02
	 *            String return
	 * @return boolean
	 */
	public boolean bloquear(String ctipoe02) {

		return this.comunDao.bloquear("cserv02||'-'||ctipoe02",
				ctipoe02.toString());
	}

	/**
	 * @param ctipoe02
	 *            String
	 * @return boolean
	 */
	public boolean desbloquear(String ctipoe02) {

		return this.comunDao.desbloquear("cserv02||'-'||ctipoe02",
				ctipoe02.toString());
	}

	/**
	 * Updates a single row in the Aa21b12s01 table.
	 * 
	 * @param aa21b02s01
	 *            Aa21b02s01
	 * @return Aa21b02s01
	 */
	@Transactional(rollbackFor = Throwable.class)
	public Aa21b02s01 updateBloqueos(Aa21b02s01 aa21b02s01) {
		return this.aa21b02s01Dao.updateBloqueos(aa21b02s01);
	}

	/**
	 * Finds a list of rows in the Aa21b02s01 table.
	 * 
	 * @param listaServicios
	 *            List<Aa21b02s01>
	 * @param jqGridRequestDto
	 *            JQGridRequestDto
	 * @return List<Aa21b02s01>
	 */
	public List<Aa21b02s01> findAllComboTiposExpServicio(
			List<Aa21b02s01> listaServicios, JQGridRequestDto jqGridRequestDto) {
		return (List<Aa21b02s01>) this.aa21b02s01Dao
				.findAllComboTiposExpServicio(listaServicios, jqGridRequestDto);
	}

	public List<Aa21b02s01> findAllComboTiposExpServicioConsulta(
			List<Aa21b02s01> listaServicios, JQGridRequestDto jqGridRequestDto) {
		return (List<Aa21b02s01>) this.aa21b02s01Dao
				.findAllComboTiposExpServicioConsulta(listaServicios,
						jqGridRequestDto);
	}

	@Override
	public void compruebaBloqueosServicio(Aa21b02s01 aa21b02s01Aux)
			throws Exception {
		String mensaje = "etErrorComprobandoBloqueosTipoExpediente";
		try {
			// Comprobamos que no exista ningún Expediente para este
			// departamento
			if (this.aa21b02s01Dao.compruebaBloqueosServicio(aa21b02s01Aux)) {
				mensaje = "etExisteBloqueoTipoExpediente";
				this.comunDao
						.desbloquear("cserv13", aa21b02s01Aux.getCserv02());
				throw new Exception();
			}
		} catch (Exception e) {
			throw new Exception(this.appMessageSource.getMessage(mensaje, null,
					LocaleContextHolder.getLocale()));
		}

	}

	@Override
	public void updateEstadosServicio(Aa21b02s01 aa21b02s01Aux) {
		// TODO Auto-generated method stub
		this.aa21b02s01Dao.updateEstadosServicio(aa21b02s01Aux);
	}

	@Override
	public void removeTiposServicio(Aa21b02s01 aa21b02s01) {
		// TODO Auto-generated method stub
		this.aa21b02s01Dao.removeTiposServicio(aa21b02s01);
	}

	@Override
	public JQGridResponseDto<Aa21b02s01> filterJerarTipoExp(
			Aa21b02s01 filterAa21b02s01, JQGridRequestDto jqGridRequestDto,
			boolean startsWith) {
		// TODO Auto-generated method stub
		List<Aa21b02s01> listaAa21b02s01 = this.aa21b02s01Dao
				.findAllLikeJerarTipoExp(filterAa21b02s01, jqGridRequestDto,
						false);

		Long recordNum = this.aa21b02s01Dao.findAllLikeCountJerarTipoExp(
				filterAa21b02s01 != null ? filterAa21b02s01 : new Aa21b02s01(),
				false);

		if (jqGridRequestDto.getMultiselection().getSelectedIds() != null) {
			List<TableRowDto<Aa21b02s01>> reorderSelection = this.aa21b02s01Dao
					.reorderSelection(filterAa21b02s01, jqGridRequestDto,
							startsWith);
			return new JQGridResponseDto<Aa21b02s01>(jqGridRequestDto,
					recordNum, listaAa21b02s01, reorderSelection);
		}
		return new JQGridResponseDto<Aa21b02s01>(jqGridRequestDto, recordNum,
				listaAa21b02s01);
	}
}
