package com.ejie.aa21b.service;

import java.util.List;

import com.ejie.aa21b.model.Aa21b01s01;
import com.ejie.aa21b.model.Aa21b02s01;
import com.ejie.aa21b.model.Aa21b13s01;
import com.ejie.x38.dto.JQGridRequestDto;
import com.ejie.x38.dto.JQGridResponseDto;
import com.ejie.x38.dto.JerarquiaDto;
import com.ejie.x38.dto.TableRowDto;

/**
 * Aa21b01s01Service  
 * 
 *  
 */

public interface Aa21b01s01Service {

	/**
	 * Inserts a single row in the Aa21b01s01 table.
	 * 
	 * @param aa21b01s01
	 *            Aa21b01s01
	 * @return Aa21b01s01
	 */
	Aa21b01s01 add(Aa21b01s01 aa21b01s01);

	/**
	 * Updates a single row in the Aa21b01s01 table.
	 * 
	 * @param aa21b01s01
	 *            Aa21b01s01
	 * @return Aa21b01s01
	 */
	Aa21b01s01 update(Aa21b01s01 aa21b01s01);

	/**
	 * Finds a single row in the Aa21b01s01 table.
	 * 
	 * @param aa21b01s01
	 *            Aa21b01s01
	 * @return Aa21b01s01
	 */
	Aa21b01s01 find(Aa21b01s01 aa21b01s01);

	/**
	 * Deletes a single row in the Aa21b01s01 table.
	 * 
	 * @param aa21b01s01
	 *            Aa21b01s01
	 * @throws Exception
	 *             Exception
	 */
	void remove(Aa21b01s01 aa21b01s01) throws Exception;

	/**
	 * Finds a list of rows in the Aa21b01s01 table.
	 * 
	 * @param aa21b01s01
	 *            Aa21b01s01
	 * @param jqGridRequestDto
	 *            JQGridRequestDto
	 * @return List<Aa21b01s01>
	 */
	List<Aa21b01s01> findAll(Aa21b01s01 aa21b01s01,
			JQGridRequestDto jqGridRequestDto);

	/**
	 * Finds rows in the Aa21b01s01 table using like.
	 * 
	 * @param aa21b01s01
	 *            Aa21b01s01
	 * @param jqGridRequestDto
	 *            JQGridRequestDto
	 * @param startsWith
	 *            Boolean
	 * @return List<Aa21b01s01>
	 */
	List<Aa21b01s01> findAllLike(Aa21b01s01 aa21b01s01,
			JQGridRequestDto jqGridRequestDto, Boolean startsWith);

	/*
	 * OPERACIONES RUP_TABLE
	 */

	/**
	 * Removes rows from the Aa21b01s01 table.
	 * 
	 * @param filterAa21b01s01
	 *            Aa21b01s01
	 * @param jqGridRequestDto
	 *            JQGridRequestDto
	 * @param startsWith
	 *            Boolean
	 */
	void removeMultiple(Aa21b01s01 filterAa21b01s01,
			JQGridRequestDto jqGridRequestDto, Boolean startsWith);

	/**
	 * Filter method in the Aa21b01s01 table.
	 * 
	 * @param filterAa21b01s01
	 *            Aa21b01s01
	 * @param jqGridRequestDto
	 *            JQGridRequestDto
	 * @param listaTiposExpedientes
	 *            List<Aa21b02s01>
	 * @param listaServicios
	 *            List<Aa21b13s01>
	 * @param startsWith
	 *            Boolean
	 * @return JQGridResponseDto<Aa21b01s01>
	 */
	JQGridResponseDto<Aa21b01s01> filter(Aa21b01s01 filterAa21b01s01,
			JQGridRequestDto jqGridRequestDto, List<Aa21b13s01> listaServicios,
			List<Aa21b02s01> listaTiposExpedientes, Boolean startsWith);

	/**
	 * Searches rows in the Aa21b01s01 table.
	 * 
	 * @param filterAa21b01s01
	 *            Aa21b01s01
	 * @param searchAa21b01s01
	 *            Aa21b01s01
	 * @param jqGridRequestDto
	 *            JQGridRequestDto
	 * @param startsWith
	 *            Boolean
	 * @return List<TableRowDto<Aa21b01s01>>
	 */
	List<TableRowDto<Aa21b01s01>> search(Aa21b01s01 filterAa21b01s01,
			Aa21b01s01 searchAa21b01s01, JQGridRequestDto jqGridRequestDto,
			Boolean startsWith);

	/**
	 * Reorder the selection made in Aa21b01s01 table.
	 * 
	 * @param filterAa21b01s01
	 *            Aa21b01s01
	 * @param jqGridRequestDto
	 *            JQGridRequestDto
	 * @param startsWith
	 *            Boolean
	 * @return Object
	 */
	Object reorderSelection(Aa21b01s01 filterAa21b01s01,
			JQGridRequestDto jqGridRequestDto, Boolean startsWith);

	/*
	 * OPERACIONES RUP_TABLE JERARQUIA
	 */

	/**
	 * Finder method in the hierarchical the Aa21b01s01 table.
	 * 
	 * @param filterAa21b01s01
	 *            Aa21b01s01
	 * @param jqGridRequestDto
	 *            JQGridRequestDto
	 * @param startsWith
	 *            Boolean
	 * @return JQGridResponseDto<JerarquiaDto<Aa21b01s01>>
	 */
	JQGridResponseDto<JerarquiaDto<Aa21b01s01>> jerarquia(
			Aa21b01s01 filterAa21b01s01, JQGridRequestDto jqGridRequestDto,
			Boolean startsWith);

	/**
	 * Finder method for siblings rows in the hierarchical the Aa21b01s01 table.
	 * 
	 * @param filterAa21b01s01
	 *            Aa21b01s01
	 * @param jqGridRequestDto
	 *            JQGridRequestDto
	 * @return JQGridResponseDto<JerarquiaDto<Aa21b01s01>>
	 */
	JQGridResponseDto<JerarquiaDto<Aa21b01s01>> jerarquiaChildren(
			Aa21b01s01 filterAa21b01s01, JQGridRequestDto jqGridRequestDto);

	/**
	 * 
	 * @param aa21b01s01
	 *            Aa21b01s01
	 * @return Aa21b01s01
	 */
	Aa21b01s01 updateBloqueos(Aa21b01s01 aa21b01s01);

	/**
	 * 
	 * @param id
	 *            String
	 * @return boolean
	 */
	boolean bloquear(String id);

	/**
	 * 
	 * @param id
	 *            String
	 * @return boolean
	 */
	boolean desbloquear(String id);

	/**
	 * 
	 * @param faseExp
	 *            Aa21b01s01
	 * @param c
	 *            Boolean
	 * @return List<Aa21b01s01>
	 */
	List<Aa21b01s01> findFase(Aa21b01s01 faseExp, Boolean c);

	/**
	 * 
	 * @param aa21b01s01aux
	 *            Aa21b01s01
	 */
	void updateDocumentoFase(Aa21b01s01 aa21b01s01aux);

	/**
	 * 
	 * @param aa21b01s01aux
	 *            Aa21b01s01
	 * @return Aa21b01s01
	 * @throws Exception
	 *             Exception
	 */
	Aa21b01s01 addDocumentoFase(Aa21b01s01 aa21b01s01aux) throws Exception;

	/**
	 * 
	 * @param aa21b01s01Aux
	 *            Aa21b01s01
	 * @throws Exception
	 *             Exception
	 */
	void compruebaBloqueosServicio(Aa21b01s01 aa21b01s01Aux) throws Exception;

	/**
	 * 
	 * @param aa21b01s01Aux
	 *            Aa21b01s01
	 */
	void updateEstadosServicio(Aa21b01s01 aa21b01s01Aux);

	/**
	 * 
	 * @param aa21b01s01
	 *            Aa21b01s01
	 * @return Aa21b01s01
	 */
	Aa21b01s01 findDocumentoFase(Aa21b01s01 aa21b01s01);

	/**
	 * 
	 * @param aa21b01s01
	 *            Aa21b01s01
	 */
	void removeFasesServicio(Aa21b01s01 aa21b01s01);

	public void removeFasesTipoServicio(Aa21b02s01 aa21b02s01);

}
