package com.ejie.aa21b.seguridad;

import javax.servlet.http.HttpServletRequest;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;
import org.springframework.web.context.support.WebApplicationContextUtils;

import com.ejie.aa21b.ldap.SecurityHelpperException;
import com.ejie.aa21b.ldap.SecurityHelpperXLNets;
import com.ejie.aa21b.model.Aa21b15s01;
import com.ejie.aa21b.service.Aa21b15s01Service;

public class Aa21bSeguridad {
	private static final Logger logger = LoggerFactory
			.getLogger(Aa21bSeguridad.class);

	public Aa21bSeguridad() {
	}

	/*
	 * private boolean existeUsuario() { try { HttpServletRequest currentRequest
	 * = ((ServletRequestAttributes) RequestContextHolder
	 * .currentRequestAttributes()).getRequest(); aa00jPersonaSesion miUsuario =
	 * (aa00jPersonaSesion) currentRequest
	 * .getSession().getAttribute("aa00jPersonaSesion"); return (miUsuario !=
	 * null); } catch (Exception e) { return false; } }
	 */

	/*
	 * private void removeUsuario() { try { HttpServletRequest currentRequest =
	 * ((ServletRequestAttributes) RequestContextHolder
	 * .currentRequestAttributes()).getRequest();
	 * currentRequest.getSession().removeAttribute("aa00jPersonaSesion"); }
	 * catch (Exception e) { } }
	 */

	private void setUsuario(Aa21bPersonaSesion miUsuario) {
		try {
			logger.info("función setUsuario (meter el usuario en la sesión "
					+ miUsuario.toString());
			HttpServletRequest currentRequest = ((ServletRequestAttributes) RequestContextHolder
					.currentRequestAttributes()).getRequest();
			currentRequest.getSession().setAttribute("Aa21bPersonaSesion",
					miUsuario);
		} catch (Exception e) {
			logger.error("Error establecer  usuario");
			StackTraceElement[] stackTraceElements = Thread.currentThread()
					.getStackTrace();
			for (StackTraceElement stackTrace : stackTraceElements) {
				logger.error(stackTrace.getClassName() + "  "
						+ stackTrace.getMethodName() + " "
						+ stackTrace.getLineNumber());
			}
		}
	}

	public Aa21bPersonaSesion getUsuario() {
		try {
			logger.info("función getUsuario");
			HttpServletRequest currentRequest = ((ServletRequestAttributes) RequestContextHolder
					.currentRequestAttributes()).getRequest();
			Aa21bPersonaSesion miUsuario = (Aa21bPersonaSesion) currentRequest
					.getSession().getAttribute("Aa21bPersonaSesion");
			logger.info("Cargando usuario de la sesión");
			if (miUsuario == null) {
				logger.info("No existe cargar usuario de XLNETS");
				miUsuario = this.crearUsuarioDeXlnets(currentRequest);
				// leer el de la tabla 15 el usuario interno

				ApplicationContext ctx = WebApplicationContextUtils
						.getWebApplicationContext(currentRequest.getSession()
								.getServletContext());
				// final Aa00j03s01Service aa00j03s01Service = ctx
				// .getBean(Aa00j03s01Service.class);

				final Aa21b15s01Service aa21b15s01Service = ctx
						.getBean(Aa21b15s01Service.class);
				Aa21b15s01 aa21b15s01busqUsuario = new Aa21b15s01();
				aa21b15s01busqUsuario.setUxlnet15(miUsuario.getPersonaXLNET()
						.getCodigo());
				aa21b15s01busqUsuario = aa21b15s01Service
						.findXLNET(aa21b15s01busqUsuario);
				if (aa21b15s01busqUsuario != null) {
					miUsuario.setServicio(aa21b15s01busqUsuario.getCserv15());
					miUsuario.setPersonaAplicacion(aa21b15s01busqUsuario);
				}
				this.setUsuario(miUsuario);
			}
			logger.info("Usuario=" + miUsuario.toString());

			return miUsuario;
		} catch (Exception e) {
			logger.error("Error al obtener usuario");
			StackTraceElement[] stackTraceElements = Thread.currentThread()
					.getStackTrace();
			for (StackTraceElement stackTrace : stackTraceElements) {
				logger.error(stackTrace.getClassName() + "  "
						+ stackTrace.getMethodName() + " "
						+ stackTrace.getLineNumber());
			}
			return null;
		}
	}

	private Aa21bPersonaSesion crearUsuarioDeXlnets(
			HttpServletRequest currentRequest) {
		logger.info("Función crearUsuarioDeXlnets-->Crear usuario desde XLNETS");
		Aa21bPersonaSesion ps = new Aa21bPersonaSesion();

		SecurityHelpperXLNets sh = new SecurityHelpperXLNets();
		try {
			ps.setPersonaXLNET(sh.getPersonasXLNETs(sh.getUsuario(), null,
					null, null, null).get(0));
		} catch (SecurityHelpperException e) {
			logger.error("Error al crear usuario xlnets");
			StackTraceElement[] stackTraceElements = Thread.currentThread()
					.getStackTrace();
			for (StackTraceElement stackTrace : stackTraceElements) {
				logger.error(stackTrace.getClassName() + "  "
						+ stackTrace.getMethodName() + " "
						+ stackTrace.getLineNumber());
			}
		}
		try {
			ps.setEsConsultador(sh.usuarioLogueadoEsConsultor());
		} catch (Exception e) {
			logger.error("Error al obtener si el usuario es consultador");
			StackTraceElement[] stackTraceElements = Thread.currentThread()
					.getStackTrace();
			for (StackTraceElement stackTrace : stackTraceElements) {
				logger.error(stackTrace.getClassName() + "  "
						+ stackTrace.getMethodName() + " "
						+ stackTrace.getLineNumber());
			}
		}
		try {
			ps.setEsAdministrador(sh.usuarioLogueadoEsAdmininstrador());
		} catch (Exception e) {
			logger.error("Error al obtener si el usuario es administrador ");
			StackTraceElement[] stackTraceElements = Thread.currentThread()
					.getStackTrace();
			for (StackTraceElement stackTrace : stackTraceElements) {
				logger.error(stackTrace.getClassName() + "  "
						+ stackTrace.getMethodName() + " "
						+ stackTrace.getLineNumber());
			}
		}
		try {
			ps.setEsTramitador(sh.usuarioLogueadoEsTramitador());
		} catch (Exception e) {
			logger.error("Error al obtener si el usuario es tramitador ");
			StackTraceElement[] stackTraceElements = Thread.currentThread()
					.getStackTrace();
			for (StackTraceElement stackTrace : stackTraceElements) {
				logger.error(stackTrace.getClassName() + "  "
						+ stackTrace.getMethodName() + " "
						+ stackTrace.getLineNumber());
			}
		}
		try {
			ps.setEsDeDireccion(sh.usuarioLogueadoEsDireccion());
		} catch (Exception e) {
			logger.error("Error al obtener si el usuario es tramitador ");
			StackTraceElement[] stackTraceElements = Thread.currentThread()
					.getStackTrace();
			for (StackTraceElement stackTrace : stackTraceElements) {
				logger.error(stackTrace.getClassName() + "  "
						+ stackTrace.getMethodName() + " "
						+ stackTrace.getLineNumber());
			}
		}
		/*
		 * ApplicationContext ctx = WebApplicationContextUtils
		 * .getWebApplicationContext(currentRequest.getSession()
		 * .getServletContext());
		 */

		return ps;
	}
}
