package com.ejie.aa21b.pdf.xml;

import java.text.SimpleDateFormat;
import java.util.List;
import java.util.Locale;

import javax.servlet.http.HttpServletRequest;

import org.apache.log4j.Logger;

import com.ejie.aa21b.model.Aa21b15s01;
import com.ejie.aa21b.util.Aa21bConstantes;
import com.ejie.aa21b.util.Aa21bParametros;

/**
 * Class Aa21bUsuariosXML
 * 
 *  
 * 
 */
public class Aa21bUsuariosXML {

	/**
	 * Method 'Aa21bUsuariosXML'. Constructor vacio
	 */
	private Aa21bUsuariosXML() {
	}

	private static final Logger logger = Logger
			.getLogger(Aa21bUsuariosXML.class);

	/**
	 * Method 'getXml'
	 * 
	 * @param request
	 *            HttpServletRequest
	 * @param listaServices
	 *            List<Object>
	 * @param locale
	 *            Locale
	 * 
	 * @return String
	 * @throws Exception
	 *             Exception
	 */
	@SuppressWarnings("unchecked")
	public static String getXml(HttpServletRequest request,
			List<Object> listaServices, Locale locale) throws Exception {
		logger.info("getXml - Inicio");

		// Obtener la fecha actual
		String fechaObtencion = "";

		try {
			SimpleDateFormat sdf = new SimpleDateFormat("dd-MM-yyyy");
			SimpleDateFormat sdf_eu = new SimpleDateFormat("yyyy-MM-dd");

			if (Aa21bConstantes.AA21B_IDIOMA_EUS.equalsIgnoreCase(locale.getLanguage())) {
				fechaObtencion = sdf_eu.format(new java.util.Date());
			} else {
				fechaObtencion = sdf.format(new java.util.Date());
			}
		} catch (Exception e) {
			fechaObtencion = "";
			logger.error("getXml - Error obteniendo la fecha actual: "
					+ e.toString());
		}

		List<Aa21b15s01> aa21bUsuarios = null;

		// Generar el xml
		StringBuffer datosXML = new StringBuffer("");

		datosXML.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");

		datosXML.append("<servicios>");

		logger.info("getXml - Obtener la ruta de la imagen del logo del encabezado");

		datosXML.append("<imgLogoUrl>"
				+ (Aa21bUsuariosXML.class.getResource(Aa21bParametros
						.getImpreso("pdf.img.logo"))) + "</imgLogoUrl>");

		datosXML.append("<fecha>" + fechaObtencion + "</fecha>");

		logger.info("getXml - Obtener los datos identificativos");

		try {
			if (listaServices.size() != 0) {
				aa21bUsuarios = (List<Aa21b15s01>) listaServices.get(0);
				String cServAnt = "";
				for (int i = 0; i < aa21bUsuarios.size(); i++) {
					Aa21b15s01 tUsuario = (Aa21b15s01) aa21bUsuarios.get(i);

					String cServ = ((tUsuario.getCserv15() == null) ? ""
							: tUsuario.getCserv15());

					if (!cServ.equals(cServAnt)) {
						datosXML.append("<servicio>");
					}

					datosXML.append("<cserv15>"
							+ ((tUsuario.getCserv15() == null) ? "" : tUsuario
									.getCserv15()) + "</cserv15>");

					datosXML.append("<dserv15>"
							+ ((tUsuario.getDserv15() == null) ? "" : tUsuario
									.getDserv15()) + "</dserv15>");

					datosXML.append("<eserv15>"
							+ ((tUsuario.getEserv15() == null) ? "" : tUsuario
									.getEserv15()) + "</eserv15>");

					datosXML.append("<situServ>");
					if (tUsuario.getSituServ() != null
							&& tUsuario.getSituServ().trim().equals("A")) {
						datosXML.append("Alta");
					} else if (tUsuario.getSituServ() != null
							&& tUsuario.getSituServ().trim().equals("B")) {
						datosXML.append("Baja");
					} else {
						datosXML.append(" - ");
					}
					datosXML.append("</situServ>");

					datosXML.append("<usuario>");

					datosXML.append("<cusu15>"
							+ ((tUsuario.getCusu15() == null) ? "" : tUsuario
									.getCusu15()) + "</cusu15>");
					datosXML.append("<dusu15>"
							+ ((tUsuario.getDusu15() == null) ? "" : tUsuario
									.getDusu15()) + "</dusu15>");
					datosXML.append("<cserv15>"
							+ ((tUsuario.getCserv15() == null) ? "" : tUsuario
									.getCserv15()) + "</cserv15>");

					datosXML.append("<situ15>");
					if (tUsuario.getSitu15() != null
							&& tUsuario.getSitu15().trim().equals("A")) {
						datosXML.append("Alta");
					} else if (tUsuario.getSitu15() != null
							&& tUsuario.getSitu15().trim().equals("B")) {
						datosXML.append("Baja");
					} else {
						datosXML.append(" - ");
					}

					datosXML.append("</situ15>");

					datosXML.append("</usuario>");

					if (aa21bUsuarios.size() != (i + 1)) {
						Aa21b15s01 tUsuarioSig = (Aa21b15s01) aa21bUsuarios
								.get(i + 1);

						if (!cServ.equals(tUsuarioSig.getCserv15())) {
							datosXML.append("</servicio>");
						}
					} else {
						datosXML.append("</servicio>");
					}
					cServAnt = cServ;
				}
			}

		} catch (Exception e) {
			logger.error("getXml - Error obteniendo xml: " + e.toString());
		}

		datosXML.append("</servicios>");

		logger.info("getXml - Fin");

		return datosXML.toString().replaceAll("&", "&amp;");
	}
}
