package com.ejie.aa21b.pdf.xml;

import java.text.SimpleDateFormat;
import java.util.List;
import java.util.Locale;

import javax.servlet.http.HttpServletRequest;

import org.apache.log4j.Logger;

import com.ejie.aa21b.model.Aa21b14s01;
import com.ejie.aa21b.util.Aa21bConstantes;
import com.ejie.aa21b.util.Aa21bParametros;

/**
 * 
 *  
 * 
 */
public class Aa21bUbicacionExpedientesXML {

	/**
	 * Method 'Aa21bUbicacionExpedientesXML'. Constructor vacio
	 */
	private Aa21bUbicacionExpedientesXML() {
	}

	private static final Logger logger = Logger
			.getLogger(Aa21bUbicacionExpedientesXML.class);

	/**
	 * Method 'getXml'
	 * 
	 * @param request
	 *            HttpServletRequest
	 * @param listaServices
	 *            List<Object>
	 * @param locale
	 *            Locale
	 * 
	 * @return String
	 * @throws Exception
	 *             Exception
	 */
	@SuppressWarnings("unchecked")
	public static String getXml(HttpServletRequest request,
			List<Object> listaServices, Locale locale) throws Exception {
		logger.info("getXml - Inicio");

		// Obtener la fecha actual
		String fechaObtencion = "";

		try {
			SimpleDateFormat sdf = new SimpleDateFormat("dd-MM-yyyy");
			SimpleDateFormat sdf_eu = new SimpleDateFormat("yyyy-MM-dd");

			if (Aa21bConstantes.AA21B_IDIOMA_EUS.equalsIgnoreCase(locale.getLanguage())) {
				fechaObtencion = sdf_eu.format(new java.util.Date());
			} else {
				fechaObtencion = sdf.format(new java.util.Date());
			}
		} catch (Exception e) {
			fechaObtencion = "";
			logger.error("getXml - Error obteniendo la fecha actual: "
					+ e.toString());
		}

		List<Aa21b14s01> aa21bUbicacionExpedientes = null;

		// Generar el xml
		StringBuffer datosXML = new StringBuffer("");

		datosXML.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");

		datosXML.append("<ubicacionExpedientes>");

		logger.info("getXml - Obtener la ruta de la imagen del logo del encabezado");

		datosXML.append("<imgLogoUrl>"
				+ (Aa21bEstadosExpedientesXML.class.getResource(Aa21bParametros
						.getImpreso("pdf.img.logo"))) + "</imgLogoUrl>");

		datosXML.append("<fecha>" + fechaObtencion + "</fecha>");

		logger.info("getXml - Obtener los datos identificativos");

		try {
			if (listaServices.size() != 0) {
				aa21bUbicacionExpedientes = (List<Aa21b14s01>) listaServices
						.get(0);
				for (int i = 0; i < aa21bUbicacionExpedientes.size(); i++) {
					Aa21b14s01 tUbicacionExp = (Aa21b14s01) aa21bUbicacionExpedientes
							.get(i);

					datosXML.append("<ubicacionExpediente>");

					datosXML.append("<carchi14>"
							+ ((tUbicacionExp.getCarchi14() == null) ? ""
									: tUbicacionExp.getCarchi14())
							+ "</carchi14>");
					datosXML.append("<darchi14>"
							+ ((tUbicacionExp.getDarchi14() == null) ? ""
									: tUbicacionExp.getDarchi14())
							+ "</darchi14>");
					datosXML.append("<earchi14>"
							+ ((tUbicacionExp.getEarchi14() == null) ? ""
									: tUbicacionExp.getEarchi14())
							+ "</earchi14>");
					datosXML.append("<situ14>");

					if (tUbicacionExp.getSitu14() != null
							&& tUbicacionExp.getSitu14().trim().equals("A")) {
						datosXML.append("Alta");
					} else if (tUbicacionExp.getSitu14() != null
							&& tUbicacionExp.getSitu14().trim().equals("B")) {
						datosXML.append("Baja");
					} else {
						datosXML.append(" - ");
					}

					datosXML.append("</situ14>");

					datosXML.append("</ubicacionExpediente>");
				}
			}

		} catch (Exception e) {
			logger.error("getXml - Error obteniendo xml: " + e.toString());
		}

		datosXML.append("</ubicacionExpedientes>");

		logger.info("getXml - Fin");

		return datosXML.toString().replaceAll("&", "&amp;");
	}
}
