package com.ejie.aa21b.pdf.xml;

import java.text.SimpleDateFormat;
import java.util.List;
import java.util.Locale;

import javax.servlet.http.HttpServletRequest;

import org.apache.log4j.Logger;

import com.ejie.aa21b.model.Aa21b05s01;
import com.ejie.aa21b.util.Aa21bConstantes;
import com.ejie.aa21b.util.Aa21bParametros;

/**
 * 
 *  
 * 
 */
public class Aa21bTiposDocumentosXML {

	/**
	 * Method 'Aa21bDepartamentosXML'. Constructor vacio
	 */
	private Aa21bTiposDocumentosXML() {
	}

	private static final Logger logger = Logger
			.getLogger(Aa21bTiposDocumentosXML.class);

	/**
	 * Method 'getXml'
	 * 
	 * @param request
	 *            HttpServletRequest
	 * @param listaServices
	 *            List<Object>
	 * @param locale
	 *            Locale
	 * 
	 * @return String
	 * @throws Exception
	 *             Exception
	 */
	@SuppressWarnings("unchecked")
	public static String getXml(HttpServletRequest request,
			List<Object> listaServices, Locale locale) throws Exception {
		logger.info("getXml - Inicio");

		// Obtener la fecha actual
		String fechaObtencion = "";

		try {
			SimpleDateFormat sdf = new SimpleDateFormat("dd-MM-yyyy");
			SimpleDateFormat sdf_eu = new SimpleDateFormat("yyyy-MM-dd");

			if (Aa21bConstantes.AA21B_IDIOMA_EUS.equalsIgnoreCase(locale.getLanguage())) {
				fechaObtencion = sdf_eu.format(new java.util.Date());
			} else {
				fechaObtencion = sdf.format(new java.util.Date());
			}
		} catch (Exception e) {
			fechaObtencion = "";
			logger.error("getXml - Error obteniendo la fecha actual: "
					+ e.toString());
		}

		List<Aa21b05s01> aa21bTiposDocumentos = null;

		// Generar el xml
		StringBuffer datosXML = new StringBuffer("");

		datosXML.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");

		datosXML.append("<tiposDocumentos>");

		logger.info("getXml - Obtener la ruta de la imagen del logo del encabezado");

		datosXML.append("<imgLogoUrl>"
				+ (Aa21bTiposDocumentosXML.class.getResource(Aa21bParametros
						.getImpreso("pdf.img.logo"))) + "</imgLogoUrl>");

		datosXML.append("<fecha>" + fechaObtencion + "</fecha>");

		logger.info("getXml - Obtener los datos identificativos");

		try {
			if (listaServices.size() != 0) {
				aa21bTiposDocumentos = (List<Aa21b05s01>) listaServices.get(0);
				for (int i = 0; i < aa21bTiposDocumentos.size(); i++) {
					Aa21b05s01 tTipoDocumento = (Aa21b05s01) aa21bTiposDocumentos
							.get(i);

					datosXML.append("<tipoDocumento>");

					datosXML.append("<cdocu05>"
							+ ((tTipoDocumento.getCdocu05() == null) ? ""
									: tTipoDocumento.getCdocu05())
							+ "</cdocu05>");
					datosXML.append("<ddocu05>"
							+ ((tTipoDocumento.getDdocu05() == null) ? ""
									: tTipoDocumento.getDdocu05())
							+ "</ddocu05>");
					datosXML.append("<edocu05>"
							+ ((tTipoDocumento.getEdocu05() == null) ? ""
									: tTipoDocumento.getEdocu05())
							+ "</edocu05>");
					datosXML.append("<situ05>");

					if (tTipoDocumento.getSitu05() != null
							&& tTipoDocumento.getSitu05().trim().equals("A")) {
						datosXML.append("Alta");
					} else if (tTipoDocumento.getSitu05() != null
							&& tTipoDocumento.getSitu05().trim().equals("B")) {
						datosXML.append("Baja");
					} else {
						datosXML.append(" - ");
					}

					datosXML.append("</situ05>");

					datosXML.append("</tipoDocumento>");
				}
			}

		} catch (Exception e) {
			logger.error("getXml - Error obteniendo xml: " + e.toString());
		}

		datosXML.append("</tiposDocumentos>");

		logger.info("getXml - Fin");

		return datosXML.toString().replaceAll("&", "&amp;");
	}
}
