package com.ejie.aa21b.pdf.xml;

import java.text.SimpleDateFormat;
import java.util.List;
import java.util.Locale;

import javax.servlet.http.HttpServletRequest;

import org.apache.log4j.Logger;

import com.ejie.aa21b.model.Aa21bServiciosTiposFases;
import com.ejie.aa21b.util.Aa21bConstantes;
import com.ejie.aa21b.util.Aa21bParametros;

/**
 * Class Aa21bResponsablesXML
 * 
 *  
 * 
 */
public class Aa21bServiciosTiposFasesXML {

	/**
	 * Method 'Aa21bResponsablesXML'. Constructor vacio
	 */
	private Aa21bServiciosTiposFasesXML() {
	}

	private static final Logger logger = Logger
			.getLogger(Aa21bServiciosTiposFasesXML.class);

	/**
	 * Method 'getXml'
	 * 
	 * @param request
	 *            HttpServletRequest
	 * @param listaServices
	 *            List<Object>
	 * @param locale
	 *            Locale
	 * 
	 * @return String
	 * @throws Exception
	 *             Exception
	 */
	@SuppressWarnings("unchecked")
	public static String getXml(HttpServletRequest request,
			List<Object> listaServices, Locale locale) throws Exception {
		logger.info("getXml - Inicio");

		// Obtener la fecha actual
		String fechaObtencion = "";

		try {
			SimpleDateFormat sdf = new SimpleDateFormat("dd-MM-yyyy");
			SimpleDateFormat sdf_eu = new SimpleDateFormat("yyyy-MM-dd");

			if (Aa21bConstantes.AA21B_IDIOMA_EUS.equalsIgnoreCase(locale.getLanguage())) {
				fechaObtencion = sdf_eu.format(new java.util.Date());
			} else {
				fechaObtencion = sdf.format(new java.util.Date());
			}
		} catch (Exception e) {
			fechaObtencion = "";
			logger.error("getXml - Error obteniendo la fecha actual: "
					+ e.toString());
		}

		List<Aa21bServiciosTiposFases> aa21bServiciosTiposFases = null;

		// Generar el xml
		StringBuffer datosXML = new StringBuffer("");

		datosXML.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");

		datosXML.append("<servicios>");

		logger.info("getXml - Obtener la ruta de la imagen del logo del encabezado");

		datosXML.append("<imgLogoUrl>"
				+ (Aa21bServiciosTiposFasesXML.class
						.getResource(Aa21bParametros.getImpreso("pdf.img.logo")))
				+ "</imgLogoUrl>");

		datosXML.append("<fecha>" + fechaObtencion + "</fecha>");

		logger.info("getXml - Obtener los datos identificativos");

		try {
			if (listaServices.size() != 0) {
				aa21bServiciosTiposFases = (List<Aa21bServiciosTiposFases>) listaServices
						.get(0);
				String cServAnt = "";
				for (int i = 0; i < aa21bServiciosTiposFases.size(); i++) {
					Aa21bServiciosTiposFases tServiciosTiposFases = (Aa21bServiciosTiposFases) aa21bServiciosTiposFases
							.get(i);

					String cServ = ((tServiciosTiposFases.getCServ13() == null) ? ""
							: tServiciosTiposFases.getCServ13());

					if (!cServ.equals(cServAnt)) {
						datosXML.append("<servicio>");
					}

					datosXML.append("<cserv13>"
							+ ((tServiciosTiposFases.getCServ13() == null) ? ""
									: tServiciosTiposFases.getCServ13())
							+ "</cserv13>");

					datosXML.append("<dserv13>"
							+ ((tServiciosTiposFases.getDServ13() == null) ? ""
									: tServiciosTiposFases.getDServ13())
							+ "</dserv13>");

					datosXML.append("<eserv13>"
							+ ((tServiciosTiposFases.getEServ13() == null) ? ""
									: tServiciosTiposFases.getEServ13())
							+ "</eserv13>");

					datosXML.append("<situ13>");
					if (tServiciosTiposFases.getSitu13() != null
							&& tServiciosTiposFases.getSitu13().trim()
									.equals("A")) {
						datosXML.append("Alta");
					} else if (tServiciosTiposFases.getSitu13() != null
							&& tServiciosTiposFases.getSitu13().trim()
									.equals("B")) {
						datosXML.append("Baja");
					} else {
						datosXML.append(" - ");
					}
					datosXML.append("</situ13>");

					datosXML.append("<registro>");

					datosXML.append("<ctipoe02>"
							+ ((tServiciosTiposFases.getCtipoe02() == null) ? ""
									: tServiciosTiposFases.getCtipoe02())
							+ "</ctipoe02>");

					datosXML.append("<dtipoe02>"
							+ ((tServiciosTiposFases.getDtipoe02() == null) ? ""
									: tServiciosTiposFases.getDtipoe02())
							+ "</dtipoe02>");

					datosXML.append("<etipoe02>"
							+ ((tServiciosTiposFases.getEtipoe02() == null) ? ""
									: tServiciosTiposFases.getEtipoe02())
							+ "</etipoe02>");

					datosXML.append("<ctrami02>");
					if (tServiciosTiposFases.getCtrami02() != null
							&& tServiciosTiposFases.getCtrami02().equals("1")) {
						if (Aa21bConstantes.AA21B_IDIOMA_EUS.equalsIgnoreCase(locale
								.getLanguage())) {
							datosXML.append("Bai");
						} else {
							datosXML.append("Sí");
						}
					} else if (tServiciosTiposFases.getCtrami02() != null
							&& tServiciosTiposFases.getCtrami02().equals("2")) {
						if (Aa21bConstantes.AA21B_IDIOMA_EUS.equalsIgnoreCase(locale
								.getLanguage())) {
							datosXML.append("Ez");
						} else {
							datosXML.append("No");
						}
					}
					datosXML.append("</ctrami02>");

					datosXML.append("<situ02>");
					if (tServiciosTiposFases.getSitu02() != null
							&& tServiciosTiposFases.getSitu02().equals("A")) {
						if (Aa21bConstantes.AA21B_IDIOMA_EUS.equalsIgnoreCase(locale
								.getLanguage())) {
							datosXML.append("Alta");
						} else {
							datosXML.append("Alta");
						}
					} else if (tServiciosTiposFases.getSitu02() != null
							&& tServiciosTiposFases.getSitu02().equals("B")) {
						if (Aa21bConstantes.AA21B_IDIOMA_EUS.equalsIgnoreCase(locale
								.getLanguage())) {
							datosXML.append("Baja");
						} else {
							datosXML.append("Baja");
						}
					}
					datosXML.append("</situ02>");

					datosXML.append("<cfase01>"
							+ ((tServiciosTiposFases.getCfase01() == null) ? ""
									: tServiciosTiposFases.getCfase01())
							+ "</cfase01>");

					datosXML.append("<dfase01>"
							+ ((tServiciosTiposFases.getDfase01() == null) ? ""
									: tServiciosTiposFases.getDfase01())
							+ "</dfase01>");

					datosXML.append("<efase01>"
							+ ((tServiciosTiposFases.getEfase01() == null) ? ""
									: tServiciosTiposFases.getEfase01())
							+ "</efase01>");

					datosXML.append("<situ01>");
					if (tServiciosTiposFases.getSitu01() != null
							&& tServiciosTiposFases.getSitu01().equals("A")) {
						if (Aa21bConstantes.AA21B_IDIOMA_EUS.equalsIgnoreCase(locale
								.getLanguage())) {
							datosXML.append("Alta");
						} else {
							datosXML.append("Alta");
						}
					} else if (tServiciosTiposFases.getSitu01() != null
							&& tServiciosTiposFases.getSitu01().equals("B")) {
						if (Aa21bConstantes.AA21B_IDIOMA_EUS.equalsIgnoreCase(locale
								.getLanguage())) {
							datosXML.append("Baja");
						} else {
							datosXML.append("Baja");
						}
					}
					datosXML.append("</situ01>");

					datosXML.append("</registro>");

					if (aa21bServiciosTiposFases.size() != (i + 1)) {
						Aa21bServiciosTiposFases tServicioTipoFaseSig = (Aa21bServiciosTiposFases) aa21bServiciosTiposFases
								.get(i + 1);

						if (!cServ.equals(tServicioTipoFaseSig.getCServ13())) {
							datosXML.append("</servicio>");
						}
					} else {
						datosXML.append("</servicio>");
					}
					cServAnt = cServ;
				}
			}

		} catch (Exception e) {
			logger.error("getXml - Error obteniendo xml: " + e.toString());
		}

		datosXML.append("</servicios>");

		logger.info("getXml - Fin");

		return datosXML.toString().replaceAll("&", "&amp;");
	}
}
