package com.ejie.aa21b.pdf.xml;

import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.List;
import java.util.Locale;

import javax.servlet.http.HttpServletRequest;

import org.apache.log4j.Logger;

import com.ejie.aa21b.model.Aa21b20s01Consultas;
import com.ejie.aa21b.util.Aa21bConstantes;
import com.ejie.aa21b.util.Aa21bParametros;

/**
 * Class Aa21bListadosExpedientesXML
 * 
 *  
 * 
 */
public class Aa21bListadosExpedientesXML {

	/**
	 * Method 'Aa21bResponsablesXML'. Constructor vacio
	 */
	private Aa21bListadosExpedientesXML() {
	}

	private static final Logger logger = Logger
			.getLogger(Aa21bListadosExpedientesXML.class);

	/**
	 * Method 'getXml'
	 * 
	 * @param request
	 *            HttpServletRequest
	 * @param listaServices
	 *            List<Object>
	 * @param locale
	 *            Locale
	 * 
	 * @return String
	 * @throws Exception
	 *             Exception
	 */
	@SuppressWarnings("unchecked")
	public static String getXml(HttpServletRequest request,
			List<Object> listaServices, Locale locale) throws Exception {
		logger.info("getXml - Inicio");

		// Obtener la fecha actual
		String fechaObtencion = "";

		try {
			SimpleDateFormat sdf = new SimpleDateFormat("dd-MM-yyyy");
			SimpleDateFormat sdf_eu = new SimpleDateFormat("yyyy-MM-dd");

			if (Aa21bConstantes.AA21B_IDIOMA_EUS.equalsIgnoreCase(locale.getLanguage())) {
				fechaObtencion = sdf_eu.format(new java.util.Date());
			} else {
				fechaObtencion = sdf.format(new java.util.Date());
			}
		} catch (Exception e) {
			fechaObtencion = "";
			logger.error("getXml - Error obteniendo la fecha actual: "
					+ e.toString());
		}

		List<Aa21b20s01Consultas> aa21bExpedientes = null;

		List<String> listaFiltrados = null;

		// Generar el xml
		StringBuffer datosXML = new StringBuffer("");

		datosXML.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");

		datosXML.append("<expedientes>");

		logger.info("getXml - Obtener la ruta de la imagen del logo del encabezado");

		datosXML.append("<imgLogoUrl>"
				+ (Aa21bServiciosTiposFasesXML.class
						.getResource(Aa21bParametros.getImpreso("pdf.img.logo")))
				+ "</imgLogoUrl>");

		datosXML.append("<fecha>" + fechaObtencion + "</fecha>");

		logger.info("getXml - Obtener los datos identificativos");

		try {
			if (listaServices.size() != 0) {
				aa21bExpedientes = (List<Aa21b20s01Consultas>) listaServices
						.get(0);
				listaFiltrados = (List<String>) listaServices.get(1);
				String cServAnt = "";
				int contador = 1;
				for (int i = 0; i < aa21bExpedientes.size(); i++) {
					Aa21b20s01Consultas tExpediente = (Aa21b20s01Consultas) aa21bExpedientes
							.get(i);

					String cServ = ((tExpediente.getCserv20().toString() == null) ? ""
							: tExpediente.getCserv20().toString());

					if (!cServ.equals(cServAnt)) {
						contador = 1;
						datosXML.append("<servicio>");

						datosXML.append("<filtros>");
						for (int z = 0; z < listaFiltrados.size(); z++) {
							datosXML.append("<filtro>");
							datosXML.append("<valorFiltro>"
									+ listaFiltrados.get(z) + "</valorFiltro>");
							datosXML.append("</filtro>");
						}

						datosXML.append("</filtros>");

					}

					datosXML.append("<cserv20>"
							+ ((tExpediente.getCserv20().toString() == null) ? ""
									: tExpediente.getCserv20()) + "</cserv20>");

					datosXML.append("<dserv20>"
							+ ((tExpediente.getDserv20() == null) ? ""
									: tExpediente.getDserv20()) + "</dserv20>");

					datosXML.append("<eserv20>"
							+ ((tExpediente.getEserv20() == null) ? ""
									: tExpediente.getEserv20()) + "</eserv20>");

					datosXML.append("<expediente>");

					datosXML.append("<contador>" + contador + "</contador>");

					datosXML.append("<refExp>"
							+ ((tExpediente.getRefExp() == null) ? ""
									: tExpediente.getRefExp()) + "</refExp>");

					datosXML.append("<objeto>"
							+ ((tExpediente.getObjeto20() == null) ? ""
									: tExpediente.getObjeto20()) + "</objeto>");

					String fechaApertura = "";
					String fechaCierre = "";
					try {
						SimpleDateFormat sdf = new SimpleDateFormat(
								"dd-MM-yyyy");
						SimpleDateFormat sdf_eu = new SimpleDateFormat(
								"yyyy-MM-dd");

						if (Aa21bConstantes.AA21B_IDIOMA_EUS.equalsIgnoreCase(locale
								.getLanguage())) {
							fechaApertura = sdf_eu.format(tExpediente
									.getFaper20());
							fechaCierre = sdf_eu.format(tExpediente
									.getFcier20());
						} else {
							fechaApertura = sdf
									.format(tExpediente.getFaper20());
							fechaCierre = sdf.format(tExpediente.getFcier20());
						}
					} catch (Exception e) {
						logger.error("getXml - Error formateando fecha de apertura y cierre : "
								+ e.toString());
					}

					datosXML.append("<faper>" + fechaApertura + "</faper>");

					datosXML.append("<fcier>" + fechaCierre + "</fcier>");

					String importeExp = "";
					String importeAdj = "";
					DecimalFormat _decimalFormat = new DecimalFormat(
							"###,###.####");
					if (tExpediente.getEimpor20() != null) {
						importeExp = _decimalFormat.format(tExpediente
								.getEimpor20());
					}
					datosXML.append("<importeExp>" + importeExp
							+ "</importeExp>");

					if (tExpediente.getEimpora20() != null) {
						importeAdj = _decimalFormat.format(tExpediente
								.getEimpora20());
					}
					datosXML.append("<importeAdj>" + importeAdj
							+ "</importeAdj>");

					datosXML.append("</expediente>");

					if (aa21bExpedientes.size() != (i + 1)) {
						Aa21b20s01Consultas tExpedienteSig = (Aa21b20s01Consultas) aa21bExpedientes
								.get(i + 1);

						if (!cServ.equals(tExpedienteSig.getCserv20()
								.toString())) {
							datosXML.append("</servicio>");
						}
					} else {
						datosXML.append("</servicio>");
					}
					cServAnt = cServ;
					contador++;
				}
			}

		} catch (Exception e) {
			logger.error("getXml - Error obteniendo xml: " + e.toString());
		}

		datosXML.append("</expedientes>");

		logger.info("getXml - Fin");

		return datosXML.toString().replaceAll("&", "&amp;");
	}
}
