package com.ejie.aa21b.pdf.xml;

import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.SimpleDateFormat;
import java.util.List;
import java.util.Locale;

import javax.servlet.http.HttpServletRequest;

import org.apache.log4j.Logger;

import com.ejie.aa21b.model.Aa21b12s01;
import com.ejie.aa21b.model.Aa21b13s01;
import com.ejie.aa21b.model.Aa21b14s01;
import com.ejie.aa21b.model.Aa21b15s01;
import com.ejie.aa21b.model.Aa21b20s01;
import com.ejie.aa21b.model.Aa21b21s01;
import com.ejie.aa21b.model.Aa21b25s01;
import com.ejie.aa21b.model.Aa21b29s01;
import com.ejie.aa21b.model.NoraMunicipio;
import com.ejie.aa21b.model.NoraProvincia;
import com.ejie.aa21b.util.Aa21bConstantes;
import com.ejie.aa21b.util.Aa21bParametros;

/**
 * 
 *  
 * 
 */
public class Aa21bExpedienteDetalleXML {

	/**
	 * Method 'Aa21bExpedienteDetalleXML'. Constructor vacio
	 */
	private Aa21bExpedienteDetalleXML() {
	}

	private static final Logger logger = Logger
			.getLogger(Aa21bExpedienteDetalleXML.class);

	/**
	 * Method 'getXml'
	 * 
	 * @param request
	 *            HttpServletRequest
	 * @param listaServices
	 *            List<Object>
	 * @param locale
	 *            Locale
	 * 
	 * @return String
	 * @throws Exception
	 *             Exception
	 */
	@SuppressWarnings("unchecked")
	public static String getXml(HttpServletRequest request,
			List<Object> listaServices, Locale locale) throws Exception {
		logger.info("getXml - Inicio");

		// Obtener la fecha actual
		String fechaObtencion = "";

		try {
			SimpleDateFormat sdf = new SimpleDateFormat("dd-MM-yyyy");
			SimpleDateFormat sdf_eu = new SimpleDateFormat("yyyy-MM-dd");

			if (Aa21bConstantes.AA21B_IDIOMA_EUS.equalsIgnoreCase(locale
					.getLanguage())) {
				fechaObtencion = sdf_eu.format(new java.util.Date());
			} else {
				fechaObtencion = sdf.format(new java.util.Date());
			}
		} catch (Exception e) {
			fechaObtencion = "";
			logger.error("getXml - Error obteniendo la fecha actual: "
					+ e.toString());
		}

		Aa21b20s01 aa21bExpedienteDetalle = new Aa21b20s01();
		List<Aa21b21s01> fasesExpDetalleServices = null;
		List<Aa21b29s01> respExpDetalleServices = null;
		List<Aa21b25s01> documentosExpDetalleServices = null;
		List<Aa21b20s01> listaExpAsociadosServices = null;
		NoraMunicipio municipio = new NoraMunicipio();
		NoraProvincia provincia = new NoraProvincia();
		Aa21b15s01 responsable = new Aa21b15s01();
		Aa21b13s01 servicio = new Aa21b13s01();
		Aa21b14s01 ubicacion = new Aa21b14s01();
		Aa21b12s01 departamento = new Aa21b12s01();

		// Generar el xml
		StringBuffer datosXML = new StringBuffer("");

		datosXML.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");

		datosXML.append("<expediente>");

		logger.info("getXml - Obtener la ruta de la imagen del logo del encabezado");

		datosXML.append("<imgLogoUrl>"
				+ (Aa21bExpedienteDetalleXML.class.getResource(Aa21bParametros
						.getImpreso("pdf.img.logo"))) + "</imgLogoUrl>");

		datosXML.append("<fecha>" + fechaObtencion + "</fecha>");

		logger.info("getXml - Obtener los datos identificativos");

		try {
			if (listaServices.size() != 0) {
				aa21bExpedienteDetalle = (Aa21b20s01) listaServices.get(0);

				documentosExpDetalleServices = (List<Aa21b25s01>) listaServices
						.get(1);

				listaExpAsociadosServices = (List<Aa21b20s01>) listaServices
						.get(2);

				if (listaServices.get(3) != null) {
					provincia = (NoraProvincia) ((List<NoraProvincia>) listaServices
							.get(3)).get(0);
				}

				if (listaServices.get(4) != null) {
					municipio = (NoraMunicipio) ((List<NoraMunicipio>) listaServices
							.get(4)).get(0);
				}
				if (listaServices.get(5) != null) {
					responsable = (Aa21b15s01) ((List<Aa21b15s01>) listaServices
							.get(5)).get(0);
				}

				if (listaServices.get(6) != null) {
					servicio = (Aa21b13s01) ((List<Aa21b13s01>) listaServices
							.get(6)).get(0);
				}

				if (listaServices.get(7) != null) {
					ubicacion = (Aa21b14s01) ((List<Aa21b14s01>) listaServices
							.get(7)).get(0);
				}

				if (listaServices.get(8) != null) {
					fasesExpDetalleServices = (List<Aa21b21s01>) listaServices
							.get(8);
				}
				if (listaServices.get(9) != null) {
					respExpDetalleServices = (List<Aa21b29s01>) listaServices
							.get(9);
				}
				if (listaServices.get(10) != null) {
					departamento = (Aa21b12s01) ((List<Aa21b12s01>) listaServices
							.get(10)).get(0);
				}

				// datosXML.append("<estadoExpediente>");

				datosXML.append("<refExp>"
						+ ((aa21bExpedienteDetalle.getRefExp() == null) ? ""
								: aa21bExpedienteDetalle.getRefExp())
						+ "</refExp>");

				datosXML.append("<objeto>"
						+ ((aa21bExpedienteDetalle.getObjeto20() == null) ? ""
								: aa21bExpedienteDetalle.getObjeto20())
						+ "</objeto>");

				datosXML.append("<departamentoCas>"
						+ ((departamento.getDDepar12() == null) ? ""
								: departamento.getDDepar12())
						+ "</departamentoCas>");

				datosXML.append("<departamentoEusk>"
						+ ((departamento.getEDepar12() == null) ? ""
								: departamento.getEDepar12())
						+ "</departamentoEusk>");

				datosXML.append("<provincia>"
						+ ((aa21bExpedienteDetalle.getCprov20() == null) ? ""
								: aa21bExpedienteDetalle.getCprov20())
						+ "</provincia>");

				datosXML.append("<desProvincia>"
						+ ((provincia.getDsO() == null) ? "" : provincia
								.getDsO()) + "</desProvincia>");

				datosXML.append("<municipio>"
						+ ((aa21bExpedienteDetalle.getCmuni20() == null) ? ""
								: aa21bExpedienteDetalle.getCmuni20())
						+ "</municipio>");

				datosXML.append("<desMunicipio>"
						+ ((municipio.getDsO() == null) ? "" : municipio
								.getDsO()) + "</desMunicipio>");

				// Situación

				datosXML.append("<responsable>"
						+ ((aa21bExpedienteDetalle.getCrespo20() == null) ? ""
								: aa21bExpedienteDetalle.getCrespo20())
						+ "</responsable>");

				datosXML.append("<desResponsable>"
						+ ((responsable.getDusu15() == null) ? "" : responsable
								.getDusu15()) + "</desResponsable>");

				datosXML.append("<servicio>"
						+ ((aa21bExpedienteDetalle.getCserv20() == null) ? ""
								: aa21bExpedienteDetalle.getCserv20())
						+ "</servicio>");

				datosXML.append("<desServicioCas>"
						+ ((servicio.getDServ13() == null) ? "" : servicio
								.getDServ13()) + "</desServicioCas>");

				datosXML.append("<desServicioEusk>"
						+ ((servicio.getEServ13() == null) ? "" : servicio
								.getEServ13()) + "</desServicioEusk>");

				String fechaApertura = "";
				String fechaCierre = "";
				try {
					SimpleDateFormat sdf = new SimpleDateFormat("dd-MM-yyyy");
					SimpleDateFormat sdf_eu = new SimpleDateFormat("yyyy-MM-dd");

					if (Aa21bConstantes.AA21B_IDIOMA_EUS
							.equalsIgnoreCase(locale.getLanguage())) {
						fechaApertura = sdf_eu.format(aa21bExpedienteDetalle
								.getFaper20());
						fechaCierre = sdf_eu.format(aa21bExpedienteDetalle
								.getFcier20());
					} else {
						fechaApertura = sdf.format(aa21bExpedienteDetalle
								.getFaper20());
						fechaCierre = sdf.format(aa21bExpedienteDetalle
								.getFcier20());
					}
				} catch (Exception e) {
					logger.error("getXml - Error formateando fecha de apertura y cierre : "
							+ e.toString());
				}

				datosXML.append("<faper>" + fechaApertura + "</faper>");

				datosXML.append("<fcier>" + fechaCierre + "</fcier>");

				datosXML.append("<estado>"
						+ ((aa21bExpedienteDetalle.getCesta20() == null) ? ""
								: aa21bExpedienteDetalle.getCesta20())
						+ "</estado>");

				datosXML.append("<estadoCas>"
						+ ((aa21bExpedienteDetalle.getDesta() == null) ? ""
								: aa21bExpedienteDetalle.getDesta())
						+ "</estadoCas>");

				datosXML.append("<estadoEusk>"
						+ ((aa21bExpedienteDetalle.getEesta() == null) ? ""
								: aa21bExpedienteDetalle.getEesta())
						+ "</estadoEusk>");

				datosXML.append("<archivo>"
						+ ((aa21bExpedienteDetalle.getCarchi20() == null) ? ""
								: aa21bExpedienteDetalle.getCarchi20())
						+ "</archivo>");

				datosXML.append("<desArchivoCas>"
						+ ((ubicacion.getDarchi14() == null) ? "" : ubicacion
								.getDarchi14()) + "</desArchivoCas>");

				datosXML.append("<desArchivoEusk>"
						+ ((ubicacion.getEarchi14() == null) ? "" : ubicacion
								.getEarchi14()) + "</desArchivoEusk>");

				datosXML.append("<signatura>"
						+ ((aa21bExpedienteDetalle.getUbica20() == null) ? ""
								: aa21bExpedienteDetalle.getUbica20())
						+ "</signatura>");

				// Otros datos
				DecimalFormatSymbols simbolos = DecimalFormatSymbols
						.getInstance(Locale.GERMAN);
				DecimalFormat df = new DecimalFormat("###,###.####", simbolos);

				datosXML.append("<importeExp>");
				if (aa21bExpedienteDetalle.getEimpor20() != null) {
					BigDecimal importe1 = aa21bExpedienteDetalle.getEimpor20();
					importe1 = importe1.setScale(2, BigDecimal.ROUND_HALF_EVEN);
					String importe1formateado = df.format(importe1);
					datosXML.append(importe1formateado);
				}
				datosXML.append("</importeExp>");

				datosXML.append("<importeAdj>");
				if (aa21bExpedienteDetalle.getEimpora20() != null) {
					BigDecimal importe2 = aa21bExpedienteDetalle.getEimpora20();
					importe2 = importe2.setScale(2, BigDecimal.ROUND_HALF_EVEN);
					String importe2formateado = df.format(importe2);
					datosXML.append(importe2formateado);
				}
				datosXML.append("</importeAdj>");

				datosXML.append("<observaciones>"
						+ ((aa21bExpedienteDetalle.getObser20() == null) ? ""
								: aa21bExpedienteDetalle.getObser20())
						+ "</observaciones>");

				datosXML.append("<referencia>"
						+ ((aa21bExpedienteDetalle.getRefer20() == null) ? ""
								: aa21bExpedienteDetalle.getRefer20())
						+ "</referencia>");

				datosXML.append("<tieneFases>");
				if (fasesExpDetalleServices.size() > 0) {
					datosXML.append("si");
				} else {
					datosXML.append("no");
				}
				datosXML.append("</tieneFases>");

				datosXML.append("<fasesExp>");
				for (int y = 0; y < fasesExpDetalleServices.size(); y++) {
					Aa21b21s01 aa21bFaseExpDetalle = (Aa21b21s01) fasesExpDetalleServices
							.get(y);
					datosXML.append("<fase>");
					datosXML.append("<descFaseCas>"
							+ ((aa21bFaseExpDetalle.getDfase21() == null) ? ""
									: aa21bFaseExpDetalle.getDfase21())
							+ "</descFaseCas>");

					datosXML.append("<descFaseEusk>"
							+ ((aa21bFaseExpDetalle.getEfase21() == null) ? ""
									: aa21bFaseExpDetalle.getEfase21())
							+ "</descFaseEusk>");

					String fechaPrevista = "";
					String fechaReal = "";
					try {
						SimpleDateFormat sdf = new SimpleDateFormat(
								"dd-MM-yyyy");
						SimpleDateFormat sdf_eu = new SimpleDateFormat(
								"yyyy-MM-dd");

						if (Aa21bConstantes.AA21B_IDIOMA_EUS
								.equalsIgnoreCase(locale.getLanguage())) {
							fechaPrevista = sdf_eu.format(aa21bFaseExpDetalle
									.getFprevi21());

							fechaReal = sdf_eu.format(aa21bFaseExpDetalle
									.getFreal21());

						} else {
							fechaPrevista = sdf.format(aa21bFaseExpDetalle
									.getFprevi21());

							fechaReal = sdf.format(aa21bFaseExpDetalle
									.getFreal21());

						}
					} catch (Exception e) {
						logger.error("getXml - Error formateando fecha de apertura y cierre : "
								+ e.toString());
					}

					datosXML.append("<fecPrevi>" + fechaPrevista
							+ "</fecPrevi>");

					datosXML.append("<fecReal>" + fechaReal + "</fecReal>");

					datosXML.append("</fase>");
				}
				datosXML.append("</fasesExp>");

				datosXML.append("<tieneDocs>");
				if (documentosExpDetalleServices.size() > 0) {
					datosXML.append("si");
				} else {
					datosXML.append("no");
				}
				datosXML.append("</tieneDocs>");

				datosXML.append("<documentosExp>");
				// Documentos Expediente
				for (int z = 0; z < documentosExpDetalleServices.size(); z++) {
					Aa21b25s01 aa21bDocumentosExpDetalle = (Aa21b25s01) documentosExpDetalleServices
							.get(z);
					datosXML.append("<documento>");

					datosXML.append("<codDocumento>"
							+ ((aa21bDocumentosExpDetalle.getCdocu25() == null) ? ""
									: aa21bDocumentosExpDetalle.getCdocu25())
							+ "</codDocumento>");

					datosXML.append("<descripcionCas>"
							+ ((aa21bDocumentosExpDetalle.getDdocu25() == null) ? ""
									: aa21bDocumentosExpDetalle.getDdocu25())
							+ "</descripcionCas>");

					datosXML.append("<descripcionEusk>"
							+ ((aa21bDocumentosExpDetalle.getEdocu25() == null) ? ""
									: aa21bDocumentosExpDetalle.getEdocu25())
							+ "</descripcionEusk>");

					String fechaAnotacion = "";
					try {
						SimpleDateFormat sdf = new SimpleDateFormat(
								"dd-MM-yyyy");
						SimpleDateFormat sdf_eu = new SimpleDateFormat(
								"yyyy-MM-dd");

						if (Aa21bConstantes.AA21B_IDIOMA_EUS
								.equalsIgnoreCase(locale.getLanguage())) {
							fechaAnotacion = sdf_eu
									.format(aa21bDocumentosExpDetalle
											.getFanot25());

						} else {
							fechaAnotacion = sdf
									.format(aa21bDocumentosExpDetalle
											.getFanot25());

						}
					} catch (Exception e) {
						logger.error("getXml - Error formateando fecha de apertura y cierre : "
								+ e.toString());
					}

					datosXML.append("<fAnotacion>" + fechaAnotacion
							+ "</fAnotacion>");

					datosXML.append("<nAnotacion>"
							+ ((aa21bDocumentosExpDetalle.getNanot25() == null) ? ""
									: aa21bDocumentosExpDetalle.getNanot25())
							+ "</nAnotacion>");

					datosXML.append("</documento>");
				}
				datosXML.append("</documentosExp>");

				datosXML.append("<expAsociados>");
				// Expedientes Asociados
				for (int x = 0; x < listaExpAsociadosServices.size(); x++) {
					Aa21b20s01 aa21bExpAsociados = (Aa21b20s01) listaExpAsociadosServices
							.get(x);

					if (!aa21bExpAsociados.getRefExp().equals(
							aa21bExpedienteDetalle.getRefExp())) {
						datosXML.append("<expAsociado>");
						// Angel 19/06/2018 - Añadir también el expediente de
						// baja si existe
						// datosXML.append("<referencia>" +
						// ((aa21bExpAsociados.getRefExp() == null) ? "":
						// aa21bExpAsociados.getRefExp())+ "</referencia>");
						datosXML.append("<referencia>"
								+ ((aa21bExpAsociados.getRefExp() == null) ? ""
										: aa21bExpAsociados.getRefExp())
								+ ((aa21bExpAsociados.getUbica20() == null) ? ""
										: "(" + aa21bExpAsociados.getUbica20()
												+ ")") + "</referencia>");

						// Fin Angel

						datosXML.append("</expAsociado>");
					}

				}
				datosXML.append("</expAsociados>");

				datosXML.append("<historicosResp>");
				// Histórico responsables
				for (int x = 0; x < respExpDetalleServices.size(); x++) {
					Aa21b29s01 aa21bRespExpDetalle = (Aa21b29s01) respExpDetalleServices
							.get(x);

					if (aa21bRespExpDetalle.getCrespo29() != aa21bExpedienteDetalle
							.getCrespo20()) {
						datosXML.append("<respHist>");

						datosXML.append("<codRespHist>"
								+ ((aa21bRespExpDetalle.getCrespo29() == null) ? ""
										: aa21bRespExpDetalle.getCrespo29())
								+ "</codRespHist>");

						datosXML.append("<descRespHist>"
								+ ((aa21bRespExpDetalle.getDrespo29() == null) ? ""
										: aa21bRespExpDetalle.getDrespo29())
								+ "</descRespHist>");

						String fechaRespHist = "";
						try {
							SimpleDateFormat sdf = new SimpleDateFormat(
									"dd-MM-yyyy");
							SimpleDateFormat sdf_eu = new SimpleDateFormat(
									"yyyy-MM-dd");

							if (Aa21bConstantes.AA21B_IDIOMA_EUS
									.equalsIgnoreCase(locale.getLanguage())) {
								fechaRespHist = sdf_eu
										.format(aa21bRespExpDetalle
												.getFrespo29());

							} else {
								fechaRespHist = sdf.format(aa21bRespExpDetalle
										.getFrespo29());

							}
						} catch (Exception e) {
							logger.error("getXml - Error formateando fecha de apertura y cierre : "
									+ e.toString());
						}

						datosXML.append("<fRespHist>" + fechaRespHist
								+ "</fRespHist>");

						datosXML.append("</respHist>");
					}

				}
				datosXML.append("</historicosResp>");

			}

		} catch (Exception e) {
			logger.error("getXml - Error obteniendo xml: " + e.toString());
		}

		datosXML.append("</expediente>");

		logger.info("getXml - Fin");

		return datosXML.toString().replaceAll("&", "&amp;");
	}
}
