package com.ejie.aa21b.pdf.xml;

import java.text.SimpleDateFormat;
import java.util.List;
import java.util.Locale;

import javax.servlet.http.HttpServletRequest;

import org.apache.log4j.Logger;

import com.ejie.aa21b.model.Aa21b07s01;
import com.ejie.aa21b.util.Aa21bConstantes;
import com.ejie.aa21b.util.Aa21bParametros;

/**
 * 
 *  
 * 
 */
public class Aa21bEstadosExpedientesXML {

	/**
	 * Method 'Aa21bEstadosExpedientesXML'. Constructor vacio
	 */
	private Aa21bEstadosExpedientesXML() {
	}

	private static final Logger logger = Logger
			.getLogger(Aa21bEstadosExpedientesXML.class);

	/**
	 * Method 'getXml'
	 * 
	 * @param request
	 *            HttpServletRequest
	 * @param listaServices
	 *            List<Object>
	 * @param locale
	 *            Locale
	 * 
	 * @return String
	 * @throws Exception
	 *             Exception
	 */
	@SuppressWarnings("unchecked")
	public static String getXml(HttpServletRequest request,
			List<Object> listaServices, Locale locale) throws Exception {
		logger.info("getXml - Inicio");

		// Obtener la fecha actual
		String fechaObtencion = "";

		try {
			SimpleDateFormat sdf = new SimpleDateFormat("dd-MM-yyyy");
			SimpleDateFormat sdf_eu = new SimpleDateFormat("yyyy-MM-dd");

			if (Aa21bConstantes.AA21B_IDIOMA_EUS.equalsIgnoreCase(locale.getLanguage())) {
				fechaObtencion = sdf_eu.format(new java.util.Date());
			} else {
				fechaObtencion = sdf.format(new java.util.Date());
			}
		} catch (Exception e) {
			fechaObtencion = "";
			logger.error("getXml - Error obteniendo la fecha actual: "
					+ e.toString());
		}

		List<Aa21b07s01> aa21bEstadosExpedientes = null;

		// Generar el xml
		StringBuffer datosXML = new StringBuffer("");

		datosXML.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");

		datosXML.append("<estadosExpedientes>");

		logger.info("getXml - Obtener la ruta de la imagen del logo del encabezado");

		datosXML.append("<imgLogoUrl>"
				+ (Aa21bEstadosExpedientesXML.class.getResource(Aa21bParametros
						.getImpreso("pdf.img.logo"))) + "</imgLogoUrl>");

		datosXML.append("<fecha>" + fechaObtencion + "</fecha>");

		logger.info("getXml - Obtener los datos identificativos");

		try {
			if (listaServices.size() != 0) {
				aa21bEstadosExpedientes = (List<Aa21b07s01>) listaServices
						.get(0);
				for (int i = 0; i < aa21bEstadosExpedientes.size(); i++) {
					Aa21b07s01 tEstadoExp = (Aa21b07s01) aa21bEstadosExpedientes
							.get(i);

					datosXML.append("<estadoExpediente>");

					datosXML.append("<cesta07>"
							+ ((tEstadoExp.getCesta07() == null) ? ""
									: tEstadoExp.getCesta07()) + "</cesta07>");
					datosXML.append("<desta07>"
							+ ((tEstadoExp.getDesta07() == null) ? ""
									: tEstadoExp.getDesta07()) + "</desta07>");
					datosXML.append("<eesta07>"
							+ ((tEstadoExp.getEesta07() == null) ? ""
									: tEstadoExp.getEesta07()) + "</eesta07>");
					datosXML.append("<situ07>");

					if (tEstadoExp.getSitu07() != null
							&& tEstadoExp.getSitu07().trim().equals("A")) {
						datosXML.append("Alta");
					} else if (tEstadoExp.getSitu07() != null
							&& tEstadoExp.getSitu07().trim().equals("B")) {
						datosXML.append("Baja");
					} else {
						datosXML.append(" - ");
					}

					datosXML.append("</situ07>");

					datosXML.append("</estadoExpediente>");
				}
			}

		} catch (Exception e) {
			logger.error("getXml - Error obteniendo xml: " + e.toString());
		}

		datosXML.append("</estadosExpedientes>");

		logger.info("getXml - Fin");

		return datosXML.toString().replaceAll("&", "&amp;");
	}
}
