package com.ejie.aa21b.pdf.xml;

import java.text.SimpleDateFormat;
import java.util.List;
import java.util.Locale;

import javax.servlet.http.HttpServletRequest;

import org.apache.log4j.Logger;

import com.ejie.aa21b.model.Aa21b97s01;
import com.ejie.aa21b.util.Aa21bConstantes;
import com.ejie.aa21b.util.Aa21bParametros;

/**
 * 
 *  
 * 
 */
public class Aa21bDesbloqueosTablasXML {

	/**
	 * Method 'Aa21bDesbloqueosTablasXML'. Constructor vacio
	 */
	private Aa21bDesbloqueosTablasXML() {
	}

	private static final Logger logger = Logger
			.getLogger(Aa21bDesbloqueosTablasXML.class);

	/**
	 * Method 'getXml'
	 * 
	 * @param request
	 *            HttpServletRequest
	 * @param listaServices
	 *            List<Object>
	 * @param locale
	 *            Locale
	 * 
	 * @return String
	 * @throws Exception
	 *             Exception
	 */
	@SuppressWarnings("unchecked")
	public static String getXml(HttpServletRequest request,
			List<Object> listaServices, Locale locale) throws Exception {
		logger.info("getXml - Inicio");

		// Obtener la fecha actual
		String fechaObtencion = "";

		try {
			SimpleDateFormat sdf = new SimpleDateFormat("dd-MM-yyyy");
			SimpleDateFormat sdf_eu = new SimpleDateFormat("yyyy-MM-dd");

			if (Aa21bConstantes.AA21B_IDIOMA_EUS.equalsIgnoreCase(locale.getLanguage())) {
				fechaObtencion = sdf_eu.format(new java.util.Date());
			} else {
				fechaObtencion = sdf.format(new java.util.Date());
			}
		} catch (Exception e) {
			fechaObtencion = "";
			logger.error("getXml - Error obteniendo la fecha actual: "
					+ e.toString());
		}

		List<Aa21b97s01> aa21bDesbloqueosTablas = null;

		// Generar el xml
		StringBuffer datosXML = new StringBuffer("");

		datosXML.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");

		datosXML.append("<tablasBloqueadas>");

		logger.info("getXml - Obtener la ruta de la imagen del logo del encabezado");

		datosXML.append("<imgLogoUrl>"
				+ (Aa21bDesbloqueosTablasXML.class.getResource(Aa21bParametros
						.getImpreso("pdf.img.logo"))) + "</imgLogoUrl>");

		datosXML.append("<fecha>" + fechaObtencion + "</fecha>");

		logger.info("getXml - Obtener los datos identificativos");

		try {
			if (listaServices.size() != 0) {
				aa21bDesbloqueosTablas = (List<Aa21b97s01>) listaServices
						.get(0);
				for (int i = 0; i < aa21bDesbloqueosTablas.size(); i++) {
					Aa21b97s01 tTablaBloqueada = (Aa21b97s01) aa21bDesbloqueosTablas
							.get(i);

					datosXML.append("<tabla>");

					datosXML.append("<tabla97>"
							+ ((tTablaBloqueada.getTabla97() == null) ? ""
									: tTablaBloqueada.getTabla97())
							+ "</tabla97>");
					if (locale.getLanguage() == "es")
						datosXML.append("<desc97>"
								+ ((tTablaBloqueada.getDesc97() == null) ? ""
										: tTablaBloqueada.getDesc97())
								+ "</desc97>");
					else
						datosXML.append("<desc97>"
								+ ((tTablaBloqueada.getDese97() == null) ? ""
										: tTablaBloqueada.getDese97())
								+ "</desc97>");

					datosXML.append("<numBloqueados>"
							+ ((tTablaBloqueada.getNumBloqueados() == null) ? ""
									: tTablaBloqueada.getNumBloqueados())
							+ "</numBloqueados>");

					datosXML.append("</tabla>");
				}
			}

		} catch (Exception e) {
			logger.error("getXml - Error obteniendo xml: " + e.toString());
		}

		datosXML.append("</tablasBloqueadas>");

		logger.info("getXml - Fin");

		return datosXML.toString().replaceAll("&", "&amp;");
	}
}
