package com.ejie.aa21b.pdf.xml;

import java.text.SimpleDateFormat;
import java.util.List;
import java.util.Locale;

import javax.servlet.http.HttpServletRequest;

import org.apache.log4j.Logger;

import com.ejie.aa21b.model.Aa21b12s01;
import com.ejie.aa21b.util.Aa21bConstantes;
import com.ejie.aa21b.util.Aa21bParametros;

/**
 * 
 *  
 * 
 */
public class Aa21bDepartamentosXML {

	/**
	 * Method 'Aa21bDepartamentosXML'. Constructor vacio
	 */
	private Aa21bDepartamentosXML() {
	}

	private static final Logger logger = Logger
			.getLogger(Aa21bDepartamentosXML.class);

	/**
	 * Method 'getXml'
	 * 
	 * @param request
	 *            HttpServletRequest
	 * @param listaServices
	 *            List<Object>
	 * @param locale
	 *            Locale
	 * 
	 * @return String
	 * @throws Exception
	 *             Exception
	 */
	@SuppressWarnings("unchecked")
	public static String getXml(HttpServletRequest request,
			List<Object> listaServices, Locale locale) throws Exception {
		logger.info("getXml - Inicio");

		// Obtener la fecha actual
		String fechaObtencion = "";

		try {
			SimpleDateFormat sdf = new SimpleDateFormat("dd-MM-yyyy");
			SimpleDateFormat sdf_eu = new SimpleDateFormat("yyyy-MM-dd");

			if (Aa21bConstantes.AA21B_IDIOMA_EUS.equalsIgnoreCase(locale.getLanguage())) {
				fechaObtencion = sdf_eu.format(new java.util.Date());
			} else {
				fechaObtencion = sdf.format(new java.util.Date());
			}
		} catch (Exception e) {
			fechaObtencion = "";
			logger.error("getXml - Error obteniendo la fecha actual: "
					+ e.toString());
		}

		List<Aa21b12s01> aa21bDepartamentos = null;

		// Generar el xml
		StringBuffer datosXML = new StringBuffer("");

		datosXML.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");

		datosXML.append("<departamentos>");

		logger.info("getXml - Obtener la ruta de la imagen del logo del encabezado");

		datosXML.append("<imgLogoUrl>"
				+ (Aa21bDepartamentosXML.class.getResource(Aa21bParametros
						.getImpreso("pdf.img.logo"))) + "</imgLogoUrl>");

		datosXML.append("<fecha>" + fechaObtencion + "</fecha>");

		logger.info("getXml - Obtener los datos identificativos");

		try {
			if (listaServices.size() != 0) {
				aa21bDepartamentos = (List<Aa21b12s01>) listaServices.get(0);
				for (int i = 0; i < aa21bDepartamentos.size(); i++) {
					Aa21b12s01 tDepartamento = (Aa21b12s01) aa21bDepartamentos
							.get(i);

					datosXML.append("<departamento>");

					datosXML.append("<cdepar12>"
							+ ((tDepartamento.getCDepar12() == null) ? ""
									: tDepartamento.getCDepar12())
							+ "</cdepar12>");
					datosXML.append("<ddepar12>"
							+ ((tDepartamento.getDDepar12() == null) ? ""
									: tDepartamento.getDDepar12())
							+ "</ddepar12>");
					datosXML.append("<edepar12>"
							+ ((tDepartamento.getEDepar12() == null) ? ""
									: tDepartamento.getEDepar12())
							+ "</edepar12>");
					datosXML.append("<situ12>");

					if (tDepartamento.getSitu12() != null
							&& tDepartamento.getSitu12().trim().equals("A")) {
						datosXML.append("Alta");
					} else if (tDepartamento.getSitu12() != null
							&& tDepartamento.getSitu12().trim().equals("B")) {
						datosXML.append("Baja");
					} else {
						datosXML.append(" - ");
					}

					datosXML.append("</situ12>");

					datosXML.append("</departamento>");
				}
			}

		} catch (Exception e) {
			logger.error("getXml - Error obteniendo xml: " + e.toString());
		}

		datosXML.append("</departamentos>");

		logger.info("getXml - Fin");

		return datosXML.toString().replaceAll("&", "&amp;");
	}
}
