package com.ejie.aa21b.pdf;

import java.io.OutputStream;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.support.ReloadableResourceBundleMessageSource;

import com.ejie.aa21b.model.Aa21b20s01Consultas;
import com.ejie.aa21b.util.Aa21bConstantes;
import com.itextpdf.text.BaseColor;
import com.itextpdf.text.Document;
import com.itextpdf.text.DocumentException;
import com.itextpdf.text.Element;
import com.itextpdf.text.Font;
import com.itextpdf.text.Font.FontFamily;
import com.itextpdf.text.PageSize;
import com.itextpdf.text.Paragraph;
import com.itextpdf.text.Rectangle;
import com.itextpdf.text.pdf.PdfPCell;
import com.itextpdf.text.pdf.PdfPTable;
import com.itextpdf.text.pdf.PdfWriter;

public class PdfInformeTramitacion extends PdfBuilder {
	private static final Logger logger = LoggerFactory
			.getLogger(PdfInformeTramitacion.class);
	private Font fontNormal = new Font(FontFamily.HELVETICA, 10, Font.NORMAL,
			BaseColor.BLACK);
	Font fontHeader = new Font(FontFamily.HELVETICA, 14, Font.BOLD,
			BaseColor.BLACK);
	Font fontCabecera = new Font(FontFamily.HELVETICA, 10, Font.BOLD,
			BaseColor.BLACK);

	Font fontDatos = new Font(FontFamily.HELVETICA, 9, Font.NORMAL,
			BaseColor.BLACK);

	public PdfInformeTramitacion(
			ReloadableResourceBundleMessageSource appMessageSource,
			Locale locale) {
		super(appMessageSource, locale);

	}

	public void crearListado(List<Aa21b20s01Consultas> datos,
			List<String> listaFiltros, OutputStream out) {
		Document doc = new Document(PageSize.A4.rotate(), 36, 36, 72, 36);

		PdfWriter docWriter = null;
		// doc.setPageSize(PageSize.A4.rotate());
		try {
			// String path = "c:/datos/aa66/" + pdfFilename;
			// docWriter = PdfWriter.getInstance(doc, new
			// FileOutputStream(path));
			docWriter = PdfWriter.getInstance(doc, out);
			doc.addAuthor("iaizpurl"); //$NON-NLS-1$
			doc.addCreationDate();
			doc.addProducer();
			doc.addCreator("iaizpurl"); //$NON-NLS-1$

			TableHeader event = new TableHeader();
			docWriter.setPageEvent(event);
			doc.open();
			doc.setMargins(-30, -30, 72, 36);
			doc.newPage();

			PdfPTable table = null;
			PdfPTable cabecera = null;

			Iterator<Aa21b20s01Consultas> iter = datos.iterator();
			Aa21b20s01Consultas elemento = null;
			long servicio = -111;

			boolean nuevogrupo = false;
			// int countGrupos = 0;

			float[] columnWidths = new float[] { 2f, 12f, 11f, 10f, 10f, 13f,
					25f };
			float[] columnWidths2 = new float[] { 10f, 30f, 10f, 30f };

			int countExpe = 1;
			String filtro = "";

			for (int i = 0; i < listaFiltros.size(); i++) {
				// filtro += listaFiltros.get(i) + " \r\n";
				filtro = filtro.concat(listaFiltros.get(i)).concat(" \r\n");
			}
			while (iter.hasNext()) {
				nuevogrupo = false;
				elemento = iter.next();
				if (elemento.getCserv20() != servicio) {
					servicio = elemento.getCserv20();
					nuevogrupo = true;
				}

				if (nuevogrupo) {
					countExpe = 1;
					// Título, Informe de tramitación
					// Filtros
					// Servicio y Responsable
					// Raya separadora
					if (table != null) {
						doc.add(table);
						doc.newPage();
					}
					cabecera = new PdfPTable(4);
					cabecera.setWidths(columnWidths2);
					String texto = "";

					PdfPCell celda1 = new PdfPCell(new Paragraph(
							appMessageSource.getMessage("itrami.1", null,
									locale), fontHeader));
					celda1.setColspan(4);
					celda1.setHorizontalAlignment(Element.ALIGN_CENTER);
					formatearCelda(celda1);
					cabecera.addCell(celda1);

					PdfPCell celda2 = new PdfPCell(new Paragraph(filtro,
							fontCabecera));
					celda2.setColspan(4);
					formatearCelda(celda2);
					cabecera.addCell(celda2);
					PdfPCell celda30 = new PdfPCell(new Paragraph(
							appMessageSource.getMessage("itrami.2", null,
									locale), fontCabecera));

					formatearCelda2(celda30);
					cabecera.addCell(celda30);

					if (Aa21bConstantes.AA21B_IDIOMA_EUS.equalsIgnoreCase(locale
							.getLanguage())) {
						texto = elemento.getEserv20();
					} else {
						texto = elemento.getDserv20();
					}
					PdfPCell celda3 = new PdfPCell(new Paragraph(
							elemento.getCserv20() + "-" + texto, fontNormal));
					formatearCelda2(celda3);

					cabecera.addCell(celda3);
					PdfPCell celda40 = new PdfPCell(new Paragraph(
							appMessageSource.getMessage("itrami.3", null,
									locale), fontCabecera));
					formatearCelda2(celda40);
					cabecera.addCell(celda40);

					PdfPCell celda4 = new PdfPCell(new Paragraph(
							elemento.getDrespo20(), fontNormal));
					formatearCelda2(celda4);
					cabecera.addCell(celda4);

					doc.add(cabecera);

					// Tabla
					// Hay que escribir un nuevo grupo

					// doc.newPage();

					// countGrupos++;
					// Creamos tabla de datos

					table = new PdfPTable(7);
					table.setWidths(columnWidths);

					// cell1 = new PdfPCell(
					// new Paragraph(

					// cell1.setBorder(PdfPCell.BOTTOM);
					// table.addCell(cell1);

					nuevogrupo = false;
				}

				aniadirExpediente(table, elemento, countExpe);
				countExpe++;
			}
			doc.add(table);

		} catch (DocumentException dex) {
			logger.error(dex.getMessage());
			StackTraceElement[] els = dex.getStackTrace();
			for (StackTraceElement el : els) {
				logger.error(el.toString());
			}
		} catch (Exception ex) {
			logger.error(ex.getMessage());
			StackTraceElement[] els = ex.getStackTrace();
			for (StackTraceElement el : els) {
				logger.error(el.toString());
			}
		} finally {
			if (doc != null) {
				doc.close();
			}
			if (docWriter != null) {
				docWriter.close();
			}
		}
	}

	/**
	 * Añade un expediente
	 * 
	 * @param table
	 * @param expediente
	 * @param contador
	 */
	private void aniadirExpediente(PdfPTable table,
			Aa21b20s01Consultas expediente, int contador) {
		// Primera línea
		PdfPCell celda11 = new PdfPCell(
				new Paragraph(contador + "", fontNormal));
		formatearCelda(celda11);
		// String texto;

		table.addCell(celda11);
		PdfPCell celda12 = new PdfPCell(new Paragraph(expediente.getRefExp()
				+ "", fontNormal));
		formatearCelda(celda12);

		table.addCell(celda12);
		PdfPCell celda13 = new PdfPCell(new Paragraph(
				appMessageSource.getMessage("itrami.4", null, locale),
				fontCabecera));
		formatearCelda(celda13);
		table.addCell(celda13);

		PdfPCell celda14 = new PdfPCell(new Paragraph(expediente.getObjeto20(),
				fontNormal));
		celda14.setColspan(4);
		formatearCelda(celda14);

		table.addCell(celda14);

		// Segunda línea
		// Vacío doble
		PdfPCell celda21 = new PdfPCell(new Paragraph(" ", fontNormal));
		celda21.setColspan(2);
		formatearCelda(celda21);

		table.addCell(celda21);
		PdfPCell celda23 = new PdfPCell(new Paragraph(
				appMessageSource.getMessage("itrami.5", null, locale),
				fontCabecera));
		formatearCelda(celda23);

		table.addCell(celda23);

		if (Aa21bConstantes.AA21B_IDIOMA_EUS.equalsIgnoreCase(locale.getLanguage())) {
			PdfPCell celda24 = new PdfPCell(new Paragraph(
					expediente.getEesta20(), fontNormal));
			celda24.setColspan(2);
			formatearCelda(celda24);
			table.addCell(celda24);
		} else {
			PdfPCell celda24 = new PdfPCell(new Paragraph(
					expediente.getDesta20(), fontNormal));
			celda24.setColspan(2);
			formatearCelda(celda24);
			table.addCell(celda24);
		}

		PdfPCell celda26 = new PdfPCell(new Paragraph(
				appMessageSource.getMessage("itrami.6", null, locale),
				fontCabecera));
		formatearCelda(celda26);

		table.addCell(celda26);
		if (Aa21bConstantes.AA21B_IDIOMA_EUS.equalsIgnoreCase(locale.getLanguage())) {
			PdfPCell celda27 = new PdfPCell(new Paragraph(
					expediente.getEdepar20(), fontNormal));
			celda27.setColspan(2);
			formatearCelda(celda27);
			table.addCell(celda27);
		} else {
			PdfPCell celda27 = new PdfPCell(new Paragraph(
					expediente.getDdepar20(), fontNormal));
			celda27.setColspan(2);
			formatearCelda(celda27);
			table.addCell(celda27);
		}

		// Tercera línea
		// Vacío doble
		PdfPCell celda31 = new PdfPCell(new Paragraph(" ", fontNormal));
		celda31.setColspan(2);
		formatearCelda(celda31);

		table.addCell(celda31);
		PdfPCell celda33 = new PdfPCell(new Paragraph(
				appMessageSource.getMessage("itrami.7", null, locale),
				fontCabecera));
		formatearCelda(celda33);

		table.addCell(celda33);

		PdfPCell celda34 = new PdfPCell(new Paragraph(
				formatear(expediente.getFaper20()), fontNormal));
		formatearCelda(celda34);

		table.addCell(celda34);
		PdfPCell celda35 = new PdfPCell(new Paragraph(
				appMessageSource.getMessage("itrami.8", null, locale),
				fontCabecera));
		formatearCelda(celda35);

		table.addCell(celda35);

		PdfPCell celda36 = new PdfPCell(new Paragraph(
				formatear(expediente.getFcier20()), fontNormal));
		celda36.setColspan(2);
		formatearCelda(celda36);
		table.addCell(celda36);

		// cuarta línea
		// Vacío doble
		PdfPCell celda41 = new PdfPCell(new Paragraph(" ", fontNormal));
		celda41.setColspan(2);
		formatearCelda(celda41);
		table.addCell(celda41);
		PdfPCell celda43 = new PdfPCell(new Paragraph(
				appMessageSource.getMessage("itrami.9", null, locale),
				fontCabecera));
		formatearCelda(celda43);
		table.addCell(celda43);

		PdfPCell celda44 = new PdfPCell(new Paragraph(expediente.getDrespo20(),
				fontNormal));
		celda44.setColspan(4);
		formatearCelda(celda44);
		table.addCell(celda44);

	}

	private void formatearCelda(PdfPCell celda) {
		celda.setBorder(Rectangle.NO_BORDER);
		celda.setPadding(3);
	}

	private void formatearCelda2(PdfPCell celda) {
		celda.setBorderWidthTop(0);
		celda.setBorderWidthLeft(0);
		celda.setBorderWidthRight(0);
		celda.setBorderWidthBottom(2);
		celda.setPadding(5);
		celda.setPaddingBottom(10);
	}

	private String formatear(Date date) {
		String fecha = "";
		try {
			SimpleDateFormat sdf = new SimpleDateFormat("dd-MM-yyyy");
			SimpleDateFormat sdf_eu = new SimpleDateFormat("yyyy-MM-dd");

			if (Aa21bConstantes.AA21B_IDIOMA_EUS.equalsIgnoreCase(locale.getLanguage())) {
				fecha = sdf_eu.format(date);

			} else {
				fecha = sdf.format(date);

			}
		} catch (Exception e) {

		}
		return fecha;
	}
}
