package com.ejie.aa21b.pdf;

import java.io.OutputStream;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.support.ReloadableResourceBundleMessageSource;

import com.ejie.aa21b.model.Aa21b20s01Consultas;
import com.ejie.aa21b.util.Aa21bConstantes;
import com.itextpdf.text.BaseColor;
import com.itextpdf.text.Document;
import com.itextpdf.text.DocumentException;
import com.itextpdf.text.Element;
import com.itextpdf.text.Font;
import com.itextpdf.text.Font.FontFamily;
import com.itextpdf.text.PageSize;
import com.itextpdf.text.Paragraph;
import com.itextpdf.text.Rectangle;
import com.itextpdf.text.pdf.PdfPCell;
import com.itextpdf.text.pdf.PdfPTable;
import com.itextpdf.text.pdf.PdfWriter;

public class PdfInformeListado extends PdfBuilder {
	private static final Logger logger = LoggerFactory
			.getLogger(PdfInformeListado.class);
	private Font fontNormal = new Font(FontFamily.HELVETICA, 8, Font.NORMAL,
			BaseColor.BLACK);
	Font fontHeader = new Font(FontFamily.HELVETICA, 14, Font.BOLD,
			BaseColor.BLACK);
	Font fontCabecera = new Font(FontFamily.HELVETICA, 8, Font.BOLD,
			BaseColor.BLACK);

	Font fontDatos = new Font(FontFamily.HELVETICA, 7, Font.NORMAL,
			BaseColor.BLACK);

	public PdfInformeListado(
			ReloadableResourceBundleMessageSource appMessageSource,
			Locale locale) {
		super(appMessageSource, locale);

	}

	public void crearListado(List<Aa21b20s01Consultas> datos,
			List<String> listaFiltros, OutputStream out) {
		Document doc = new Document(PageSize.A4.rotate(), 36, 36, 72, 36);

		PdfWriter docWriter = null;
		// doc.setPageSize(PageSize.A4.rotate());
		try {
			// String path = "c:/datos/aa66/" + pdfFilename;
			// docWriter = PdfWriter.getInstance(doc, new
			// FileOutputStream(path));
			docWriter = PdfWriter.getInstance(doc, out);
			doc.addAuthor("iaizpurl"); //$NON-NLS-1$
			doc.addCreationDate();
			doc.addProducer();
			doc.addCreator("iaizpurl"); //$NON-NLS-1$

			TableHeader event = new TableHeader();
			docWriter.setPageEvent(event);
			doc.open();
			doc.setMargins(-30, -30, 72, 36);
			doc.newPage();

			PdfPTable table = null;
			PdfPTable cabecera = null;

			Iterator<Aa21b20s01Consultas> iter = datos.iterator();
			Aa21b20s01Consultas elemento = null;
			long servicio = -111;

			boolean nuevogrupo = false;
			// int countGrupos = 0;

			float[] columnWidths = new float[] { 10f, 20f, 60f, 20f, 15f, 15f,
					20f };
			float[] columnWidths2 = new float[] { 1f, 10f };

			int countExpe = 1;
			String filtro = "";

			for (int i = 0; i < listaFiltros.size(); i++) {
				// filtro += listaFiltros.get(i) + " ";
				filtro = filtro.concat(listaFiltros.get(i)).concat(" ");
			}
			while (iter.hasNext()) {
				nuevogrupo = false;
				elemento = iter.next();
				if (elemento.getCserv20() != servicio) {
					servicio = elemento.getCserv20();
					nuevogrupo = true;
				}

				if (nuevogrupo) {
					countExpe = 1;
					// Título, Informe de tramitación
					// Filtros
					// Servicio y Responsable
					// Raya separadora
					if (table != null) {
						doc.add(table);
						doc.newPage();
					}
					cabecera = new PdfPTable(2);
					cabecera.setWidths(columnWidths2);
					String texto = "";

					PdfPCell celda1 = new PdfPCell(
							new Paragraph(appMessageSource.getMessage(
									"lexpe.0", null, locale), fontHeader));
					celda1.setColspan(2);
					celda1.setHorizontalAlignment(Element.ALIGN_CENTER);
					formatearCelda(celda1);
					cabecera.addCell(celda1);

					PdfPCell celda2 = new PdfPCell(new Paragraph(filtro,
							fontCabecera));
					celda2.setColspan(2);
					formatearCelda(celda2);
					cabecera.addCell(celda2);
					PdfPCell celda30 = new PdfPCell(
							new Paragraph(appMessageSource.getMessage(
									"lexpe.1", null, locale), fontCabecera));

					formatearCelda2(celda30);
					cabecera.addCell(celda30);

					if (Aa21bConstantes.AA21B_IDIOMA_EUS.equalsIgnoreCase(locale
							.getLanguage())) {
						texto = elemento.getEserv20();
					} else {
						texto = elemento.getDserv20();
					}
					PdfPCell celda3 = new PdfPCell(new Paragraph(
							elemento.getCserv20() + "-" + texto, fontNormal));
					formatearCelda2(celda3);

					cabecera.addCell(celda3);

					doc.add(cabecera);

					// Tabla
					// Hay que escribir un nuevo grupo

					// doc.newPage();

					// countGrupos++;
					// Creamos tabla de datos

					table = new PdfPTable(7);
					table.setWidths(columnWidths);
					aniadirHeader(table);
					// cell1 = new PdfPCell(
					// new Paragraph(

					// cell1.setBorder(PdfPCell.BOTTOM);
					// table.addCell(cell1);

					nuevogrupo = false;
				}

				aniadirExpediente(table, elemento, countExpe);
				countExpe++;
			}
			doc.add(table);

		} catch (DocumentException dex) {
			logger.error(dex.getMessage());
			StackTraceElement[] els = dex.getStackTrace();
			for (StackTraceElement el : els) {
				logger.error(el.toString());
			}
		} catch (Exception ex) {
			logger.error(ex.getMessage());
			StackTraceElement[] els = ex.getStackTrace();
			for (StackTraceElement el : els) {
				logger.error(el.toString());
			}
		} finally {
			if (doc != null) {
				doc.close();
			}
			if (docWriter != null) {
				docWriter.close();
			}
		}
	}

	private void aniadirHeader(PdfPTable table) {
		PdfPCell celda11 = new PdfPCell(new Paragraph(
				appMessageSource.getMessage("lexpe.2", null, locale),
				fontCabecera));
		formatearCelda2(celda11);
		table.addCell(celda11);
		PdfPCell celda12 = new PdfPCell(new Paragraph(
				appMessageSource.getMessage("lexpe.3", null, locale),
				fontCabecera));
		formatearCelda2(celda12);
		table.addCell(celda12);
		PdfPCell celda13 = new PdfPCell(new Paragraph(
				appMessageSource.getMessage("lexpe.4", null, locale),
				fontCabecera));
		formatearCelda2(celda13);
		table.addCell(celda13);
		PdfPCell celda14 = new PdfPCell(new Paragraph(
				appMessageSource.getMessage("lexpe.5", null, locale),
				fontCabecera));
		formatearCelda2(celda14);
		table.addCell(celda14);
		PdfPCell celda15 = new PdfPCell(new Paragraph(
				appMessageSource.getMessage("lexpe.6", null, locale),
				fontCabecera));
		formatearCelda2(celda15);
		table.addCell(celda15);
		PdfPCell celda16 = new PdfPCell(new Paragraph(
				appMessageSource.getMessage("lexpe.7", null, locale),
				fontCabecera));
		formatearCelda2(celda16);
		table.addCell(celda16);
		PdfPCell celda17 = new PdfPCell(new Paragraph(
				appMessageSource.getMessage("lexpe.8", null, locale),
				fontCabecera));
		formatearCelda2(celda17);
		table.addCell(celda17);
	}

	/**
	 * Añade un expediente
	 * 
	 * @param table
	 * @param expediente
	 * @param contador
	 */
	private void aniadirExpediente(PdfPTable table,
			Aa21b20s01Consultas expediente, int contador) {
		// Primera línea
		PdfPCell celda1 = new PdfPCell(new Paragraph(contador + "", fontNormal));
		formatearCelda(celda1);

		table.addCell(celda1);
		PdfPCell celda21 = new PdfPCell(new Paragraph(expediente.getRefExp()
				+ "", fontNormal));
		formatearCelda(celda21);

		table.addCell(celda21);

		PdfPCell celda2 = new PdfPCell(new Paragraph(expediente.getObjeto20(),
				fontNormal));

		formatearCelda(celda2);

		table.addCell(celda2);

		PdfPCell celda3 = new PdfPCell(new Paragraph(
				formatear(expediente.getFaper20()), fontNormal));

		formatearCelda(celda3);

		table.addCell(celda3);

		PdfPCell celda4 = new PdfPCell(new Paragraph(
				formatear(expediente.getFcier20()), fontNormal));

		formatearCelda(celda4);
		table.addCell(celda4);
		String kk = "";
		DecimalFormatSymbols simbolos = DecimalFormatSymbols
				.getInstance(Locale.GERMAN);
		DecimalFormat _decimalFormat = new DecimalFormat("###,###.####",
				simbolos);

		if (expediente.getEimpor20() != null)
			kk = _decimalFormat.format(expediente.getEimpor20()) + "";

		PdfPCell celda5 = new PdfPCell(new Paragraph(kk, fontNormal));
		formatearCelda(celda5);
		celda5.setHorizontalAlignment(Element.ALIGN_RIGHT);
		table.addCell(celda5);

		if (expediente.getEimpora20() != null)
			kk = _decimalFormat.format(expediente.getEimpora20()) + "";
		PdfPCell celda6 = new PdfPCell(new Paragraph(kk, fontNormal));
		formatearCelda(celda6);
		celda6.setHorizontalAlignment(Element.ALIGN_RIGHT);
		table.addCell(celda6);

	}

	private void formatearCelda(PdfPCell celda) {
		celda.setBorder(Rectangle.NO_BORDER);
		celda.setPadding(5);
	}

	private void formatearCelda2(PdfPCell celda) {
		celda.setBorderWidthTop(0);
		celda.setBorderWidthLeft(0);
		celda.setBorderWidthRight(0);
		celda.setBorderWidthBottom(2);
		celda.setPadding(5);
		celda.setPaddingBottom(10);
		celda.setHorizontalAlignment(Element.ALIGN_CENTER);
	}

	private String formatear(Date date) {
		String fecha = "";
		try {
			SimpleDateFormat sdf = new SimpleDateFormat("dd-MM-yyyy");
			SimpleDateFormat sdf_eu = new SimpleDateFormat("yyyy-MM-dd");

			if (Aa21bConstantes.AA21B_IDIOMA_EUS.equalsIgnoreCase(locale.getLanguage())) {
				fecha = sdf_eu.format(date);

			} else {
				fecha = sdf.format(date);

			}
		} catch (Exception e) {

		}
		return fecha;
	}
}
