package com.ejie.aa21b.pdf;

import java.util.List;
import java.util.Locale;

import javax.servlet.http.HttpServletRequest;

import org.apache.log4j.Logger;

import com.ejie.aa21b.pdf.xml.Aa21bUbicacionExpedientesXML;
import com.ejie.aa21b.util.Aa21bConstantes;
import com.ejie.aa21b.util.Aa21bParametros;

/**
 * 
 *  
 * 
 */
public class Aa21bUbicacionExpedientesPDF implements Aa21bPDF {

	private static final Logger logger = Logger
			.getLogger(Aa21bUbicacionExpedientesPDF.class);

	/**
	 * Method 'getXmlPdf'
	 * 
	 * @param request
	 *            HttpServletRequest
	 * @param listaServices
	 *            List<Object>
	 * @param locale
	 *            Locale
	 * 
	 * @return String
	 */
	public String getXmlPdf(HttpServletRequest request,
			List<Object> listaServices, Locale locale) {
		logger.info("getXmlPdf - Inicio");
		String xmlPdf = null;
		try {
			xmlPdf = Aa21bUbicacionExpedientesXML.getXml(request,
					listaServices, locale);
			// }
		} catch (Exception e) {
			logger.error("getXmlPdf - Error al obtener el XML: "
					+ e.getMessage() + " --> " + e.toString());
			return null;
		}
		logger.info("getXmlPdf - Fin");
		return xmlPdf;
	}

	/**
	 * Method 'getXsltFichero'
	 * 
	 * @param request
	 *            HttpServletRequest
	 * @param locale
	 *            Locale
	 * 
	 * @return String
	 */
	public String getXsltFichero(HttpServletRequest request, Locale locale) {
		logger.info("getXsltFichero - Inicio");
		String xsltFichero = null;
		try {
			if (Aa21bConstantes.AA21B_IDIOMA_EUS.equalsIgnoreCase(locale.getLanguage())) {
				xsltFichero = Aa21bParametros
						.getImpreso("pdf.xsl.impresoUbicacionExpedientes_eu");
			} else {
				xsltFichero = Aa21bParametros
						.getImpreso("pdf.xsl.impresoUbicacionExpedientes_es");
			}

		} catch (Exception e) {
			logger.error("getXsltFichero - Error al obtener el nombre del xslt: "
					+ e.getMessage() + " --> " + e.toString());
			return null;
		}
		logger.info("getXsltFichero - Fin");
		return xsltFichero;
	}
}
