package com.ejie.aa21b.model.ws;

import org.apache.commons.lang.StringUtils;

public class ExpActualizaWs {

	private String cexpe;
	private Long aexpe;
	private Integer nexpe;
	private String objeto;
	private String ubica;
	private String refExp;

	/**
	 * Method 'ExpedientesWs'.
	 */
	public ExpActualizaWs() {
		this.setCexpe("");
	}

	public ExpActualizaWs(String cexpe, Long aexpe, Integer nexpe,
			String refExp, String objeto, String ubica) {
		this.setCexpe(cexpe);
		this.setAexpe(aexpe);
		this.setNexpe(nexpe);
		this.setRefExp(refExp);
		this.setObjeto(objeto);
		this.setUbica(ubica);
	}

	public String getReferenciaGrupo() {
		String expe = this.getCexpe() + "/"
				+ StringUtils.leftPad(this.getNexpe() + "", 6, '0') + "/"
				+ this.getAexpe();
		return expe;
	}

	/**
	 * @param cexpe
	 *            the cexpe to set
	 */
	public void setCexpe(String cexpe) {
		this.cexpe = cexpe;
	}

	/**
	 * @return the cexpe
	 */
	public String getCexpe() {
		return cexpe;
	}

	/**
	 * @param aexpe
	 *            the aexpe to set
	 */
	public void setAexpe(Long aexpe) {
		this.aexpe = aexpe;
	}

	/**
	 * @return the aexpe
	 */
	public Long getAexpe() {
		return aexpe;
	}

	/**
	 * @param nexpe
	 *            the nexpe to set
	 */
	public void setNexpe(Integer nexpe) {
		this.nexpe = nexpe;
	}

	/**
	 * @return the nexpe
	 */
	public Integer getNexpe() {
		return nexpe;
	}

	/**
	 * @param objeto
	 *            the objeto to set
	 */
	public void setObjeto(String objeto) {
		this.objeto = objeto;
	}

	/**
	 * @return the objeto
	 */
	public String getObjeto() {
		return objeto;
	}

	/**
	 * @param ubica
	 *            the ubica to set
	 */
	public void setUbica(String ubica) {
		this.ubica = ubica;
	}

	/**
	 * @return the ubica
	 */
	public String getUbica() {
		if (ubica != null) {
			return ubica;
		} else {
			return "";
		}

	}

	/**
	 * @param refExp
	 *            the refExp to set
	 */
	public void setRefExp(String refExp) {
		this.refExp = refExp;
	}

	/**
	 * @return the refExp
	 */
	public String getRefExp() {
		return refExp;
	}

}
