package com.ejie.aa21b.model;

import java.util.Date;

import org.codehaus.jackson.annotate.JsonIgnore;
import org.codehaus.jackson.map.annotate.JsonDeserialize;
import org.codehaus.jackson.map.annotate.JsonSerialize;

import com.ejie.aa21b.util.JsonDateDeserializer;
import com.ejie.x38.serialization.JsonDateSerializer;

/**
 * Aa21b21s01  
 * 
 *  
 */

public class Aa21b21s01 implements java.io.Serializable {

	private static final long serialVersionUID = 1L;
	// Clave compuesta
	private String cserv21;
	private String cexpe21;
	private String aexpe21;
	private Integer nexpe21;
	private Long cfase21;

	private String tdocu21;
	private Date fprevi21;
	private Date freal21;

	public byte[] getDocumentoPID() {
		return documentoPID;
	}

	public void setDocumentoPID(byte[] documentoPID) {
		this.documentoPID = documentoPID;
	}

	private String docu21;
	private String extdocu21;

	private String dfase21;
	private String efase21;
	private byte[] documentoPID;
	private String codPid21;
	private String pathDocPif;

	public String getPathDocPif() {
		return pathDocPif;
	}

	public void setPathDocPif(String pathDocPif) {
		this.pathDocPif = pathDocPif;
	}

	/**
	 * @return the id
	 */
	public String getIdFaseExp() {
		return cserv21 + "-" + cexpe21 + "-" + aexpe21 + "-" + nexpe21 + "-"
				+ cfase21;
	}

	public String getCodPid21() {
		return codPid21;
	}

	public void setCodPid21(String codPid21) {
		this.codPid21 = codPid21;
	}

	/**
	 * @param id
	 *            the id to set
	 */
	public void setIdFaseExp(String id) {
		String[] ids = id.split("-");
		this.cserv21 = ids[0];
		this.cexpe21 = ids[1];
		this.aexpe21 = ids[2];
		this.nexpe21 = new Integer(ids[3]);
		this.cfase21 = new Long(ids[4]);
	}

	/**
	 * Method 'Aa21b21s01'.
	 */
	public Aa21b21s01() {
	}

	/**
	 * Method 'Aa21b21s01'.
	 * 
	 * @param cserv21
	 *            String
	 * @param cexpe21
	 *            String
	 * @param aexpe21
	 *            String
	 * @param nexpe21
	 *            Integer
	 * @param cfase21
	 *            Long
	 */
	public Aa21b21s01(String cserv21, String cexpe21, String aexpe21,
			Integer nexpe21, Long cfase21) {
		this.cserv21 = cserv21;
		this.cexpe21 = cexpe21;
		this.aexpe21 = aexpe21;
		this.nexpe21 = nexpe21;
		this.cfase21 = cfase21;
	}

	/**
	 * Method 'Aa21b21s01'.
	 * 
	 * @param cserv21
	 *            String
	 * @param cexpe21
	 *            String
	 * @param aexpe21
	 *            String
	 * @param nexpe21
	 *            Integer
	 * @param cfase21
	 *            Long
	 * 
	 * @param tdocu21
	 *            String
	 * @param fprevi21
	 *            Date
	 * @param freal21
	 *            Date
	 * @param dfase21
	 *            String
	 */
	public Aa21b21s01(String cserv21, String cexpe21, String aexpe21,
			Integer nexpe21, Long cfase21, String tdocu21, Date fprevi21,
			Date freal21, String dfase21, String efase21,
			String extdocu21) {

		this.cserv21 = cserv21;
		this.cexpe21 = cexpe21;
		this.aexpe21 = aexpe21;
		this.nexpe21 = nexpe21;
		this.cfase21 = cfase21;
		this.tdocu21 = tdocu21;
		this.fprevi21 = fprevi21;
		this.freal21 = freal21;
		this.dfase21 = dfase21;
		this.efase21 = efase21;
		this.extdocu21 = extdocu21;
	}

	/**
	 * Method 'Aa21b21s01'.
	 * 
	 * @param cserv21
	 *            String
	 * @param cexpe21
	 *            String
	 * @param aexpe21
	 *            String
	 * @param nexpe21
	 *            Integer
	 * @param cfase21
	 *            Long
	 * 
	 * @param tdocu21
	 *            String
	 */
	public Aa21b21s01(String cserv21, String cexpe21, String aexpe21,
			Integer nexpe21, Long cfase21, String tdocu21, String docu21,
			String extdocu21) {

		this.cserv21 = cserv21;
		this.cexpe21 = cexpe21;
		this.aexpe21 = aexpe21;
		this.nexpe21 = nexpe21;
		this.cfase21 = cfase21;

		this.tdocu21 = tdocu21;
		this.docu21 = docu21;
		this.extdocu21 = extdocu21;
	}

	/**
	 * Method 'getCserv21'.
	 * 
	 * @return String
	 */

	public String getCserv21() {
		return this.cserv21;
	}

	/**
	 * Method 'setCserv21'.
	 * 
	 * @param cserv21
	 *            String
	 * @return
	 */

	public void setCserv21(String cserv21) {
		this.cserv21 = cserv21;
	}

	/**
	 * Method 'getCexpe21'.
	 * 
	 * @return String
	 */

	public String getCexpe21() {
		return this.cexpe21;
	}

	/**
	 * Method 'setCexpe21'.
	 * 
	 * @param cexpe21
	 *            String
	 * @return
	 */

	public void setCexpe21(String cexpe21) {
		this.cexpe21 = cexpe21;
	}

	/**
	 * Method 'getAexpe21'.
	 * 
	 * @return String
	 */

	public String getAexpe21() {
		return this.aexpe21;
	}

	/**
	 * Method 'setAexpe21'.
	 * 
	 * @param aexpe21
	 *            String
	 * @return
	 */

	public void setAexpe21(String aexpe21) {
		this.aexpe21 = aexpe21;
	}

	/**
	 * Method 'getNexpe21'.
	 * 
	 * @return Integer
	 */

	public Integer getNexpe21() {
		return this.nexpe21;
	}

	/**
	 * Method 'setNexpe21'.
	 * 
	 * @param nexpe21
	 *            Integer
	 * @return
	 */

	public void setNexpe21(Integer nexpe21) {
		this.nexpe21 = nexpe21;
	}

	/**
	 * Method 'getCfase21'.
	 * 
	 * @return Long
	 */

	public Long getCfase21() {
		return this.cfase21;
	}

	/**
	 * Method 'setCfase21'.
	 * 
	 * @param cfase21
	 *            Long
	 * @return
	 */

	public void setCfase21(Long cfase21) {
		this.cfase21 = cfase21;
	}

	/**
	 * Method 'getNdocu21'.
	 * 
	 * @return Long
	 */

	// public Long getNdocu21() {
	// return this.ndocu21;
	// }

	/**
	 * Method 'setNdocu21'.
	 * 
	 * @param ndocu21
	 *            Long
	 * @return
	 */

	// public void setNdocu21(Long ndocu21) {
	// this.ndocu21 = ndocu21;
	// }

	/**
	 * Method 'getTdocu21'.
	 * 
	 * @return String
	 */

	public String getTdocu21() {
		return this.tdocu21;
	}

	/**
	 * Method 'setTdocu21'.
	 * 
	 * @param tdocu21
	 *            String
	 * @return
	 */

	public void setTdocu21(String tdocu21) {
		this.tdocu21 = tdocu21;
	}

	/**
	 * Method 'getFprevi21'.
	 * 
	 * @return java.util.Date
	 */

	@JsonSerialize(using = JsonDateSerializer.class)
	public Date getFprevi21() {
		return this.fprevi21;
	}

	/**
	 * Method 'setFprevi21'.
	 * 
	 * @param fprevi21
	 *            java.util.Date
	 * @return
	 */
	@JsonDeserialize(using = JsonDateDeserializer.class)
	public void setFprevi21(Date fprevi21) {
		this.fprevi21 = fprevi21;
	}

	/**
	 * Method 'getFreal21'.
	 * 
	 * @return java.util.Date
	 */

	@JsonSerialize(using = JsonDateSerializer.class)
	public Date getFreal21() {
		return this.freal21;
	}

	/**
	 * Method 'setFreal21'.
	 * 
	 * @param freal21
	 *            java.util.Date
	 * @return
	 */
	@JsonDeserialize(using = JsonDateDeserializer.class)
	public void setFreal21(Date freal21) {
		this.freal21 = freal21;
	}

	/**
	 * Method 'getDfase21'.
	 * 
	 * @return String
	 */
	public String getDfase21() {
		return dfase21;
	}

	/**
	 * Method 'setDfase21'.
	 * 
	 * @param dfase21
	 *            String
	 * @return
	 */
	public void setDfase21(String dfase21) {
		this.dfase21 = dfase21;
	}

	/**
	 * Method 'getEfase21'.
	 * 
	 * @return String
	 */
	public String getEfase21() {
		return efase21;
	}

	/**
	 * Method 'setEfase21'.
	 * 
	 * @param efase21
	 *            String
	 * @return
	 */
	public void setEfase21(String efase21) {
		this.efase21 = efase21;
	}

	@JsonIgnore
	public String getDocu21() {
		return docu21;
	}

	@JsonIgnore
	public void setDocu21(String docu21) {
		this.docu21 = docu21;
	}

	public String getExtdocu21() {
		return extdocu21;
	}

	public void setExtdocu21(String extdocu21) {
		this.extdocu21 = extdocu21;
	}

	/**
	 * Intended only for logging and debugging.
	 * 
	 * Here, the contents of every main field are placed into the result.
	 * 
	 * @return String
	 */
	@Override
	public String toString() {
		StringBuilder result = new StringBuilder();
		result.append(this.getClass().getName()).append(" Object { ");
		// Clave compuesta

		result.append("[ cserv21: ").append(this.cserv21).append(" ]");

		result.append(", [ cexpe21: ").append(this.cexpe21).append(" ]");

		result.append(", [ aexpe21: ").append(this.aexpe21).append(" ]");

		result.append(", [ nexpe21: ").append(this.nexpe21).append(" ]");

		result.append(", [ cfase21: ").append(this.cfase21).append(" ]");

		result.append(", [ tdocu21: ").append(this.tdocu21).append(" ]");
		result.append(", [ fprevi21: ").append(this.fprevi21).append(" ]");
		result.append(", [ freal21: ").append(this.freal21).append(" ]");
		result.append(", [ dfase21: ").append(this.dfase21).append(" ]");
		result.append(", [ efase21: ").append(this.efase21).append(" ]");
		result.append("}");
		return result.toString();
	}
}