/*
 * Copyright 2012 E.J.I.E., S.A.
 *
 * Licencia con arreglo a la EUPL, VersiÃ³n 1.1 exclusivamente (la Â«LicenciaÂ»);
 * Solo podrÃ¡ usarse esta obra si se respeta la Licencia.
 * Puede obtenerse una copia de la Licencia en
 *
 * http://ec.europa.eu/idabc/eupl.html
 *
 * Salvo cuando lo exija la legislaciÃ³n aplicable o se acuerde por escrito,
 * el programa distribuido con arreglo a la Licencia se distribuye Â«TAL CUALÂ»,
 * SIN GARANTÃ�AS NI CONDICIONES DE NINGÃšN TIPO, ni expresas ni implÃ­citas.
 * VÃ©ase la Licencia en el idioma concreto que rige los permisos y limitaciones
 * que establece la Licencia.
 */

package com.ejie.aa21b.dao;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;

import javax.annotation.Resource;
import javax.sql.DataSource;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.aa21b.model.NoraAutonomia;
import com.ejie.aa21b.model.NoraProvincia;
import com.ejie.x38.dto.JQGridManager;
import com.ejie.x38.dto.JQGridRequestDto;
import com.ejie.x38.dto.Pagination;

/**
 * * NoraProvinciaDaoImpl  
 * 
 *  
 */

@Repository
@Transactional
public class NoraProvinciaDaoImpl implements NoraProvinciaDao {
	private JdbcTemplate jdbcTemplate;
	private static final Logger logger = LoggerFactory
			.getLogger(NoraProvinciaDaoImpl.class);

	private RowMapper<NoraProvincia> rwMap = new RowMapper<NoraProvincia>() {
		public NoraProvincia mapRow(ResultSet resultSet, int rowNum)
				throws SQLException {

			NoraAutonomia autonomia = new NoraAutonomia();
			autonomia.setId(resultSet.getString("AUTONOMIAID"));

			return new NoraProvincia(resultSet.getString("ID"),
					resultSet.getString("DSO"), autonomia);
		}
	};

	/**
	 * Method use to set the datasource.
	 * 
	 * @param dataSource
	 *            DataSource
	 * @return
	 */
	@Resource
	public void setDataSource(DataSource dataSource) {
		this.jdbcTemplate = new JdbcTemplate(dataSource);
	}

	/**
	 * Inserts a single row in the NoraProvincia table.
	 * 
	 * @param provincia
	 *            Pagination
	 * @return NoraProvincia
	 */
	public NoraProvincia add(NoraProvincia provincia) {

		String query = "INSERT INTO AA21B93S01( ID,DS_O,AUTONOMIA_ID)"
				+ "VALUES (?,?,?)";

		this.jdbcTemplate.update(query, provincia.getId(), provincia.getDsO(),
				provincia.getAutonomia().getId());
		return provincia;
	}

	/**
	 * Updates a single row in the NoraProvincia table.
	 * 
	 * @param provincia
	 *            Pagination
	 * @return NoraProvincia
	 */
	public NoraProvincia update(NoraProvincia provincia) {
		String query = "UPDATE AA21B93S01 SET  WHERE ID=? AND DS_O=? AND AUTONOMIA_ID=?";
		this.jdbcTemplate.update(query, provincia.getId(), provincia.getDsO(),
				provincia.getAutonomia().getId());
		return provincia;
	}

	/**
	 * Finds a single row in the NoraProvincia table.
	 * 
	 * @param provincia
	 *            Pagination
	 * @return NoraProvincia
	 */
	@Transactional(readOnly = true)
	public NoraProvincia find(NoraProvincia provincia) {
		String query = "SELECT t1.ID ID, t1.DS_O DSO, t1.AUTONOMIA_ID AUTONOMIAID "
				+ "FROM AA21B93S01 t1  " + "WHERE t1.ID = ?  ";
		return (NoraProvincia) this.jdbcTemplate.queryForObject(query, rwMap,
				provincia.getId());
	}

	/**
	 * Removes a single row in the NoraProvincia table.
	 * 
	 * @param provincia
	 *            Pagination
	 * @return
	 */
	public void remove(NoraProvincia provincia) {
		String query = "DELETE  FROM AA21B93S01 WHERE ID=? AND DS_O=? AND AUTONOMIA_ID=?";
		this.jdbcTemplate.update(query, provincia.getId(), provincia.getDsO(),
				provincia.getAutonomia().getId());
	}

	/**
	 * Finds a List of rows in the NoraProvincia table.
	 * 
	 * @param provincia
	 *            NoraProvincia
	 * @param jqGridRequestDto
	 *            JQGridRequestDto
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<NoraProvincia> findAll(NoraProvincia provincia,
			JQGridRequestDto jqGridRequestDto) {

		NoraProvinciaDaoImpl.logger.info("Método findAll");

		List<Object> params = new ArrayList<Object>();

		StringBuilder query = new StringBuilder(
				"SELECT  t1.ID ID,t1.DS_O DSO,t1.AUTONOMIA_ID AUTONOMIAID "
						+ "FROM AA21B93S01 t1 ");

		StringBuilder where = new StringBuilder(" WHERE 1=1 ");

		if (provincia != null && provincia.getId() != null) {
			where.append(" AND t1.ID = ?");
			params.add(provincia.getId());
		}
		if (provincia != null && provincia.getDsO() != null) {
			where.append(" AND t1.DS_O = ?");
			params.add(provincia.getDsO());
		}
		if (provincia != null && provincia.getAutonomia() != null
				&& provincia.getAutonomia().getId() != null) {
			where.append(" AND t1.AUTONOMIA_ID = ?");
			params.add(provincia.getAutonomia().getId());
		}
		query.append(where);

		if (jqGridRequestDto != null) {
			query = JQGridManager.getPaginationQuery(jqGridRequestDto, query);
		}

		NoraProvinciaDaoImpl.logger.info("findAll");
		NoraProvinciaDaoImpl.logger.info("SQL = " + query.toString());
		NoraProvinciaDaoImpl.logger.info("PARAMS" + params);

		return (List<NoraProvincia>) this.jdbcTemplate.query(query.toString(),
				rwMap, params.toArray());
	}

	/**
	 * Counts rows in the NoraProvincia table.
	 * 
	 * @param provincia
	 *            NoraProvincia
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long findAllCount(NoraProvincia provincia) {

		StringBuffer where = new StringBuffer(3000);
		List<Object> params = new ArrayList<Object>();
		where.append(" WHERE 1=1  ");

		StringBuffer query = new StringBuffer(
				"SELECT COUNT(1) FROM  AA21B93S01 t1  ");
		if (provincia != null && provincia.getId() != null) {
			where.append(" AND t1.ID = ?");
			params.add(provincia.getId());
		}
		if (provincia != null && provincia.getDsO() != null) {
			where.append(" AND t1.DS_O = ?");
			params.add(provincia.getDsO());
		}
		if (provincia != null && provincia.getAutonomia().getId() != null) {
			where.append(" AND t1.AUTONOMIA_ID = ?");
			params.add(provincia.getAutonomia().getId());
		}
		query.append(where);
		return this.jdbcTemplate.queryForLong(query.toString(),
				params.toArray());
	}

	/**
	 * Finds rows in the NoraProvincia table using like.
	 * 
	 * @param provincia
	 *            NoraProvincia
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<NoraProvincia> findAllLike(NoraProvincia provincia,
			Pagination pagination, Boolean startsWith) {
		StringBuffer where = new StringBuffer(3000);
		List<Object> params = new ArrayList<Object>();
		where.append(" WHERE 1=1 	");

		StringBuilder query = new StringBuilder(
				"SELECT  t1.ID ID,t1.DS_O DSO,t1.AUTONOMIA_ID AUTONOMIAID "
						+ "FROM AA21B93S01 t1 ");

		if (provincia != null && provincia.getId() != null) {
			where.append(" AND UPPER(t1.ID) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(provincia.getId().toUpperCase() + "%");
			} else {
				params.add("%" + provincia.getId().toUpperCase() + "%");
			}
			where.append(" AND t1.ID IS NOT NULL");
		}
		if (provincia != null && provincia.getDsO() != null) {
			where.append(" AND UPPER(t1.DS_O) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(provincia.getDsO().toUpperCase() + "%");
			} else {
				params.add("%" + provincia.getDsO().toUpperCase() + "%");
			}
			where.append(" AND t1.DS_O IS NOT NULL");
		}
		if (provincia != null && provincia.getAutonomia().getId() != null) {
			where.append(" AND UPPER(t1.AUTONOMIA_ID) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(provincia.getAutonomia().getId() + "%");
			} else {
				params.add("%" + provincia.getAutonomia().getId() + "%");
			}
			where.append(" AND t1.AUTONOMIA_ID IS NOT NULL");
		}
		query.append(where);

		if (pagination != null) {
			query = pagination.getPaginationQuery(query);
		}
		return (List<NoraProvincia>) this.jdbcTemplate.query(query.toString(),
				rwMap, params.toArray());
	}
}
