/*
 * Copyright 2012 E.J.I.E., S.A.
 *
 * Licencia con arreglo a la EUPL, Versión 1.1 exclusivamente (la «Licencia»);
 * Solo podrá usarse esta obra si se respeta la Licencia.
 * Puede obtenerse una copia de la Licencia en
 *
 * http://ec.europa.eu/idabc/eupl.html
 *
 * Salvo cuando lo exija la legislación aplicable o se acuerde por escrito,
 * el programa distribuido con arreglo a la Licencia se distribuye «TAL CUAL»,
 * SIN GARANTÍAS NI CONDICIONES DE NINGÚN TIPO, ni expresas ni implícitas.
 * Véase la Licencia en el idioma concreto que rige los permisos y limitaciones
 * que establece la Licencia.
 */

package com.ejie.aa21b.dao;

import java.util.List;

import com.ejie.aa21b.model.NoraProvincia;
import com.ejie.x38.dto.JQGridRequestDto;
import com.ejie.x38.dto.Pagination;

/**
 * * NoraProvinciaDao  
 * 
 *  
 */

public interface NoraProvinciaDao {

	/**
	 * Inserts a single row in the NoraProvincia table.
	 * 
	 * @param provincia
	 *            NoraProvincia
	 * @return NoraProvincia
	 */
	NoraProvincia add(NoraProvincia provincia);

	/**
	 * Updates a single row in the NoraProvincia table.
	 * 
	 * @param provincia
	 *            NoraProvincia
	 * @return NoraProvincia
	 */
	NoraProvincia update(NoraProvincia provincia);

	/**
	 * Finds a single row in the NoraProvincia table.
	 * 
	 * @param provincia
	 *            NoraProvincia
	 * @return NoraProvincia
	 */
	NoraProvincia find(NoraProvincia provincia);

	/**
	 * Deletes a single row in the NoraProvincia table.
	 * 
	 * @param provincia
	 *            NoraProvincia
	 * @return
	 */
	void remove(NoraProvincia provincia);

	/**
	 * Finds a List of rows in the NoraProvincia table.
	 * 
	 * @param provincia
	 *            NoraProvincia
	 * @param jqGridRequestDto
	 *            JQGridRequestDto
	 * @return List
	 */
	List<NoraProvincia> findAll(NoraProvincia provincia,
			JQGridRequestDto jqGridRequestDto);

	/**
	 * Counts rows in the NoraProvincia table.
	 * 
	 * @param provincia
	 *            NoraProvincia
	 * @return List
	 */
	Long findAllCount(NoraProvincia provincia);

	/**
	 * Finds rows in the NoraProvincia table using like.
	 * 
	 * @param provincia
	 *            NoraProvincia
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	List<NoraProvincia> findAllLike(NoraProvincia provincia,
			Pagination pagination, Boolean startsWith);
}
