/*
 * Copyright 2012 E.J.I.E., S.A.
 *
 * Licencia con arreglo a la EUPL, Versión 1.1 exclusivamente (la «Licencia»);
 * Solo podrá usarse esta obra si se respeta la Licencia.
 * Puede obtenerse una copia de la Licencia en
 *
 * http://ec.europa.eu/idabc/eupl.html
 *
 * Salvo cuando lo exija la legislación aplicable o se acuerde por escrito,
 * el programa distribuido con arreglo a la Licencia se distribuye «TAL CUAL»,
 * SIN GARANTÍAS NI CONDICIONES DE NINGÚN TIPO, ni expresas ni implícitas.
 * Véase la Licencia en el idioma concreto que rige los permisos y limitaciones
 * que establece la Licencia.
 */

package com.ejie.aa21b.dao;

import java.util.List;

import com.ejie.aa21b.model.NoraPais;
import com.ejie.x38.dto.JQGridRequestDto;
import com.ejie.x38.dto.Pagination;

/**
 * * NoraPaisDao  
 * 
 *  
 */

public interface NoraPaisDao {

	/**
	 * Finds a single row in the NoraPais table.
	 * 
	 * @param pais
	 *            NoraPais
	 * @return NoraPais
	 */
	NoraPais find(NoraPais pais);

	/**
	 * Finds a List of rows in the NoraPais table.
	 * 
	 * @param pais
	 *            NoraPais
	 * @param jqGridRequestDto
	 *            JQGridRequestDto
	 * @return List
	 */
	List<NoraPais> findAll(NoraPais pais, JQGridRequestDto jqGridRequestDto);

	/**
	 * Counts rows in the NoraPais table.
	 * 
	 * @param pais
	 *            NoraPais
	 * @return List
	 */
	Long findAllCount(NoraPais pais);

	/**
	 * Finds rows in the NoraPais table using like.
	 * 
	 * @param pais
	 *            NoraPais
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	List<NoraPais> findAllLike(NoraPais pais, Pagination pagination,
			Boolean startsWith);
}
