/*
 * Copyright 2012 E.J.I.E., S.A.
 *
 * Licencia con arreglo a la EUPL, Versión 1.1 exclusivamente (la «Licencia»);
 * Solo podrá usarse esta obra si se respeta la Licencia.
 * Puede obtenerse una copia de la Licencia en
 *
 * http://ec.europa.eu/idabc/eupl.html
 *
 * Salvo cuando lo exija la legislación aplicable o se acuerde por escrito,
 * el programa distribuido con arreglo a la Licencia se distribuye «TAL CUAL»,
 * SIN GARANTÍAS NI CONDICIONES DE NINGÚN TIPO, ni expresas ni implícitas.
 * Véase la Licencia en el idioma concreto que rige los permisos y limitaciones
 * que establece la Licencia.
 */

package com.ejie.aa21b.dao;

import java.util.List;

import com.ejie.aa21b.model.NoraMunicipio;
import com.ejie.x38.dto.Pagination;

/**
 * * NoraMunicipioDao  
 * 
 *  
 */

public interface NoraMunicipioDao {

	/**
	 * Inserts a single row in the NoraMunicipio table.
	 * 
	 * @param municipio
	 *            NoraMunicipio
	 * @return NoraMunicipio
	 */
	NoraMunicipio add(NoraMunicipio municipio);

	/**
	 * Updates a single row in the NoraMunicipio table.
	 * 
	 * @param municipio
	 *            NoraMunicipio
	 * @return NoraMunicipio
	 */
	NoraMunicipio update(NoraMunicipio municipio);

	/**
	 * Finds a single row in the NoraMunicipio table.
	 * 
	 * @param municipio
	 *            NoraMunicipio
	 * @return NoraMunicipio
	 */
	NoraMunicipio find(NoraMunicipio municipio);

	/**
	 * Deletes a single row in the NoraMunicipio table.
	 * 
	 * @param municipio
	 *            NoraMunicipio
	 * @return
	 */
	void remove(NoraMunicipio municipio);

	/**
	 * Finds a List of rows in the NoraMunicipio table.
	 * 
	 * @param municipio
	 *            NoraMunicipio
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	List<NoraMunicipio> findAll(NoraMunicipio municipio, Pagination pagination);

	/**
	 * Counts rows in the NoraMunicipio table.
	 * 
	 * @param municipio
	 *            NoraMunicipio
	 * @return List
	 */
	Long findAllCount(NoraMunicipio municipio);

	/**
	 * Finds rows in the NoraMunicipio table using like.
	 * 
	 * @param municipio
	 *            NoraMunicipio
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	List<NoraMunicipio> findAllLike(NoraMunicipio municipio,
			Pagination pagination, Boolean startsWith);
}
