/*
 * Copyright 2012 E.J.I.E., S.A.
 *
 * Licencia con arreglo a la EUPL, Versión 1.1 exclusivamente (la «Licencia»);
 * Solo podrá usarse esta obra si se respeta la Licencia.
 * Puede obtenerse una copia de la Licencia en
 *
 * http://ec.europa.eu/idabc/eupl.html
 *
 * Salvo cuando lo exija la legislación aplicable o se acuerde por escrito,
 * el programa distribuido con arreglo a la Licencia se distribuye «TAL CUAL»,
 * SIN GARANTÍAS NI CONDICIONES DE NINGÚN TIPO, ni expresas ni implícitas.
 * Véase la Licencia en el idioma concreto que rige los permisos y limitaciones
 * que establece la Licencia.
 */

package com.ejie.aa21b.dao;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;

import javax.annotation.Resource;
import javax.sql.DataSource;

import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.aa21b.model.NoraAutonomia;
import com.ejie.x38.dto.Pagination;

/**
 * * NoraAutonomiaDaoImpl  
 * 
 *  
 */

@Repository
@Transactional
public class NoraAutonomiaDaoImpl implements NoraAutonomiaDao {
	private JdbcTemplate jdbcTemplate;
	private RowMapper<NoraAutonomia> rwMap = new RowMapper<NoraAutonomia>() {
		public NoraAutonomia mapRow(ResultSet resultSet, int rowNum)
				throws SQLException {
			return new NoraAutonomia(resultSet.getString("ID"),
					resultSet.getString("DSO"));
		}
	};

	/**
	 * Method use to set the datasource.
	 * 
	 * @param dataSource
	 *            DataSource
	 * @return
	 */
	@Resource
	public void setDataSource(DataSource dataSource) {
		this.jdbcTemplate = new JdbcTemplate(dataSource);
	}

	/**
	 * Finds a single row in the NoraAutonomia table.
	 * 
	 * @param autonomia
	 *            Pagination
	 * @return NoraAutonomia
	 */
	@Transactional(readOnly = true)
	public NoraAutonomia find(NoraAutonomia autonomia) {
		String query = "SELECT t1.ID ID, t1.DS_O DSO "
				+ "FROM T17_AUTONOMIA t1  "
				+ "WHERE t1.ID = ?   AND t1.DS_O = ?  ";
		return (NoraAutonomia) this.jdbcTemplate.queryForObject(query, rwMap,
				autonomia.getId(), autonomia.getDsO());
	}

	/**
	 * Finds a List of rows in the NoraAutonomia table.
	 * 
	 * @param autonomia
	 *            NoraAutonomia
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<NoraAutonomia> findAll(NoraAutonomia autonomia,
			Pagination pagination) {
		StringBuffer where = new StringBuffer(3000);
		List<Object> params = new ArrayList<Object>();
		where.append(" WHERE 1=1 	");

		StringBuilder query = new StringBuilder("SELECT  t1.ID ID,t1.DS_O DSO "
				+ "FROM T17_AUTONOMIA t1 ");

		if (autonomia != null && autonomia.getId() != null) {
			where.append(" AND t1.ID = ?");
			params.add(autonomia.getId());
		}
		if (autonomia != null && autonomia.getDsO() != null) {
			where.append(" AND t1.DS_O = ?");
			params.add(autonomia.getDsO());
		}
		query.append(where);

		if (pagination != null) {
			query = pagination.getPaginationQuery(query);
		}
		return (List<NoraAutonomia>) this.jdbcTemplate.query(query.toString(),
				rwMap, params.toArray());
	}

	/**
	 * Counts rows in the NoraAutonomia table.
	 * 
	 * @param autonomia
	 *            NoraAutonomia
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long findAllCount(NoraAutonomia autonomia) {

		StringBuffer where = new StringBuffer(3000);
		List<Object> params = new ArrayList<Object>();
		where.append(" WHERE 1=1  ");

		StringBuffer query = new StringBuffer(
				"SELECT COUNT(1) FROM  T17_AUTONOMIA t1  ");
		if (autonomia != null && autonomia.getId() != null) {
			where.append(" AND t1.ID = ?");
			params.add(autonomia.getId());
		}
		if (autonomia != null && autonomia.getDsO() != null) {
			where.append(" AND t1.DS_O = ?");
			params.add(autonomia.getDsO());
		}
		query.append(where);
		return this.jdbcTemplate.queryForLong(query.toString(),
				params.toArray());
	}

	/**
	 * Finds rows in the NoraAutonomia table using like.
	 * 
	 * @param autonomia
	 *            NoraAutonomia
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<NoraAutonomia> findAllLike(NoraAutonomia autonomia,
			Pagination pagination, Boolean startsWith) {
		StringBuffer where = new StringBuffer(3000);
		List<Object> params = new ArrayList<Object>();
		where.append(" WHERE 1=1 	");

		StringBuilder query = new StringBuilder("SELECT  t1.ID ID,t1.DS_O DSO "
				+ "FROM T17_AUTONOMIA t1 ");

		if (autonomia != null && autonomia.getId() != null) {
			where.append(" AND UPPER(t1.ID) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(autonomia.getId() + "%");
			} else {
				params.add("%" + autonomia.getId() + "%");
			}
			where.append(" AND t1.ID IS NOT NULL");
		}
		if (autonomia != null && autonomia.getDsO() != null) {
			where.append(" AND UPPER(t1.DS_O) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(autonomia.getDsO().toUpperCase() + "%");
			} else {
				params.add("%" + autonomia.getDsO().toUpperCase() + "%");
			}
			where.append(" AND t1.DS_O IS NOT NULL");
		}
		query.append(where);

		if (pagination != null) {
			query = pagination.getPaginationQuery(query);
		}
		return (List<NoraAutonomia>) this.jdbcTemplate.query(query.toString(),
				rwMap, params.toArray());
	}
}
