/*
 * Copyright 2012 E.J.I.E., S.A.
 *
 * Licencia con arreglo a la EUPL, Versión 1.1 exclusivamente (la «Licencia»);
 * Solo podrá usarse esta obra si se respeta la Licencia.
 * Puede obtenerse una copia de la Licencia en
 *
 * http://ec.europa.eu/idabc/eupl.html
 *
 * Salvo cuando lo exija la legislación aplicable o se acuerde por escrito,
 * el programa distribuido con arreglo a la Licencia se distribuye «TAL CUAL»,
 * SIN GARANTÍAS NI CONDICIONES DE NINGÚN TIPO, ni expresas ni implícitas.
 * Véase la Licencia en el idioma concreto que rige los permisos y limitaciones
 * que establece la Licencia.
 */

package com.ejie.aa21b.dao;

import java.util.List;

import com.ejie.aa21b.model.NoraAutonomia;
import com.ejie.x38.dto.Pagination;

/**
 * * NoraAutonomiaDao  
 * 
 *  
 */

public interface NoraAutonomiaDao {

	/**
	 * Finds a single row in the NoraAutonomia table.
	 * 
	 * @param autonomia
	 *            NoraAutonomia
	 * @return NoraAutonomia
	 */
	NoraAutonomia find(NoraAutonomia autonomia);

	/**
	 * Finds a List of rows in the NoraAutonomia table.
	 * 
	 * @param autonomia
	 *            NoraAutonomia
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	List<NoraAutonomia> findAll(NoraAutonomia autonomia, Pagination pagination);

	/**
	 * Counts rows in the NoraAutonomia table.
	 * 
	 * @param autonomia
	 *            NoraAutonomia
	 * @return List
	 */
	Long findAllCount(NoraAutonomia autonomia);

	/**
	 * Finds rows in the NoraAutonomia table using like.
	 * 
	 * @param autonomia
	 *            NoraAutonomia
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	List<NoraAutonomia> findAllLike(NoraAutonomia autonomia,
			Pagination pagination, Boolean startsWith);
}
